/*
 * Decompiled with CFR 0.152.
 */
package fr.zooacademy.raiddensfix;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.ShowdownActionRequest;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.runner.ShowdownService;
import com.necro.raid.dens.common.data.dimension.RaidRegion;
import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.raids.helpers.RaidInventorySaveManager;
import com.necro.raid.dens.common.raids.helpers.RaidJoinHelper;
import com.necro.raid.dens.common.raids.helpers.RaidReadyManager;
import com.necro.raid.dens.common.util.RaidUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\bJ\u001f\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0016\u0010\bJ\u0015\u0010\u0017\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u001e\u0010\u0018J\u0015\u0010\u001f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u001f\u0010\u0018J\u0015\u0010 \u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b \u0010\u0018J\u0015\u0010!\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b!\u0010\u0018J\u001f\u0010#\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\"\u001a\u00020\u001b\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010%\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b%\u0010\u0012J\u0017\u0010&\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b&\u0010\bJ\u0015\u0010'\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b'\u0010\u0018J\r\u0010(\u001a\u00020\u0006\u00a2\u0006\u0004\b(\u0010\u0003J\u001d\u0010+\u001a\u00020\u00062\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0)H\u0007\u00a2\u0006\u0004\b+\u0010,J'\u00100\u001a\u00020\u00062\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0)2\b\u0010/\u001a\u0004\u0018\u00010.H\u0007\u00a2\u0006\u0004\b0\u00101J!\u00103\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u000f2\b\u0010/\u001a\u0004\u0018\u00010.H\u0007\u00a2\u0006\u0004\b3\u00104R\u001c\u00107\u001a\n 6*\u0004\u0018\u000105058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0014\u0010:\u001a\u0002098\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b:\u0010;R \u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>R2\u0010A\u001a \u0012\u0004\u0012\u00020\u000f\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020\u00190?0)0<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010>R,\u0010B\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020\u000b0?0<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010>R,\u0010C\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020@0?0<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bC\u0010>R\u0014\u0010D\u001a\u00020@8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bD\u0010ER \u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010>R\u0014\u0010G\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bG\u0010HR\u0014\u0010I\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bI\u0010HR\u0014\u0010J\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bJ\u0010HR\u0018\u0010L\u001a\u0004\u0018\u00010K8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u0010M\u00a8\u0006N"}, d2={"Lfr/zooacademy/raiddensfix/RaidRecoveryManager;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "init", "(Lnet/minecraft/server/MinecraftServer;)V", "Lnet/minecraft/class_3222;", "player", "", "currentTick", "scheduleWatchdog", "(Lnet/minecraft/class_3222;J)V", "Ljava/util/UUID;", "playerUuid", "cancelWatchdog", "(Ljava/util/UUID;)V", "tick", "checkForStalledBattles", "(Lnet/minecraft/server/MinecraftServer;J)V", "scanForStuckPlayers", "recoverPlayer", "(Lnet/minecraft/class_3222;)V", "Lnet/minecraft/class_1799;", "stack", "", "isRaidItem", "(Lnet/minecraft/class_1799;)Z", "saveRaidItems", "restoreRaidItems", "removeRaidItemsFromInventory", "persistInventoryToDisk", "deleteAfter", "restoreFromDisk", "(Lnet/minecraft/class_3222;Z)Z", "cleanupDiskBackup", "restorePersistedInventories", "onPlayerJoin", "onServerClose", "", "players", "savePreRaidState", "(Ljava/util/List;)V", "participants", "Lcom/necro/raid/dens/common/data/dimension/RaidRegion;", "region", "resyncPlayerPositions", "(Ljava/util/List;Lcom/necro/raid/dens/common/data/dimension/RaidRegion;)V", "raidId", "repositionBoss", "(Ljava/util/UUID;Lcom/necro/raid/dens/common/data/dimension/RaidRegion;)V", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/slf4j/Logger;", "", "RAID_NAMESPACE", "Ljava/lang/String;", "Ljava/util/concurrent/ConcurrentHashMap;", "watchdogTimers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Pair;", "", "savedRaidItems", "battleTurnTracker", "unstallAttempts", "MAX_UNSTALL_ATTEMPTS", "I", "recoveredPlayers", "RECOVERY_COOLDOWN_TICKS", "J", "STALL_THRESHOLD_TURN1_TICKS", "STALL_THRESHOLD_TICKS", "Ljava/nio/file/Path;", "inventoryBackupDir", "Ljava/nio/file/Path;", "raid-dens-fix"})
@SourceDebugExtension(value={"SMAP\nRaidRecoveryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RaidRecoveryManager.kt\nfr/zooacademy/raiddensfix/RaidRecoveryManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,927:1\n774#2:928\n865#2,2:929\n1788#2,4:931\n1869#2,2:935\n2746#2,2:937\n1761#2,3:939\n2748#2:942\n2746#2,2:943\n1761#2,3:945\n2748#2:948\n*S KotlinDebug\n*F\n+ 1 RaidRecoveryManager.kt\nfr/zooacademy/raiddensfix/RaidRecoveryManager\n*L\n117#1:928\n117#1:929,2\n299#1:931,4\n586#1:935,2\n357#1:937,2\n358#1:939,3\n357#1:942\n362#1:943,2\n363#1:945,3\n362#1:948\n*E\n"})
public final class RaidRecoveryManager {
    @NotNull
    public static final RaidRecoveryManager INSTANCE = new RaidRecoveryManager();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RaidDensFix");
    @NotNull
    private static final String RAID_NAMESPACE = "cobblemonraiddens";
    @NotNull
    private static final ConcurrentHashMap<UUID, Long> watchdogTimers = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<UUID, List<Pair<Integer, class_1799>>> savedRaidItems = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<UUID, Pair<Integer, Long>> battleTurnTracker = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<UUID, Pair<Integer, Integer>> unstallAttempts = new ConcurrentHashMap();
    private static final int MAX_UNSTALL_ATTEMPTS = 3;
    @NotNull
    private static final ConcurrentHashMap<UUID, Long> recoveredPlayers = new ConcurrentHashMap();
    private static final long RECOVERY_COOLDOWN_TICKS = 600L;
    private static final long STALL_THRESHOLD_TURN1_TICKS = 40L;
    private static final long STALL_THRESHOLD_TICKS = 100L;
    @Nullable
    private static Path inventoryBackupDir;

    private RaidRecoveryManager() {
    }

    public final void init(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Path worldDir = server.method_27050(class_5218.field_24188);
        Path path = inventoryBackupDir = worldDir.resolve("raiddensfix").resolve("inventories");
        Intrinsics.checkNotNull((Object)path);
        Files.createDirectories(path, new FileAttribute[0]);
        LOGGER.info("[RaidDensFix] Recovery manager initialized. Backup dir: {}", (Object)inventoryBackupDir);
        this.restorePersistedInventories(server);
    }

    public final void scheduleWatchdog(@NotNull class_3222 player, long currentTick) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        long checkTick = currentTick + 100L;
        ((Map)watchdogTimers).put(player.method_5667(), checkTick);
        LOGGER.debug("[RaidDensFix] Watchdog scheduled for {} at tick {}", (Object)player.method_5477().getString(), (Object)checkTick);
    }

    public final void cancelWatchdog(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
        if (watchdogTimers.remove(playerUuid) != null) {
            LOGGER.debug("[RaidDensFix] Watchdog cancelled for {}", (Object)playerUuid);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void tick(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        long currentTick = server.method_30002().method_8510();
        if (!((Map)watchdogTimers).isEmpty()) {
            void $this$filterTo$iv$iv;
            Set<Map.Entry<UUID, Long>> set = watchdogTimers.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!(((Number)it.getValue()).longValue() <= currentTick)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List expired = (List)destination$iv$iv;
            for (Object e : expired) {
                class_3222 player;
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Object k = ((Map.Entry)e).getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
                UUID playerUuid = (UUID)k;
                watchdogTimers.remove(playerUuid);
                if (server.method_3760().method_14602(playerUuid) == null || !RaidUtils.isRaidDimension((class_1937)player.method_37908())) continue;
                PokemonBattle battle = BattleRegistry.getBattleByParticipatingPlayer((class_3222)player);
                if (battle != null) {
                    LOGGER.debug("[RaidDensFix] Player {} is in battle, watchdog OK", (Object)player.method_5477().getString());
                    continue;
                }
                LOGGER.warn("[RaidDensFix] Player {} is STUCK in raid dimension without battle! Initiating recovery.", (Object)player.method_5477().getString());
                this.recoverPlayer(player);
            }
        }
        if (currentTick % 20L == 0L) {
            this.checkForStalledBattles(server, currentTick);
        }
        if (currentTick % 200L == 0L) {
            this.scanForStuckPlayers(server);
        }
    }

    private final void checkForStalledBattles(MinecraftServer server, long currentTick) {
        Map map = RaidHelper.ACTIVE_RAIDS;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"ACTIVE_RAIDS");
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            RaidInstance raidInstance = (RaidInstance)iterator.next().getValue();
            if (raidInstance.isFinished()) continue;
            for (PokemonBattle battle : raidInstance.getBattles()) {
                long threshold;
                if (battle.getEnded()) continue;
                UUID battleId = battle.getBattleId();
                int currentTurn = battle.getTurn();
                Pair<Integer, Long> tracked = battleTurnTracker.get(battleId);
                if (tracked == null || ((Number)tracked.getFirst()).intValue() != currentTurn) {
                    ((Map)battleTurnTracker).put(battleId, new Pair((Object)currentTurn, (Object)currentTick));
                    continue;
                }
                long ticksSinceTurnStart = currentTick - ((Number)tracked.getSecond()).longValue();
                if (ticksSinceTurnStart < (threshold = currentTurn <= 1 ? 40L : 100L)) continue;
                try {
                    boolean playerHasResponses;
                    BattleActor bossActor;
                    BattleActor playerActor;
                    BattleSide side1 = battle.getSide1();
                    BattleSide side2 = battle.getSide2();
                    if ((BattleActor)ArraysKt.firstOrNull((Object[])side1.getActors()) == null || (BattleActor)ArraysKt.firstOrNull((Object[])side2.getActors()) == null) continue;
                    boolean playerMustChoose = playerActor.getMustChoose();
                    boolean bossMustChoose = bossActor.getMustChoose();
                    if (playerMustChoose) continue;
                    boolean bossHasResponses = !((Collection)bossActor.getResponses()).isEmpty();
                    boolean bl = playerHasResponses = !((Collection)playerActor.getResponses()).isEmpty();
                    if (ticksSinceTurnStart >= 100L && ticksSinceTurnStart % 100L < 20L) {
                        Object[] objectArray = new Object[]{battleId, currentTurn, ticksSinceTurnStart, playerMustChoose, playerActor.getResponses().size(), bossMustChoose, bossActor.getResponses().size()};
                        LOGGER.info("[RaidDensFix] Battle {} turn {} stalled {}t: player(mustChoose={}, responses={}), boss(mustChoose={}, responses={})", objectArray);
                    }
                    boolean stallCase1 = !playerMustChoose && playerHasResponses && !bossHasResponses;
                    boolean stallCase2 = !playerMustChoose && !bossMustChoose && !playerHasResponses && !bossHasResponses;
                    boolean stallCase3 = !playerMustChoose && !bossMustChoose && playerHasResponses && bossHasResponses && ticksSinceTurnStart >= threshold * (long)2;
                    boolean stallCase4 = !playerMustChoose && bossMustChoose && !playerHasResponses && !bossHasResponses;
                    boolean stallCase5 = !playerMustChoose && bossMustChoose && bossHasResponses;
                    String stallCaseName = stallCase1 ? "boss_no_response" : (stallCase2 ? "both_empty" : (stallCase3 ? "both_responded_stuck" : (stallCase4 ? "boss_must_choose_stuck" : (stallCase5 ? "boss_response_stuck" : null))));
                    if (stallCaseName == null) continue;
                    Pair<Integer, Integer> tracked2 = unstallAttempts.get(battleId);
                    int attempts = tracked2 != null && ((Number)tracked2.getFirst()).intValue() == currentTurn ? ((Number)tracked2.getSecond()).intValue() + 1 : 1;
                    ((Map)unstallAttempts).put(battleId, new Pair((Object)currentTurn, (Object)attempts));
                    if (attempts > 3) {
                        Object[] objectArray = new Object[]{battleId, currentTurn, attempts, stallCaseName};
                        LOGGER.error("[RaidDensFix] STALL UNRECOVERABLE in battle {} (turn {}, {} attempts, case={}). Force-ending battle.", objectArray);
                        try {
                            battle.end();
                            LOGGER.info("[RaidDensFix] Battle {} force-ended. Players will be recovered by periodic scan.", (Object)battleId);
                        }
                        catch (Exception endEx) {
                            LOGGER.error("[RaidDensFix] Failed to force-end battle {}: {}", (Object)battleId, (Object)endEx.getMessage());
                        }
                        battleTurnTracker.remove(battleId);
                        unstallAttempts.remove(battleId);
                        continue;
                    }
                    Object[] endEx = new Object[]{battleId, currentTurn, ticksSinceTurnStart, stallCaseName, attempts, 3};
                    LOGGER.warn("[RaidDensFix] STALL DETECTED in battle {} (turn {}, stalled for {} ticks, case={}, attempt {}/{}). Forcing unstall.", endEx);
                    ShowdownService showdown = ShowdownService.Companion.getService();
                    if (stallCase1 || stallCase2 || stallCase4) {
                        if (bossMustChoose) {
                            int request22;
                            try {
                                int n;
                                ShowdownActionRequest request22 = bossActor.getRequest();
                                Object object = request22;
                                if (object != null && (object = object.getActive()) != null && (object = (ShowdownMoveset)CollectionsKt.firstOrNull((List)object)) != null && (object = object.getMoves()) != null) {
                                    Iterable $this$count$iv = (Iterable)object;
                                    boolean $i$f$count = false;
                                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                        n = 0;
                                    } else {
                                        int count$iv = 0;
                                        for (Object element$iv : $this$count$iv) {
                                            InBattleMove it = (InBattleMove)element$iv;
                                            boolean bl2 = false;
                                            if (!(!it.getDisabled()) || ++count$iv >= 0) continue;
                                            CollectionsKt.throwCountOverflow();
                                        }
                                        n = count$iv;
                                    }
                                } else {
                                    n = 4;
                                }
                                request22 = n;
                            }
                            catch (Exception exception) {
                                request22 = 4;
                            }
                            int bossMoveCount = request22;
                            int moveIndex = RangesKt.random((IntRange)new IntRange(1, RangesKt.coerceIn((int)bossMoveCount, (int)1, (int)4)), (Random)((Random)Random.Default));
                            Intrinsics.checkNotNull((Object)battleId);
                            var34_40 = new String[]{">p2 move " + moveIndex};
                            showdown.send(battleId, (String[])var34_40);
                            var34_40 = new Object[]{moveIndex, battleId, stallCaseName, bossMoveCount};
                            LOGGER.info("[RaidDensFix] Sent >p2 move {} to Showdown for battle {} (case={}, bossMustChoose=true, availableMoves={})", var34_40);
                        } else {
                            Intrinsics.checkNotNull((Object)battleId);
                            String[] bossMoveCount = new String[]{">p2 pass"};
                            showdown.send(battleId, bossMoveCount);
                            LOGGER.info("[RaidDensFix] Sent >p2 pass to Showdown for battle {} (case={}, bossMustChoose=false)", (Object)battleId, (Object)stallCaseName);
                        }
                    } else if (stallCase3) {
                        try {
                            battle.checkForInputDispatch();
                            LOGGER.info("[RaidDensFix] Forced checkForInputDispatch for battle {} (case={})", (Object)battleId, (Object)stallCaseName);
                        }
                        catch (Exception dispatchEx) {
                            Object[] moveIndex = new Object[]{battleId, stallCaseName, dispatchEx.getMessage()};
                            LOGGER.warn("[RaidDensFix] checkForInputDispatch failed for battle {} (case={}): {}", moveIndex);
                            int moveIdx = RangesKt.random((IntRange)new IntRange(1, 4), (Random)((Random)Random.Default));
                            Intrinsics.checkNotNull((Object)battleId);
                            var34_40 = new String[]{">p2 move " + moveIdx};
                            showdown.send(battleId, (String[])var34_40);
                            LOGGER.info("[RaidDensFix] Fallback: sent >p2 move {} for battle {}", (Object)moveIdx, (Object)battleId);
                        }
                    } else if (stallCase5) {
                        try {
                            bossActor.setMustChoose(false);
                            LOGGER.info("[RaidDensFix] Set boss mustChoose=false for battle {} (had {} responses)", (Object)battleId, (Object)bossActor.getResponses().size());
                            battle.checkForInputDispatch();
                            LOGGER.info("[RaidDensFix] checkForInputDispatch succeeded for battle {} (case={})", (Object)battleId, (Object)stallCaseName);
                        }
                        catch (Exception dispatchEx) {
                            Object[] moveIdx = new Object[]{battleId, stallCaseName, dispatchEx.getMessage()};
                            LOGGER.warn("[RaidDensFix] checkForInputDispatch failed for battle {} (case={}): {}. Sending >p2 move as fallback.", moveIdx);
                            int moveIdx5 = RangesKt.random((IntRange)new IntRange(1, 4), (Random)((Random)Random.Default));
                            Intrinsics.checkNotNull((Object)battleId);
                            var34_40 = new String[]{">p2 move " + moveIdx5};
                            showdown.send(battleId, (String[])var34_40);
                            LOGGER.info("[RaidDensFix] Fallback: sent >p2 move {} for battle {}", (Object)moveIdx5, (Object)battleId);
                        }
                    }
                    ((Map)battleTurnTracker).put(battleId, new Pair((Object)currentTurn, (Object)currentTick));
                    Object[] objectArray = new Object[]{battleId, stallCaseName, attempts};
                    LOGGER.info("[RaidDensFix] Forced dispatch for battle {} (case={}, attempt {}). Battle should now advance.", objectArray);
                }
                catch (Exception e) {
                    Object[] objectArray = new Object[]{battleId, e.getMessage(), e};
                    LOGGER.error("[RaidDensFix] Error checking stall for battle {}: {}", objectArray);
                }
            }
        }
        ((ConcurrentHashMap.KeySetView)battleTurnTracker.keySet()).removeIf(arg_0 -> RaidRecoveryManager.checkForStalledBattles$lambda$2(RaidRecoveryManager::checkForStalledBattles$lambda$1, arg_0));
        ((ConcurrentHashMap.KeySetView)unstallAttempts.keySet()).removeIf(arg_0 -> RaidRecoveryManager.checkForStalledBattles$lambda$4(RaidRecoveryManager::checkForStalledBattles$lambda$3, arg_0));
    }

    private final void scanForStuckPlayers(MinecraftServer server) {
        class_3218 class_32182 = ModDimensions.getRaidDimension((MinecraftServer)server);
        if (class_32182 == null) {
            return;
        }
        class_3218 raidDimension = class_32182;
        List list = raidDimension.method_18456();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        for (class_3222 player : CollectionsKt.toList((Iterable)list)) {
            RaidInstance raidInstance;
            RaidJoinHelper.Participant participant;
            PokemonBattle battle;
            if (player == null || watchdogTimers.containsKey(player.method_5667()) || (battle = BattleRegistry.getBattleByParticipatingPlayer((class_3222)player)) != null || (participant = RaidJoinHelper.getParticipant((class_1657)((class_1657)player))) != null && (raidInstance = (RaidInstance)RaidHelper.ACTIVE_RAIDS.get(participant.raid())) != null || RaidReadyManager.isInReadyCheck((class_3222)player)) continue;
            long currentTick = server.method_30002().method_8510();
            Long lastRecovery = recoveredPlayers.get(player.method_5667());
            if (lastRecovery != null && currentTick - lastRecovery < 600L) continue;
            LOGGER.warn("[RaidDensFix] Periodic scan: Player {} stuck in raid dimension. Recovering.", (Object)player.method_5477().getString());
            ((Map)recoveredPlayers).put(player.method_5667(), currentTick);
            this.recoverPlayer(player);
        }
    }

    public final void recoverPlayer(@NotNull class_3222 player) {
        Object[] objectArray;
        Path file;
        Path dir;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        LOGGER.info("[RaidDensFix] === RECOVERING PLAYER: {} ===", (Object)player.method_5477().getString());
        RaidJoinHelper.removeParticipant((class_1657)((class_1657)player));
        RaidJoinHelper.removeFromQueue((class_1657)((class_1657)player), (boolean)true);
        RaidHelper.removeRequests((UUID)player.method_5667());
        double homeX = 0.0;
        double homeY = 64.0;
        double homeZ = 0.0;
        String homeDimStr = "minecraft:overworld";
        boolean hasHomePos = false;
        Path path = dir = inventoryBackupDir;
        Path path2 = file = path != null ? path.resolve(player.method_5667() + ".dat") : null;
        if (file != null && Files.exists(file, new LinkOption[0])) {
            try {
                class_2487 tag = class_2507.method_30613((Path)file, (class_2505)class_2505.method_53898());
                if (tag.method_10545("HomeX")) {
                    homeX = tag.method_10574("HomeX");
                    homeY = tag.method_10574("HomeY");
                    homeZ = tag.method_10574("HomeZ");
                    String string = tag.method_10558("HomeDim");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                    homeDimStr = string;
                    hasHomePos = true;
                    Object[] objectArray2 = new Object[5];
                    objectArray2[0] = player.method_5477().getString();
                    objectArray = "%.1f";
                    Object[] objectArray3 = new Object[]{homeX};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format((String)objectArray, Arrays.copyOf(objectArray3, objectArray3.length)), (String)"format(...)");
                    objectArray = "%.1f";
                    objectArray3 = new Object[]{homeY};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format((String)objectArray, Arrays.copyOf(objectArray3, objectArray3.length)), (String)"format(...)");
                    objectArray = "%.1f";
                    objectArray3 = new Object[]{homeZ};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format((String)objectArray, Arrays.copyOf(objectArray3, objectArray3.length)), (String)"format(...)");
                    objectArray2[4] = homeDimStr;
                    LOGGER.info("[RaidDensFix] Found saved home position for {}: ({}, {}, {}) in {}", objectArray2);
                }
            }
            catch (Exception e) {
                LOGGER.error("[RaidDensFix] Failed to read home position from disk for {}", (Object)player.method_5477().getString(), (Object)e);
            }
        }
        boolean tpDone = false;
        try {
            class_5321 homeDimKey;
            class_3218 homeLevel;
            if (hasHomePos && (homeLevel = player.field_13995.method_3847(homeDimKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)homeDimStr)))) != null) {
                player.method_48105(homeLevel, homeX, homeY, homeZ, (Set)new HashSet(), player.method_36454(), player.method_36455());
                boolean bl = tpDone = !RaidUtils.isRaidDimension((class_1937)player.method_37908());
                if (tpDone) {
                    objectArray = new Object[5];
                    objectArray[0] = player.method_5477().getString();
                    String string = "%.1f";
                    Object[] objectArray4 = new Object[]{homeX};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray4, objectArray4.length)), (String)"format(...)");
                    string = "%.1f";
                    objectArray4 = new Object[]{homeY};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray4, objectArray4.length)), (String)"format(...)");
                    string = "%.1f";
                    objectArray4 = new Object[]{homeZ};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray4, objectArray4.length)), (String)"format(...)");
                    objectArray[4] = homeDimStr;
                    LOGGER.info("[RaidDensFix] TP: {} sent to saved position ({}, {}, {}) in {}", objectArray);
                } else {
                    LOGGER.warn("[RaidDensFix] TP to saved position failed for {} (still in raid dim)", (Object)player.method_5477().getString());
                }
            }
            if (!tpDone) {
                try {
                    RaidHelper.teleportFromRaid((class_3222)player);
                    boolean bl = tpDone = !RaidUtils.isRaidDimension((class_1937)player.method_37908());
                    if (tpDone) {
                        LOGGER.info("[RaidDensFix] TP: {} sent back via teleportFromRaid()", (Object)player.method_5477().getString());
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("[RaidDensFix] teleportFromRaid() failed for {}: {}", (Object)player.method_5477().getString(), (Object)e.getMessage());
                }
            }
            if (!tpDone) {
                LOGGER.error("[RaidDensFix] CRITICAL: No saved position found for {}! Using overworld spawn as absolute last resort.", (Object)player.method_5477().getString());
                class_3218 overworld = player.field_13995.method_30002();
                class_2338 spawnPos = overworld.method_43126();
                player.method_48105(overworld, (double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264() + 1.0, (double)spawnPos.method_10260() + 0.5, (Set)new HashSet(), player.method_36454(), player.method_36455());
                tpDone = !RaidUtils.isRaidDimension((class_1937)player.method_37908());
            }
        }
        catch (Exception e) {
            LOGGER.error("[RaidDensFix] CRITICAL: Failed to TP {} out of raid dimension!", (Object)player.method_5477().getString(), (Object)e);
        }
        if (player.field_13974.method_14257() != class_1934.field_9215) {
            LOGGER.info("[RaidDensFix] Resetting gamemode for {} from {} to SURVIVAL", (Object)player.method_5477().getString(), (Object)player.field_13974.method_14257());
            player.method_7336(class_1934.field_9215);
        }
        boolean inventoryRestored = false;
        if (RaidInventorySaveManager.hasSavedInventory((class_3222)player)) {
            RaidInventorySaveManager.restoreInventory((class_3222)player);
            inventoryRestored = true;
            LOGGER.info("[RaidDensFix] Inventory restored from RAM for {}", (Object)player.method_5477().getString());
        } else if (file != null && Files.exists(file, new LinkOption[0]) && this.restoreFromDisk(player, true)) {
            inventoryRestored = true;
            LOGGER.info("[RaidDensFix] Inventory restored from disk for {}", (Object)player.method_5477().getString());
        }
        if (!inventoryRestored) {
            LOGGER.warn("[RaidDensFix] No saved inventory found for {}. Player keeps current inventory.", (Object)player.method_5477().getString());
        }
        if (file != null && Files.exists(file, new LinkOption[0])) {
            Files.deleteIfExists(file);
        }
        if (RaidUtils.isRaidDimension((class_1937)player.method_37908())) {
            LOGGER.error("[RaidDensFix] CRITICAL: Player {} is STILL in raid dimension after all TP attempts!", (Object)player.method_5477().getString());
        }
        player.method_43496((class_2561)class_2561.method_43470((String)"[Raid Fix] ").method_27694(RaidRecoveryManager::recoverPlayer$lambda$0).method_10852((class_2561)class_2561.method_43470((String)"Le raid a rencontre une erreur. Vous avez ete teleporte en securite et votre inventaire a ete restaure.").method_27694(RaidRecoveryManager::recoverPlayer$lambda$1)));
        LOGGER.info("[RaidDensFix] === RECOVERY COMPLETE for {} ===", (Object)player.method_5477().getString());
    }

    private final boolean isRaidItem(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        class_2960 class_29602 = class_7923.field_41178.method_10221((Object)stack.method_7909());
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"getKey(...)");
        class_2960 itemKey = class_29602;
        return Intrinsics.areEqual((Object)itemKey.method_12836(), (Object)RAID_NAMESPACE);
    }

    public final void saveRaidItems(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        class_1661 inventory = player.method_31548();
        List raidItems = new ArrayList();
        int n = inventory.method_5439();
        for (int i = 0; i < n; ++i) {
            class_1799 stack = inventory.method_5438(i);
            Intrinsics.checkNotNull((Object)stack);
            if (!this.isRaidItem(stack)) continue;
            raidItems.add(TuplesKt.to((Object)i, (Object)stack.method_7972()));
        }
        if (!((Collection)raidItems).isEmpty()) {
            ((Map)savedRaidItems).put(player.method_5667(), raidItems);
            LOGGER.info("[RaidDensFix] Saved {} raid item(s) for {} to restore after clear", (Object)raidItems.size(), (Object)player.method_5477().getString());
            Iterable $this$forEach$iv = raidItems;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                int slot = ((Number)pair.component1()).intValue();
                class_1799 stack = (class_1799)pair.component2();
                Object[] objectArray = new Object[]{slot, class_7923.field_41178.method_10221((Object)stack.method_7909()), stack.method_7947()};
                LOGGER.debug("[RaidDensFix]   Slot {}: {} x{}", objectArray);
            }
        }
    }

    public final void restoreRaidItems(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        List<Pair<Integer, class_1799>> list = savedRaidItems.remove(player.method_5667());
        if (list == null) {
            return;
        }
        List<Pair<Integer, class_1799>> items = list;
        class_1661 inventory = player.method_31548();
        for (Pair<Integer, class_1799> pair : items) {
            int slot = ((Number)pair.component1()).intValue();
            class_1799 stack = (class_1799)pair.component2();
            boolean bl = 0 <= slot ? slot < inventory.method_5439() : false;
            if (bl) {
                inventory.method_5447(slot, stack);
                continue;
            }
            if (inventory.method_7394(stack)) continue;
            LOGGER.warn("[RaidDensFix] Could not restore raid item {} for {} - inventory full!", (Object)class_7923.field_41178.method_10221((Object)stack.method_7909()), (Object)player.method_5477().getString());
        }
        LOGGER.info("[RaidDensFix] Restored {} raid item(s) for {} after inventory clear", (Object)items.size(), (Object)player.method_5477().getString());
    }

    public final void removeRaidItemsFromInventory(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        class_1661 inventory = player.method_31548();
        int removed = 0;
        int n = inventory.method_5439();
        for (int i = 0; i < n; ++i) {
            class_1799 stack = inventory.method_5438(i);
            Intrinsics.checkNotNull((Object)stack);
            if (!this.isRaidItem(stack)) continue;
            inventory.method_5447(i, class_1799.field_8037);
            ++removed;
        }
        if (removed > 0) {
            LOGGER.debug("[RaidDensFix] Removed {} raid item(s) from {} before full inventory restore", (Object)removed, (Object)player.method_5477().getString());
        }
    }

    public final void persistInventoryToDisk(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Path path = inventoryBackupDir;
        if (path == null) {
            return;
        }
        Path dir = path;
        try {
            class_1661 inventory = player.method_31548();
            class_2487 tag = new class_2487();
            class_2499 itemList = new class_2499();
            int n = inventory.method_5439();
            for (int i = 0; i < n; ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (stack.method_7960()) continue;
                class_2487 itemTag = new class_2487();
                itemTag.method_10569("Slot", i);
                itemList.add((Object)stack.method_57376((class_7225.class_7874)player.method_56673(), (class_2520)itemTag));
            }
            tag.method_10566("Items", (class_2520)itemList);
            class_2499 armorList = new class_2499();
            int stack = inventory.field_7548.size();
            for (int i = 0; i < stack; ++i) {
                Object object = inventory.field_7548.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                class_1799 stack2 = (class_1799)object;
                if (stack2.method_7960()) continue;
                class_2487 itemTag = new class_2487();
                itemTag.method_10569("Slot", i);
                armorList.add((Object)stack2.method_57376((class_7225.class_7874)player.method_56673(), (class_2520)itemTag));
            }
            tag.method_10566("Armor", (class_2520)armorList);
            Object object = inventory.field_7544.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            class_1799 offhand = (class_1799)object;
            if (!offhand.method_7960()) {
                tag.method_10566("Offhand", offhand.method_57358((class_7225.class_7874)player.method_56673()));
            }
            tag.method_10549("HomeX", player.method_23317());
            tag.method_10549("HomeY", player.method_23318());
            tag.method_10549("HomeZ", player.method_23321());
            tag.method_10582("HomeDim", player.method_37908().method_27983().method_29177().toString());
            Path file = dir.resolve(player.method_5667() + ".dat");
            class_2507.method_30614((class_2487)tag, (Path)file);
            LOGGER.debug("[RaidDensFix] Inventory persisted to disk for {}", (Object)player.method_5477().getString());
        }
        catch (Exception e) {
            LOGGER.error("[RaidDensFix] Failed to persist inventory for {}", (Object)player.method_5477().getString(), (Object)e);
        }
    }

    public final boolean restoreFromDisk(@NotNull class_3222 player, boolean deleteAfter) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Path path = inventoryBackupDir;
        if (path == null) {
            return false;
        }
        Path dir = path;
        Path file = dir.resolve(player.method_5667() + ".dat");
        if (!Files.exists(file, new LinkOption[0])) {
            return false;
        }
        try {
            class_1799 stack;
            int slot;
            class_2487 itemTag;
            int i;
            int n;
            class_2487 tag = class_2507.method_30613((Path)file, (class_2505)class_2505.method_53898());
            class_1661 inventory = player.method_31548();
            inventory.method_5448();
            if (tag.method_10545("Items")) {
                class_2499 itemList = tag.method_10554("Items", 10);
                n = itemList.size();
                for (i = 0; i < n; ++i) {
                    itemTag = itemList.method_10602(i);
                    slot = itemTag.method_10550("Slot");
                    stack = class_1799.method_57360((class_7225.class_7874)((class_7225.class_7874)player.method_56673()), (class_2520)((class_2520)itemTag)).orElse(class_1799.field_8037);
                    boolean bl = 0 <= slot ? slot < inventory.method_5439() : false;
                    if (!bl) continue;
                    inventory.method_5447(slot, stack);
                }
            }
            if (tag.method_10545("Armor")) {
                class_2499 armorList = tag.method_10554("Armor", 10);
                n = armorList.size();
                for (i = 0; i < n; ++i) {
                    itemTag = armorList.method_10602(i);
                    slot = itemTag.method_10550("Slot");
                    stack = class_1799.method_57360((class_7225.class_7874)((class_7225.class_7874)player.method_56673()), (class_2520)((class_2520)itemTag)).orElse(class_1799.field_8037);
                    boolean bl = 0 <= slot ? slot < inventory.field_7548.size() : false;
                    if (!bl) continue;
                    inventory.field_7548.set(slot, (Object)stack);
                }
            }
            if (tag.method_10545("Offhand")) {
                class_1799 offhand = class_1799.method_57360((class_7225.class_7874)((class_7225.class_7874)player.method_56673()), (class_2520)((class_2520)tag.method_10562("Offhand"))).orElse(class_1799.field_8037);
                inventory.field_7544.set(0, (Object)offhand);
            }
            if (deleteAfter) {
                Files.deleteIfExists(file);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("[RaidDensFix] Failed to restore inventory from disk for {}", (Object)player.method_5477().getString(), (Object)e);
            return false;
        }
    }

    public static /* synthetic */ boolean restoreFromDisk$default(RaidRecoveryManager raidRecoveryManager, class_3222 class_32222, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return raidRecoveryManager.restoreFromDisk(class_32222, bl);
    }

    public final void cleanupDiskBackup(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
        Path path = inventoryBackupDir;
        if (path == null) {
            return;
        }
        Path dir = path;
        try {
            Files.deleteIfExists(dir.resolve(playerUuid + ".dat"));
        }
        catch (Exception e) {
            LOGGER.error("[RaidDensFix] Failed to cleanup disk backup for {}", (Object)playerUuid, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void restorePersistedInventories(MinecraftServer server) {
        Path path = inventoryBackupDir;
        if (path == null) {
            return;
        }
        Path dir = path;
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        Ref.IntRef count = new Ref.IntRef();
        AutoCloseable autoCloseable = Files.list(dir);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            stream.filter(arg_0 -> RaidRecoveryManager.restorePersistedInventories$lambda$0$1(RaidRecoveryManager::restorePersistedInventories$lambda$0$0, arg_0)).forEach(arg_0 -> RaidRecoveryManager.restorePersistedInventories$lambda$0$3(arg_0 -> RaidRecoveryManager.restorePersistedInventories$lambda$0$2(count, arg_0), arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        if (count.element > 0) {
            LOGGER.warn("[RaidDensFix] {} persisted inventories found from previous session. They will be restored when players join.", (Object)count.element);
        }
    }

    public final void onPlayerJoin(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Path path = inventoryBackupDir;
        if (path == null) {
            return;
        }
        Path dir = path;
        Path file = dir.resolve(player.method_5667() + ".dat");
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        LOGGER.info("[RaidDensFix] Player {} has a persisted inventory backup.", (Object)player.method_5477().getString());
        boolean inRaidDim = RaidUtils.isRaidDimension((class_1937)player.method_37908());
        if (inRaidDim) {
            LOGGER.info("[RaidDensFix] Player {} is in raid dimension. Deferring full recovery to recoverPlayer().", (Object)player.method_5477().getString());
            return;
        }
        LOGGER.info("[RaidDensFix] Player {} is in overworld. Restoring inventory from disk.", (Object)player.method_5477().getString());
        if (this.restoreFromDisk(player, true)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"[Raid Fix] ").method_27694(RaidRecoveryManager::onPlayerJoin$lambda$0).method_10852((class_2561)class_2561.method_43470((String)"Votre inventaire du dernier raid a ete restaure automatiquement.").method_27694(RaidRecoveryManager::onPlayerJoin$lambda$1)));
        }
    }

    public final void onServerClose() {
        watchdogTimers.clear();
        savedRaidItems.clear();
        battleTurnTracker.clear();
        unstallAttempts.clear();
        recoveredPlayers.clear();
    }

    @JvmStatic
    public static final void savePreRaidState(@NotNull List<? extends class_3222> players) {
        Intrinsics.checkNotNullParameter(players, (String)"players");
        for (class_3222 class_32222 : players) {
            if (class_32222 == null || !class_32222.method_5805() || RaidUtils.isRaidDimension((class_1937)class_32222.method_37908())) continue;
            INSTANCE.persistInventoryToDisk(class_32222);
            Object[] objectArray = new Object[5];
            objectArray[0] = class_32222.method_5477().getString();
            String string = "%.1f";
            Object[] objectArray2 = new Object[]{class_32222.method_23317()};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
            string = "%.1f";
            objectArray2 = new Object[]{class_32222.method_23318()};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
            string = "%.1f";
            objectArray2 = new Object[]{class_32222.method_23321()};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
            objectArray[4] = class_32222.method_37908().method_27983().method_29177();
            LOGGER.info("[RaidDensFix] Pre-raid state saved for {} at ({}, {}, {}) in {}", objectArray);
        }
    }

    @JvmStatic
    public static final void resyncPlayerPositions(@NotNull List<? extends class_3222> participants, @Nullable RaidRegion region) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        if (region == null) {
            return;
        }
        try {
            class_243 playerPos = region.getPlayerPos();
            class_243 bossPos = region.getBossPos();
            double dx = bossPos.field_1352 - playerPos.field_1352;
            double dz = bossPos.field_1350 - playerPos.field_1350;
            float yaw = (float)(Math.atan2(-dx, dz) * 57.29577951308232);
            for (class_3222 class_32222 : participants) {
                if (class_32222 == null || !class_32222.method_5805()) continue;
                class_32222.method_48105(class_32222.method_51469(), playerPos.field_1352, playerPos.field_1351, playerPos.field_1350, (Set)new HashSet(), yaw, 0.0f);
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = participants.size();
            String string = "%.1f";
            Object[] objectArray2 = new Object[]{playerPos.field_1352};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
            string = "%.1f";
            objectArray2 = new Object[]{playerPos.field_1351};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
            string = "%.1f";
            objectArray2 = new Object[]{playerPos.field_1350};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
            LOGGER.debug("[RaidDensFix] Resynced {} player position(s) at ({}, {}, {}) facing boss", objectArray);
        }
        catch (Exception e) {
            LOGGER.error("[RaidDensFix] Failed to resync player positions", (Throwable)e);
        }
    }

    @JvmStatic
    public static final void repositionBoss(@NotNull UUID raidId, @Nullable RaidRegion region) {
        Intrinsics.checkNotNullParameter((Object)raidId, (String)"raidId");
        LOGGER.debug("[RaidDensFix] repositionBoss called (no-op, handled by Raid Dens)");
    }

    private static final boolean checkForStalledBattles$lambda$1(UUID battleId) {
        boolean bl;
        block7: {
            Iterable $this$none$iv = RaidHelper.ACTIVE_RAIDS.values();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    boolean bl2;
                    block6: {
                        RaidInstance raid = (RaidInstance)element$iv;
                        boolean bl3 = false;
                        List list = raid.getBattles();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBattles(...)");
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                PokemonBattle it = (PokemonBattle)element$iv2;
                                boolean bl4 = false;
                                if (!(Intrinsics.areEqual((Object)it.getBattleId(), (Object)battleId) && !it.getEnded())) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean checkForStalledBattles$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean checkForStalledBattles$lambda$3(UUID battleId) {
        boolean bl;
        block7: {
            Iterable $this$none$iv = RaidHelper.ACTIVE_RAIDS.values();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    boolean bl2;
                    block6: {
                        RaidInstance raid = (RaidInstance)element$iv;
                        boolean bl3 = false;
                        List list = raid.getBattles();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBattles(...)");
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                PokemonBattle it = (PokemonBattle)element$iv2;
                                boolean bl4 = false;
                                if (!(Intrinsics.areEqual((Object)it.getBattleId(), (Object)battleId) && !it.getEnded())) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean checkForStalledBattles$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final class_2583 recoverPlayer$lambda$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 recoverPlayer$lambda$1(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final boolean restorePersistedInventories$lambda$0$0(Path it) {
        return StringsKt.endsWith$default((String)((Object)it).toString(), (String)".dat", (boolean)false, (int)2, null);
    }

    private static final boolean restorePersistedInventories$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit restorePersistedInventories$lambda$0$2(Ref.IntRef $count, Path file) {
        String uuidStr = StringsKt.removeSuffix((String)((Object)file.getFileName()).toString(), (CharSequence)".dat");
        try {
            UUID.fromString(uuidStr);
            int n = $count.element;
            $count.element = n + 1;
            LOGGER.info("[RaidDensFix] Found persisted inventory for UUID: {} (will restore on join)", (Object)uuidStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Unit.INSTANCE;
    }

    private static final void restorePersistedInventories$lambda$0$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final class_2583 onPlayerJoin$lambda$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 onPlayerJoin$lambda$1(class_2583 it) {
        return it.method_36139(0x55FF55);
    }
}

