/*
 * Decompiled with CFR 0.152.
 */
package fr.zooacademy.raiddensfix;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.necro.raid.dens.common.data.raid.RaidBoss;
import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.raids.helpers.RaidInventorySaveManager;
import com.necro.raid.dens.common.raids.helpers.RaidJoinHelper;
import fr.zooacademy.raiddensfix.RaidRecoveryManager;
import fr.zooacademy.raiddensfix.SpeciesTranslationService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\t\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0019\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lfr/zooacademy/raiddensfix/RaidDensFixMod;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "registerCommands", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "source", "Lnet/minecraft/class_3222;", "player", "", "recoverCommand", "(Lnet/minecraft/class_2168;Lnet/minecraft/class_3222;)I", "statusCommand", "(Lnet/minecraft/class_2168;)I", "", "raidIdStr", "forceCloseCommand", "(Lnet/minecraft/class_2168;Ljava/lang/String;)I", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/slf4j/Logger;", "raid-dens-fix"})
public final class RaidDensFixMod
implements ModInitializer {
    @NotNull
    public static final RaidDensFixMod INSTANCE = new RaidDensFixMod();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RaidDensFix");

    private RaidDensFixMod() {
    }

    public void onInitialize() {
        LOGGER.info("[RaidDensFix] Initializing Raid Dens Fix mod v1.0.0");
        SpeciesTranslationService.INSTANCE.load();
        ServerLifecycleEvents.SERVER_STARTED.register(RaidDensFixMod::onInitialize$lambda$0);
        ServerLifecycleEvents.SERVER_STOPPING.register(RaidDensFixMod::onInitialize$lambda$1);
        ServerTickEvents.END_SERVER_TICK.register(RaidDensFixMod::onInitialize$lambda$2);
        ServerPlayConnectionEvents.JOIN.register(RaidDensFixMod::onInitialize$lambda$3);
        CommandRegistrationCallback.EVENT.register(RaidDensFixMod::onInitialize$lambda$4);
        LOGGER.info("[RaidDensFix] Raid Dens Fix mod initialized successfully");
    }

    private final void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"raidfix").requires(RaidDensFixMod::registerCommands$lambda$0)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"recover").then(class_2170.method_9244((String)"player", (ArgumentType)((ArgumentType)class_2186.method_9305())).executes(RaidDensFixMod::registerCommands$lambda$1))).executes(RaidDensFixMod::registerCommands$lambda$2))).then(class_2170.method_9247((String)"status").executes(RaidDensFixMod::registerCommands$lambda$3))).then(class_2170.method_9247((String)"forceclose").then(class_2170.method_9244((String)"raidId", (ArgumentType)((ArgumentType)StringArgumentType.string())).executes(RaidDensFixMod::registerCommands$lambda$4))));
    }

    private final int recoverCommand(class_2168 source, class_3222 player) {
        LOGGER.info("[RaidDensFix] /raidfix recover executed for {}", (Object)player.method_5477().getString());
        RaidRecoveryManager.INSTANCE.recoverPlayer(player);
        source.method_9226(() -> RaidDensFixMod.recoverCommand$lambda$0(player), true);
        return 1;
    }

    private final int statusCommand(class_2168 source) {
        MinecraftServer server = source.method_9211();
        Map activeRaids = RaidHelper.ACTIVE_RAIDS;
        source.method_9226(RaidDensFixMod::statusCommand$lambda$0, false);
        source.method_9226(() -> RaidDensFixMod.statusCommand$lambda$1(activeRaids), false);
        Intrinsics.checkNotNull((Object)activeRaids);
        for (Map.Entry entry : activeRaids.entrySet()) {
            UUID uuid = (UUID)entry.getKey();
            RaidInstance instance = (RaidInstance)entry.getValue();
            RaidBoss boss = instance.getRaidBoss();
            Object object = boss;
            if (object == null || (object = object.getProperties()) == null || (object = object.getSpecies()) == null) {
                object = "Unknown";
            }
            Object bossName = object;
            int playerCount = instance.getPlayers().size();
            Object object2 = instance.getRaidState();
            if (object2 == null || (object2 = object2.name()) == null) {
                object2 = "UNKNOWN";
            }
            Object state = object2;
            source.method_9226(() -> RaidDensFixMod.statusCommand$lambda$2((String)bossName, boss, playerCount, (String)state, uuid), false);
        }
        class_3218 raidDim = ModDimensions.getRaidDimension((MinecraftServer)server);
        if (raidDim != null) {
            List playersInRaid = raidDim.method_18456();
            source.method_9226(() -> RaidDensFixMod.statusCommand$lambda$3(playersInRaid), false);
            for (class_3222 player : playersInRaid) {
                if (player == null) continue;
                PokemonBattle battle = BattleRegistry.getBattleByParticipatingPlayer((class_3222)player);
                boolean inBattle = battle != null;
                RaidJoinHelper.Participant participant = RaidJoinHelper.getParticipant((class_1657)((class_1657)player));
                boolean participating = participant != null;
                boolean hasSavedInv = RaidInventorySaveManager.hasSavedInventory((class_3222)player);
                int statusColor = inBattle ? 0x55FF55 : 0xFF5555;
                String statusText = inBattle ? "EN COMBAT" : "PAS EN COMBAT";
                source.method_9226(() -> RaidDensFixMod.statusCommand$lambda$4(player, statusText, participating, hasSavedInv, statusColor), false);
            }
        }
        source.method_9226(RaidDensFixMod::statusCommand$lambda$5, false);
        return 1;
    }

    private final int forceCloseCommand(class_2168 source, String raidIdStr) {
        try {
            UUID raidId = UUID.fromString(raidIdStr);
            RaidInstance instance = (RaidInstance)RaidHelper.ACTIVE_RAIDS.get(raidId);
            if (instance == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Raid " + raidIdStr + " non trouve dans les raids actifs")));
                return 0;
            }
            LOGGER.warn("[RaidDensFix] Force closing raid {} via /raidfix forceclose", (Object)raidIdStr);
            Iterator iterator = new ArrayList(instance.getPlayers()).iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                class_3222 player = (class_3222)iterator2.next();
                if (player == null) continue;
                RaidRecoveryManager.INSTANCE.recoverPlayer(player);
            }
            instance.closeRaid(source.method_9211());
            source.method_9226(() -> RaidDensFixMod.forceCloseCommand$lambda$0(raidIdStr), true);
            return 1;
        }
        catch (IllegalArgumentException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("UUID invalide: " + raidIdStr)));
            return 0;
        }
    }

    private static final void onInitialize$lambda$0(MinecraftServer server) {
        Intrinsics.checkNotNull((Object)server);
        RaidRecoveryManager.INSTANCE.init(server);
        SpeciesTranslationService.INSTANCE.buildEnglishMap();
        LOGGER.info("[RaidDensFix] Recovery manager initialized");
    }

    private static final void onInitialize$lambda$1(MinecraftServer minecraftServer) {
        RaidRecoveryManager.INSTANCE.onServerClose();
    }

    private static final void onInitialize$lambda$2(MinecraftServer server) {
        Intrinsics.checkNotNull((Object)server);
        RaidRecoveryManager.INSTANCE.tick(server);
    }

    private static final void onInitialize$lambda$3(class_3244 handler, PacketSender packetSender, MinecraftServer minecraftServer) {
        class_3222 player = handler.field_14140;
        Intrinsics.checkNotNull((Object)player);
        RaidRecoveryManager.INSTANCE.onPlayerJoin(player);
    }

    private static final void onInitialize$lambda$4(CommandDispatcher dispatcher, class_7157 class_71572, class_2170.class_5364 class_53642) {
        Intrinsics.checkNotNull((Object)dispatcher);
        INSTANCE.registerCommands((CommandDispatcher<class_2168>)dispatcher);
    }

    private static final boolean registerCommands$lambda$0(class_2168 it) {
        return it.method_9259(2);
    }

    private static final int registerCommands$lambda$1(CommandContext context) {
        class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        class_2168 class_21682 = (class_2168)object;
        Intrinsics.checkNotNull((Object)player);
        return INSTANCE.recoverCommand(class_21682, player);
    }

    private static final int registerCommands$lambda$2(CommandContext context) {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        class_2168 class_21682 = (class_2168)object;
        Intrinsics.checkNotNull((Object)player);
        return INSTANCE.recoverCommand(class_21682, player);
    }

    private static final int registerCommands$lambda$3(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.statusCommand((class_2168)object);
    }

    private static final int registerCommands$lambda$4(CommandContext context) {
        String raidId = StringArgumentType.getString((CommandContext)context, (String)"raidId");
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        class_2168 class_21682 = (class_2168)object;
        Intrinsics.checkNotNull((Object)raidId);
        return INSTANCE.forceCloseCommand(class_21682, raidId);
    }

    private static final class_2561 recoverCommand$lambda$0(class_3222 $player) {
        return (class_2561)class_2561.method_43470((String)("[Raid Fix] Recovery execute pour " + $player.method_5477().getString())).method_27694(RaidDensFixMod::recoverCommand$lambda$0$0);
    }

    private static final class_2583 recoverCommand$lambda$0$0(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final class_2561 statusCommand$lambda$0() {
        return (class_2561)class_2561.method_43470((String)"=== Raid Dens Fix - Status ===").method_27694(RaidDensFixMod::statusCommand$lambda$0$0);
    }

    private static final class_2583 statusCommand$lambda$0$0(class_2583 it) {
        return it.method_36139(0x55FFFF).method_10982(Boolean.valueOf(true));
    }

    private static final class_2561 statusCommand$lambda$1(Map $activeRaids) {
        return (class_2561)class_2561.method_43470((String)("Raids actifs: " + $activeRaids.size())).method_27694(RaidDensFixMod::statusCommand$lambda$1$0);
    }

    private static final class_2583 statusCommand$lambda$1$0(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2561 statusCommand$lambda$2(String $bossName, RaidBoss $boss, int $playerCount, String $state, UUID $uuid) {
        RaidBoss raidBoss = $boss;
        return (class_2561)class_2561.method_43470((String)("  - " + $bossName + " (T" + (raidBoss != null && (raidBoss = raidBoss.getTier()) != null ? Integer.valueOf(raidBoss.ordinal() + 1) : "?") + ") | " + $playerCount + " joueurs | " + $state + " | " + $uuid)).method_27694(RaidDensFixMod::statusCommand$lambda$2$0);
    }

    private static final class_2583 statusCommand$lambda$2$0(class_2583 it) {
        return it.method_36139(0xAAAAAA);
    }

    private static final class_2561 statusCommand$lambda$3(List $playersInRaid) {
        return (class_2561)class_2561.method_43470((String)("Joueurs dans raid_dimension: " + $playersInRaid.size())).method_27694(RaidDensFixMod::statusCommand$lambda$3$0);
    }

    private static final class_2583 statusCommand$lambda$3$0(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2561 statusCommand$lambda$4(class_3222 $player, String $statusText, boolean $participating, boolean $hasSavedInv, int $statusColor) {
        return (class_2561)class_2561.method_43470((String)("  - " + $player.method_5477().getString() + ": " + $statusText + " | participant=" + $participating + " | inv_saved=" + $hasSavedInv)).method_27694(arg_0 -> RaidDensFixMod.statusCommand$lambda$4$0($statusColor, arg_0));
    }

    private static final class_2583 statusCommand$lambda$4$0(int $statusColor, class_2583 it) {
        return it.method_36139($statusColor);
    }

    private static final class_2561 statusCommand$lambda$5() {
        return (class_2561)class_2561.method_43470((String)"--- Fin du status ---").method_27694(RaidDensFixMod::statusCommand$lambda$5$0);
    }

    private static final class_2583 statusCommand$lambda$5$0(class_2583 it) {
        return it.method_36139(0x55FFFF);
    }

    private static final class_2561 forceCloseCommand$lambda$0(String $raidIdStr) {
        return (class_2561)class_2561.method_43470((String)("[Raid Fix] Raid " + $raidIdStr + " ferme de force. Tous les joueurs ont ete recuperes.")).method_27694(RaidDensFixMod::forceCloseCommand$lambda$0$0);
    }

    private static final class_2583 forceCloseCommand$lambda$0$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }
}

