/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ludichat.cobbreeding.utils.SemVerKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0086\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0086\u0002\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\t\u0010\fR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lludichat/cobbreeding/utils/SemVer;", "", "", "", "components", "<init>", "(Ljava/util/List;)V", "", "ver", "compareTo", "(I)I", "(Ljava/lang/String;)I", "(Lludichat/cobbreeding/utils/SemVer;)I", "Ljava/util/List;", "getComponents", "()Ljava/util/List;", "getMajor", "()I", "major", "getMinor", "minor", "getPatch", "patch", "getOthers", "others", "common"})
public final class SemVer {
    @NotNull
    private final List<String> components;

    public SemVer(@NotNull List<String> components) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        this.components = components;
    }

    @NotNull
    public final List<String> getComponents() {
        return this.components;
    }

    public final int getMajor() {
        String string = (String)CollectionsKt.getOrNull(this.components, (int)0);
        return string != null ? Integer.parseInt(string) : 0;
    }

    public final int getMinor() {
        String string = (String)CollectionsKt.getOrNull(this.components, (int)1);
        return string != null ? Integer.parseInt(string) : 0;
    }

    public final int getPatch() {
        String string = (String)CollectionsKt.getOrNull(this.components, (int)2);
        return string != null ? Integer.parseInt(string) : 0;
    }

    @NotNull
    public final List<String> getOthers() {
        return this.components.size() > 3 ? this.components.subList(3, this.components.size()) : CollectionsKt.emptyList();
    }

    public final int compareTo(int ver) {
        return Intrinsics.compare((int)this.getMajor(), (int)ver);
    }

    public final int compareTo(@NotNull String ver) {
        Intrinsics.checkNotNullParameter((Object)ver, (String)"ver");
        return this.compareTo(SemVerKt.toSemVer(ver));
    }

    public final int compareTo(@NotNull SemVer ver) {
        int n;
        Intrinsics.checkNotNullParameter((Object)ver, (String)"ver");
        int ma = Intrinsics.compare((int)this.getMajor(), (int)ver.getMajor());
        int mi = Intrinsics.compare((int)this.getMinor(), (int)ver.getMinor());
        int pa = Intrinsics.compare((int)this.getPatch(), (int)ver.getPatch());
        if (ma == 0) {
            if (mi == 0) {
                if (pa == 0) {
                    boolean ot2;
                    boolean ot1 = !((Collection)this.getOthers()).isEmpty();
                    boolean bl = ot2 = !((Collection)ver.getOthers()).isEmpty();
                    n = ot1 && !ot2 ? 1 : (!ot1 && ot2 ? -1 : 0);
                } else {
                    n = pa;
                }
            } else {
                n = mi;
            }
        } else {
            n = ma;
        }
        return n;
    }
}

