/*
 * Decompiled with CFR 0.152.
 */
package fr.zooacademy.pokedexrewards;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokedex.CaughtCount;
import com.cobblemon.mod.common.api.pokedex.GlobalPokedexValueCalculator;
import com.cobblemon.mod.common.api.pokedex.PokedexManager;
import com.cobblemon.mod.common.api.pokedex.SeenCount;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PokedexRewardsMod
implements ModInitializer {
    public static final String MOD_ID = "pokedex-rewards";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"pokedex-rewards");
    private static final int TOTAL_POKEMON = 1025;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<int[], Integer> REWARDS_BY_RANGE = new LinkedHashMap<int[], Integer>();
    private Path claimedFilePath;
    private Map<String, List<Integer>> claimedMilestones = new HashMap<String, List<Integer>>();
    private MinecraftServer server;

    public void onInitialize() {
        LOGGER.info("Initializing Pokedex Rewards Mod for Zoo Academy");
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.server = server;
            this.claimedFilePath = server.method_27050(class_5218.field_24188).resolve("pokedex_rewards_claimed.json");
            this.loadClaimedMilestones();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.saveClaimedMilestones());
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> this.registerCommands((CommandDispatcher<class_2168>)dispatcher));
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pokedexreward").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"check").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.executeCheck((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player").method_5477().getString()))))).then(class_2170.method_9247((String)"claim").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.executeClaim((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player").method_5477().getString()))))).then(class_2170.method_9247((String)"reset").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> this.executeReset((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player").method_5477().getString())))));
    }

    private int executeCheck(CommandContext<class_2168> ctx, String playerName) {
        class_3222 player = this.server.method_3760().method_14566(playerName);
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Joueur non trouve: " + playerName)));
            return 0;
        }
        PokedexStats stats = this.getPokedexStats(player);
        int pendingReward = this.calculatePendingReward(player.method_5845(), stats.currentMilestone);
        player.method_43496((class_2561)class_2561.method_43470((String)""));
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a76\u00a7l\u2605 Assistant de Chen \u00a7r\u00a77:"));
        player.method_43496((class_2561)class_2561.method_43470((String)("\u00a77Tu as capture \u00a7e" + stats.caught + "\u00a77 Pokemon et vu \u00a7b" + stats.seen + "\u00a77!")));
        player.method_43496((class_2561)class_2561.method_43470((String)("\u00a77Completion: \u00a7a" + String.format("%.1f", stats.completionPercent) + "%\u00a77 du Pokedex National!")));
        if (pendingReward > 0) {
            player.method_43496((class_2561)class_2561.method_43470((String)""));
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7eRecompenses en attente: \u00a76+" + pendingReward + " PokeDollars\u00a7e!")));
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a77Parle-moi encore pour les recuperer!"));
        } else {
            player.method_43496((class_2561)class_2561.method_43470((String)""));
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a77Tu as deja recupere toutes tes recompenses."));
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a77Continue a capturer des Pokemon et reviens me voir!"));
        }
        return 1;
    }

    private int executeClaim(CommandContext<class_2168> ctx, String playerName) {
        class_3222 player = this.server.method_3760().method_14566(playerName);
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Joueur non trouve: " + playerName)));
            return 0;
        }
        String uuid = player.method_5845();
        PokedexStats stats = this.getPokedexStats(player);
        List<int[]> pendingMilestones = this.getPendingMilestones(uuid, stats.currentMilestone);
        if (pendingMilestones.isEmpty()) {
            player.method_43496((class_2561)class_2561.method_43470((String)""));
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a76\u00a7l\u2605 Assistant de Chen \u00a7r\u00a77:"));
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a77Tu n'as pas de nouvelles recompenses pour le moment."));
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a77Continue ton aventure et reviens me voir!"));
            return 0;
        }
        int totalReward = 0;
        List claimed = this.claimedMilestones.computeIfAbsent(uuid, k -> new ArrayList());
        for (int[] milestone : pendingMilestones) {
            totalReward += milestone[1];
            claimed.add(milestone[0]);
        }
        Collections.sort(claimed);
        this.saveClaimedMilestones();
        int amountWithDecimals = totalReward * 100;
        this.server.method_3734().method_44252(this.server.method_3739(), "guishop balance guishop:credit add " + playerName + " " + amountWithDecimals);
        player.method_43496((class_2561)class_2561.method_43470((String)""));
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a76\u00a7l\u2605 Assistant de Chen \u00a7r\u00a77:"));
        player.method_43496((class_2561)class_2561.method_43470((String)("\u00a77Tu as capture \u00a7e" + stats.caught + "\u00a77 Pokemon (\u00a7a" + String.format("%.1f", stats.completionPercent) + "%\u00a77)!")));
        player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7aRecompense: \u00a7e+" + totalReward + " PokeDollars\u00a7a!")));
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a77Continue ton aventure et reviens me voir!"));
        LOGGER.info("Player {} claimed {} PokeDollars for Pokedex milestones", (Object)playerName, (Object)totalReward);
        return 1;
    }

    private int executeReset(CommandContext<class_2168> ctx, String playerName) {
        class_3222 player = this.server.method_3760().method_14566(playerName);
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Joueur non trouve: " + playerName)));
            return 0;
        }
        this.claimedMilestones.remove(player.method_5845());
        this.saveClaimedMilestones();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aRecompenses Pokedex reinitialisees pour " + playerName)), true);
        return 1;
    }

    private PokedexStats getPokedexStats(class_3222 player) {
        PokedexManager pokedex = Cobblemon.INSTANCE.getPlayerDataManager().getPokedexData(player);
        int caught = (Integer)pokedex.getGlobalCalculatedValue((GlobalPokedexValueCalculator)CaughtCount.INSTANCE);
        int seen = (Integer)pokedex.getGlobalCalculatedValue((GlobalPokedexValueCalculator)SeenCount.INSTANCE);
        double completionPercent = (double)caught * 100.0 / 1025.0;
        int currentMilestone = (int)completionPercent / 2 * 2;
        return new PokedexStats(caught, seen, completionPercent, currentMilestone);
    }

    private int getRewardForMilestone(int milestone) {
        for (Map.Entry<int[], Integer> entry : REWARDS_BY_RANGE.entrySet()) {
            int[] range = entry.getKey();
            if (milestone < range[0] || milestone >= range[1]) continue;
            return entry.getValue();
        }
        if (milestone >= 100) {
            return 20000;
        }
        return 0;
    }

    private List<int[]> getPendingMilestones(String uuid, int currentMilestone) {
        List claimed = this.claimedMilestones.getOrDefault(uuid, new ArrayList());
        ArrayList<int[]> pending = new ArrayList<int[]>();
        for (int milestone = 2; milestone <= currentMilestone; milestone += 2) {
            if (claimed.contains(milestone)) continue;
            int reward = this.getRewardForMilestone(milestone);
            pending.add(new int[]{milestone, reward});
        }
        return pending;
    }

    private int calculatePendingReward(String uuid, int currentMilestone) {
        return this.getPendingMilestones(uuid, currentMilestone).stream().mapToInt(m -> m[1]).sum();
    }

    private void loadClaimedMilestones() {
        if (Files.exists(this.claimedFilePath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(this.claimedFilePath);){
                Type type = new TypeToken<Map<String, List<Integer>>>(this){}.getType();
                this.claimedMilestones = (Map)GSON.fromJson((Reader)reader, type);
                if (this.claimedMilestones == null) {
                    this.claimedMilestones = new HashMap<String, List<Integer>>();
                }
                LOGGER.info("Loaded claimed milestones for {} players", (Object)this.claimedMilestones.size());
            }
            catch (Exception e) {
                LOGGER.error("Failed to load claimed milestones", (Throwable)e);
                this.claimedMilestones = new HashMap<String, List<Integer>>();
            }
        }
    }

    private void saveClaimedMilestones() {
        try {
            Files.createDirectories(this.claimedFilePath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.claimedFilePath, new OpenOption[0]);){
                GSON.toJson(this.claimedMilestones, (Appendable)writer);
            }
            LOGGER.info("Saved claimed milestones for {} players", (Object)this.claimedMilestones.size());
        }
        catch (Exception e) {
            LOGGER.error("Failed to save claimed milestones", (Throwable)e);
        }
    }

    static {
        REWARDS_BY_RANGE.put(new int[]{0, 10}, 2000);
        REWARDS_BY_RANGE.put(new int[]{10, 20}, 4000);
        REWARDS_BY_RANGE.put(new int[]{20, 30}, 6000);
        REWARDS_BY_RANGE.put(new int[]{30, 40}, 8000);
        REWARDS_BY_RANGE.put(new int[]{40, 50}, 10000);
        REWARDS_BY_RANGE.put(new int[]{50, 60}, 12000);
        REWARDS_BY_RANGE.put(new int[]{60, 70}, 14000);
        REWARDS_BY_RANGE.put(new int[]{70, 80}, 16000);
        REWARDS_BY_RANGE.put(new int[]{80, 90}, 18000);
        REWARDS_BY_RANGE.put(new int[]{90, 100}, 20000);
    }

    private record PokedexStats(int caught, int seen, double completionPercent, int currentMilestone) {
    }
}

