/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.util;

import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.duel.DuelManager;
import com.music176.pokemonleague.gym.GymManager;
import com.music176.pokemonleague.league.LeagueManager;
import com.music176.pokemonleague.ranked.RankedManager;
import com.music176.pokemonleague.tournament.TournamentManager;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/music176/pokemonleague/util/CommandBlocker;", "", "<init>", "()V", "Ljava/util/UUID;", "playerId", "", "isPlayerInBlockedState", "(Ljava/util/UUID;)Z", "", "command", "shouldBlockCommand", "(Ljava/lang/String;)Z", "Lnet/minecraft/class_3222;", "player", "tryBlockCommand", "(Lnet/minecraft/class_3222;Ljava/lang/String;)Z", "getBlockedReason", "(Ljava/util/UUID;)Ljava/lang/String;", "", "BLOCKED_COMMANDS", "Ljava/util/List;", "ALLOWED_COMMANDS", "pokemon-league-mod"})
public final class CommandBlocker {
    @NotNull
    public static final CommandBlocker INSTANCE = new CommandBlocker();
    @NotNull
    private static final List<String> BLOCKED_COMMANDS;
    @NotNull
    private static final List<String> ALLOWED_COMMANDS;

    private CommandBlocker() {
    }

    public final boolean isPlayerInBlockedState(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return LeagueManager.INSTANCE.isPlayerActive(playerId) || GymManager.INSTANCE.isPlayerActive(playerId) || DuelManager.INSTANCE.isPlayerInDuel(playerId) || RankedManager.INSTANCE.isPlayerInSession(playerId) || TournamentManager.INSTANCE.isPlayerInTournament(playerId);
    }

    public final boolean shouldBlockCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        String string = command.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String lowerCommand = ((Object)StringsKt.trim((CharSequence)string)).toString();
        for (String allowed : ALLOWED_COMMANDS) {
            if (!StringsKt.startsWith$default((String)lowerCommand, (String)allowed, (boolean)false, (int)2, null)) continue;
            return false;
        }
        for (String blocked : BLOCKED_COMMANDS) {
            if (!Intrinsics.areEqual((Object)lowerCommand, (Object)blocked) && !StringsKt.startsWith$default((String)lowerCommand, (String)(blocked + " "), (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    public final boolean tryBlockCommand(@NotNull class_3222 player, @NotNull String command) {
        String quitCommand;
        String string;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        if (!this.isPlayerInBlockedState(uUID)) {
            return false;
        }
        if (!this.shouldBlockCommand(command)) {
            return false;
        }
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        if (LeagueManager.INSTANCE.isPlayerActive(uUID2)) {
            string = "la Ligue";
        } else {
            UUID uUID3 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
            if (GymManager.INSTANCE.isPlayerActive(uUID3)) {
                string = "un defi d'arene";
            } else {
                UUID uUID4 = player.method_5667();
                Intrinsics.checkNotNullExpressionValue((Object)uUID4, (String)"getUUID(...)");
                if (DuelManager.INSTANCE.isPlayerInDuel(uUID4)) {
                    string = "un duel";
                } else {
                    UUID uUID5 = player.method_5667();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID5, (String)"getUUID(...)");
                    if (RankedManager.INSTANCE.isPlayerInSession(uUID5)) {
                        string = "un combat ranked";
                    } else {
                        UUID uUID6 = player.method_5667();
                        Intrinsics.checkNotNullExpressionValue((Object)uUID6, (String)"getUUID(...)");
                        string = TournamentManager.INSTANCE.isPlayerInTournament(uUID6) ? "un tournoi" : "un combat";
                    }
                }
            }
        }
        String sessionType = string;
        player.method_43496((class_2561)class_2561.method_43470((String)("Cette commande est desactivee pendant " + sessionType + "!")).method_27694(CommandBlocker::tryBlockCommand$lambda$0));
        UUID uUID7 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID7, (String)"getUUID(...)");
        if (LeagueManager.INSTANCE.isPlayerActive(uUID7)) {
            v8 = "/league quit";
        } else {
            UUID uUID8 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID8, (String)"getUUID(...)");
            if (GymManager.INSTANCE.isPlayerActive(uUID8)) {
                v8 = "/gym quit";
            } else {
                UUID uUID9 = player.method_5667();
                Intrinsics.checkNotNullExpressionValue((Object)uUID9, (String)"getUUID(...)");
                if (DuelManager.INSTANCE.isPlayerInDuel(uUID9)) {
                    v8 = "/duel quit";
                } else {
                    UUID uUID10 = player.method_5667();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID10, (String)"getUUID(...)");
                    if (RankedManager.INSTANCE.isPlayerInSession(uUID10)) {
                        v8 = "/combat quit";
                    } else {
                        UUID uUID11 = player.method_5667();
                        Intrinsics.checkNotNullExpressionValue((Object)uUID11, (String)"getUUID(...)");
                        v8 = quitCommand = TournamentManager.INSTANCE.isPlayerInTournament(uUID11) ? "/tournois leave" : null;
                    }
                }
            }
        }
        if (quitCommand != null) {
            player.method_43496((class_2561)class_2561.method_43470((String)("Utilisez " + quitCommand + " pour abandonner.")).method_27694(CommandBlocker::tryBlockCommand$lambda$1));
        }
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Blocked command '/" + command + "' for player " + player.method_5477().getString() + " (in " + sessionType + ")");
        return true;
    }

    @Nullable
    public final String getBlockedReason(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return LeagueManager.INSTANCE.isPlayerActive(playerId) ? "Vous etes dans la Ligue" : (GymManager.INSTANCE.isPlayerActive(playerId) ? "Vous etes dans un defi d'arene" : (DuelManager.INSTANCE.isPlayerInDuel(playerId) ? "Vous etes dans un duel" : (RankedManager.INSTANCE.isPlayerInSession(playerId) ? "Vous etes dans un combat ranked" : (TournamentManager.INSTANCE.isPlayerInTournament(playerId) ? "Vous etes dans un tournoi" : null))));
    }

    private static final class_2583 tryBlockCommand$lambda$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 tryBlockCommand$lambda$1(class_2583 it) {
        return it.method_36139(0xAAAAAA);
    }

    static {
        Object[] objectArray = new String[]{"spawn", "home", "sethome", "back", "tp", "tpa", "tpaccept", "tpahere", "tpyes", "tpdeny", "tpno", "warp", "warps", "rtp", "wild", "wilderness", "randomtp", "randomteleport", "tppos", "tphere", "s]", "hub", "lobby", "server"};
        BLOCKED_COMMANDS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"league quit", "ligue quit", "gym quit", "arene quit", "duel quit", "combat quit", "tournament leave", "tournament quit", "tournois leave", "tournois quit"};
        ALLOWED_COMMANDS = CollectionsKt.listOf((Object[])objectArray);
    }
}

