/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.tournament;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.scheduling.SchedulingFunctionsKt;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.BattleStartResult;
import com.cobblemon.mod.common.battles.ErroredBattleStart;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.config.Position;
import com.music176.pokemonleague.duel.DuelManager;
import com.music176.pokemonleague.gym.GymManager;
import com.music176.pokemonleague.inventory.InventoryManager;
import com.music176.pokemonleague.league.LeagueManager;
import com.music176.pokemonleague.profile.PlayerProfileManager;
import com.music176.pokemonleague.tournament.MatchState;
import com.music176.pokemonleague.tournament.RoundFormats;
import com.music176.pokemonleague.tournament.TournamentArena;
import com.music176.pokemonleague.tournament.TournamentBracket;
import com.music176.pokemonleague.tournament.TournamentConfig;
import com.music176.pokemonleague.tournament.TournamentMatch;
import com.music176.pokemonleague.tournament.TournamentMode;
import com.music176.pokemonleague.tournament.TournamentParticipant;
import com.music176.pokemonleague.tournament.TournamentRewardItem;
import com.music176.pokemonleague.tournament.TournamentRewards;
import com.music176.pokemonleague.tournament.TournamentSession;
import com.music176.pokemonleague.tournament.TournamentState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1259;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003J\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u0003JE\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0003J\u0015\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010!\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000b\u00a2\u0006\u0004\b!\u0010 J\u0015\u0010#\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u000b\u00a2\u0006\u0004\b#\u0010 J\u0017\u0010%\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010'\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b'\u0010\u0003J\u000f\u0010(\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b(\u0010\u0003J\u000f\u0010)\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b)\u0010\u0003J\u0015\u0010+\u001a\b\u0012\u0004\u0012\u00020\r0*H\u0002\u00a2\u0006\u0004\b+\u0010,J\u001f\u00100\u001a\u00020\u00062\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b0\u00101J\u0017\u00102\u001a\u00020\u00062\u0006\u0010.\u001a\u00020-H\u0002\u00a2\u0006\u0004\b2\u00103J\u0017\u00104\u001a\u00020\u00062\u0006\u0010.\u001a\u00020-H\u0002\u00a2\u0006\u0004\b4\u00103J'\u00107\u001a\u00020\u00062\u0006\u0010.\u001a\u00020-2\u0006\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b7\u00108J3\u0010;\u001a\u00020\u00062\u0006\u0010.\u001a\u00020-2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u000b0*2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000b0*H\u0002\u00a2\u0006\u0004\b;\u0010<J\u0017\u0010=\u001a\u00020\u00062\u0006\u0010.\u001a\u00020-H\u0002\u00a2\u0006\u0004\b=\u00103J)\u0010A\u001a\u00020\u00062\f\u0010?\u001a\b\u0012\u0004\u0012\u00020>0*2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020>0*\u00a2\u0006\u0004\bA\u0010BJ'\u0010F\u001a\u00020\u00062\u0006\u0010.\u001a\u00020-2\u0006\u0010D\u001a\u00020C2\u0006\u0010E\u001a\u00020CH\u0002\u00a2\u0006\u0004\bF\u0010GJ\u0015\u0010I\u001a\u00020\u00062\u0006\u0010H\u001a\u00020>\u00a2\u0006\u0004\bI\u0010JJ\u000f\u0010K\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\bK\u0010\u0003J\u0017\u0010M\u001a\u00020\u00062\u0006\u0010L\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\bM\u0010NJ-\u0010P\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020O0*2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\bP\u0010QJ\u000f\u0010R\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\bR\u0010\u0003J\u0015\u0010T\u001a\u00020\u00062\u0006\u0010S\u001a\u00020\u001a\u00a2\u0006\u0004\bT\u0010UJ\u001f\u0010X\u001a\u00020\u00062\u0006\u0010V\u001a\u00020C2\u0006\u0010W\u001a\u00020\rH\u0002\u00a2\u0006\u0004\bX\u0010YJ\u0015\u0010Z\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000b\u00a2\u0006\u0004\bZ\u0010[J\u0015\u0010\\\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000b\u00a2\u0006\u0004\b\\\u0010[J\u0017\u0010]\u001a\u00020\u00062\u0006\u0010.\u001a\u00020-H\u0002\u00a2\u0006\u0004\b]\u00103J\u0015\u0010^\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020>\u00a2\u0006\u0004\b^\u0010_J\u0015\u0010`\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020>\u00a2\u0006\u0004\b`\u0010_J\u000f\u0010a\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0004\ba\u0010bJ\u0015\u0010c\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000b\u00a2\u0006\u0004\bc\u0010 J\u001f\u0010f\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010e\u001a\u00020dH\u0002\u00a2\u0006\u0004\bf\u0010gJ\u0017\u0010h\u001a\u00020\u00062\u0006\u0010V\u001a\u00020CH\u0002\u00a2\u0006\u0004\bh\u0010iJ\u0017\u0010j\u001a\u00020\u00062\u0006\u0010V\u001a\u00020CH\u0002\u00a2\u0006\u0004\bj\u0010iJ\u0017\u0010k\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\bk\u0010[J\u0017\u0010n\u001a\u00020\u00062\u0006\u0010m\u001a\u00020lH\u0002\u00a2\u0006\u0004\bn\u0010oJ\u0017\u0010p\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\bp\u0010[J\u0017\u0010q\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\bq\u0010[J\u0017\u0010r\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\br\u0010[J!\u0010s\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000b2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\bs\u0010tJ\u001d\u0010v\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010u\u001a\u00020\u0015\u00a2\u0006\u0004\bv\u0010wJ\u0015\u0010x\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000b\u00a2\u0006\u0004\bx\u0010[J\u000f\u0010y\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\by\u0010\u0003J\u0015\u0010z\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020>\u00a2\u0006\u0004\bz\u0010_J\u0015\u0010{\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020>\u00a2\u0006\u0004\b{\u0010_J\u0011\u0010|\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0004\b|\u0010}J\u001f\u0010~\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b~\u0010\u007fJ\u001f\u0010\u0080\u0001\u001a\u00020\u00062\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\r\u00a2\u0006\u0005\b\u0080\u0001\u00101J\u0011\u0010\u0081\u0001\u001a\u00020\u0006H\u0002\u00a2\u0006\u0005\b\u0081\u0001\u0010\u0003J(\u0010\u0084\u0001\u001a\u0010\u0012\u0005\u0012\u00030\u0083\u0001\u0012\u0004\u0012\u00020\r0\u0082\u00012\u0006\u0010V\u001a\u00020CH\u0002\u00a2\u0006\u0006\b\u0084\u0001\u0010\u0085\u0001J!\u0010\u0086\u0001\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\rH\u0002\u00a2\u0006\u0005\b\u0086\u0001\u0010\u007fJ!\u0010\u0087\u0001\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\rH\u0002\u00a2\u0006\u0005\b\u0087\u0001\u0010\u007fJ\u0018\u0010\u0088\u0001\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\r\u00a2\u0006\u0006\b\u0088\u0001\u0010\u0089\u0001J\u0011\u0010\u008a\u0001\u001a\u00020\u0006H\u0002\u00a2\u0006\u0005\b\u008a\u0001\u0010\u0003R\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0005\u0010\u008b\u0001R,\u0010\u008e\u0001\u001a\u00030\u008c\u00012\b\u0010\u008d\u0001\u001a\u00030\u008c\u00018\u0006@BX\u0086.\u00a2\u0006\u0010\n\u0006\b\u008e\u0001\u0010\u008f\u0001\u001a\u0006\b\u0090\u0001\u0010\u0091\u0001R\u001b\u0010\u0092\u0001\u001a\u0004\u0018\u00010\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0092\u0001\u0010\u0093\u0001R$\u0010\u0095\u0001\u001a\u000f\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020>0\u0094\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0095\u0001\u0010\u0096\u0001R$\u0010\u0097\u0001\u001a\u000f\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020>0\u0094\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0097\u0001\u0010\u0096\u0001R$\u0010\u0098\u0001\u001a\u000f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020>0\u0094\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0098\u0001\u0010\u0096\u0001R\u0019\u0010\u0099\u0001\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0099\u0001\u0010\u009a\u0001R%\u0010\u009c\u0001\u001a\u0010\u0012\u0004\u0012\u00020>\u0012\u0005\u0012\u00030\u009b\u00010\u0094\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u009c\u0001\u0010\u0096\u0001R$\u0010\u009d\u0001\u001a\u000f\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020\r0\u0094\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u009d\u0001\u0010\u0096\u0001R3\u0010\u009f\u0001\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0013\u0012\u0011\u0012\u0005\u0012\u00030\u009e\u0001\u0012\u0005\u0012\u00030\u009e\u00010\u0082\u00010\u0094\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u009f\u0001\u0010\u0096\u0001R\u0019\u0010\u00a0\u0001\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u00a0\u0001\u0010\u009a\u0001\u00a8\u0006\u00a1\u0001"}, d2={"Lcom/music176/pokemonleague/tournament/TournamentManager;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "initialize", "(Lnet/minecraft/server/MinecraftServer;)V", "shutdown", "reloadConfig", "Lnet/minecraft/class_3222;", "creator", "", "name", "Lcom/music176/pokemonleague/tournament/TournamentMode;", "mode", "Lcom/music176/pokemonleague/tournament/RoundFormats;", "roundFormats", "Lcom/music176/pokemonleague/tournament/TournamentRewards;", "rewards", "", "maxParticipants", "Lcom/music176/pokemonleague/tournament/TournamentSession;", "createTournament", "(Lnet/minecraft/class_3222;Ljava/lang/String;Lcom/music176/pokemonleague/tournament/TournamentMode;Lcom/music176/pokemonleague/tournament/RoundFormats;Lcom/music176/pokemonleague/tournament/TournamentRewards;I)Lcom/music176/pokemonleague/tournament/TournamentSession;", "", "openRegistration", "()Z", "startRegistrationBroadcast", "player", "registerPlayer", "(Lnet/minecraft/class_3222;)Z", "unregisterPlayer", "admin", "startTournament", "remainingSeconds", "startPreTournamentCountdown", "(I)V", "prepareAllParticipants", "actuallyStartTournament", "scheduleNextMatches", "", "getAvailableArenas", "()Ljava/util/List;", "Lcom/music176/pokemonleague/tournament/TournamentMatch;", "match", "arenaId", "startMatch", "(Lcom/music176/pokemonleague/tournament/TournamentMatch;Ljava/lang/String;)V", "startMatchCountdown", "(Lcom/music176/pokemonleague/tournament/TournamentMatch;)V", "startBattle", "player1", "player2", "start1v1Battle", "(Lcom/music176/pokemonleague/tournament/TournamentMatch;Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;)V", "team1Players", "team2Players", "start2v2Battle", "(Lcom/music176/pokemonleague/tournament/TournamentMatch;Ljava/util/List;Ljava/util/List;)V", "handleMatchError", "Ljava/util/UUID;", "winnerIds", "loserIds", "handleBattleResult", "(Ljava/util/List;Ljava/util/List;)V", "Lcom/music176/pokemonleague/tournament/TournamentParticipant;", "winner", "loser", "completeMatch", "(Lcom/music176/pokemonleague/tournament/TournamentMatch;Lcom/music176/pokemonleague/tournament/TournamentParticipant;Lcom/music176/pokemonleague/tournament/TournamentParticipant;)V", "playerId", "handlePlayerForfeit", "(Ljava/util/UUID;)V", "finalizeTournament", "tournament", "distributeRewards", "(Lcom/music176/pokemonleague/tournament/TournamentSession;)V", "Lcom/music176/pokemonleague/tournament/TournamentRewardItem;", "giveRewards", "(Lnet/minecraft/class_3222;Ljava/util/List;Lcom/music176/pokemonleague/tournament/TournamentMode;)V", "endCeremony", "cancelled", "endTournament", "(Z)V", "participant", "reason", "disqualifyParticipant", "(Lcom/music176/pokemonleague/tournament/TournamentParticipant;Ljava/lang/String;)V", "handlePlayerDisconnect", "(Lnet/minecraft/class_3222;)V", "handlePlayerReconnect", "checkReconnectionTimeout", "isPlayerInTournament", "(Ljava/util/UUID;)Z", "isPlayerInMatch", "getActiveTournament", "()Lcom/music176/pokemonleague/tournament/TournamentSession;", "canPlayerJoinTournament", "Lcom/music176/pokemonleague/config/Position;", "position", "teleportToPosition", "(Lnet/minecraft/class_3222;Lcom/music176/pokemonleague/config/Position;)V", "teleportParticipantBack", "(Lcom/music176/pokemonleague/tournament/TournamentParticipant;)V", "teleportToSpectatorArea", "recallAllPokemon", "Lnet/minecraft/class_2561;", "message", "broadcastToServer", "(Lnet/minecraft/class_2561;)V", "healPlayerParty", "applySaturation", "removeSaturation", "addTournamentSpectator", "(Lnet/minecraft/class_3222;Ljava/lang/String;)Z", "arenaNumber", "switchSpectatorArena", "(Lnet/minecraft/class_3222;I)Z", "removeTournamentSpectator", "endAllTournamentSpectators", "isTournamentSpectator", "isPlayerEliminated", "getFirstActiveArena", "()Ljava/lang/String;", "teleportSpectatorToArena", "(Lnet/minecraft/class_3222;Ljava/lang/String;)V", "createBossBarsForMatch", "startBossBarUpdateLoop", "Lkotlin/Pair;", "", "getPartyHpInfo", "(Lcom/music176/pokemonleague/tournament/TournamentParticipant;)Lkotlin/Pair;", "addSpectatorToBossBars", "removeSpectatorFromBossBars", "cleanupArenaBossBars", "(Ljava/lang/String;)V", "cleanupAllBossBars", "Lnet/minecraft/server/MinecraftServer;", "Lcom/music176/pokemonleague/tournament/TournamentConfig;", "value", "config", "Lcom/music176/pokemonleague/tournament/TournamentConfig;", "getConfig", "()Lcom/music176/pokemonleague/tournament/TournamentConfig;", "activeTournament", "Lcom/music176/pokemonleague/tournament/TournamentSession;", "Ljava/util/concurrent/ConcurrentHashMap;", "playerToTournament", "Ljava/util/concurrent/ConcurrentHashMap;", "playerToMatch", "arenaToMatch", "broadcastTaskRunning", "Z", "Lnet/minecraft/class_1934;", "tournamentSpectators", "spectatorArenaChoice", "Lnet/minecraft/class_3213;", "arenaBossBars", "bossBarTaskRunning", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nTournamentManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TournamentManager.kt\ncom/music176/pokemonleague/tournament/TournamentManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1759:1\n1869#2:1760\n1869#2,2:1761\n1870#2:1763\n1878#2,3:1764\n774#2:1767\n865#2,2:1768\n1563#2:1770\n1634#2,3:1771\n1869#2,2:1774\n1869#2,2:1776\n1869#2,2:1778\n1869#2,2:1780\n1869#2,2:1782\n1617#2,9:1784\n1869#2:1793\n1870#2:1795\n1626#2:1796\n1617#2,9:1797\n1869#2:1806\n1870#2:1808\n1626#2:1809\n1869#2,2:1810\n1869#2,2:1812\n774#2:1814\n865#2,2:1815\n1563#2:1817\n1634#2,3:1818\n774#2:1821\n865#2,2:1822\n1563#2:1824\n1634#2,3:1825\n774#2:1828\n865#2,2:1829\n1563#2:1831\n1634#2,3:1832\n774#2:1835\n865#2,2:1836\n1563#2:1838\n1634#2,3:1839\n1869#2,2:1843\n1869#2,2:1845\n1761#2,3:1847\n1869#2,2:1850\n1869#2,2:1852\n1869#2,2:1854\n1869#2,2:1856\n1869#2,2:1858\n1869#2,2:1860\n1869#2:1862\n1869#2,2:1863\n1870#2:1865\n1869#2,2:1866\n1869#2,2:1868\n1869#2,2:1870\n1869#2:1872\n1869#2,2:1873\n1870#2:1875\n1869#2,2:1876\n1869#2,2:1878\n1869#2,2:1880\n1869#2,2:1882\n1869#2,2:1884\n1869#2,2:1886\n1869#2,2:1888\n1869#2:1890\n1869#2,2:1891\n1870#2:1893\n1869#2:1894\n1869#2,2:1895\n1870#2:1897\n1869#2:1898\n1869#2,2:1899\n1870#2:1901\n774#2:1902\n865#2,2:1903\n1869#2,2:1905\n1869#2,2:1907\n1869#2,2:1909\n1869#2,2:1911\n1869#2,2:1913\n1869#2,2:1915\n1869#2,2:1917\n1869#2,2:1921\n1869#2,2:1923\n1869#2:1925\n1869#2,2:1926\n1870#2:1928\n1869#2,2:1929\n1869#2,2:1931\n1#3:1794\n1#3:1807\n1#3:1842\n216#4,2:1919\n216#4,2:1933\n*S KotlinDebug\n*F\n+ 1 TournamentManager.kt\ncom/music176/pokemonleague/tournament/TournamentManager\n*L\n456#1:1760\n457#1:1761,2\n456#1:1763\n542#1:1764,3\n569#1:1767\n569#1:1768,2\n570#1:1770\n570#1:1771,3\n587#1:1774,2\n588#1:1776,2\n594#1:1778,2\n602#1:1780,2\n613#1:1782,2\n667#1:1784,9\n667#1:1793\n667#1:1795\n667#1:1796\n668#1:1797,9\n668#1:1806\n668#1:1808\n668#1:1809\n677#1:1810,2\n682#1:1812,2\n706#1:1814\n706#1:1815,2\n706#1:1817\n706#1:1818,3\n707#1:1821\n707#1:1822,2\n707#1:1824\n707#1:1825,3\n745#1:1828\n745#1:1829,2\n745#1:1831\n745#1:1832,3\n756#1:1835\n756#1:1836,2\n756#1:1838\n756#1:1839,3\n799#1:1843,2\n800#1:1845,2\n826#1:1847,3\n846#1:1850,2\n851#1:1852,2\n871#1:1854,2\n907#1:1856,2\n908#1:1858,2\n936#1:1860,2\n997#1:1862\n998#1:1863,2\n997#1:1865\n1004#1:1866,2\n1009#1:1868,2\n1013#1:1870,2\n1019#1:1872\n1020#1:1873,2\n1019#1:1875\n1028#1:1876,2\n1031#1:1878,2\n1034#1:1880,2\n1078#1:1882,2\n1085#1:1884,2\n1092#1:1886,2\n1100#1:1888,2\n1129#1:1890\n1131#1:1891,2\n1129#1:1893\n1176#1:1894\n1178#1:1895,2\n1176#1:1897\n1188#1:1898\n1189#1:1899,2\n1188#1:1901\n1254#1:1902\n1254#1:1903,2\n1254#1:1905,2\n1292#1:1907,2\n1356#1:1909,2\n1380#1:1911,2\n1390#1:1913,2\n1400#1:1915,2\n1560#1:1917,2\n1638#1:1921,2\n1641#1:1923,2\n1701#1:1925\n1704#1:1926,2\n1701#1:1928\n1751#1:1929,2\n642#1:1931,2\n667#1:1794\n668#1:1807\n1628#1:1919,2\n1664#1:1933,2\n*E\n"})
public final class TournamentManager {
    @NotNull
    public static final TournamentManager INSTANCE = new TournamentManager();
    @Nullable
    private static MinecraftServer server;
    private static TournamentConfig config;
    @Nullable
    private static TournamentSession activeTournament;
    @NotNull
    private static final ConcurrentHashMap<UUID, UUID> playerToTournament;
    @NotNull
    private static final ConcurrentHashMap<UUID, UUID> playerToMatch;
    @NotNull
    private static final ConcurrentHashMap<String, UUID> arenaToMatch;
    private static boolean broadcastTaskRunning;
    @NotNull
    private static final ConcurrentHashMap<UUID, class_1934> tournamentSpectators;
    @NotNull
    private static final ConcurrentHashMap<UUID, String> spectatorArenaChoice;
    @NotNull
    private static final ConcurrentHashMap<String, Pair<class_3213, class_3213>> arenaBossBars;
    private static boolean bossBarTaskRunning;

    private TournamentManager() {
    }

    @NotNull
    public final TournamentConfig getConfig() {
        TournamentConfig tournamentConfig = config;
        if (tournamentConfig != null) {
            return tournamentConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    public final void initialize(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        TournamentManager.server = server;
        config = TournamentConfig.Companion.load();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("TournamentManager initialized");
    }

    public final void shutdown() {
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession != null) {
            TournamentSession tournament = tournamentSession;
            boolean bl = false;
            INSTANCE.endTournament(true);
        }
        broadcastTaskRunning = false;
        server = null;
        PokemonLeagueMod.INSTANCE.getLOGGER().info("TournamentManager shutdown");
    }

    public final void reloadConfig() {
        config = TournamentConfig.Companion.load();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Tournament config reloaded");
    }

    @Nullable
    public final TournamentSession createTournament(@NotNull class_3222 creator, @NotNull String name, @NotNull TournamentMode mode, @NotNull RoundFormats roundFormats, @NotNull TournamentRewards rewards, int maxParticipants) {
        TournamentSession tournament;
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)roundFormats, (String)"roundFormats");
        Intrinsics.checkNotNullParameter((Object)rewards, (String)"rewards");
        if (activeTournament != null) {
            creator.method_43496((class_2561)class_2561.method_43470((String)"Un tournoi est deja en cours!").method_27694(TournamentManager::createTournament$lambda$0));
            return null;
        }
        if (!this.getConfig().hasMinimumArenas()) {
            creator.method_43496((class_2561)class_2561.method_43470((String)"Aucune arene configuree! Utilisez /tournament admin setarena").method_27694(TournamentManager::createTournament$lambda$1));
            return null;
        }
        UUID uUID = creator.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        UUID uUID2 = uUID;
        String string = creator.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String string2 = string;
        activeTournament = tournament = new TournamentSession(null, name, mode, uUID2, string2, maxParticipants, roundFormats, rewards, null, null, null, null, null, 0L, null, null, null, null, null, null, 1048321, null);
        creator.method_43496((class_2561)class_2561.method_43470((String)("Tournoi '" + name + "' cree! Utilisez /tournament admin start pour ouvrir les inscriptions.")).method_27694(TournamentManager::createTournament$lambda$2));
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Tournament '" + name + "' created by " + creator.method_5477().getString());
        return tournament;
    }

    public static /* synthetic */ TournamentSession createTournament$default(TournamentManager tournamentManager, class_3222 class_32222, String string, TournamentMode tournamentMode, RoundFormats roundFormats, TournamentRewards tournamentRewards, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            roundFormats = new RoundFormats(null, null, null, 7, null);
        }
        if ((n2 & 0x10) != 0) {
            tournamentRewards = new TournamentRewards(null, null, null, 7, null);
        }
        if ((n2 & 0x20) != 0) {
            n = 32;
        }
        return tournamentManager.createTournament(class_32222, string, tournamentMode, roundFormats, tournamentRewards, n);
    }

    public final boolean openRegistration() {
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            return false;
        }
        TournamentSession tournament = tournamentSession;
        if (tournament.getState() != TournamentState.CREATED) {
            return false;
        }
        tournament.setState(TournamentState.REGISTRATION);
        tournament.setRegistrationOpenedAt(System.currentTimeMillis());
        this.startRegistrationBroadcast();
        class_5250 class_52502 = class_2561.method_43470((String)("=== TOURNOI: " + tournament.getName() + " ===")).method_27694(TournamentManager::openRegistration$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
        this.broadcastToServer((class_2561)class_52502);
        class_5250 class_52503 = class_2561.method_43470((String)("Mode: " + tournament.getMode().getDisplayName() + " | Inscriptions ouvertes!")).method_27694(TournamentManager::openRegistration$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"withStyle(...)");
        this.broadcastToServer((class_2561)class_52503);
        class_5250 class_52504 = class_2561.method_43470((String)"[Cliquez pour rejoindre /tournois join]").method_27694(TournamentManager::openRegistration$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"withStyle(...)");
        this.broadcastToServer((class_2561)class_52504);
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Tournament registration opened");
        return true;
    }

    private final void startRegistrationBroadcast() {
        if (broadcastTaskRunning) {
            return;
        }
        broadcastTaskRunning = true;
        SchedulingFunctionsKt.afterOnServer((float)this.getConfig().getRegistrationBroadcastIntervalSeconds(), TournamentManager::startRegistrationBroadcast$lambda$3);
    }

    public final boolean registerPlayer(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            TournamentManager $this$registerPlayer_u24lambda_u240 = this;
            boolean bl = false;
            player.method_43496((class_2561)class_2561.method_43470((String)"Aucun tournoi en cours!").method_27694(TournamentManager::registerPlayer$lambda$0$0));
            return false;
        }
        TournamentSession tournament = tournamentSession;
        if (!tournament.isRegistrationOpen()) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Les inscriptions sont fermees!").method_27694(TournamentManager::registerPlayer$lambda$1));
            return false;
        }
        if (tournament.isFull()) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Le tournoi est complet!").method_27694(TournamentManager::registerPlayer$lambda$2));
            return false;
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        if (this.isPlayerInTournament(uUID)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Vous etes deja inscrit!").method_27694(TournamentManager::registerPlayer$lambda$3));
            return false;
        }
        if (!this.canPlayerJoinTournament(player)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Vous ne pouvez pas rejoindre le tournoi (deja en combat/gym/duel)").method_27694(TournamentManager::registerPlayer$lambda$4));
            return false;
        }
        String string = player.method_5667().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        List list = CollectionsKt.listOf((Object)player.method_5667().toString());
        List list2 = CollectionsKt.listOf((Object)player.method_5477().getString());
        String string2 = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String string3 = player.method_37908().method_27983().method_29177().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        TournamentParticipant participant = new TournamentParticipant(string, list, list2, string2, string3, player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455(), 0, false, null, 0, null, 31744, null);
        tournament.getParticipants().add(participant);
        ((Map)playerToTournament).put(player.method_5667(), tournament.getTournamentId());
        player.method_43496((class_2561)class_2561.method_43470((String)("Vous etes inscrit au tournoi '" + tournament.getName() + "'!")).method_27694(TournamentManager::registerPlayer$lambda$5));
        player.method_43496((class_2561)class_2561.method_43470((String)"Vous serez teleporte 2 minutes avant le debut.").method_27694(TournamentManager::registerPlayer$lambda$6));
        class_5250 class_52502 = class_2561.method_43470((String)("[TOURNOI] " + player.method_5477().getString() + " s'est inscrit! (" + tournament.getParticipantCount() + "/" + tournament.getMaxParticipants() + ")")).method_27694(TournamentManager::registerPlayer$lambda$7);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
        this.broadcastToServer((class_2561)class_52502);
        PokemonLeagueMod.INSTANCE.getLOGGER().info(player.method_5477().getString() + " registered for tournament");
        return true;
    }

    public final boolean unregisterPlayer(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            return false;
        }
        TournamentSession tournament = tournamentSession;
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        TournamentParticipant tournamentParticipant = tournament.findParticipant(uUID);
        if (tournamentParticipant == null) {
            return false;
        }
        TournamentParticipant participant = tournamentParticipant;
        if (tournament.getState() == TournamentState.REGISTRATION) {
            tournament.getParticipants().remove(participant);
            playerToTournament.remove(player.method_5667());
            player.method_43496((class_2561)class_2561.method_43470((String)"Vous avez quitte le tournoi.").method_27694(TournamentManager::unregisterPlayer$lambda$0));
            return true;
        }
        if (tournament.getState() == TournamentState.STARTING) {
            tournament.getParticipants().remove(participant);
            playerToTournament.remove(player.method_5667());
            this.removeSaturation(player);
            InventoryManager.INSTANCE.restoreInventory(player);
            this.teleportParticipantBack(participant);
            player.method_43496((class_2561)class_2561.method_43470((String)"Vous avez quitte le tournoi.").method_27694(TournamentManager::unregisterPlayer$lambda$1));
            return true;
        }
        if (tournament.isActive()) {
            this.disqualifyParticipant(participant, "Abandon volontaire");
            return true;
        }
        return false;
    }

    public final boolean startTournament(@NotNull class_3222 admin) {
        Intrinsics.checkNotNullParameter((Object)admin, (String)"admin");
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            return false;
        }
        TournamentSession tournament = tournamentSession;
        if (tournament.getState() != TournamentState.REGISTRATION) {
            admin.method_43496((class_2561)class_2561.method_43470((String)"Le tournoi n'est pas en phase d'inscription!").method_27694(TournamentManager::startTournament$lambda$0));
            return false;
        }
        if (!tournament.hasEnoughParticipants()) {
            admin.method_43496((class_2561)class_2561.method_43470((String)("Pas assez de participants! (minimum: " + tournament.getMinimumParticipants() + ")")).method_27694(TournamentManager::startTournament$lambda$1));
            return false;
        }
        tournament.setState(TournamentState.STARTING);
        broadcastTaskRunning = false;
        class_5250 class_52502 = class_2561.method_43470((String)("=== LE TOURNOI " + tournament.getName() + " COMMENCE DANS 5 MINUTES! ===")).method_27694(TournamentManager::startTournament$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
        this.broadcastToServer((class_2561)class_52502);
        class_5250 class_52503 = class_2561.method_43470((String)("Les inscriptions sont fermees! " + tournament.getParticipantCount() + " participants.")).method_27694(TournamentManager::startTournament$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"withStyle(...)");
        this.broadcastToServer((class_2561)class_52503);
        class_5250 class_52504 = class_2561.method_43470((String)"Les joueurs seront teleportes 30 secondes avant le debut.").method_27694(TournamentManager::startTournament$lambda$4);
        Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"withStyle(...)");
        this.broadcastToServer((class_2561)class_52504);
        admin.method_43496((class_2561)class_2561.method_43470((String)"Demarrage du tournoi dans 5 minutes...").method_27694(TournamentManager::startTournament$lambda$5));
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Tournament '" + tournament.getName() + "' starting countdown (5 min) with " + tournament.getParticipantCount() + " participants");
        this.startPreTournamentCountdown(300);
        return true;
    }

    private final void startPreTournamentCountdown(int remainingSeconds) {
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            return;
        }
        TournamentSession tournament = tournamentSession;
        if (tournament.getState() != TournamentState.STARTING) {
            return;
        }
        switch (remainingSeconds) {
            case 300: {
                break;
            }
            case 120: {
                class_5250 class_52502 = class_2561.method_43470((String)"[TOURNOI] Debut dans 2 minutes!").method_27694(TournamentManager::startPreTournamentCountdown$lambda$0);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
                this.broadcastToServer((class_2561)class_52502);
                break;
            }
            case 60: {
                class_5250 class_52503 = class_2561.method_43470((String)"[TOURNOI] Debut dans 1 minute!").method_27694(TournamentManager::startPreTournamentCountdown$lambda$1);
                Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"withStyle(...)");
                this.broadcastToServer((class_2561)class_52503);
                break;
            }
            case 30: {
                class_5250 class_52504 = class_2561.method_43470((String)"[TOURNOI] Debut dans 30 secondes!").method_27694(TournamentManager::startPreTournamentCountdown$lambda$2);
                Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"withStyle(...)");
                this.broadcastToServer((class_2561)class_52504);
                this.prepareAllParticipants();
                break;
            }
            case 10: {
                class_5250 class_52505 = class_2561.method_43470((String)"[TOURNOI] Debut dans 10 secondes!").method_27694(TournamentManager::startPreTournamentCountdown$lambda$3);
                Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"withStyle(...)");
                this.broadcastToServer((class_2561)class_52505);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                class_5250 class_52506 = class_2561.method_43470((String)("[TOURNOI] " + remainingSeconds + "...")).method_27694(TournamentManager::startPreTournamentCountdown$lambda$4);
                Intrinsics.checkNotNullExpressionValue((Object)class_52506, (String)"withStyle(...)");
                this.broadcastToServer((class_2561)class_52506);
            }
        }
        if (remainingSeconds > 0) {
            SchedulingFunctionsKt.afterOnServer((float)1.0f, () -> TournamentManager.startPreTournamentCountdown$lambda$5(remainingSeconds));
        } else {
            class_5250 class_52507 = class_2561.method_43470((String)"[TOURNOI] C'EST PARTI!").method_27694(TournamentManager::startPreTournamentCountdown$lambda$6);
            Intrinsics.checkNotNullExpressionValue((Object)class_52507, (String)"withStyle(...)");
            this.broadcastToServer((class_2561)class_52507);
            this.actuallyStartTournament();
        }
    }

    private final void prepareAllParticipants() {
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            return;
        }
        TournamentSession tournament = tournamentSession;
        class_5250 class_52502 = class_2561.method_43470((String)"[TOURNOI] Teleportation des participants!").method_27694(TournamentManager::prepareAllParticipants$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
        this.broadcastToServer((class_2561)class_52502);
        Iterable $this$forEach$iv = tournament.getParticipants();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TournamentParticipant participant = (TournamentParticipant)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = participant.getUUIDs();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                UUID uuid = (UUID)element$iv2;
                boolean bl2 = false;
                MinecraftServer minecraftServer = server;
                if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(uuid)) == null) continue;
                MinecraftServer player = minecraftServer;
                boolean bl3 = false;
                String string = player.method_37908().method_27983().method_29177().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                TournamentParticipant updatedParticipant = TournamentParticipant.copy$default(participant, null, null, null, null, string, player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455(), 0, false, null, 0, null, 31759, null);
                int index = tournament.getParticipants().indexOf(participant);
                if (index >= 0) {
                    tournament.getParticipants().set(index, updatedParticipant);
                }
                InventoryManager.INSTANCE.saveAndClearInventory((class_3222)player);
                INSTANCE.applySaturation((class_3222)player);
                INSTANCE.teleportToPosition((class_3222)player, INSTANCE.getConfig().getWaitingRoomPosition());
                player.method_43496((class_2561)class_2561.method_43470((String)"Vous avez ete teleporte! Le tournoi commence dans 30 secondes.").method_27694(TournamentManager::prepareAllParticipants$lambda$1$0$0$0));
            }
        }
    }

    private final void actuallyStartTournament() {
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            return;
        }
        TournamentSession tournament = tournamentSession;
        TournamentBracket bracket = new TournamentBracket(tournament.getTournamentId(), tournament.getParticipantCount());
        bracket.generate(CollectionsKt.toList((Iterable)tournament.getParticipants()), tournament.getRoundFormats());
        tournament.setBracket(bracket);
        tournament.setState(TournamentState.IN_PROGRESS);
        tournament.setStartedAt(System.currentTimeMillis());
        class_5250 class_52502 = class_2561.method_43470((String)("=== LE TOURNOI " + tournament.getName() + " COMMENCE! ===")).method_27694(TournamentManager::actuallyStartTournament$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
        this.broadcastToServer((class_2561)class_52502);
        class_5250 class_52503 = class_2561.method_43470((String)(tournament.getParticipantCount() + " participants - Mode: " + tournament.getMode().getDisplayName())).method_27694(TournamentManager::actuallyStartTournament$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"withStyle(...)");
        this.broadcastToServer((class_2561)class_52503);
        this.scheduleNextMatches();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Tournament '" + tournament.getName() + "' started with " + tournament.getParticipantCount() + " participants");
    }

    /*
     * WARNING - void declaration
     */
    private final void scheduleNextMatches() {
        block7: {
            List<String> availableArenas;
            List<TournamentMatch> readyMatches;
            TournamentBracket bracket;
            TournamentSession tournament;
            block6: {
                TournamentSession tournamentSession = activeTournament;
                if (tournamentSession == null) {
                    return;
                }
                tournament = tournamentSession;
                TournamentBracket tournamentBracket = tournament.getBracket();
                if (tournamentBracket == null) {
                    return;
                }
                bracket = tournamentBracket;
                readyMatches = bracket.getReadyMatches();
                availableArenas = this.getAvailableArenas();
                int currentActiveCount = tournament.getActiveMatches().size();
                int maxNewMatches = Math.min(readyMatches.size(), Math.min(availableArenas.size(), 4 - currentActiveCount));
                PokemonLeagueMod.INSTANCE.getLOGGER().info("Scheduling matches: " + readyMatches.size() + " ready, " + availableArenas.size() + " arenas available, " + currentActiveCount + " active");
                Iterable $this$forEachIndexed$iv = CollectionsKt.take((Iterable)readyMatches, (int)maxNewMatches);
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void match;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    TournamentMatch tournamentMatch = (TournamentMatch)item$iv;
                    int index = n;
                    boolean bl = false;
                    if (index >= availableArenas.size()) continue;
                    INSTANCE.startMatch((TournamentMatch)match, availableArenas.get(index));
                }
                if (!bracket.isTournamentComplete()) break block6;
                this.finalizeTournament();
                break block7;
            }
            if (!readyMatches.isEmpty() || !tournament.getActiveMatches().isEmpty()) break block7;
            TournamentMatch tournamentMatch = bracket.getGrandFinal();
            if (tournamentMatch != null) {
                String arena;
                TournamentMatch gf = tournamentMatch;
                boolean bl = false;
                if (gf.isReady() && gf.getState() == MatchState.PENDING && (arena = (String)CollectionsKt.firstOrNull(availableArenas)) != null) {
                    INSTANCE.startMatch(gf, arena);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getAvailableArenas() {
        void $this$mapTo$iv$iv;
        TournamentArena it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getConfig().getConfiguredArenas();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TournamentArena)element$iv$iv;
            boolean bl = false;
            if (!(!arenaToMatch.containsKey(it.getArenaId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (TournamentArena)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getArenaId());
        }
        return (List)destination$iv$iv;
    }

    private final void startMatch(TournamentMatch match, String arenaId) {
        Object object;
        Object p1Name;
        Object object2;
        MinecraftServer player;
        UUID uuid;
        Iterable $this$forEach$iv;
        Object object3;
        Iterator it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv2;
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            return;
        }
        TournamentSession tournament = tournamentSession;
        TournamentArena tournamentArena = this.getConfig().getArena(arenaId);
        if (tournamentArena == null) {
            return;
        }
        TournamentArena arena = tournamentArena;
        match.setArenaId(arenaId);
        match.setState(MatchState.WAITING_PLAYERS);
        tournament.getActiveMatches().put(match.getMatchId(), match);
        ((Map)arenaToMatch).put(arenaId, match.getMatchId());
        Object object4 = match.getParticipant1();
        if (object4 != null && (object4 = ((TournamentParticipant)object4).getUUIDs()) != null) {
            $this$forEach$iv2 = (Iterable)object4;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                it = (UUID)element$iv;
                boolean bl = false;
                ((Map)playerToMatch).put(it, match.getMatchId());
            }
        }
        if ((object3 = match.getParticipant2()) != null && (object3 = ((TournamentParticipant)object3).getUUIDs()) != null) {
            $this$forEach$iv2 = (Iterable)object3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                it = (UUID)element$iv;
                boolean bl = false;
                ((Map)playerToMatch).put(it, match.getMatchId());
            }
        }
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Starting match: " + match.getMatchDisplayName() + " in " + arenaId);
        TournamentParticipant tournamentParticipant = match.getParticipant1();
        if (tournamentParticipant != null) {
            TournamentParticipant p1 = tournamentParticipant;
            boolean bl = false;
            $this$forEach$iv = p1.getUUIDs();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                uuid = (UUID)element$iv;
                boolean bl2 = false;
                MinecraftServer minecraftServer = server;
                if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(uuid)) == null) continue;
                player = minecraftServer;
                boolean bl3 = false;
                INSTANCE.teleportToPosition((class_3222)player, arena.getPlayer1Spawn());
            }
        }
        TournamentParticipant tournamentParticipant2 = match.getParticipant2();
        if (tournamentParticipant2 != null) {
            TournamentParticipant p2 = tournamentParticipant2;
            boolean bl = false;
            $this$forEach$iv = p2.getUUIDs();
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv) {
                uuid = (UUID)element$iv;
                boolean bl4 = false;
                MinecraftServer minecraftServer = server;
                if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(uuid)) == null) continue;
                player = minecraftServer;
                boolean bl5 = false;
                INSTANCE.teleportToPosition((class_3222)player, arena.getPlayer2Spawn());
            }
        }
        if ((object2 = match.getParticipant1()) == null || (object2 = ((TournamentParticipant)object2).getDisplayName()) == null) {
            object2 = p1Name = "TBD";
        }
        if ((object = match.getParticipant2()) == null || (object = ((TournamentParticipant)object).getDisplayName()) == null) {
            object = "TBD";
        }
        Object p2Name = object;
        $this$forEach$iv2 = match.getAllPlayerIds();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            class_3222 player2;
            UUID playerId = (UUID)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            class_3222 class_32222 = player2 = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
            if (class_32222 != null) {
                class_32222.method_43496((class_2561)class_2561.method_43470((String)("=== " + match.getRoundDisplayName() + " ===")).method_27694(TournamentManager::startMatch$lambda$4$0));
            }
            class_3222 class_32223 = player2;
            if (class_32223 == null) continue;
            class_32223.method_43496((class_2561)class_2561.method_43470((String)((String)p1Name + " VS " + (String)p2Name)).method_27694(TournamentManager::startMatch$lambda$4$1));
        }
        this.createBossBarsForMatch(match, arenaId);
        this.startMatchCountdown(match);
    }

    private final void startMatchCountdown(TournamentMatch match) {
        match.setState(MatchState.COUNTDOWN);
        TournamentManager.startMatchCountdown$countdown(match, this.getConfig().getCountdownSeconds());
    }

    /*
     * WARNING - void declaration
     */
    private final void startBattle(TournamentMatch match) {
        List p2Players;
        Object object;
        List p1Players;
        Iterable<class_3222> destination$iv$iv;
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            return;
        }
        TournamentSession tournament = tournamentSession;
        match.setState(MatchState.IN_BATTLE);
        Object object2 = match.getParticipant1();
        if (object2 != null && (object2 = ((TournamentParticipant)object2).getUUIDs()) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)object2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                class_3222 it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                UUID it = (UUID)element$iv$iv;
                boolean bl2 = false;
                MinecraftServer minecraftServer = server;
                if ((minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(it) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            v3 = (List)destination$iv$iv;
        } else {
            v3 = p1Players = CollectionsKt.emptyList();
        }
        if ((object = match.getParticipant2()) != null && (object = ((TournamentParticipant)object).getUUIDs()) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)object;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                class_3222 it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                UUID it = (UUID)element$iv$iv;
                boolean bl4 = false;
                MinecraftServer minecraftServer = server;
                if ((minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(it) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            v6 = (List)destination$iv$iv2;
        } else {
            v6 = p2Players = CollectionsKt.emptyList();
        }
        if (p1Players.isEmpty() || p2Players.isEmpty()) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Not enough players for tournament match");
            this.handleMatchError(match);
            return;
        }
        Iterable $this$forEach$iv = CollectionsKt.plus((Collection)p1Players, (Iterable)p2Players);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 player = (class_3222)element$iv;
            boolean bl = false;
            INSTANCE.healPlayerParty(player);
        }
        $this$forEach$iv = match.getAllPlayerIds();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 player;
            UUID playerId = (UUID)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            class_3222 class_32222 = player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
            if (class_32222 == null) continue;
            class_32222.method_43496((class_2561)class_2561.method_43470((String)"Les items sont desactives!").method_27694(TournamentManager::startBattle$lambda$3$0));
        }
        try {
            if (tournament.getMode() == TournamentMode.SINGLES_1V1) {
                this.start1v1Battle(match, (class_3222)p1Players.get(0), (class_3222)p2Players.get(0));
            } else {
                this.start2v2Battle(match, p1Players, p2Players);
            }
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to start tournament battle", (Throwable)e);
            this.handleMatchError(match);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void start1v1Battle(TournamentMatch match, class_3222 player1, class_3222 player2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Pokemon it;
        void $this$filterTo$iv$iv2;
        PlayerPartyStore party1 = Cobblemon.INSTANCE.getStorage().getParty(player1);
        PlayerPartyStore party2 = Cobblemon.INSTANCE.getStorage().getParty(player2);
        Iterable $this$filter$iv = (Iterable)party1;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (Pokemon)element$iv$iv;
            boolean bl = false;
            if (!(!it.isFainted())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (Pokemon)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BattlePokemon.Companion.playerOwned(it));
        }
        List pokemon1 = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = (Iterable)party2;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        BattleActor[] destination$iv$iv2 = (BattleActor[])new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pokemon it2 = (Pokemon)element$iv$iv;
            boolean bl = false;
            if (!(!it2.isFainted())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pokemon it2 = (Pokemon)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(BattlePokemon.Companion.playerOwned(it2));
        }
        List pokemon2 = (List)destination$iv$iv2;
        if (pokemon1.isEmpty() || pokemon2.isEmpty()) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Players don't have valid Pokemon");
            this.handleMatchError(match);
            return;
        }
        UUID uUID = player1.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerBattleActor actor1 = new PlayerBattleActor(uUID, pokemon1);
        UUID uUID2 = player2.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        PlayerBattleActor actor2 = new PlayerBattleActor(uUID2, pokemon2);
        destination$iv$iv2 = new BattleActor[]{actor1};
        BattleSide side1 = new BattleSide(destination$iv$iv2);
        BattleActor[] $i$f$mapTo22 = new BattleActor[]{actor2};
        BattleSide side2 = new BattleSide($i$f$mapTo22);
        BattleFormat format = BattleFormat.Companion.getGEN_9_SINGLES();
        Set originalRuleSet = format.getRuleSet();
        format.setRuleSet(SetsKt.plus((Set)originalRuleSet, (Object)"Bag Clause"));
        try {
            BattleStartResult result = BattleRegistry.startBattle((BattleFormat)format, (BattleSide)side1, (BattleSide)side2, (boolean)false);
            result.ifErrored(arg_0 -> TournamentManager.start1v1Battle$lambda$4(match, arg_0));
            result.ifSuccessful(TournamentManager::start1v1Battle$lambda$5);
        }
        finally {
            format.setRuleSet(originalRuleSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void start2v2Battle(TournamentMatch match, List<? extends class_3222> team1Players, List<? extends class_3222> team2Players) {
        BattleActor[] party;
        Collection collection;
        Iterable<BattlePokemon> destination$iv$iv;
        List team1Actors = new ArrayList();
        for (class_3222 class_32222 : team1Players) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl;
            Pokemon it;
            void $this$filterTo$iv$iv;
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(class_32222);
            Iterable $this$filter$iv = (Iterable)playerPartyStore;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Pokemon)element$iv$iv;
                bl = false;
                if (!(!it.isFainted())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Pokemon)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                collection.add((BattlePokemon)BattlePokemon.Companion.playerOwned(it));
            }
            List pokemon = (List)destination$iv$iv;
            if (pokemon.isEmpty()) {
                this.handleMatchError(match);
                return;
            }
            UUID uUID = class_32222.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            team1Actors.add(new PlayerBattleActor(uUID, pokemon));
        }
        List team2Actors = new ArrayList();
        for (class_3222 class_32223 : team2Players) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl;
            Pokemon it;
            void $this$filterTo$iv$iv;
            party = Cobblemon.INSTANCE.getStorage().getParty(class_32223);
            Iterable $this$filter$iv = (Iterable)party;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Pokemon)element$iv$iv;
                bl = false;
                if (!(!it.isFainted())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Pokemon)item$iv$iv;
                collection = destination$iv$iv3;
                bl = false;
                collection.add(BattlePokemon.Companion.playerOwned(it));
            }
            List pokemon = (List)destination$iv$iv3;
            if (pokemon.isEmpty()) {
                this.handleMatchError(match);
                return;
            }
            UUID uUID = class_32223.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            team2Actors.add(new PlayerBattleActor(uUID, pokemon));
        }
        if (team1Actors.size() != 2 || team2Actors.size() != 2) {
            this.handleMatchError(match);
            return;
        }
        BattleActor[] battleActorArray = new BattleActor[]{team1Actors.get(0), team1Actors.get(1)};
        BattleSide battleSide = new BattleSide(battleActorArray);
        party = new BattleActor[]{team2Actors.get(0), team2Actors.get(1)};
        BattleSide battleSide2 = new BattleSide(party);
        BattleFormat format = BattleFormat.Companion.getGEN_9_MULTI();
        Set originalRuleSet = format.getRuleSet();
        format.setRuleSet(SetsKt.plus((Set)originalRuleSet, (Object)"Bag Clause"));
        try {
            BattleStartResult result = BattleRegistry.startBattle((BattleFormat)format, (BattleSide)battleSide, (BattleSide)battleSide2, (boolean)false);
            result.ifErrored(arg_0 -> TournamentManager.start2v2Battle$lambda$4(match, arg_0));
            result.ifSuccessful(TournamentManager::start2v2Battle$lambda$5);
        }
        finally {
            format.setRuleSet(originalRuleSet);
        }
    }

    private final void handleMatchError(TournamentMatch match) {
        Object object;
        UUID it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Object object2;
        Object it2;
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            return;
        }
        TournamentSession tournament = tournamentSession;
        match.setState(MatchState.COMPLETED);
        String string = match.getArenaId();
        if (string != null) {
            it2 = string;
            boolean bl = false;
            arenaToMatch.remove(it2);
        }
        if ((object2 = match.getParticipant1()) != null && (object2 = ((TournamentParticipant)object2).getUUIDs()) != null) {
            $this$forEach$iv = (Iterable)object2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (UUID)element$iv;
                boolean bl = false;
                playerToMatch.remove(it);
            }
        }
        if ((object = match.getParticipant2()) != null && (object = ((TournamentParticipant)object).getUUIDs()) != null) {
            $this$forEach$iv = (Iterable)object;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (UUID)element$iv;
                boolean bl = false;
                playerToMatch.remove(it);
            }
        }
        tournament.getActiveMatches().remove(match.getMatchId());
        TournamentParticipant tournamentParticipant = match.getParticipant1();
        if (tournamentParticipant != null) {
            it2 = tournamentParticipant;
            boolean bl = false;
            INSTANCE.teleportToSpectatorArea((TournamentParticipant)it2);
        }
        TournamentParticipant tournamentParticipant2 = match.getParticipant2();
        if (tournamentParticipant2 != null) {
            it2 = tournamentParticipant2;
            boolean bl = false;
            INSTANCE.teleportToSpectatorArea((TournamentParticipant)it2);
        }
        this.scheduleNextMatches();
    }

    public final void handleBattleResult(@NotNull List<UUID> winnerIds, @NotNull List<UUID> loserIds) {
        class_3222 player;
        TournamentParticipant loserParticipant;
        boolean bl;
        int $i$f$any;
        TournamentMatch match;
        TournamentSession tournament;
        block22: {
            Object object;
            Object object2;
            block20: {
                Intrinsics.checkNotNullParameter(winnerIds, (String)"winnerIds");
                Intrinsics.checkNotNullParameter(loserIds, (String)"loserIds");
                for (Object it : (Iterable)winnerIds) {
                    boolean bl2 = false;
                    if ((it = playerToMatch.get(it)) == null) continue;
                    object2 = it;
                    break block20;
                }
                object2 = object = null;
            }
            if (object2 == null) {
                Object object3;
                block21: {
                    for (UUID it : (Iterable)loserIds) {
                        boolean bl3 = false;
                        if ((it = playerToMatch.get(it)) == null) continue;
                        object3 = it;
                        break block21;
                    }
                    object3 = object = null;
                }
                if (object3 == null) {
                    return;
                }
            }
            Object matchId = object;
            TournamentSession tournamentSession = activeTournament;
            if (tournamentSession == null) {
                return;
            }
            tournament = tournamentSession;
            TournamentMatch tournamentMatch = tournament.getActiveMatches().get(matchId);
            if (tournamentMatch == null) {
                return;
            }
            match = tournamentMatch;
            if (match.getState() != MatchState.IN_BATTLE) {
                return;
            }
            Iterable $this$any$iv = winnerIds;
            $i$f$any = 0;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UUID it = (UUID)element$iv;
                    boolean bl4 = false;
                    Object object4 = match.getParticipant1();
                    if (object4 == null || (object4 = ((TournamentParticipant)object4).getUUIDs()) == null) {
                        object4 = CollectionsKt.emptyList();
                    }
                    if (!object4.contains(it)) continue;
                    bl = true;
                    break block22;
                }
                bl = false;
            }
        }
        TournamentParticipant winnerParticipant = bl ? match.getParticipant1() : match.getParticipant2();
        TournamentParticipant tournamentParticipant = loserParticipant = Intrinsics.areEqual((Object)winnerParticipant, (Object)match.getParticipant1()) ? match.getParticipant2() : match.getParticipant1();
        if (Intrinsics.areEqual((Object)winnerParticipant, (Object)match.getParticipant1())) {
            $i$f$any = match.getParticipant1Wins();
            match.setParticipant1Wins($i$f$any + 1);
        } else {
            $i$f$any = match.getParticipant2Wins();
            match.setParticipant2Wins($i$f$any + 1);
        }
        Iterable $this$forEach$iv = match.getAllPlayerIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID playerId = (UUID)element$iv;
            boolean bl5 = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(playerId)) == null) continue;
            MinecraftServer it = minecraftServer;
            boolean bl6 = false;
            INSTANCE.recallAllPokemon((class_3222)it);
        }
        $this$forEach$iv = match.getAllPlayerIds();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID playerId = (UUID)element$iv;
            boolean bl7 = false;
            MinecraftServer minecraftServer = server;
            class_3222 class_32222 = player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
            if (class_32222 != null) {
                TournamentParticipant tournamentParticipant2 = winnerParticipant;
                class_32222.method_43496((class_2561)class_2561.method_43470((String)((tournamentParticipant2 != null ? tournamentParticipant2.getDisplayName() : null) + " remporte le match!")).method_27694(TournamentManager::handleBattleResult$lambda$4$0));
            }
            class_3222 class_32223 = player;
            if (class_32223 == null) continue;
            class_32223.method_43496((class_2561)class_2561.method_43470((String)("Score: " + match.getScoreString())).method_27694(TournamentManager::handleBattleResult$lambda$4$1));
        }
        if (match.isSeriesOver()) {
            TournamentParticipant tournamentParticipant3 = winnerParticipant;
            Intrinsics.checkNotNull((Object)tournamentParticipant3);
            TournamentParticipant tournamentParticipant4 = loserParticipant;
            Intrinsics.checkNotNull((Object)tournamentParticipant4);
            this.completeMatch(match, tournamentParticipant3, tournamentParticipant4);
        } else {
            int $this$forEach$iv2 = match.getCurrentGame();
            match.setCurrentGame($this$forEach$iv2 + 1);
            match.setState(MatchState.BETWEEN_GAMES);
            Iterable $this$forEach$iv22 = match.getAllPlayerIds();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv22) {
                UUID playerId = (UUID)element$iv;
                boolean bl8 = false;
                MinecraftServer minecraftServer = server;
                class_3222 class_32224 = player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
                if (class_32224 != null) {
                    class_32224.method_43496((class_2561)class_2561.method_43470((String)("Prochain match dans " + INSTANCE.getConfig().getBetweenMatchesDelaySeconds() + " secondes...")).method_27694(TournamentManager::handleBattleResult$lambda$5$0));
                }
                if (player == null) continue;
                Cobblemon.INSTANCE.getStorage().getParty(player).heal();
            }
            SchedulingFunctionsKt.afterOnServer((float)this.getConfig().getBetweenMatchesDelaySeconds(), () -> TournamentManager.handleBattleResult$lambda$6(tournament, match));
        }
    }

    private final void completeMatch(TournamentMatch match, TournamentParticipant winner, TournamentParticipant loser) {
        Object object;
        UUID it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Object object2;
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            return;
        }
        TournamentSession tournament = tournamentSession;
        TournamentBracket tournamentBracket = tournament.getBracket();
        if (tournamentBracket == null) {
            return;
        }
        TournamentBracket bracket = tournamentBracket;
        match.setWinner(winner);
        match.setLoser(loser);
        match.setState(MatchState.COMPLETED);
        String string = match.getArenaId();
        if (string != null) {
            String arenaId = string;
            boolean bl = false;
            arenaToMatch.remove(arenaId);
            INSTANCE.cleanupArenaBossBars(arenaId);
        }
        if ((object2 = match.getParticipant1()) != null && (object2 = ((TournamentParticipant)object2).getUUIDs()) != null) {
            $this$forEach$iv = (Iterable)object2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (UUID)element$iv;
                boolean bl = false;
                playerToMatch.remove(it);
            }
        }
        if ((object = match.getParticipant2()) != null && (object = ((TournamentParticipant)object).getUUIDs()) != null) {
            $this$forEach$iv = (Iterable)object;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (UUID)element$iv;
                boolean bl = false;
                playerToMatch.remove(it);
            }
        }
        tournament.getActiveMatches().remove(match.getMatchId());
        bracket.advanceWinner(match);
        class_5250 class_52502 = class_2561.method_43470((String)("[TOURNOI] " + winner.getDisplayName() + " bat " + loser.getDisplayName() + "! (" + match.getScoreString() + ")")).method_27694(TournamentManager::completeMatch$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
        this.broadcastToServer((class_2561)class_52502);
        if (loser.isEliminated()) {
            class_5250 class_52503 = class_2561.method_43470((String)("[TOURNOI] " + loser.getDisplayName() + " est elimine!")).method_27694(TournamentManager::completeMatch$lambda$4);
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"withStyle(...)");
            this.broadcastToServer((class_2561)class_52503);
            this.teleportToSpectatorArea(loser);
        } else {
            this.teleportToSpectatorArea(loser);
        }
        this.teleportToSpectatorArea(winner);
        Iterable $this$forEach$iv2 = match.getAllPlayerIds();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            UUID playerId = (UUID)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(playerId)) == null) continue;
            it = minecraftServer;
            boolean bl2 = false;
            Cobblemon.INSTANCE.getStorage().getParty((class_3222)it).heal();
        }
        SchedulingFunctionsKt.afterOnServer((float)2.0f, TournamentManager::completeMatch$lambda$6);
    }

    public final void handlePlayerForfeit(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        UUID uUID = playerToMatch.get(playerId);
        if (uUID == null) {
            return;
        }
        UUID matchId = uUID;
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            return;
        }
        TournamentSession tournament = tournamentSession;
        TournamentMatch tournamentMatch = tournament.getActiveMatches().get(matchId);
        if (tournamentMatch == null) {
            return;
        }
        TournamentMatch match = tournamentMatch;
        Object object = match.getParticipant1();
        if (object == null || (object = ((TournamentParticipant)object).getUUIDs()) == null) {
            object = CollectionsKt.emptyList();
        }
        TournamentParticipant forfeitingParticipant = object.contains(playerId) ? match.getParticipant1() : match.getParticipant2();
        TournamentParticipant winnerParticipant = Intrinsics.areEqual((Object)forfeitingParticipant, (Object)match.getParticipant1()) ? match.getParticipant2() : match.getParticipant1();
        TournamentParticipant tournamentParticipant = forfeitingParticipant;
        class_5250 class_52502 = class_2561.method_43470((String)("[TOURNOI] " + (tournamentParticipant != null ? tournamentParticipant.getDisplayName() : null) + " abandonne!")).method_27694(TournamentManager::handlePlayerForfeit$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
        this.broadcastToServer((class_2561)class_52502);
        TournamentParticipant tournamentParticipant2 = winnerParticipant;
        Intrinsics.checkNotNull((Object)tournamentParticipant2);
        TournamentParticipant tournamentParticipant3 = forfeitingParticipant;
        Intrinsics.checkNotNull((Object)tournamentParticipant3);
        this.completeMatch(match, tournamentParticipant2, tournamentParticipant3);
    }

    private final void finalizeTournament() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        UUID uuid;
        TournamentParticipant participant;
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            return;
        }
        TournamentSession tournament = tournamentSession;
        TournamentBracket tournamentBracket = tournament.getBracket();
        if (tournamentBracket == null) {
            return;
        }
        TournamentBracket bracket = tournamentBracket;
        Triple<TournamentParticipant, TournamentParticipant, TournamentParticipant> triple = bracket.getPlacements();
        TournamentParticipant first = (TournamentParticipant)triple.component1();
        TournamentParticipant second = (TournamentParticipant)triple.component2();
        TournamentParticipant third = (TournamentParticipant)triple.component3();
        tournament.setFirstPlace(first);
        tournament.setSecondPlace(second);
        tournament.setThirdPlace(third);
        TournamentParticipant tournamentParticipant = first;
        if (tournamentParticipant != null) {
            tournamentParticipant.setFinalPlacement(1);
        }
        TournamentParticipant tournamentParticipant2 = second;
        if (tournamentParticipant2 != null) {
            tournamentParticipant2.setFinalPlacement(2);
        }
        TournamentParticipant tournamentParticipant3 = third;
        if (tournamentParticipant3 != null) {
            tournamentParticipant3.setFinalPlacement(3);
        }
        tournament.setState(TournamentState.CEREMONY);
        tournament.setEndedAt(System.currentTimeMillis());
        Iterable $this$forEach$iv = tournament.getParticipants();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            participant = (TournamentParticipant)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = participant.getUUIDs();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                uuid = (UUID)element$iv2;
                boolean bl2 = false;
                Object object5 = server;
                if (object5 == null || (object5 = object5.method_3760()) == null || (object5 = object5.method_14602(uuid)) == null || (object5 = object5.method_5477()) == null || (object5 = object5.getString()) == null) {
                    object5 = participant.getDisplayName();
                }
                Object name = object5;
                PlayerProfileManager.INSTANCE.recordTournamentParticipation(uuid, (String)name);
            }
        }
        Object object6 = first;
        if (object6 != null && (object6 = ((TournamentParticipant)object6).getUUIDs()) != null) {
            Iterable $this$forEach$iv3 = (Iterable)object6;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv3) {
                UUID uuid2 = (UUID)element$iv;
                boolean bl = false;
                Object object7 = server;
                if (object7 == null || (object7 = object7.method_3760()) == null || (object7 = object7.method_14602(uuid2)) == null || (object7 = object7.method_5477()) == null || (object7 = object7.getString()) == null) {
                    object7 = first.getDisplayName();
                }
                Object name = object7;
                PlayerProfileManager.INSTANCE.recordTournamentVictory(uuid2, (String)name);
            }
        }
        if ((object4 = second) != null && (object4 = ((TournamentParticipant)object4).getUUIDs()) != null) {
            Iterable $this$forEach$iv4 = (Iterable)object4;
            boolean $i$f$forEach4 = false;
            for (Object element$iv : $this$forEach$iv4) {
                UUID uuid3 = (UUID)element$iv;
                boolean bl = false;
                Object object8 = server;
                if (object8 == null || (object8 = object8.method_3760()) == null || (object8 = object8.method_14602(uuid3)) == null || (object8 = object8.method_5477()) == null || (object8 = object8.getString()) == null) {
                    object8 = second.getDisplayName();
                }
                Object name = object8;
                PlayerProfileManager.INSTANCE.recordTournamentPodium(uuid3, (String)name);
            }
        }
        if ((object3 = third) != null && (object3 = ((TournamentParticipant)object3).getUUIDs()) != null) {
            Iterable $this$forEach$iv5 = (Iterable)object3;
            boolean $i$f$forEach5 = false;
            for (Object element$iv : $this$forEach$iv5) {
                UUID uuid4 = (UUID)element$iv;
                boolean bl = false;
                Object object9 = server;
                if (object9 == null || (object9 = object9.method_3760()) == null || (object9 = object9.method_14602(uuid4)) == null || (object9 = object9.method_5477()) == null || (object9 = object9.getString()) == null) {
                    object9 = third.getDisplayName();
                }
                Object name = object9;
                PlayerProfileManager.INSTANCE.recordTournamentPodium(uuid4, (String)name);
            }
        }
        $this$forEach$iv = tournament.getParticipants();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            participant = (TournamentParticipant)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv6 = participant.getUUIDs();
            boolean $i$f$forEach6 = false;
            for (Object element$iv2 : $this$forEach$iv6) {
                uuid = (UUID)element$iv2;
                boolean bl3 = false;
                MinecraftServer minecraftServer = server;
                if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(uuid)) == null) continue;
                MinecraftServer player = minecraftServer;
                boolean bl4 = false;
                INSTANCE.teleportToPosition((class_3222)player, INSTANCE.getConfig().getEndZonePosition());
            }
        }
        Object object10 = first;
        if (object10 != null && (object10 = ((TournamentParticipant)object10).getUUIDs()) != null) {
            Iterable $this$forEach$iv7 = (Iterable)object10;
            boolean $i$f$forEach7 = false;
            for (Object element$iv : $this$forEach$iv7) {
                UUID uuid5 = (UUID)element$iv;
                boolean bl = false;
                MinecraftServer minecraftServer = server;
                if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(uuid5)) == null) continue;
                MinecraftServer it = minecraftServer;
                boolean bl5 = false;
                INSTANCE.teleportToPosition((class_3222)it, INSTANCE.getConfig().getPodiumFirst());
            }
        }
        if ((object2 = second) != null && (object2 = ((TournamentParticipant)object2).getUUIDs()) != null) {
            Iterable $this$forEach$iv8 = (Iterable)object2;
            boolean $i$f$forEach8 = false;
            for (Object element$iv : $this$forEach$iv8) {
                UUID uuid6 = (UUID)element$iv;
                boolean bl = false;
                MinecraftServer minecraftServer = server;
                if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(uuid6)) == null) continue;
                MinecraftServer it = minecraftServer;
                boolean bl6 = false;
                INSTANCE.teleportToPosition((class_3222)it, INSTANCE.getConfig().getPodiumSecond());
            }
        }
        if ((object = third) != null && (object = ((TournamentParticipant)object).getUUIDs()) != null) {
            Iterable $this$forEach$iv9 = (Iterable)object;
            boolean $i$f$forEach9 = false;
            for (Object element$iv : $this$forEach$iv9) {
                UUID uuid7 = (UUID)element$iv;
                boolean bl = false;
                MinecraftServer minecraftServer = server;
                if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(uuid7)) == null) continue;
                MinecraftServer it = minecraftServer;
                boolean bl7 = false;
                INSTANCE.teleportToPosition((class_3222)it, INSTANCE.getConfig().getPodiumThird());
            }
        }
        class_5250 class_52502 = class_2561.method_43470((String)("=== RESULTATS DU TOURNOI " + tournament.getName() + " ===")).method_27694(TournamentManager::finalizeTournament$lambda$8);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
        this.broadcastToServer((class_2561)class_52502);
        TournamentParticipant tournamentParticipant4 = first;
        if (tournamentParticipant4 != null) {
            TournamentParticipant it = tournamentParticipant4;
            boolean bl = false;
            class_5250 class_52503 = class_2561.method_43470((String)("1er: " + it.getDisplayName())).method_27694(TournamentManager::finalizeTournament$lambda$9$0);
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"withStyle(...)");
            INSTANCE.broadcastToServer((class_2561)class_52503);
        }
        TournamentParticipant tournamentParticipant5 = second;
        if (tournamentParticipant5 != null) {
            TournamentParticipant it = tournamentParticipant5;
            boolean bl = false;
            class_5250 class_52504 = class_2561.method_43470((String)("2eme: " + it.getDisplayName())).method_27694(TournamentManager::finalizeTournament$lambda$10$0);
            Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"withStyle(...)");
            INSTANCE.broadcastToServer((class_2561)class_52504);
        }
        TournamentParticipant tournamentParticipant6 = third;
        if (tournamentParticipant6 != null) {
            TournamentParticipant it = tournamentParticipant6;
            boolean bl = false;
            class_5250 class_52505 = class_2561.method_43470((String)("3eme: " + it.getDisplayName())).method_27694(TournamentManager::finalizeTournament$lambda$11$0);
            Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"withStyle(...)");
            INSTANCE.broadcastToServer((class_2561)class_52505);
        }
        this.distributeRewards(tournament);
        SchedulingFunctionsKt.afterOnServer((float)this.getConfig().getEndCeremonyDurationSeconds(), TournamentManager::finalizeTournament$lambda$12);
        TournamentParticipant tournamentParticipant7 = first;
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Tournament '" + tournament.getName() + "' finalized. Winner: " + (tournamentParticipant7 != null ? tournamentParticipant7.getDisplayName() : null));
    }

    private final void distributeRewards(TournamentSession tournament) {
        block5: {
            Object object;
            Object object2;
            MinecraftServer player;
            UUID uuid;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Object object3 = tournament.getFirstPlace();
            if (object3 != null && (object3 = ((TournamentParticipant)object3).getUUIDs()) != null) {
                $this$forEach$iv = (Iterable)object3;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    uuid = (UUID)element$iv;
                    boolean bl = false;
                    MinecraftServer minecraftServer = server;
                    if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(uuid)) == null) continue;
                    player = minecraftServer;
                    boolean bl2 = false;
                    INSTANCE.giveRewards((class_3222)player, tournament.getRewards().getFirstPlace(), tournament.getMode());
                }
            }
            if ((object2 = tournament.getSecondPlace()) != null && (object2 = ((TournamentParticipant)object2).getUUIDs()) != null) {
                $this$forEach$iv = (Iterable)object2;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    uuid = (UUID)element$iv;
                    boolean bl = false;
                    MinecraftServer minecraftServer = server;
                    if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(uuid)) == null) continue;
                    player = minecraftServer;
                    boolean bl3 = false;
                    INSTANCE.giveRewards((class_3222)player, tournament.getRewards().getSecondPlace(), tournament.getMode());
                }
            }
            if ((object = tournament.getThirdPlace()) == null || (object = ((TournamentParticipant)object).getUUIDs()) == null) break block5;
            $this$forEach$iv = (Iterable)object;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                uuid = (UUID)element$iv;
                boolean bl = false;
                MinecraftServer minecraftServer = server;
                if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(uuid)) == null) continue;
                player = minecraftServer;
                boolean bl4 = false;
                INSTANCE.giveRewards((class_3222)player, tournament.getRewards().getThirdPlace(), tournament.getMode());
            }
        }
    }

    private final void giveRewards(class_3222 player, List<TournamentRewardItem> rewards, TournamentMode mode) {
        Iterable $this$forEach$iv = rewards;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TournamentRewardItem reward = (TournamentRewardItem)element$iv;
            boolean bl = false;
            try {
                class_2960 itemId = class_2960.method_12829((String)reward.getItemId());
                if (itemId == null) continue;
                Object object = class_7923.field_41178.method_10223(itemId);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                class_1792 item = (class_1792)object;
                class_1799 stack = new class_1799((class_1935)item, reward.getCount());
                player.method_31548().method_7394(stack);
            }
            catch (Exception e) {
                PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to give reward " + reward.getItemId() + " to " + player.method_5477().getString(), (Throwable)e);
            }
        }
    }

    private final void endCeremony() {
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            return;
        }
        TournamentSession tournament = tournamentSession;
        tournament.setState(TournamentState.FINISHED);
        this.endAllTournamentSpectators();
        this.cleanupAllBossBars();
        Iterable $this$forEach$iv = tournament.getParticipants();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TournamentParticipant participant = (TournamentParticipant)element$iv;
            boolean bl = false;
            INSTANCE.teleportParticipantBack(participant);
            Iterable $this$forEach$iv2 = participant.getUUIDs();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                UUID uuid = (UUID)element$iv2;
                boolean bl2 = false;
                MinecraftServer minecraftServer = server;
                if (minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null && (minecraftServer = minecraftServer.method_14602(uuid)) != null) {
                    MinecraftServer player = minecraftServer;
                    boolean bl3 = false;
                    INSTANCE.removeSaturation((class_3222)player);
                    InventoryManager.INSTANCE.restoreInventory((class_3222)player);
                }
                playerToTournament.remove(uuid);
            }
        }
        class_5250 class_52502 = class_2561.method_43470((String)("Le tournoi " + tournament.getName() + " est termine! Merci a tous les participants!")).method_27694(TournamentManager::endCeremony$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
        this.broadcastToServer((class_2561)class_52502);
        activeTournament = null;
        playerToMatch.clear();
        arenaToMatch.clear();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Tournament ended and cleaned up");
    }

    public final void endTournament(boolean cancelled) {
        boolean wasPreparationDone;
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            return;
        }
        TournamentSession tournament = tournamentSession;
        boolean bl = wasPreparationDone = tournament.getState() != TournamentState.REGISTRATION && tournament.getState() != TournamentState.CREATED;
        if (cancelled) {
            class_5250 class_52502 = class_2561.method_43470((String)("Le tournoi " + tournament.getName() + " a ete annule!")).method_27694(TournamentManager::endTournament$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
            this.broadcastToServer((class_2561)class_52502);
        }
        this.endAllTournamentSpectators();
        this.cleanupAllBossBars();
        if (wasPreparationDone) {
            Iterable $this$forEach$iv = tournament.getParticipants();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TournamentParticipant participant = (TournamentParticipant)element$iv;
                boolean bl2 = false;
                INSTANCE.teleportParticipantBack(participant);
                Iterable $this$forEach$iv2 = participant.getUUIDs();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    UUID uuid = (UUID)element$iv2;
                    boolean bl3 = false;
                    MinecraftServer minecraftServer = server;
                    if (minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null && (minecraftServer = minecraftServer.method_14602(uuid)) != null) {
                        MinecraftServer player = minecraftServer;
                        boolean bl4 = false;
                        INSTANCE.removeSaturation((class_3222)player);
                        InventoryManager.INSTANCE.restoreInventory((class_3222)player);
                    }
                    playerToTournament.remove(uuid);
                }
            }
        } else {
            Iterable $this$forEach$iv = tournament.getParticipants();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TournamentParticipant participant = (TournamentParticipant)element$iv;
                boolean bl5 = false;
                Iterable $this$forEach$iv3 = participant.getUUIDs();
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    UUID uuid = (UUID)element$iv3;
                    boolean bl6 = false;
                    playerToTournament.remove(uuid);
                }
            }
        }
        activeTournament = null;
        broadcastTaskRunning = false;
        bossBarTaskRunning = false;
        playerToMatch.clear();
        arenaToMatch.clear();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Tournament " + (cancelled ? "cancelled" : "ended"));
    }

    private final void disqualifyParticipant(TournamentParticipant participant, String reason) {
        TournamentMatch match;
        UUID matchId;
        TournamentSession tournament;
        block5: {
            UUID uUID;
            TournamentSession tournamentSession = activeTournament;
            if (tournamentSession == null) {
                return;
            }
            tournament = tournamentSession;
            TournamentBracket tournamentBracket = tournament.getBracket();
            if (tournamentBracket == null) {
                return;
            }
            TournamentBracket bracket = tournamentBracket;
            participant.setEliminated(true);
            participant.setLosses(2);
            class_5250 class_52502 = class_2561.method_43470((String)("[TOURNOI] " + participant.getDisplayName() + " disqualifie: " + reason)).method_27694(TournamentManager::disqualifyParticipant$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
            this.broadcastToServer((class_2561)class_52502);
            for (UUID it : (Iterable)participant.getUUIDs()) {
                boolean bl = false;
                UUID uUID2 = playerToMatch.get(it);
                if (uUID2 == null) continue;
                uUID = uUID2;
                break block5;
            }
            uUID = matchId = null;
        }
        if (matchId != null && (match = tournament.getActiveMatches().get(matchId)) != null) {
            TournamentParticipant otherParticipant;
            TournamentParticipant tournamentParticipant = otherParticipant = Intrinsics.areEqual((Object)match.getParticipant1(), (Object)participant) ? match.getParticipant2() : match.getParticipant1();
            if (otherParticipant != null) {
                this.completeMatch(match, otherParticipant, participant);
            }
        }
        this.teleportToSpectatorArea(participant);
    }

    /*
     * WARNING - void declaration
     */
    public final void handlePlayerDisconnect(@NotNull class_3222 player) {
        TournamentMatch match;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            return;
        }
        TournamentSession tournament = tournamentSession;
        UUID matchId = playerToMatch.get(player.method_5667());
        if (matchId != null && (match = tournament.getActiveMatches().get(matchId)) != null && match.getState() == MatchState.IN_BATTLE) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            match.setState(MatchState.RECONNECTING);
            match.setDisconnectedPlayerId(player.method_5667());
            match.setDisconnectTime(System.currentTimeMillis());
            Iterable $this$filter$iv = match.getAllPlayerIds();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                UUID it = (UUID)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)player.method_5667()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UUID otherId = (UUID)element$iv;
                boolean bl = false;
                MinecraftServer minecraftServer = server;
                if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(otherId)) == null) continue;
                minecraftServer.method_43496((class_2561)class_2561.method_43470((String)(player.method_5477().getString() + " deconnecte! " + INSTANCE.getConfig().getReconnectionTimeoutSeconds() + "s pour se reconnecter...")).method_27694(TournamentManager::handlePlayerDisconnect$lambda$1$0));
            }
            SchedulingFunctionsKt.afterOnServer((float)this.getConfig().getReconnectionTimeoutSeconds(), () -> TournamentManager.handlePlayerDisconnect$lambda$2(match));
        }
    }

    public final void handlePlayerReconnect(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            return;
        }
        TournamentSession tournament = tournamentSession;
        UUID matchId = playerToMatch.get(player.method_5667());
        if (matchId != null) {
            TournamentMatch match;
            TournamentMatch tournamentMatch = match = tournament.getActiveMatches().get(matchId);
            if ((tournamentMatch != null ? tournamentMatch.getState() : null) == MatchState.RECONNECTING && Intrinsics.areEqual((Object)match.getDisconnectedPlayerId(), (Object)player.method_5667())) {
                match.setState(MatchState.IN_BATTLE);
                match.setDisconnectedPlayerId(null);
                match.setDisconnectTime(null);
                String string = match.getArenaId();
                if (string != null) {
                    String arenaId = string;
                    boolean bl = false;
                    TournamentArena arena = INSTANCE.getConfig().getArena(arenaId);
                    if (arena != null) {
                        boolean isP1;
                        Object object = match.getParticipant1();
                        if (object == null || (object = ((TournamentParticipant)object).getUUIDs()) == null) {
                            object = CollectionsKt.emptyList();
                        }
                        INSTANCE.teleportToPosition(player, (isP1 = object.contains(player.method_5667())) ? arena.getPlayer1Spawn() : arena.getPlayer2Spawn());
                    }
                }
                Iterable $this$forEach$iv = match.getAllPlayerIds();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    UUID playerId = (UUID)element$iv;
                    boolean bl = false;
                    MinecraftServer minecraftServer = server;
                    if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(playerId)) == null) continue;
                    minecraftServer.method_43496((class_2561)class_2561.method_43470((String)(player.method_5477().getString() + " reconnecte!")).method_27694(TournamentManager::handlePlayerReconnect$lambda$1$0));
                }
            }
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        if (this.isPlayerInTournament(uUID)) {
            UUID uUID2 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            if (!this.isPlayerInMatch(uUID2)) {
                TournamentState tournamentState;
                TournamentSession tournamentSession2 = activeTournament;
                TournamentState tournamentState2 = tournamentState = tournamentSession2 != null ? tournamentSession2.getState() : null;
                if (tournamentState == TournamentState.IN_PROGRESS || tournamentState == TournamentState.CEREMONY) {
                    this.teleportToPosition(player, this.getConfig().getWaitingRoomPosition());
                }
            }
        }
    }

    private final void checkReconnectionTimeout(TournamentMatch match) {
        block3: {
            TournamentParticipant participant;
            if (match.getState() != MatchState.RECONNECTING) {
                return;
            }
            UUID uUID = match.getDisconnectedPlayerId();
            if (uUID == null) {
                return;
            }
            UUID disconnectedId = uUID;
            Object object = match.getParticipant1();
            if (object == null || (object = ((TournamentParticipant)object).getUUIDs()) == null) {
                object = CollectionsKt.emptyList();
            }
            TournamentParticipant tournamentParticipant = participant = object.contains(disconnectedId) ? match.getParticipant1() : match.getParticipant2();
            if (tournamentParticipant == null) break block3;
            TournamentParticipant it = tournamentParticipant;
            boolean bl = false;
            INSTANCE.disqualifyParticipant(it, "Deconnexion trop longue");
        }
    }

    public final boolean isPlayerInTournament(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return playerToTournament.containsKey(playerId);
    }

    public final boolean isPlayerInMatch(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return playerToMatch.containsKey(playerId);
    }

    @Nullable
    public final TournamentSession getActiveTournament() {
        return activeTournament;
    }

    public final boolean canPlayerJoinTournament(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        if (this.isPlayerInTournament(uUID)) {
            return false;
        }
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        if (DuelManager.INSTANCE.isPlayerInDuel(uUID2)) {
            return false;
        }
        UUID uUID3 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
        if (GymManager.INSTANCE.isPlayerActive(uUID3)) {
            return false;
        }
        UUID uUID4 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID4, (String)"getUUID(...)");
        return !LeagueManager.INSTANCE.isPlayerActive(uUID4);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void teleportToPosition(class_3222 player, Position position) {
        try {
            block5: {
                worldKey = class_2960.method_12829((String)position.getWorld());
                var5_5 = TournamentManager.server;
                if (var5_5 == null || (var6_6 = var5_5.method_29435()) == null) ** GOTO lbl-1000
                var9_7 = var6_6;
                for (T var11_9 : var9_7) {
                    it = (class_5321)var11_9;
                    $i$a$-find-TournamentManager$teleportToPosition$level$1 = false;
                    if (!Intrinsics.areEqual((Object)it.method_29177(), (Object)worldKey)) continue;
                    v0 = var11_9;
                    break block5;
                }
                v0 = null;
            }
            var7_13 = v0;
            if (var7_13 == null) ** GOTO lbl-1000
            it = var7_13;
            $i$a$-let-TournamentManager$teleportToPosition$level$2 = false;
            v1 = TournamentManager.server;
            var8_14 /* !! */  = v1 != null ? v1.method_3847(it) : null;
            if (var8_14 /* !! */  != null) {
                v2 = var8_14 /* !! */ ;
            } else lbl-1000:
            // 3 sources

            {
                v2 = player.method_51469();
            }
            level = v2;
            player.method_14251(level, position.getX(), position.getY(), position.getZ(), position.getYaw(), position.getPitch());
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to teleport " + player.method_5477().getString(), (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void teleportParticipantBack(TournamentParticipant participant) {
        $this$forEach$iv = participant.getUUIDs();
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            uuid = (UUID)element$iv;
            $i$a$-forEach-TournamentManager$teleportParticipantBack$1 = false;
            v0 = TournamentManager.server;
            if (v0 == null || (v0 = v0.method_3760()) == null || (v0 = v0.method_14602(uuid)) == null) continue;
            player = v0;
            $i$a$-let-TournamentManager$teleportParticipantBack$1$1 = false;
            try {
                block6: {
                    worldKey = class_2960.method_12829((String)participant.getOriginalWorld());
                    var11_12 = TournamentManager.server;
                    if (var11_12 == null || (var12_13 = var11_12.method_29435()) == null) ** GOTO lbl-1000
                    var13_14 = var12_13;
                    for (T var15_16 : var13_14) {
                        it = (class_5321)var15_16;
                        $i$a$-find-TournamentManager$teleportParticipantBack$1$1$level$1 = false;
                        if (!Intrinsics.areEqual((Object)it.method_29177(), (Object)worldKey)) continue;
                        v1 = var15_16;
                        break block6;
                    }
                    v1 = null;
                }
                var18_20 = v1;
                if (var18_20 == null) ** GOTO lbl-1000
                it = var18_20;
                $i$a$-let-TournamentManager$teleportParticipantBack$1$1$level$2 = false;
                v2 = TournamentManager.server;
                var19_21 /* !! */  = v2 != null ? v2.method_3847(it) : null;
                if (var19_21 /* !! */  != null) {
                    v3 = var19_21 /* !! */ ;
                } else lbl-1000:
                // 3 sources

                {
                    v3 = player.method_51469();
                }
                level = v3;
                player.method_14251(level, participant.getOriginalX(), participant.getOriginalY(), participant.getOriginalZ(), participant.getOriginalYaw(), participant.getOriginalPitch());
            }
            catch (Exception e) {
                PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to teleport back " + player.method_5477().getString(), (Throwable)e);
            }
        }
    }

    private final void teleportToSpectatorArea(TournamentParticipant participant) {
        Iterable $this$forEach$iv = participant.getUUIDs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(uuid)) == null) continue;
            MinecraftServer player = minecraftServer;
            boolean bl2 = false;
            INSTANCE.teleportToPosition((class_3222)player, INSTANCE.getConfig().getSpectatorAreaPosition());
        }
    }

    private final void recallAllPokemon(class_3222 player) {
        try {
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            Iterable $this$forEach$iv = (Iterable)party;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pokemon pokemon = (Pokemon)element$iv;
                boolean bl = false;
                Object object = pokemon.getEntity();
                if (object != null) {
                    PokemonEntity it = object;
                    boolean bl2 = false;
                    CompletableFuture completableFuture = it.recallWithAnimation();
                    object = completableFuture;
                    if (completableFuture != null) continue;
                }
                pokemon.recall();
                object = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to recall Pokemon for " + player.method_5477().getString(), (Throwable)e);
        }
    }

    private final void broadcastToServer(class_2561 message) {
        block1: {
            Object object = server;
            if (object == null || (object = object.method_3760()) == null || (object = object.method_14571()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3222 player = (class_3222)element$iv;
                boolean bl = false;
                player.method_43496(message);
            }
        }
    }

    private final void healPlayerParty(class_3222 player) {
        try {
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            party.heal();
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Healed party for " + player.method_5477().getString());
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to heal party for " + player.method_5477().getString(), (Throwable)e);
        }
    }

    private final void applySaturation(class_3222 player) {
        player.method_6092(new class_1293(class_1294.field_5922, 0x6DDD00, 255, false, false, false));
        player.method_7344().method_7580(20);
        player.method_7344().method_7581(20.0f);
    }

    private final void removeSaturation(class_3222 player) {
        player.method_6016(class_1294.field_5922);
    }

    public final boolean addTournamentSpectator(@NotNull class_3222 player, @Nullable String arenaId) {
        String targetArena;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            TournamentManager $this$addTournamentSpectator_u24lambda_u240 = this;
            boolean bl = false;
            player.method_43496((class_2561)class_2561.method_43470((String)"Aucun tournoi en cours!").method_27694(TournamentManager::addTournamentSpectator$lambda$0$0));
            return false;
        }
        TournamentSession tournament = tournamentSession;
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        if (this.isPlayerInMatch(uUID)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Vous etes en combat!").method_27694(TournamentManager::addTournamentSpectator$lambda$1));
            return false;
        }
        ((Map)tournamentSpectators).put(player.method_5667(), player.field_13974.method_14257());
        player.method_7336(class_1934.field_9219);
        this.applySaturation(player);
        String string = arenaId;
        if (string == null) {
            string = this.getFirstActiveArena();
        }
        if ((targetArena = string) != null) {
            ((Map)spectatorArenaChoice).put(player.method_5667(), targetArena);
            this.teleportSpectatorToArena(player, targetArena);
        } else {
            this.teleportToPosition(player, this.getConfig().getSpectatorAreaPosition());
        }
        String string2 = targetArena;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            INSTANCE.addSpectatorToBossBars(player, it);
        }
        player.method_43496((class_2561)class_2561.method_43470((String)"Mode spectateur active! Utilisez /tournois spectate <1-4> pour changer d'arene.").method_27694(TournamentManager::addTournamentSpectator$lambda$3));
        PokemonLeagueMod.INSTANCE.getLOGGER().info(player.method_5477().getString() + " started spectating tournament");
        return true;
    }

    public static /* synthetic */ boolean addTournamentSpectator$default(TournamentManager tournamentManager, class_3222 class_32222, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return tournamentManager.addTournamentSpectator(class_32222, string);
    }

    public final boolean switchSpectatorArena(@NotNull class_3222 player, int arenaNumber) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!tournamentSpectators.containsKey(player.method_5667())) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Vous n'etes pas en mode spectateur!").method_27694(TournamentManager::switchSpectatorArena$lambda$0));
            return false;
        }
        String arenaId = "arena_" + arenaNumber;
        TournamentArena arena = this.getConfig().getArena(arenaId);
        if (arena == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)("Arene " + arenaNumber + " n'existe pas!")).method_27694(TournamentManager::switchSpectatorArena$lambda$1));
            return false;
        }
        String string = spectatorArenaChoice.get(player.method_5667());
        if (string != null) {
            String oldArena = string;
            boolean bl = false;
            INSTANCE.removeSpectatorFromBossBars(player, oldArena);
        }
        ((Map)spectatorArenaChoice).put(player.method_5667(), arenaId);
        this.teleportSpectatorToArena(player, arenaId);
        this.addSpectatorToBossBars(player, arenaId);
        UUID matchId = arenaToMatch.get(arenaId);
        TournamentSession tournament = activeTournament;
        if (matchId != null && tournament != null) {
            TournamentMatch match = tournament.getActiveMatches().get(matchId);
            if (match != null) {
                player.method_43496((class_2561)class_2561.method_43470((String)("Arene " + arenaNumber + ": " + match.getMatchDisplayName())).method_27694(TournamentManager::switchSpectatorArena$lambda$3));
            }
        } else {
            player.method_43496((class_2561)class_2561.method_43470((String)("Arene " + arenaNumber + ": Aucun combat en cours")).method_27694(TournamentManager::switchSpectatorArena$lambda$4));
        }
        return true;
    }

    public final void removeTournamentSpectator(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        class_1934 class_19342 = tournamentSpectators.remove(player.method_5667());
        if (class_19342 == null) {
            return;
        }
        class_1934 originalMode = class_19342;
        String string = spectatorArenaChoice.remove(player.method_5667());
        if (string != null) {
            String arenaId = string;
            boolean bl = false;
            INSTANCE.removeSpectatorFromBossBars(player, arenaId);
        }
        player.method_7336(originalMode);
        this.removeSaturation(player);
        player.method_43496((class_2561)class_2561.method_43470((String)"Mode spectateur desactive.").method_27694(TournamentManager::removeTournamentSpectator$lambda$1));
        PokemonLeagueMod.INSTANCE.getLOGGER().info(player.method_5477().getString() + " stopped spectating tournament");
    }

    private final void endAllTournamentSpectators() {
        Set set = tournamentSpectators.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        List spectatorsToRemove = CollectionsKt.toList((Iterable)set);
        Iterable $this$forEach$iv = spectatorsToRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(uuid)) == null) continue;
            MinecraftServer it = minecraftServer;
            boolean bl2 = false;
            INSTANCE.removeTournamentSpectator((class_3222)it);
        }
        tournamentSpectators.clear();
        spectatorArenaChoice.clear();
    }

    public final boolean isTournamentSpectator(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return tournamentSpectators.containsKey(playerId);
    }

    public final boolean isPlayerEliminated(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            return false;
        }
        TournamentSession tournament = tournamentSession;
        TournamentParticipant tournamentParticipant = tournament.findParticipant(playerId);
        if (tournamentParticipant == null) {
            return false;
        }
        TournamentParticipant participant = tournamentParticipant;
        return participant.isEliminated();
    }

    private final String getFirstActiveArena() {
        Set set = arenaToMatch.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return (String)CollectionsKt.firstOrNull((Iterable)set);
    }

    private final void teleportSpectatorToArena(class_3222 player, String arenaId) {
        TournamentArena tournamentArena = this.getConfig().getArena(arenaId);
        if (tournamentArena == null) {
            return;
        }
        TournamentArena arena = tournamentArena;
        double midX = (arena.getPlayer1Spawn().getX() + arena.getPlayer2Spawn().getX()) / (double)2;
        double midY = Math.max(arena.getPlayer1Spawn().getY(), arena.getPlayer2Spawn().getY()) + (double)10;
        double midZ = (arena.getPlayer1Spawn().getZ() + arena.getPlayer2Spawn().getZ()) / (double)2;
        Position spectatorPos = new Position(arena.getPlayer1Spawn().getWorld(), midX, midY, midZ, arena.getPlayer1Spawn().getYaw(), 30.0f);
        this.teleportToPosition(player, spectatorPos);
    }

    public final void createBossBarsForMatch(@NotNull TournamentMatch match, @NotNull String arenaId) {
        Object object;
        MinecraftServer it;
        UUID uuid;
        Iterable $this$forEach$iv;
        Object object2;
        Object p1Name;
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
        Object object3 = match.getParticipant1();
        if (object3 == null || (object3 = ((TournamentParticipant)object3).getDisplayName()) == null) {
            object3 = p1Name = "?";
        }
        if ((object2 = match.getParticipant2()) == null || (object2 = ((TournamentParticipant)object2).getDisplayName()) == null) {
            object2 = "?";
        }
        Object p2Name = object2;
        class_3213 bar1 = new class_3213((class_2561)class_2561.method_43470((String)String.valueOf(p1Name)).method_27694(TournamentManager::createBossBarsForMatch$lambda$0), class_1259.class_1260.field_5785, class_1259.class_1261.field_5796);
        class_3213 bar2 = new class_3213((class_2561)class_2561.method_43470((String)String.valueOf(p2Name)).method_27694(TournamentManager::createBossBarsForMatch$lambda$1), class_1259.class_1260.field_5784, class_1259.class_1261.field_5796);
        ((Map)arenaBossBars).put(arenaId, new Pair((Object)bar1, (Object)bar2));
        Map $this$forEach$iv2 = spectatorArenaChoice;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv2.entrySet()) {
            Iterator iterator = element$iv;
            boolean bl = false;
            UUID spectatorId = (UUID)iterator.getKey();
            String watchingArena = (String)iterator.getValue();
            if (!Intrinsics.areEqual((Object)watchingArena, (Object)arenaId)) continue;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(spectatorId)) == null) continue;
            MinecraftServer spectator = minecraftServer;
            boolean bl2 = false;
            bar1.method_14088((class_3222)spectator);
            bar2.method_14088((class_3222)spectator);
        }
        Object object4 = match.getParticipant1();
        if (object4 != null && (object4 = ((TournamentParticipant)object4).getUUIDs()) != null) {
            $this$forEach$iv = (Iterable)object4;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                uuid = (UUID)element$iv;
                boolean bl = false;
                MinecraftServer minecraftServer = server;
                if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(uuid)) == null) continue;
                it = minecraftServer;
                boolean bl3 = false;
                bar2.method_14088((class_3222)it);
            }
        }
        if ((object = match.getParticipant2()) != null && (object = ((TournamentParticipant)object).getUUIDs()) != null) {
            $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv) {
                uuid = (UUID)element$iv;
                boolean bl = false;
                MinecraftServer minecraftServer = server;
                if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(uuid)) == null) continue;
                it = minecraftServer;
                boolean bl4 = false;
                bar1.method_14088((class_3222)it);
            }
        }
        if (!bossBarTaskRunning) {
            bossBarTaskRunning = true;
            this.startBossBarUpdateLoop();
        }
    }

    private final void startBossBarUpdateLoop() {
        SchedulingFunctionsKt.afterOnServer((float)0.5f, TournamentManager::startBossBarUpdateLoop$lambda$3);
    }

    private final Pair<Float, String> getPartyHpInfo(TournamentParticipant participant) {
        int totalHp = 0;
        int currentHp = 0;
        int alive = 0;
        int total = 0;
        Iterable $this$forEach$iv = participant.getUUIDs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(uuid)) == null) continue;
            MinecraftServer player = minecraftServer;
            boolean bl2 = false;
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty((class_3222)player);
            Iterable $this$forEach$iv2 = (Iterable)party;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Pokemon pokemon = (Pokemon)element$iv2;
                boolean bl3 = false;
                ++total;
                totalHp += pokemon.getMaxHealth();
                currentHp += pokemon.getCurrentHealth();
                if (pokemon.isFainted()) continue;
                ++alive;
            }
        }
        float percentage = totalHp > 0 ? (float)currentHp / (float)totalHp : 0.0f;
        return new Pair((Object)Float.valueOf(percentage), (Object)("(" + alive + "/" + total + ")"));
    }

    private final void addSpectatorToBossBars(class_3222 player, String arenaId) {
        block0: {
            Pair<class_3213, class_3213> pair = arenaBossBars.get(arenaId);
            if (pair == null) break block0;
            Pair<class_3213, class_3213> pair2 = pair;
            boolean bl = false;
            class_3213 bar1 = (class_3213)pair2.component1();
            class_3213 bar2 = (class_3213)pair2.component2();
            bar1.method_14088(player);
            bar2.method_14088(player);
        }
    }

    private final void removeSpectatorFromBossBars(class_3222 player, String arenaId) {
        block0: {
            Pair<class_3213, class_3213> pair = arenaBossBars.get(arenaId);
            if (pair == null) break block0;
            Pair<class_3213, class_3213> pair2 = pair;
            boolean bl = false;
            class_3213 bar1 = (class_3213)pair2.component1();
            class_3213 bar2 = (class_3213)pair2.component2();
            bar1.method_14089(player);
            bar2.method_14089(player);
        }
    }

    public final void cleanupArenaBossBars(@NotNull String arenaId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
            Pair<class_3213, class_3213> pair = arenaBossBars.remove(arenaId);
            if (pair == null) break block0;
            Pair<class_3213, class_3213> pair2 = pair;
            boolean bl = false;
            class_3213 bar1 = (class_3213)pair2.component1();
            class_3213 bar2 = (class_3213)pair2.component2();
            bar1.method_14094();
            bar2.method_14094();
        }
    }

    private final void cleanupAllBossBars() {
        Collection<Pair<class_3213, class_3213>> collection = arenaBossBars.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            class_3213 bar1 = (class_3213)pair.component1();
            class_3213 bar2 = (class_3213)pair.component2();
            bar1.method_14094();
            bar2.method_14094();
        }
        arenaBossBars.clear();
        bossBarTaskRunning = false;
    }

    private static final class_2583 createTournament$lambda$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 createTournament$lambda$1(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 createTournament$lambda$2(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final class_2583 openRegistration$lambda$0(class_2583 it) {
        return it.method_36139(16766720).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 openRegistration$lambda$1(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final class_2583 openRegistration$lambda$2(class_2583 it) {
        return it.method_36139(0xFFFF55).method_10958(new class_2558(class_2558.class_2559.field_11750, "/tournois join")).method_30938(Boolean.valueOf(true));
    }

    private static final void startRegistrationBroadcast$broadcastLoop() {
        TournamentSession tournament = activeTournament;
        if (tournament == null || tournament.getState() != TournamentState.REGISTRATION) {
            broadcastTaskRunning = false;
            return;
        }
        class_5250 class_52502 = class_2561.method_43470((String)("[TOURNOI] " + tournament.getName() + " - " + tournament.getParticipantCount() + "/" + tournament.getMaxParticipants() + " inscrits")).method_27694(TournamentManager::startRegistrationBroadcast$broadcastLoop$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
        INSTANCE.broadcastToServer((class_2561)class_52502);
        class_5250 class_52503 = class_2561.method_43470((String)"[Cliquez pour rejoindre /tournois join]").method_27694(TournamentManager::startRegistrationBroadcast$broadcastLoop$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"withStyle(...)");
        INSTANCE.broadcastToServer((class_2561)class_52503);
        SchedulingFunctionsKt.afterOnServer((float)INSTANCE.getConfig().getRegistrationBroadcastIntervalSeconds(), TournamentManager::startRegistrationBroadcast$broadcastLoop$lambda$2);
    }

    private static final class_2583 startRegistrationBroadcast$broadcastLoop$lambda$0(class_2583 it) {
        return it.method_36139(16766720);
    }

    private static final class_2583 startRegistrationBroadcast$broadcastLoop$lambda$1(class_2583 it) {
        return it.method_36139(0x55FF55).method_10958(new class_2558(class_2558.class_2559.field_11750, "/tournois join")).method_30938(Boolean.valueOf(true));
    }

    private static final Unit startRegistrationBroadcast$broadcastLoop$lambda$2() {
        TournamentManager.startRegistrationBroadcast$broadcastLoop();
        return Unit.INSTANCE;
    }

    private static final Unit startRegistrationBroadcast$lambda$3() {
        TournamentManager.startRegistrationBroadcast$broadcastLoop();
        return Unit.INSTANCE;
    }

    private static final class_2583 registerPlayer$lambda$0$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 registerPlayer$lambda$1(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 registerPlayer$lambda$2(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 registerPlayer$lambda$3(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 registerPlayer$lambda$4(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 registerPlayer$lambda$5(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final class_2583 registerPlayer$lambda$6(class_2583 it) {
        return it.method_36139(0xAAAAAA);
    }

    private static final class_2583 registerPlayer$lambda$7(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2583 unregisterPlayer$lambda$0(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2583 unregisterPlayer$lambda$1(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2583 startTournament$lambda$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 startTournament$lambda$1(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 startTournament$lambda$2(class_2583 it) {
        return it.method_36139(16766720).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 startTournament$lambda$3(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2583 startTournament$lambda$4(class_2583 it) {
        return it.method_36139(0xAAAAAA);
    }

    private static final class_2583 startTournament$lambda$5(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final class_2583 startPreTournamentCountdown$lambda$0(class_2583 it) {
        return it.method_36139(0xFFFF55).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 startPreTournamentCountdown$lambda$1(class_2583 it) {
        return it.method_36139(0xFFFF55).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 startPreTournamentCountdown$lambda$2(class_2583 it) {
        return it.method_36139(0xFF5555).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 startPreTournamentCountdown$lambda$3(class_2583 it) {
        return it.method_36139(0xFF5555).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 startPreTournamentCountdown$lambda$4(class_2583 it) {
        return it.method_36139(0xFF5555).method_10982(Boolean.valueOf(true));
    }

    private static final Unit startPreTournamentCountdown$lambda$5(int $remainingSeconds) {
        INSTANCE.startPreTournamentCountdown($remainingSeconds - 1);
        return Unit.INSTANCE;
    }

    private static final class_2583 startPreTournamentCountdown$lambda$6(class_2583 it) {
        return it.method_36139(0x55FF55).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 prepareAllParticipants$lambda$0(class_2583 it) {
        return it.method_36139(0x55FFFF).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 prepareAllParticipants$lambda$1$0$0$0(class_2583 it) {
        return it.method_36139(0x55FFFF);
    }

    private static final class_2583 actuallyStartTournament$lambda$0(class_2583 it) {
        return it.method_36139(0x55FF55).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 actuallyStartTournament$lambda$1(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2583 startMatch$lambda$4$0(class_2583 it) {
        return it.method_36139(16766720).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 startMatch$lambda$4$1(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final void startMatchCountdown$countdown(TournamentMatch $match, int seconds) {
        if ($match.getState() != MatchState.COUNTDOWN) {
            return;
        }
        if (seconds > 0) {
            Iterable $this$forEach$iv = $match.getAllPlayerIds();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3222 player;
                UUID playerId = (UUID)element$iv;
                boolean bl = false;
                MinecraftServer minecraftServer = server;
                class_3222 class_32222 = player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
                if (class_32222 == null) continue;
                class_32222.method_43496((class_2561)class_2561.method_43470((String)("Combat dans " + seconds + "...")).method_27694(TournamentManager::startMatchCountdown$countdown$lambda$0$0));
            }
            SchedulingFunctionsKt.afterOnServer((float)1.0f, () -> TournamentManager.startMatchCountdown$countdown$lambda$1(seconds, $match));
        } else {
            INSTANCE.startBattle($match);
        }
    }

    private static final class_2583 startMatchCountdown$countdown$lambda$0$0(class_2583 it) {
        return it.method_36139(0xFFFF55).method_10982(Boolean.valueOf(true));
    }

    private static final Unit startMatchCountdown$countdown$lambda$1(int $seconds, TournamentMatch $match) {
        TournamentManager.startMatchCountdown$countdown($match, $seconds - 1);
        return Unit.INSTANCE;
    }

    private static final class_2583 startBattle$lambda$3$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final Unit start1v1Battle$lambda$4(TournamentMatch $match, ErroredBattleStart error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to start 1v1 tournament: " + CollectionsKt.joinToString$default((Iterable)error.getErrors(), null, null, null, (int)0, null, null, (int)63, null));
        INSTANCE.handleMatchError($match);
        return Unit.INSTANCE;
    }

    private static final Unit start1v1Battle$lambda$5(PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Tournament 1v1 battle started: " + battle.getBattleId());
        return Unit.INSTANCE;
    }

    private static final Unit start2v2Battle$lambda$4(TournamentMatch $match, ErroredBattleStart error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to start 2v2 tournament: " + CollectionsKt.joinToString$default((Iterable)error.getErrors(), null, null, null, (int)0, null, null, (int)63, null));
        INSTANCE.handleMatchError($match);
        return Unit.INSTANCE;
    }

    private static final Unit start2v2Battle$lambda$5(PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Tournament 2v2 battle started: " + battle.getBattleId());
        return Unit.INSTANCE;
    }

    private static final class_2583 handleBattleResult$lambda$4$0(class_2583 it) {
        return it.method_36139(0x55FF55).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 handleBattleResult$lambda$4$1(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2583 handleBattleResult$lambda$5$0(class_2583 it) {
        return it.method_36139(0xAAAAAA);
    }

    private static final Unit handleBattleResult$lambda$6(TournamentSession $tournament, TournamentMatch $match) {
        if ($tournament.getActiveMatches().containsKey($match.getMatchId())) {
            INSTANCE.startMatchCountdown($match);
        }
        return Unit.INSTANCE;
    }

    private static final class_2583 completeMatch$lambda$3(class_2583 it) {
        return it.method_36139(16766720);
    }

    private static final class_2583 completeMatch$lambda$4(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final Unit completeMatch$lambda$6() {
        INSTANCE.scheduleNextMatches();
        return Unit.INSTANCE;
    }

    private static final class_2583 handlePlayerForfeit$lambda$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 finalizeTournament$lambda$8(class_2583 it) {
        return it.method_36139(16766720).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 finalizeTournament$lambda$9$0(class_2583 it) {
        return it.method_36139(16766720);
    }

    private static final class_2583 finalizeTournament$lambda$10$0(class_2583 it) {
        return it.method_36139(0xC0C0C0);
    }

    private static final class_2583 finalizeTournament$lambda$11$0(class_2583 it) {
        return it.method_36139(13467442);
    }

    private static final Unit finalizeTournament$lambda$12() {
        INSTANCE.endCeremony();
        return Unit.INSTANCE;
    }

    private static final class_2583 endCeremony$lambda$1(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final class_2583 endTournament$lambda$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 disqualifyParticipant$lambda$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 handlePlayerDisconnect$lambda$1$0(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final Unit handlePlayerDisconnect$lambda$2(TournamentMatch $match) {
        INSTANCE.checkReconnectionTimeout($match);
        return Unit.INSTANCE;
    }

    private static final class_2583 handlePlayerReconnect$lambda$1$0(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final class_2583 addTournamentSpectator$lambda$0$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 addTournamentSpectator$lambda$1(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 addTournamentSpectator$lambda$3(class_2583 it) {
        return it.method_36139(0x55FFFF);
    }

    private static final class_2583 switchSpectatorArena$lambda$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 switchSpectatorArena$lambda$1(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 switchSpectatorArena$lambda$3(class_2583 it) {
        return it.method_36139(16766720).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 switchSpectatorArena$lambda$4(class_2583 it) {
        return it.method_36139(0xAAAAAA);
    }

    private static final class_2583 removeTournamentSpectator$lambda$1(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2583 createBossBarsForMatch$lambda$0(class_2583 it) {
        return it.method_36139(0x55FF55).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 createBossBarsForMatch$lambda$1(class_2583 it) {
        return it.method_36139(0xFF5555).method_10982(Boolean.valueOf(true));
    }

    private static final void startBossBarUpdateLoop$updateLoop() {
        if (!bossBarTaskRunning) {
            return;
        }
        TournamentSession tournamentSession = activeTournament;
        if (tournamentSession == null) {
            TournamentManager $this$startBossBarUpdateLoop_u24updateLoop_u24lambda_u240 = INSTANCE;
            boolean bl = false;
            bossBarTaskRunning = false;
            return;
        }
        TournamentSession tournament = tournamentSession;
        Map $this$forEach$iv = arenaBossBars;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            TournamentParticipant p2;
            Pair<Float, String> hpInfo;
            TournamentMatch match;
            UUID matchId;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String arenaId = (String)entry.getKey();
            Pair bars = (Pair)entry.getValue();
            if (arenaToMatch.get(arenaId) == null || tournament.getActiveMatches().get(matchId) == null || match.getState() != MatchState.IN_BATTLE) continue;
            if (match.getParticipant1() != null) {
                TournamentParticipant p1;
                boolean bl2 = false;
                hpInfo = INSTANCE.getPartyHpInfo(p1);
                ((class_3213)bars.getFirst()).method_5408(((Number)hpInfo.getFirst()).floatValue());
                ((class_3213)bars.getFirst()).method_5413((class_2561)class_2561.method_43470((String)(p1.getDisplayName() + " " + hpInfo.getSecond())).method_27694(TournamentManager::startBossBarUpdateLoop$updateLoop$lambda$1$0$0));
            }
            if (match.getParticipant2() == null) continue;
            boolean bl3 = false;
            hpInfo = INSTANCE.getPartyHpInfo(p2);
            ((class_3213)bars.getSecond()).method_5408(((Number)hpInfo.getFirst()).floatValue());
            ((class_3213)bars.getSecond()).method_5413((class_2561)class_2561.method_43470((String)(p2.getDisplayName() + " " + hpInfo.getSecond())).method_27694(TournamentManager::startBossBarUpdateLoop$updateLoop$lambda$1$1$0));
        }
        SchedulingFunctionsKt.afterOnServer((float)0.5f, TournamentManager::startBossBarUpdateLoop$updateLoop$lambda$2);
    }

    private static final class_2583 startBossBarUpdateLoop$updateLoop$lambda$1$0$0(class_2583 it) {
        return it.method_36139(0x55FF55).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 startBossBarUpdateLoop$updateLoop$lambda$1$1$0(class_2583 it) {
        return it.method_36139(0xFF5555).method_10982(Boolean.valueOf(true));
    }

    private static final Unit startBossBarUpdateLoop$updateLoop$lambda$2() {
        TournamentManager.startBossBarUpdateLoop$updateLoop();
        return Unit.INSTANCE;
    }

    private static final Unit startBossBarUpdateLoop$lambda$3() {
        TournamentManager.startBossBarUpdateLoop$updateLoop();
        return Unit.INSTANCE;
    }

    static {
        playerToTournament = new ConcurrentHashMap();
        playerToMatch = new ConcurrentHashMap();
        arenaToMatch = new ConcurrentHashMap();
        tournamentSpectators = new ConcurrentHashMap();
        spectatorArenaChoice = new ConcurrentHashMap();
        arenaBossBars = new ConcurrentHashMap();
    }
}

