/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.tournament;

import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.config.Position;
import com.music176.pokemonleague.duel.BestOf;
import com.music176.pokemonleague.tournament.BracketRound;
import com.music176.pokemonleague.tournament.MatchState;
import com.music176.pokemonleague.tournament.RoundFormats;
import com.music176.pokemonleague.tournament.RuntimeRewards;
import com.music176.pokemonleague.tournament.TournamentArena;
import com.music176.pokemonleague.tournament.TournamentBracket;
import com.music176.pokemonleague.tournament.TournamentConfig;
import com.music176.pokemonleague.tournament.TournamentManager;
import com.music176.pokemonleague.tournament.TournamentMatch;
import com.music176.pokemonleague.tournament.TournamentMode;
import com.music176.pokemonleague.tournament.TournamentParticipant;
import com.music176.pokemonleague.tournament.TournamentSession;
import com.music176.pokemonleague.tournament.TournamentState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001:\f&'()*+,-./01B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\bJ\u001d\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\bJ\u001d\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0004\b\u0012\u0010\u000fJ\u0015\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\bJ\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\bJ\u001f\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\bJ\u001f\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010 \u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b \u0010!R \u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00150\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R \u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001a0\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010$\u00a8\u00062"}, d2={"Lcom/music176/pokemonleague/tournament/TournamentGUI;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "", "openPlayerMenu", "(Lnet/minecraft/class_3222;)V", "openBracketMenu", "openAdminMenu", "openPositionConfigMenu", "", "arenaNumber", "openArenaConfigMenu", "(Lnet/minecraft/class_3222;I)V", "openRewardsConfigMenu", "place", "openRewardChestMenu", "openCreationMenu", "openFormatMenu", "Lcom/music176/pokemonleague/tournament/TournamentGUI$TournamentCreationState;", "state", "createTournamentFromState", "(Lnet/minecraft/class_3222;Lcom/music176/pokemonleague/tournament/TournamentGUI$TournamentCreationState;)V", "openManagementMenu", "Lcom/music176/pokemonleague/tournament/TournamentGUI$PositionSetType;", "posType", "setPositionAtPlayer", "(Lnet/minecraft/class_3222;Lcom/music176/pokemonleague/tournament/TournamentGUI$PositionSetType;)V", "Ljava/util/UUID;", "playerId", "clearState", "(Ljava/util/UUID;)V", "Ljava/util/concurrent/ConcurrentHashMap;", "creationStates", "Ljava/util/concurrent/ConcurrentHashMap;", "pendingPositionSets", "TournamentCreationState", "PositionSetType", "PlayerMainContainer", "BracketViewerContainer", "AdminMainContainer", "PositionConfigContainer", "ArenaConfigContainer", "RewardsConfigContainer", "RewardChestContainer", "ModeSelectContainer", "FormatSelectContainer", "ManagementContainer", "pokemon-league-mod"})
public final class TournamentGUI {
    @NotNull
    public static final TournamentGUI INSTANCE = new TournamentGUI();
    @NotNull
    private static final ConcurrentHashMap<UUID, TournamentCreationState> creationStates = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<UUID, PositionSetType> pendingPositionSets = new ConcurrentHashMap();

    private TournamentGUI() {
    }

    public final void openPlayerMenu(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.method_17355(new class_3908(){

            public class_2561 method_5476() {
                class_124[] class_124Array = new class_124[]{class_124.field_1065, class_124.field_1067};
                class_5250 class_52502 = class_2561.method_43470((String)"Tournoi").method_27695(class_124Array);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
                return (class_2561)class_52502;
            }

            public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
                Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return (class_1703)new PlayerMainContainer(containerId, playerInventory, (class_3222)player);
            }
        });
    }

    public final void openBracketMenu(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.method_17355(new class_3908(){

            public class_2561 method_5476() {
                class_5250 class_52502 = class_2561.method_43470((String)"Bracket du Tournoi").method_27692(class_124.field_1065);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
                return (class_2561)class_52502;
            }

            public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
                Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return (class_1703)new BracketViewerContainer(containerId, playerInventory, (class_3222)player);
            }
        });
    }

    public final void openAdminMenu(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.method_17355(new class_3908(){

            public class_2561 method_5476() {
                class_124[] class_124Array = new class_124[]{class_124.field_1065, class_124.field_1067};
                class_5250 class_52502 = class_2561.method_43470((String)"Administration Tournoi").method_27695(class_124Array);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
                return (class_2561)class_52502;
            }

            public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
                Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return (class_1703)new AdminMainContainer(containerId, playerInventory, (class_3222)player);
            }
        });
    }

    public final void openPositionConfigMenu(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.method_17355(new class_3908(){

            public class_2561 method_5476() {
                class_5250 class_52502 = class_2561.method_43470((String)"Configuration des Positions").method_27692(class_124.field_1060);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
                return (class_2561)class_52502;
            }

            public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
                Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return (class_1703)new PositionConfigContainer(containerId, playerInventory, (class_3222)player);
            }
        });
    }

    public final void openArenaConfigMenu(@NotNull class_3222 player, int arenaNumber) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.method_17355(new class_3908(arenaNumber){
            final /* synthetic */ int $arenaNumber;
            {
                this.$arenaNumber = $arenaNumber;
            }

            public class_2561 method_5476() {
                class_5250 class_52502 = class_2561.method_43470((String)("Configuration Arene " + this.$arenaNumber)).method_27692(class_124.field_1061);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
                return (class_2561)class_52502;
            }

            public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
                Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return (class_1703)new ArenaConfigContainer(containerId, playerInventory, (class_3222)player, this.$arenaNumber);
            }
        });
    }

    public final void openRewardsConfigMenu(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.method_17355(new class_3908(){

            public class_2561 method_5476() {
                class_5250 class_52502 = class_2561.method_43470((String)"Configuration des Recompenses").method_27692(class_124.field_1065);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
                return (class_2561)class_52502;
            }

            public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
                Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return (class_1703)new RewardsConfigContainer(containerId, playerInventory, (class_3222)player);
            }
        });
    }

    public final void openRewardChestMenu(@NotNull class_3222 player, int place) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object placeText = switch (place) {
            case 1 -> "1ere";
            case 2 -> "2eme";
            case 3 -> "3eme";
            default -> place + "eme";
        };
        player.method_17355(new class_3908((String)placeText, place){
            final /* synthetic */ String $placeText;
            final /* synthetic */ int $place;
            {
                this.$placeText = $placeText;
                this.$place = $place;
            }

            public class_2561 method_5476() {
                class_5250 class_52502 = class_2561.method_43470((String)("Recompenses " + this.$placeText + " Place")).method_27692(class_124.field_1065);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
                return (class_2561)class_52502;
            }

            public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
                Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return (class_1703)new RewardChestContainer(containerId, playerInventory, (class_3222)player, this.$place);
            }
        });
    }

    public final void openCreationMenu(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ((Map)creationStates).put(player.method_5667(), new TournamentCreationState(null, null, null, 0, 15, null));
        player.method_17355(new class_3908(){

            public class_2561 method_5476() {
                class_124[] class_124Array = new class_124[]{class_124.field_1065, class_124.field_1067};
                class_5250 class_52502 = class_2561.method_43470((String)"Creer un Tournoi").method_27695(class_124Array);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
                return (class_2561)class_52502;
            }

            public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
                Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return (class_1703)new ModeSelectContainer(containerId, playerInventory, (class_3222)player);
            }
        });
    }

    private final void openFormatMenu(class_3222 player) {
        player.method_17355(new class_3908(){

            public class_2561 method_5476() {
                class_5250 class_52502 = class_2561.method_43470((String)"Configuration des Rounds").method_27692(class_124.field_1065);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
                return (class_2561)class_52502;
            }

            public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
                Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return (class_1703)new FormatSelectContainer(containerId, playerInventory, (class_3222)player);
            }
        });
    }

    private final void createTournamentFromState(class_3222 player, TournamentCreationState state) {
        TournamentMode tournamentMode = state.getMode();
        if (tournamentMode == null) {
            return;
        }
        TournamentMode mode = tournamentMode;
        TournamentSession tournament = TournamentManager.createTournament$default(TournamentManager.INSTANCE, player, state.getName(), mode, state.getRoundFormats(), null, state.getMaxParticipants(), 16, null);
        if (tournament != null) {
            TournamentManager.INSTANCE.openRegistration();
        }
        creationStates.remove(player.method_5667());
    }

    public final void openManagementMenu(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.method_17355(new class_3908(){

            public class_2561 method_5476() {
                class_5250 class_52502 = class_2561.method_43470((String)"Gestion du Tournoi").method_27692(class_124.field_1065);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
                return (class_2561)class_52502;
            }

            public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
                Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return (class_1703)new ManagementContainer(containerId, playerInventory, (class_3222)player);
            }
        });
    }

    private final void setPositionAtPlayer(class_3222 player, PositionSetType posType) {
        String string = player.method_37908().method_27983().method_29177().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Position position = new Position(string, player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        TournamentConfig config = TournamentManager.INSTANCE.getConfig();
        switch (WhenMappings.$EnumSwitchMapping$0[posType.ordinal()]) {
            case 1: {
                config.getArenas().get(0).setPlayer1Position(position);
                break;
            }
            case 2: {
                config.getArenas().get(0).setPlayer2Position(position);
                break;
            }
            case 3: {
                config.getArenas().get(1).setPlayer1Position(position);
                break;
            }
            case 4: {
                config.getArenas().get(1).setPlayer2Position(position);
                break;
            }
            case 5: {
                config.getArenas().get(2).setPlayer1Position(position);
                break;
            }
            case 6: {
                config.getArenas().get(2).setPlayer2Position(position);
                break;
            }
            case 7: {
                config.getArenas().get(3).setPlayer1Position(position);
                break;
            }
            case 8: {
                config.getArenas().get(3).setPlayer2Position(position);
                break;
            }
            case 9: {
                config.setWaitingRoomPosition(position);
                break;
            }
            case 10: {
                config.setSpectatorAreaPosition(position);
                break;
            }
            case 11: {
                config.setEndZonePosition(position);
                break;
            }
            case 12: {
                config.setPodiumFirst(position);
                break;
            }
            case 13: {
                config.setPodiumSecond(position);
                break;
            }
            case 14: {
                config.setPodiumThird(position);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        TournamentConfig.Companion.save(config);
        String posName = switch (WhenMappings.$EnumSwitchMapping$0[posType.ordinal()]) {
            case 1 -> "Arene 1 - Joueur 1";
            case 2 -> "Arene 1 - Joueur 2";
            case 3 -> "Arene 2 - Joueur 1";
            case 4 -> "Arene 2 - Joueur 2";
            case 5 -> "Arene 3 - Joueur 1";
            case 6 -> "Arene 3 - Joueur 2";
            case 7 -> "Arene 4 - Joueur 1";
            case 8 -> "Arene 4 - Joueur 2";
            case 9 -> "Salle d'attente";
            case 10 -> "Zone spectateur";
            case 11 -> "Zone de fin";
            case 12 -> "Podium 1ere place";
            case 13 -> "Podium 2eme place";
            case 14 -> "Podium 3eme place";
            default -> throw new NoWhenBranchMatchedException();
        };
        player.method_43496((class_2561)class_2561.method_43470((String)("Position '" + posName + "' definie!")).method_27694(TournamentGUI::setPositionAtPlayer$lambda$0));
    }

    public final void clearState(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        creationStates.remove(playerId);
        pendingPositionSets.remove(playerId);
    }

    private static final class_2583 setPositionAtPlayer$lambda$0(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/music176/pokemonleague/tournament/TournamentGUI$AdminMainContainer;", "Lnet/minecraft/class_1707;", "", "containerId", "Lnet/minecraft/class_1661;", "playerInventory", "Lnet/minecraft/class_3222;", "serverPlayer", "<init>", "(ILnet/minecraft/class_1661;Lnet/minecraft/class_3222;)V", "", "setupItems", "()V", "slotId", "button", "Lnet/minecraft/class_1713;", "clickType", "Lnet/minecraft/class_1657;", "player", "clicked", "(IILnet/minecraft/class_1713;Lnet/minecraft/class_1657;)V", "index", "Lnet/minecraft/class_1799;", "quickMoveStack", "(Lnet/minecraft/class_1657;I)Lnet/minecraft/class_1799;", "Lnet/minecraft/class_3222;", "pokemon-league-mod"})
    @SourceDebugExtension(value={"SMAP\nTournamentGUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TournamentGUI.kt\ncom/music176/pokemonleague/tournament/TournamentGUI$AdminMainContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1805:1\n1788#2,4:1806\n*S KotlinDebug\n*F\n+ 1 TournamentGUI.kt\ncom/music176/pokemonleague/tournament/TournamentGUI$AdminMainContainer\n*L\n489#1:1806,4\n*E\n"})
    public static final class AdminMainContainer
    extends class_1707 {
        @NotNull
        private final class_3222 serverPlayer;

        public AdminMainContainer(int containerId, @NotNull class_1661 playerInventory, @NotNull class_3222 serverPlayer) {
            Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
            Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
            super(class_3917.field_18666, containerId, playerInventory, (class_1263)new class_1277(36), 4);
            this.serverPlayer = serverPlayer;
            this.setupItems();
        }

        private final void setupItems() {
            int n;
            class_1263 container = this.method_7629();
            TournamentSession tournament = TournamentManager.INSTANCE.getActiveTournament();
            TournamentConfig config = TournamentManager.INSTANCE.getConfig();
            class_1799 filler = new class_1799((class_1935)class_1802.field_8871);
            filler.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)" "));
            for (int i = 0; i < 36; ++i) {
                container.method_5447(i, filler.method_7972());
            }
            class_1799 createButton = new class_1799((class_1935)class_1802.field_8477);
            Object[] objectArray = new class_124[]{class_124.field_1075, class_124.field_1067};
            createButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Creer un Tournoi").method_27695((class_124[])objectArray));
            objectArray = new class_5250[]{class_2561.method_43470((String)"Ouvre le menu de creation").method_27692(class_124.field_1080), class_2561.method_43473(), tournament != null ? class_2561.method_43470((String)"Un tournoi est deja en cours!").method_27692(class_124.field_1061) : class_2561.method_43470((String)"Cliquez pour creer").method_27692(class_124.field_1054)};
            createButton.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray)));
            container.method_5447(10, createButton);
            class_1799 manageButton = new class_1799((class_1935)class_1802.field_8251);
            Object[] objectArray2 = new class_124[]{class_124.field_1054, class_124.field_1067};
            manageButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Gerer le Tournoi").method_27695((class_124[])objectArray2));
            if (tournament != null) {
                objectArray2 = new class_5250[]{class_2561.method_43470((String)("Tournoi: " + tournament.getName())).method_27692(class_124.field_1068), class_2561.method_43470((String)("Statut: " + tournament.getStatusString())).method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour gerer").method_27692(class_124.field_1054)};
                v0 = (class_9290)manageButton.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray2)));
            } else {
                v0 = (class_9290)manageButton.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object)class_2561.method_43470((String)"Aucun tournoi en cours").method_27692(class_124.field_1080))));
            }
            container.method_5447(12, manageButton);
            class_1799 configButton = new class_1799((class_1935)class_1802.field_8238);
            class_124[] class_124Array = new class_124[]{class_124.field_1060, class_124.field_1067};
            configButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Configurer les Positions").method_27695(class_124Array));
            Iterable $this$count$iv = config.getArenas();
            boolean $i$f$count22 = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    TournamentArena it = (TournamentArena)element$iv;
                    boolean bl = false;
                    if (!it.isConfigured() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int configuredCount = n;
            boolean allConfigured = config.isFullyConfigured();
            Object[] $i$f$count22 = new class_5250[]{class_2561.method_43470((String)("Arenes: " + configuredCount + "/4 configurees")).method_27692(configuredCount == 4 ? class_124.field_1060 : class_124.field_1054), class_2561.method_43470((String)("Statut: " + (allConfigured ? "COMPLET" : "INCOMPLET"))).method_27692(allConfigured ? class_124.field_1060 : class_124.field_1061), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour configurer").method_27692(class_124.field_1054)};
            configButton.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])$i$f$count22)));
            container.method_5447(14, configButton);
            class_1799 rewardsButton = new class_1799((class_1935)class_1802.field_8106);
            Object[] count$iv = new class_124[]{class_124.field_1065, class_124.field_1067};
            rewardsButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Configurer les Recompenses").method_27695((class_124[])count$iv));
            count$iv = new class_5250[]{class_2561.method_43470((String)"Definir les recompenses").method_27692(class_124.field_1080), class_2561.method_43470((String)"pour les 3 premiers").method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour configurer").method_27692(class_124.field_1054)};
            rewardsButton.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])count$iv)));
            container.method_5447(16, rewardsButton);
            class_1799 reloadButton = new class_1799((class_1935)class_1802.field_8619);
            reloadButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Recharger la Config").method_27692(class_124.field_1080));
            container.method_5447(31, reloadButton);
            class_1799 closeButton = new class_1799((class_1935)class_1802.field_8077);
            closeButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Fermer").method_27692(class_124.field_1061));
            container.method_5447(35, closeButton);
        }

        public void method_7593(int slotId, int button, @NotNull class_1713 clickType, @NotNull class_1657 player) {
            Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (slotId < 0 || slotId >= 36) {
                super.method_7593(slotId, button, clickType, player);
                return;
            }
            switch (slotId) {
                case 10: {
                    if (TournamentManager.INSTANCE.getActiveTournament() == null) {
                        this.serverPlayer.method_7346();
                        INSTANCE.openCreationMenu(this.serverPlayer);
                        break;
                    }
                    this.serverPlayer.method_43496((class_2561)class_2561.method_43470((String)"Un tournoi est deja en cours!").method_27694(AdminMainContainer::clicked$lambda$0));
                    break;
                }
                case 12: {
                    if (TournamentManager.INSTANCE.getActiveTournament() == null) break;
                    this.serverPlayer.method_7346();
                    INSTANCE.openManagementMenu(this.serverPlayer);
                    break;
                }
                case 14: {
                    this.serverPlayer.method_7346();
                    INSTANCE.openPositionConfigMenu(this.serverPlayer);
                    break;
                }
                case 16: {
                    this.serverPlayer.method_7346();
                    INSTANCE.openRewardsConfigMenu(this.serverPlayer);
                    break;
                }
                case 31: {
                    TournamentManager.INSTANCE.reloadConfig();
                    this.serverPlayer.method_43496((class_2561)class_2561.method_43470((String)"Configuration rechargee!").method_27694(AdminMainContainer::clicked$lambda$1));
                    this.setupItems();
                    break;
                }
                case 35: {
                    this.serverPlayer.method_7346();
                }
            }
        }

        @NotNull
        public class_1799 method_7601(@NotNull class_1657 player, int index) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            class_1799 class_17992 = class_1799.field_8037;
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
            return class_17992;
        }

        private static final class_2583 clicked$lambda$0(class_2583 it) {
            return it.method_36139(0xFF5555);
        }

        private static final class_2583 clicked$lambda$1(class_2583 it) {
            return it.method_36139(0x55FF55);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ/\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001aR\u0014\u0010\b\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/music176/pokemonleague/tournament/TournamentGUI$ArenaConfigContainer;", "Lnet/minecraft/class_1707;", "", "containerId", "Lnet/minecraft/class_1661;", "playerInventory", "Lnet/minecraft/class_3222;", "serverPlayer", "arenaNumber", "<init>", "(ILnet/minecraft/class_1661;Lnet/minecraft/class_3222;I)V", "", "setupItems", "()V", "slotId", "button", "Lnet/minecraft/class_1713;", "clickType", "Lnet/minecraft/class_1657;", "player", "clicked", "(IILnet/minecraft/class_1713;Lnet/minecraft/class_1657;)V", "index", "Lnet/minecraft/class_1799;", "quickMoveStack", "(Lnet/minecraft/class_1657;I)Lnet/minecraft/class_1799;", "Lnet/minecraft/class_3222;", "I", "pokemon-league-mod"})
    public static final class ArenaConfigContainer
    extends class_1707 {
        @NotNull
        private final class_3222 serverPlayer;
        private final int arenaNumber;

        public ArenaConfigContainer(int containerId, @NotNull class_1661 playerInventory, @NotNull class_3222 serverPlayer, int arenaNumber) {
            Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
            Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
            super(class_3917.field_17326, containerId, playerInventory, (class_1263)new class_1277(27), 3);
            this.serverPlayer = serverPlayer;
            this.arenaNumber = arenaNumber;
            this.setupItems();
        }

        private final void setupItems() {
            class_1263 container = this.method_7629();
            TournamentArena tournamentArena = TournamentManager.INSTANCE.getConfig().getArenaByNumber(this.arenaNumber);
            if (tournamentArena == null) {
                return;
            }
            TournamentArena arena = tournamentArena;
            class_1799 filler = new class_1799((class_1935)class_1802.field_8871);
            filler.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)" "));
            for (int i = 0; i < 27; ++i) {
                container.method_5447(i, filler.method_7972());
            }
            class_1799 infoItem = new class_1799((class_1935)class_1802.field_22022);
            class_124[] class_124Array = new class_124[]{class_124.field_1061, class_124.field_1067};
            infoItem.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)("Arene " + this.arenaNumber)).method_27695(class_124Array));
            infoItem.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object)class_2561.method_43470((String)("Statut: " + (arena.isConfigured() ? "PRET" : "INCOMPLET"))).method_27692(arena.isConfigured() ? class_124.field_1060 : class_124.field_1061))));
            container.method_5447(4, infoItem);
            boolean p1Ok = !(arena.getPlayer1Spawn().getX() == 0.0);
            class_1799 p1Item = p1Ok ? new class_1799((class_1935)class_1802.field_8839) : new class_1799((class_1935)class_1802.field_8197);
            Object[] objectArray = new class_124[]{class_124.field_1078, class_124.field_1067};
            p1Item.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Position Joueur 1").method_27695((class_124[])objectArray));
            objectArray = new class_5250[]{p1Ok ? class_2561.method_43470((String)("X: " + (int)arena.getPlayer1Spawn().getX() + ", Y: " + (int)arena.getPlayer1Spawn().getY() + ", Z: " + (int)arena.getPlayer1Spawn().getZ())).method_27692(class_124.field_1080) : class_2561.method_43470((String)"Non definie").method_27692(class_124.field_1061), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour definir a votre position").method_27692(class_124.field_1054)};
            p1Item.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray)));
            container.method_5447(11, p1Item);
            boolean p2Ok = !(arena.getPlayer2Spawn().getX() == 0.0);
            class_1799 p2Item = p2Ok ? new class_1799((class_1935)class_1802.field_8839) : new class_1799((class_1935)class_1802.field_8197);
            Object[] objectArray2 = new class_124[]{class_124.field_1061, class_124.field_1067};
            p2Item.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Position Joueur 2").method_27695((class_124[])objectArray2));
            objectArray2 = new class_5250[]{p2Ok ? class_2561.method_43470((String)("X: " + (int)arena.getPlayer2Spawn().getX() + ", Y: " + (int)arena.getPlayer2Spawn().getY() + ", Z: " + (int)arena.getPlayer2Spawn().getZ())).method_27692(class_124.field_1080) : class_2561.method_43470((String)"Non definie").method_27692(class_124.field_1061), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour definir a votre position").method_27692(class_124.field_1054)};
            p2Item.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray2)));
            container.method_5447(15, p2Item);
            class_1799 backButton = new class_1799((class_1935)class_1802.field_8107);
            backButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Retour").method_27692(class_124.field_1080));
            container.method_5447(18, backButton);
            class_1799 closeButton = new class_1799((class_1935)class_1802.field_8077);
            closeButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Fermer").method_27692(class_124.field_1061));
            container.method_5447(26, closeButton);
        }

        public void method_7593(int slotId, int button, @NotNull class_1713 clickType, @NotNull class_1657 player) {
            Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (slotId < 0 || slotId >= 27) {
                super.method_7593(slotId, button, clickType, player);
                return;
            }
            switch (slotId) {
                case 11: {
                    PositionSetType positionSetType;
                    switch (this.arenaNumber) {
                        case 1: {
                            positionSetType = PositionSetType.ARENA_1_PLAYER1;
                            break;
                        }
                        case 2: {
                            positionSetType = PositionSetType.ARENA_2_PLAYER1;
                            break;
                        }
                        case 3: {
                            positionSetType = PositionSetType.ARENA_3_PLAYER1;
                            break;
                        }
                        case 4: {
                            positionSetType = PositionSetType.ARENA_4_PLAYER1;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    PositionSetType posType = positionSetType;
                    INSTANCE.setPositionAtPlayer(this.serverPlayer, posType);
                    this.setupItems();
                    break;
                }
                case 15: {
                    PositionSetType positionSetType;
                    switch (this.arenaNumber) {
                        case 1: {
                            positionSetType = PositionSetType.ARENA_1_PLAYER2;
                            break;
                        }
                        case 2: {
                            positionSetType = PositionSetType.ARENA_2_PLAYER2;
                            break;
                        }
                        case 3: {
                            positionSetType = PositionSetType.ARENA_3_PLAYER2;
                            break;
                        }
                        case 4: {
                            positionSetType = PositionSetType.ARENA_4_PLAYER2;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    PositionSetType posType = positionSetType;
                    INSTANCE.setPositionAtPlayer(this.serverPlayer, posType);
                    this.setupItems();
                    break;
                }
                case 18: {
                    this.serverPlayer.method_7346();
                    INSTANCE.openPositionConfigMenu(this.serverPlayer);
                    break;
                }
                case 26: {
                    this.serverPlayer.method_7346();
                }
            }
        }

        @NotNull
        public class_1799 method_7601(@NotNull class_1657 player, int index) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            class_1799 class_17992 = class_1799.field_8037;
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
            return class_17992;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J/\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/music176/pokemonleague/tournament/TournamentGUI$BracketViewerContainer;", "Lnet/minecraft/class_1707;", "", "containerId", "Lnet/minecraft/class_1661;", "playerInventory", "Lnet/minecraft/class_3222;", "serverPlayer", "<init>", "(ILnet/minecraft/class_1661;Lnet/minecraft/class_3222;)V", "", "setupItems", "()V", "Lcom/music176/pokemonleague/tournament/TournamentMatch;", "match", "", "label", "Lnet/minecraft/class_1799;", "createMatchItem", "(Lcom/music176/pokemonleague/tournament/TournamentMatch;Ljava/lang/String;)Lnet/minecraft/class_1799;", "slotId", "button", "Lnet/minecraft/class_1713;", "clickType", "Lnet/minecraft/class_1657;", "player", "clicked", "(IILnet/minecraft/class_1713;Lnet/minecraft/class_1657;)V", "index", "quickMoveStack", "(Lnet/minecraft/class_1657;I)Lnet/minecraft/class_1799;", "Lnet/minecraft/class_3222;", "pokemon-league-mod"})
    @SourceDebugExtension(value={"SMAP\nTournamentGUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TournamentGUI.kt\ncom/music176/pokemonleague/tournament/TournamentGUI$BracketViewerContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1805:1\n1878#2,2:1806\n1878#2,3:1808\n1880#2:1811\n1878#2,2:1812\n1878#2,3:1814\n1880#2:1817\n*S KotlinDebug\n*F\n+ 1 TournamentGUI.kt\ncom/music176/pokemonleague/tournament/TournamentGUI$BracketViewerContainer\n*L\n324#1:1806,2\n325#1:1808,3\n324#1:1811\n343#1:1812,2\n344#1:1814,3\n343#1:1817\n*E\n"})
    public static final class BracketViewerContainer
    extends class_1707 {
        @NotNull
        private final class_3222 serverPlayer;

        public BracketViewerContainer(int containerId, @NotNull class_1661 playerInventory, @NotNull class_3222 serverPlayer) {
            Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
            Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
            super(class_3917.field_17327, containerId, playerInventory, (class_1263)new class_1277(54), 6);
            this.serverPlayer = serverPlayer;
            this.setupItems();
        }

        /*
         * WARNING - void declaration
         */
        private final void setupItems() {
            TournamentSession tournament;
            class_1263 container = this.method_7629();
            TournamentSession tournamentSession = tournament = TournamentManager.INSTANCE.getActiveTournament();
            TournamentBracket bracket = tournamentSession != null ? tournamentSession.getBracket() : null;
            class_1799 filler = new class_1799((class_1935)class_1802.field_8871);
            filler.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)" "));
            for (int i = 0; i < 54; ++i) {
                container.method_5447(i, filler.method_7972());
            }
            if (bracket == null) {
                class_1799 noBracket = new class_1799((class_1935)class_1802.field_8077);
                noBracket.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Bracket non genere").method_27692(class_124.field_1061));
                container.method_5447(22, noBracket);
                class_1799 backButton = new class_1799((class_1935)class_1802.field_8107);
                backButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Retour").method_27692(class_124.field_1080));
                container.method_5447(49, backButton);
                return;
            }
            class_1799 winnerHeader = new class_1799((class_1935)class_1802.field_8733);
            class_124[] backButton = new class_124[]{class_124.field_1060, class_124.field_1067};
            winnerHeader.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Winner Bracket").method_27695(backButton));
            container.method_5447(2, winnerHeader);
            int slot = 0;
            slot = 9;
            Iterable $this$forEachIndexed$iv = CollectionsKt.take((Iterable)bracket.getWinnerBracket(), (int)4);
            boolean $i$f$forEachIndexed22 = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void round;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                BracketRound bracketRound = (BracketRound)item$iv;
                int roundIndex = n;
                boolean bl = false;
                Iterable $this$forEachIndexed$iv2 = CollectionsKt.take((Iterable)round.getMatches(), (int)4);
                boolean $i$f$forEachIndexed = false;
                int index$iv2 = 0;
                for (Object item$iv2 : $this$forEachIndexed$iv2) {
                    void match;
                    int n2;
                    if ((n2 = index$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    TournamentMatch tournamentMatch = (TournamentMatch)item$iv2;
                    int matchIndex = n2;
                    boolean bl2 = false;
                    class_1799 matchItem = this.createMatchItem((TournamentMatch)match, "W" + (roundIndex + 1) + "-M" + (matchIndex + 1));
                    if (slot >= 27) continue;
                    container.method_5447(slot, matchItem);
                    ++slot;
                }
                slot = (slot / 9 + 1) * 9;
            }
            class_1799 loserHeader = new class_1799((class_1935)class_1802.field_8793);
            class_124[] $i$f$forEachIndexed22 = new class_124[]{class_124.field_1061, class_124.field_1067};
            loserHeader.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Loser Bracket").method_27695($i$f$forEachIndexed22));
            container.method_5447(6, loserHeader);
            slot = 32;
            Iterable $this$forEachIndexed$iv3 = CollectionsKt.take((Iterable)bracket.getLoserBracket(), (int)3);
            boolean $i$f$forEachIndexed = false;
            int index$iv3 = 0;
            for (Object item$iv : $this$forEachIndexed$iv3) {
                void round;
                int n;
                if ((n = index$iv3++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                BracketRound roundIndex = (BracketRound)item$iv;
                int roundIndex2 = n;
                boolean bl = false;
                Iterable $this$forEachIndexed$iv4 = CollectionsKt.take((Iterable)round.getMatches(), (int)3);
                boolean $i$f$forEachIndexed3 = false;
                int index$iv4 = 0;
                for (Object item$iv3 : $this$forEachIndexed$iv4) {
                    void match;
                    int n3;
                    if ((n3 = index$iv4++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    TournamentMatch matchIndex = (TournamentMatch)item$iv3;
                    int matchIndex2 = n3;
                    boolean bl3 = false;
                    class_1799 matchItem = this.createMatchItem((TournamentMatch)match, "L" + (roundIndex2 + 1) + "-M" + (matchIndex2 + 1));
                    if (slot >= 45) continue;
                    container.method_5447(slot, matchItem);
                    ++slot;
                }
            }
            TournamentMatch tournamentMatch = bracket.getGrandFinal();
            if (tournamentMatch != null) {
                TournamentMatch gf = tournamentMatch;
                boolean bl = false;
                class_1799 gfItem = this.createMatchItem(gf, "Grand Final");
                class_124[] class_124Array = new class_124[]{class_124.field_1065, class_124.field_1067};
                gfItem.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"GRAND FINAL").method_27695(class_124Array));
                container.method_5447(40, gfItem);
            }
            class_1799 backButton2 = new class_1799((class_1935)class_1802.field_8107);
            backButton2.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Retour").method_27692(class_124.field_1080));
            container.method_5447(49, backButton2);
        }

        private final class_1799 createMatchItem(TournamentMatch match, String label) {
            Object object;
            Object p1;
            Object object2;
            class_1799 item;
            switch (WhenMappings.$EnumSwitchMapping$0[match.getState().ordinal()]) {
                case 1: {
                    class_1799 class_17992 = new class_1799((class_1935)class_1802.field_8581);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    class_1799 class_17992 = new class_1799((class_1935)class_1802.field_8703);
                    break;
                }
                default: {
                    class_1799 class_17992 = item = new class_1799((class_1935)class_1802.field_8736);
                }
            }
            if ((object2 = match.getParticipant1()) == null || (object2 = ((TournamentParticipant)object2).getDisplayName()) == null) {
                object2 = p1 = "TBD";
            }
            if ((object = match.getParticipant2()) == null || (object = ((TournamentParticipant)object).getDisplayName()) == null) {
                object = "TBD";
            }
            Object p2 = object;
            String status = switch (WhenMappings.$EnumSwitchMapping$0[match.getState().ordinal()]) {
                case 1 -> "Termine";
                case 2 -> "En cours!";
                case 3 -> "Compte a rebours";
                case 4 -> "En attente";
                default -> "A venir";
            };
            item.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)label).method_27692(class_124.field_1068));
            Object[] objectArray = new class_2561[3];
            Intrinsics.checkNotNullExpressionValue((Object)class_2561.method_43470((String)((String)p1 + " vs " + (String)p2)).method_27692(class_124.field_1080), (String)"withStyle(...)");
            Intrinsics.checkNotNullExpressionValue((Object)class_2561.method_43470((String)("Score: " + match.getParticipant1Wins() + " - " + match.getParticipant2Wins())).method_27692(class_124.field_1075), (String)"withStyle(...)");
            Intrinsics.checkNotNullExpressionValue((Object)class_2561.method_43470((String)("Statut: " + status)).method_27692(class_124.field_1054), (String)"withStyle(...)");
            List lore = CollectionsKt.mutableListOf((Object[])objectArray);
            TournamentParticipant tournamentParticipant = match.getWinner();
            if (tournamentParticipant != null) {
                TournamentParticipant it = tournamentParticipant;
                boolean bl = false;
                class_5250 class_52502 = class_2561.method_43470((String)("Gagnant: " + it.getDisplayName())).method_27692(class_124.field_1060);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
                lore.add(class_52502);
            }
            item.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
            return item;
        }

        public void method_7593(int slotId, int button, @NotNull class_1713 clickType, @NotNull class_1657 player) {
            Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (slotId == 49) {
                this.serverPlayer.method_7346();
                INSTANCE.openPlayerMenu(this.serverPlayer);
            }
        }

        @NotNull
        public class_1799 method_7601(@NotNull class_1657 player, int index) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            class_1799 class_17992 = class_1799.field_8037;
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
            return class_17992;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[MatchState.values().length];
                try {
                    nArray[MatchState.COMPLETED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MatchState.IN_BATTLE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MatchState.COUNTDOWN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MatchState.WAITING_PLAYERS.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/music176/pokemonleague/tournament/TournamentGUI$FormatSelectContainer;", "Lnet/minecraft/class_1707;", "", "containerId", "Lnet/minecraft/class_1661;", "playerInventory", "Lnet/minecraft/class_3222;", "serverPlayer", "<init>", "(ILnet/minecraft/class_1661;Lnet/minecraft/class_3222;)V", "", "setupItems", "()V", "slotId", "button", "Lnet/minecraft/class_1713;", "clickType", "Lnet/minecraft/class_1657;", "player", "clicked", "(IILnet/minecraft/class_1713;Lnet/minecraft/class_1657;)V", "Lcom/music176/pokemonleague/duel/BestOf;", "current", "cycleFormat", "(Lcom/music176/pokemonleague/duel/BestOf;)Lcom/music176/pokemonleague/duel/BestOf;", "index", "Lnet/minecraft/class_1799;", "quickMoveStack", "(Lnet/minecraft/class_1657;I)Lnet/minecraft/class_1799;", "Lnet/minecraft/class_3222;", "Lcom/music176/pokemonleague/tournament/TournamentGUI$TournamentCreationState;", "state", "Lcom/music176/pokemonleague/tournament/TournamentGUI$TournamentCreationState;", "pokemon-league-mod"})
    public static final class FormatSelectContainer
    extends class_1707 {
        @NotNull
        private final class_3222 serverPlayer;
        @NotNull
        private final TournamentCreationState state;

        public FormatSelectContainer(int containerId, @NotNull class_1661 playerInventory, @NotNull class_3222 serverPlayer) {
            Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
            Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
            super(class_3917.field_18666, containerId, playerInventory, (class_1263)new class_1277(36), 4);
            this.serverPlayer = serverPlayer;
            TournamentCreationState tournamentCreationState = (TournamentCreationState)creationStates.get(this.serverPlayer.method_5667());
            if (tournamentCreationState == null) {
                tournamentCreationState = new TournamentCreationState(null, null, null, 0, 15, null);
            }
            this.state = tournamentCreationState;
            this.setupItems();
        }

        private final void setupItems() {
            class_1263 container = this.method_7629();
            class_1799 filler = new class_1799((class_1935)class_1802.field_8871);
            filler.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)" "));
            for (int i = 0; i < 36; ++i) {
                container.method_5447(i, filler.method_7972());
            }
            class_1799 winnerFormat = new class_1799((class_1935)class_1802.field_8687);
            Object[] objectArray = new class_124[]{class_124.field_1060, class_124.field_1067};
            winnerFormat.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)("Winner Bracket: " + this.state.getRoundFormats().getWinnerFormat(1).getDisplayName())).method_27695((class_124[])objectArray));
            objectArray = new class_5250[]{class_2561.method_43470((String)"Format pour le winner bracket").method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour changer").method_27692(class_124.field_1054)};
            winnerFormat.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray)));
            container.method_5447(11, winnerFormat);
            class_1799 loserFormat = new class_1799((class_1935)class_1802.field_8725);
            Object[] objectArray2 = new class_124[]{class_124.field_1061, class_124.field_1067};
            loserFormat.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)("Loser Bracket: " + this.state.getRoundFormats().getLoserFormat(1).getDisplayName())).method_27695((class_124[])objectArray2));
            objectArray2 = new class_5250[]{class_2561.method_43470((String)"Format pour le loser bracket").method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour changer").method_27692(class_124.field_1054)};
            loserFormat.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray2)));
            container.method_5447(13, loserFormat);
            class_1799 grandFinalFormat = new class_1799((class_1935)class_1802.field_8137);
            Object[] objectArray3 = new class_124[]{class_124.field_1065, class_124.field_1067};
            grandFinalFormat.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)("Grand Final: " + this.state.getRoundFormats().getGrandFinal().getDisplayName())).method_27695((class_124[])objectArray3));
            objectArray3 = new class_5250[]{class_2561.method_43470((String)"Format pour la grande finale").method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour changer").method_27692(class_124.field_1054)};
            grandFinalFormat.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray3)));
            container.method_5447(15, grandFinalFormat);
            class_1799 maxPlayers = new class_1799((class_1935)class_1802.field_8575);
            maxPlayers.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)("Max Participants: " + this.state.getMaxParticipants())).method_27692(class_124.field_1075));
            Object[] objectArray4 = new class_5250[]{class_2561.method_43470((String)"Nombre maximum de participants").method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43470((String)"Clic gauche: +8 | Clic droit: -8").method_27692(class_124.field_1054)};
            maxPlayers.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray4)));
            container.method_5447(22, maxPlayers);
            class_1799 backButton = new class_1799((class_1935)class_1802.field_8107);
            backButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Retour").method_27692(class_124.field_1080));
            container.method_5447(27, backButton);
            class_1799 confirmButton = new class_1799((class_1935)class_1802.field_8839);
            Object[] objectArray5 = new class_124[]{class_124.field_1060, class_124.field_1067};
            confirmButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Creer le Tournoi").method_27695((class_124[])objectArray5));
            objectArray5 = new class_5250[4];
            Object object = this.state.getMode();
            if (object == null || (object = object.getDisplayName()) == null) {
                object = "?";
            }
            objectArray5[0] = class_2561.method_43470((String)("Mode: " + (String)object)).method_27692(class_124.field_1068);
            objectArray5[1] = class_2561.method_43470((String)("Max: " + this.state.getMaxParticipants() + " joueurs")).method_27692(class_124.field_1068);
            objectArray5[2] = class_2561.method_43473();
            objectArray5[3] = class_2561.method_43470((String)"Cliquez pour creer!").method_27692(class_124.field_1054);
            confirmButton.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray5)));
            container.method_5447(35, confirmButton);
        }

        public void method_7593(int slotId, int button, @NotNull class_1713 clickType, @NotNull class_1657 player) {
            Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (slotId < 0 || slotId >= 36) {
                super.method_7593(slotId, button, clickType, player);
                return;
            }
            switch (slotId) {
                case 11: {
                    BestOf current = this.state.getRoundFormats().getWinnerFormat(1);
                    BestOf next = this.cycleFormat(current);
                    for (int i = 1; i < 6; ++i) {
                        this.state.getRoundFormats().getWinnerBracket().put(i, next);
                    }
                    this.setupItems();
                    break;
                }
                case 13: {
                    BestOf current = this.state.getRoundFormats().getLoserFormat(1);
                    BestOf next = this.cycleFormat(current);
                    for (int i = 1; i < 11; ++i) {
                        this.state.getRoundFormats().getLoserBracket().put(i, next);
                    }
                    this.setupItems();
                    break;
                }
                case 15: {
                    this.state.getRoundFormats().setGrandFinal(this.cycleFormat(this.state.getRoundFormats().getGrandFinal()));
                    this.setupItems();
                    break;
                }
                case 22: {
                    if (button == 0) {
                        this.state.setMaxParticipants(Math.min(64, this.state.getMaxParticipants() + 8));
                    } else {
                        this.state.setMaxParticipants(Math.max(8, this.state.getMaxParticipants() - 8));
                    }
                    this.setupItems();
                    break;
                }
                case 27: {
                    this.serverPlayer.method_7346();
                    INSTANCE.openCreationMenu(this.serverPlayer);
                    break;
                }
                case 35: {
                    this.serverPlayer.method_7346();
                    INSTANCE.createTournamentFromState(this.serverPlayer, this.state);
                }
            }
        }

        private final BestOf cycleFormat(BestOf current) {
            return switch (WhenMappings.$EnumSwitchMapping$0[current.ordinal()]) {
                case 1 -> BestOf.BO3;
                case 2 -> BestOf.BO5;
                case 3 -> BestOf.BO1;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public class_1799 method_7601(@NotNull class_1657 player, int index) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            class_1799 class_17992 = class_1799.field_8037;
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
            return class_17992;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[BestOf.values().length];
                try {
                    nArray[BestOf.BO1.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BestOf.BO3.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BestOf.BO5.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/music176/pokemonleague/tournament/TournamentGUI$ManagementContainer;", "Lnet/minecraft/class_1707;", "", "containerId", "Lnet/minecraft/class_1661;", "playerInventory", "Lnet/minecraft/class_3222;", "serverPlayer", "<init>", "(ILnet/minecraft/class_1661;Lnet/minecraft/class_3222;)V", "", "setupItems", "()V", "slotId", "button", "Lnet/minecraft/class_1713;", "clickType", "Lnet/minecraft/class_1657;", "player", "clicked", "(IILnet/minecraft/class_1713;Lnet/minecraft/class_1657;)V", "index", "Lnet/minecraft/class_1799;", "quickMoveStack", "(Lnet/minecraft/class_1657;I)Lnet/minecraft/class_1799;", "Lnet/minecraft/class_3222;", "pokemon-league-mod"})
    public static final class ManagementContainer
    extends class_1707 {
        @NotNull
        private final class_3222 serverPlayer;

        public ManagementContainer(int containerId, @NotNull class_1661 playerInventory, @NotNull class_3222 serverPlayer) {
            Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
            Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
            super(class_3917.field_18666, containerId, playerInventory, (class_1263)new class_1277(36), 4);
            this.serverPlayer = serverPlayer;
            this.setupItems();
        }

        private final void setupItems() {
            class_1263 container = this.method_7629();
            TournamentSession tournament = TournamentManager.INSTANCE.getActiveTournament();
            class_1799 filler = new class_1799((class_1935)class_1802.field_8871);
            filler.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)" "));
            for (int i = 0; i < 36; ++i) {
                container.method_5447(i, filler.method_7972());
            }
            if (tournament == null) {
                class_1799 noTournament = new class_1799((class_1935)class_1802.field_8077);
                noTournament.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Aucun tournoi en cours").method_27692(class_124.field_1061));
                container.method_5447(13, noTournament);
                class_1799 backButton = new class_1799((class_1935)class_1802.field_8107);
                backButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Retour").method_27692(class_124.field_1080));
                container.method_5447(27, backButton);
                return;
            }
            class_1799 info = new class_1799((class_1935)class_1802.field_8529);
            Object[] backButton = new class_124[]{class_124.field_1065, class_124.field_1067};
            info.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)tournament.getName()).method_27695((class_124[])backButton));
            backButton = new class_5250[]{class_2561.method_43470((String)("Mode: " + tournament.getMode().getDisplayName())).method_27692(class_124.field_1068), class_2561.method_43470((String)("Statut: " + tournament.getStatusString())).method_27692(class_124.field_1080), class_2561.method_43470((String)("Participants: " + tournament.getParticipantCount() + "/" + tournament.getMaxParticipants())).method_27692(class_124.field_1075)};
            info.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])backButton)));
            container.method_5447(4, info);
            if (tournament.getState() == TournamentState.REGISTRATION) {
                class_1799 startButton = new class_1799((class_1935)class_1802.field_8839);
                Object[] objectArray = new class_124[]{class_124.field_1060, class_124.field_1067};
                startButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Demarrer le Tournoi").method_27695((class_124[])objectArray));
                objectArray = new class_5250[]{class_2561.method_43470((String)(tournament.getParticipantCount() + " participants inscrits")).method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour demarrer").method_27692(class_124.field_1054)};
                startButton.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray)));
                container.method_5447(10, startButton);
            }
            class_1799 bracketButton = new class_1799((class_1935)class_1802.field_8204);
            bracketButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Voir le Bracket").method_27692(class_124.field_1075));
            container.method_5447(12, bracketButton);
            class_1799 rewardsButton = new class_1799((class_1935)class_1802.field_8106);
            rewardsButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Configurer Recompenses").method_27692(class_124.field_1065));
            container.method_5447(14, rewardsButton);
            class_1799 cancelButton = new class_1799((class_1935)class_1802.field_8197);
            class_124[] class_124Array = new class_124[]{class_124.field_1061, class_124.field_1067};
            cancelButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Annuler le Tournoi").method_27695(class_124Array));
            container.method_5447(16, cancelButton);
            if (tournament.getState() == TournamentState.IN_PROGRESS) {
                class_1799 forceEndButton = new class_1799((class_1935)class_1802.field_8626);
                forceEndButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Forcer la Fin").method_27692(class_124.field_1079));
                Object[] objectArray = new class_5250[]{class_2561.method_43470((String)"Termine le tournoi de force").method_27692(class_124.field_1080), class_2561.method_43470((String)"Sans ceremonie ni recompenses").method_27692(class_124.field_1061)};
                forceEndButton.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray)));
                container.method_5447(22, forceEndButton);
            }
            class_1799 backButton2 = new class_1799((class_1935)class_1802.field_8107);
            backButton2.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Retour").method_27692(class_124.field_1080));
            container.method_5447(27, backButton2);
            class_1799 closeButton = new class_1799((class_1935)class_1802.field_8077);
            closeButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Fermer").method_27692(class_124.field_1061));
            container.method_5447(35, closeButton);
        }

        public void method_7593(int slotId, int button, @NotNull class_1713 clickType, @NotNull class_1657 player) {
            Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (slotId < 0 || slotId >= 36) {
                super.method_7593(slotId, button, clickType, player);
                return;
            }
            TournamentSession tournament = TournamentManager.INSTANCE.getActiveTournament();
            switch (slotId) {
                case 10: {
                    TournamentSession tournamentSession = tournament;
                    if ((tournamentSession != null ? tournamentSession.getState() : null) != TournamentState.REGISTRATION) break;
                    this.serverPlayer.method_7346();
                    TournamentManager.INSTANCE.startTournament(this.serverPlayer);
                    break;
                }
                case 12: {
                    TournamentSession tournamentSession = tournament;
                    if ((tournamentSession != null ? tournamentSession.getBracket() : null) != null) {
                        this.serverPlayer.method_7346();
                        INSTANCE.openBracketMenu(this.serverPlayer);
                        break;
                    }
                    this.serverPlayer.method_43496((class_2561)class_2561.method_43470((String)"Le bracket n'est pas encore genere!").method_27694(ManagementContainer::clicked$lambda$0));
                    break;
                }
                case 14: {
                    this.serverPlayer.method_7346();
                    INSTANCE.openRewardsConfigMenu(this.serverPlayer);
                    break;
                }
                case 16: {
                    this.serverPlayer.method_7346();
                    TournamentManager.INSTANCE.endTournament(true);
                    break;
                }
                case 22: {
                    TournamentSession tournamentSession = tournament;
                    if ((tournamentSession != null ? tournamentSession.getState() : null) != TournamentState.IN_PROGRESS) break;
                    this.serverPlayer.method_7346();
                    TournamentManager.INSTANCE.endTournament(false);
                    break;
                }
                case 27: {
                    this.serverPlayer.method_7346();
                    INSTANCE.openAdminMenu(this.serverPlayer);
                    break;
                }
                case 35: {
                    this.serverPlayer.method_7346();
                }
            }
        }

        @NotNull
        public class_1799 method_7601(@NotNull class_1657 player, int index) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            class_1799 class_17992 = class_1799.field_8037;
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
            return class_17992;
        }

        private static final class_2583 clicked$lambda$0(class_2583 it) {
            return it.method_36139(0xFF5555);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/music176/pokemonleague/tournament/TournamentGUI$ModeSelectContainer;", "Lnet/minecraft/class_1707;", "", "containerId", "Lnet/minecraft/class_1661;", "playerInventory", "Lnet/minecraft/class_3222;", "serverPlayer", "<init>", "(ILnet/minecraft/class_1661;Lnet/minecraft/class_3222;)V", "", "setupItems", "()V", "slotId", "button", "Lnet/minecraft/class_1713;", "clickType", "Lnet/minecraft/class_1657;", "player", "clicked", "(IILnet/minecraft/class_1713;Lnet/minecraft/class_1657;)V", "index", "Lnet/minecraft/class_1799;", "quickMoveStack", "(Lnet/minecraft/class_1657;I)Lnet/minecraft/class_1799;", "Lnet/minecraft/class_3222;", "pokemon-league-mod"})
    public static final class ModeSelectContainer
    extends class_1707 {
        @NotNull
        private final class_3222 serverPlayer;

        public ModeSelectContainer(int containerId, @NotNull class_1661 playerInventory, @NotNull class_3222 serverPlayer) {
            Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
            Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
            super(class_3917.field_17326, containerId, playerInventory, (class_1263)new class_1277(27), 3);
            this.serverPlayer = serverPlayer;
            this.setupItems();
        }

        private final void setupItems() {
            class_1263 container = this.method_7629();
            class_1799 filler = new class_1799((class_1935)class_1802.field_8871);
            filler.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)" "));
            for (int i = 0; i < 27; ++i) {
                container.method_5447(i, filler.method_7972());
            }
            class_1799 mode1v1 = new class_1799((class_1935)class_1802.field_8802);
            Object[] objectArray = new class_124[]{class_124.field_1060, class_124.field_1067};
            mode1v1.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Mode 1v1").method_27695((class_124[])objectArray));
            objectArray = new class_5250[]{class_2561.method_43470((String)"Tournoi en solo").method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour selectionner").method_27692(class_124.field_1054)};
            mode1v1.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray)));
            container.method_5447(11, mode1v1);
            class_1799 mode2v2 = new class_1799((class_1935)class_1802.field_22022);
            Object[] objectArray2 = new class_124[]{class_124.field_1076, class_124.field_1067};
            mode2v2.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Mode 2v2").method_27695((class_124[])objectArray2));
            objectArray2 = new class_5250[]{class_2561.method_43470((String)"Tournoi en equipe de 2").method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour selectionner").method_27692(class_124.field_1054)};
            mode2v2.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray2)));
            container.method_5447(15, mode2v2);
            class_1799 backButton = new class_1799((class_1935)class_1802.field_8107);
            backButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Retour").method_27692(class_124.field_1080));
            container.method_5447(18, backButton);
            class_1799 closeButton = new class_1799((class_1935)class_1802.field_8077);
            closeButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Fermer").method_27692(class_124.field_1061));
            container.method_5447(22, closeButton);
        }

        public void method_7593(int slotId, int button, @NotNull class_1713 clickType, @NotNull class_1657 player) {
            Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (slotId < 0 || slotId >= 27) {
                super.method_7593(slotId, button, clickType, player);
                return;
            }
            switch (slotId) {
                case 11: {
                    TournamentCreationState tournamentCreationState = (TournamentCreationState)creationStates.get(this.serverPlayer.method_5667());
                    if (tournamentCreationState == null) {
                        return;
                    }
                    TournamentCreationState state = tournamentCreationState;
                    state.setMode(TournamentMode.SINGLES_1V1);
                    this.serverPlayer.method_7346();
                    INSTANCE.openFormatMenu(this.serverPlayer);
                    break;
                }
                case 15: {
                    TournamentCreationState tournamentCreationState = (TournamentCreationState)creationStates.get(this.serverPlayer.method_5667());
                    if (tournamentCreationState == null) {
                        return;
                    }
                    TournamentCreationState state = tournamentCreationState;
                    state.setMode(TournamentMode.DOUBLES_2V2);
                    this.serverPlayer.method_7346();
                    INSTANCE.openFormatMenu(this.serverPlayer);
                    break;
                }
                case 18: {
                    this.serverPlayer.method_7346();
                    creationStates.remove(this.serverPlayer.method_5667());
                    INSTANCE.openAdminMenu(this.serverPlayer);
                    break;
                }
                case 22: {
                    this.serverPlayer.method_7346();
                    creationStates.remove(this.serverPlayer.method_5667());
                }
            }
        }

        @NotNull
        public class_1799 method_7601(@NotNull class_1657 player, int index) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            class_1799 class_17992 = class_1799.field_8037;
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
            return class_17992;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/music176/pokemonleague/tournament/TournamentGUI$PlayerMainContainer;", "Lnet/minecraft/class_1707;", "", "containerId", "Lnet/minecraft/class_1661;", "playerInventory", "Lnet/minecraft/class_3222;", "serverPlayer", "<init>", "(ILnet/minecraft/class_1661;Lnet/minecraft/class_3222;)V", "", "setupItems", "()V", "slotId", "button", "Lnet/minecraft/class_1713;", "clickType", "Lnet/minecraft/class_1657;", "player", "clicked", "(IILnet/minecraft/class_1713;Lnet/minecraft/class_1657;)V", "index", "Lnet/minecraft/class_1799;", "quickMoveStack", "(Lnet/minecraft/class_1657;I)Lnet/minecraft/class_1799;", "Lnet/minecraft/class_3222;", "pokemon-league-mod"})
    public static final class PlayerMainContainer
    extends class_1707 {
        @NotNull
        private final class_3222 serverPlayer;

        public PlayerMainContainer(int containerId, @NotNull class_1661 playerInventory, @NotNull class_3222 serverPlayer) {
            Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
            Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
            super(class_3917.field_17326, containerId, playerInventory, (class_1263)new class_1277(27), 3);
            this.serverPlayer = serverPlayer;
            this.setupItems();
        }

        private final void setupItems() {
            class_1263 container;
            block17: {
                Object[] objectArray;
                block19: {
                    boolean isRegistered;
                    block18: {
                        Object warningLore;
                        class_124[] participant;
                        container = this.method_7629();
                        TournamentSession tournament = TournamentManager.INSTANCE.getActiveTournament();
                        UUID uUID = this.serverPlayer.method_5667();
                        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                        isRegistered = TournamentManager.INSTANCE.isPlayerInTournament(uUID);
                        class_1799 filler = new class_1799((class_1935)class_1802.field_8871);
                        filler.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)" "));
                        for (int i = 0; i < 27; ++i) {
                            container.method_5447(i, filler.method_7972());
                        }
                        class_1799 info = new class_1799((class_1935)class_1802.field_8529);
                        if (tournament != null) {
                            Object[] objectArray2 = new class_124[]{class_124.field_1065, class_124.field_1067};
                            info.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)tournament.getName()).method_27695((class_124[])objectArray2));
                            objectArray2 = new class_5250[]{class_2561.method_43470((String)("Mode: " + tournament.getMode().getDisplayName())).method_27692(class_124.field_1068), class_2561.method_43470((String)("Statut: " + tournament.getStatusString())).method_27692(class_124.field_1080), class_2561.method_43470((String)("Participants: " + tournament.getParticipantCount() + "/" + tournament.getMaxParticipants())).method_27692(class_124.field_1075)};
                            v1 = (class_9290)info.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray2)));
                        } else {
                            info.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Aucun tournoi").method_27692(class_124.field_1080));
                            v1 = (class_9290)info.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object)class_2561.method_43470((String)"Aucun tournoi en cours").method_27692(class_124.field_1063))));
                        }
                        container.method_5447(4, info);
                        if (tournament != null && tournament.isRegistrationOpen() && !isRegistered) {
                            class_1799 joinButton = new class_1799((class_1935)class_1802.field_8839);
                            Object[] objectArray3 = new class_124[]{class_124.field_1060, class_124.field_1067};
                            joinButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Rejoindre le Tournoi").method_27695((class_124[])objectArray3));
                            objectArray3 = new class_5250[]{class_2561.method_43470((String)"Cliquez pour vous inscrire").method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43470((String)(tournament.getParticipantCount() + "/" + tournament.getMaxParticipants() + " places")).method_27692(class_124.field_1054)};
                            joinButton.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray3)));
                            container.method_5447(11, joinButton);
                        } else if (isRegistered) {
                            class_1799 registeredButton = new class_1799((class_1935)class_1802.field_8687);
                            registeredButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Vous etes inscrit!").method_27692(class_124.field_1060));
                            TournamentSession tournamentSession = tournament;
                            if (tournamentSession != null) {
                                UUID uUID2 = this.serverPlayer.method_5667();
                                Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
                                v4 = tournamentSession.findParticipant(uUID2);
                            } else {
                                v4 = participant = null;
                            }
                            if (participant != null) {
                                objectArray = new class_5250[]{class_2561.method_43470((String)("Bracket: " + participant.getCurrentBracket().name())).method_27692(class_124.field_1080), class_2561.method_43470((String)("Defaites: " + participant.getLosses())).method_27692(class_124.field_1080)};
                                registeredButton.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray)));
                            }
                            container.method_5447(11, registeredButton);
                        } else {
                            class_1799 noJoinButton = new class_1799((class_1935)class_1802.field_8333);
                            noJoinButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Inscriptions fermees").method_27692(class_124.field_1080));
                            container.method_5447(11, noJoinButton);
                        }
                        if (isRegistered) {
                            List list;
                            class_1799 leaveButton = new class_1799((class_1935)class_1802.field_8197);
                            participant = new class_124[]{class_124.field_1061, class_124.field_1067};
                            leaveButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Quitter le Tournoi").method_27695(participant));
                            TournamentSession tournamentSession = tournament;
                            if ((tournamentSession != null ? tournamentSession.getState() : null) == TournamentState.IN_PROGRESS) {
                                objectArray = new class_5250[]{class_2561.method_43470((String)"ATTENTION: Disqualification!").method_27692(class_124.field_1061), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour quitter").method_27692(class_124.field_1080)};
                                list = CollectionsKt.listOf((Object[])objectArray);
                            } else {
                                list = CollectionsKt.listOf((Object)class_2561.method_43470((String)"Cliquez pour quitter").method_27692(class_124.field_1080));
                            }
                            warningLore = list;
                            leaveButton.method_57379(class_9334.field_49632, (Object)new class_9290((List)warningLore));
                            container.method_5447(13, leaveButton);
                        }
                        if (tournament != null && tournament.getBracket() != null) {
                            class_1799 bracketButton = new class_1799((class_1935)class_1802.field_8204);
                            warningLore = new class_124[]{class_124.field_1075, class_124.field_1067};
                            bracketButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Voir le Bracket").method_27695(warningLore));
                            bracketButton.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object)class_2561.method_43470((String)"Voir l'arbre du tournoi").method_27692(class_124.field_1080))));
                            container.method_5447(15, bracketButton);
                        }
                        UUID uUID3 = this.serverPlayer.method_5667();
                        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
                        boolean isSpectating = TournamentManager.INSTANCE.isTournamentSpectator(uUID3);
                        if (tournament == null || tournament.getState() != TournamentState.IN_PROGRESS) break block17;
                        if (!isSpectating) break block18;
                        class_1799 stopSpectateButton = new class_1799((class_1935)class_1802.field_8449);
                        objectArray = new class_124[]{class_124.field_1054, class_124.field_1067};
                        stopSpectateButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Arreter de Spectater").method_27695((class_124[])objectArray));
                        objectArray = new class_5250[]{class_2561.method_43470((String)"Vous etes en mode spectateur").method_27692(class_124.field_1060), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour quitter le mode spectateur").method_27692(class_124.field_1080)};
                        stopSpectateButton.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray)));
                        container.method_5447(20, stopSpectateButton);
                        break block17;
                    }
                    if (!isRegistered) break block19;
                    UUID uUID = this.serverPlayer.method_5667();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                    if (!TournamentManager.INSTANCE.isPlayerEliminated(uUID)) break block17;
                }
                class_1799 spectateButton = new class_1799((class_1935)class_1802.field_8449);
                objectArray = new class_124[]{class_124.field_1076, class_124.field_1067};
                spectateButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Spectater le Tournoi").method_27695((class_124[])objectArray));
                objectArray = new class_5250[]{class_2561.method_43470((String)"Observer les combats en direct").method_27692(class_124.field_1080), class_2561.method_43470((String)"avec les barres de PV!").method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour spectater").method_27692(class_124.field_1054)};
                spectateButton.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray)));
                container.method_5447(20, spectateButton);
            }
            class_1799 closeButton = new class_1799((class_1935)class_1802.field_8077);
            closeButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Fermer").method_27692(class_124.field_1061));
            container.method_5447(22, closeButton);
        }

        public void method_7593(int slotId, int button, @NotNull class_1713 clickType, @NotNull class_1657 player) {
            Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (slotId < 0 || slotId >= 27) {
                super.method_7593(slotId, button, clickType, player);
                return;
            }
            switch (slotId) {
                case 11: {
                    TournamentSession tournament = TournamentManager.INSTANCE.getActiveTournament();
                    if (tournament == null || !tournament.isRegistrationOpen()) break;
                    UUID uUID = this.serverPlayer.method_5667();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                    if (TournamentManager.INSTANCE.isPlayerInTournament(uUID)) break;
                    this.serverPlayer.method_7346();
                    TournamentManager.INSTANCE.registerPlayer(this.serverPlayer);
                    break;
                }
                case 13: {
                    UUID uUID = this.serverPlayer.method_5667();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                    if (!TournamentManager.INSTANCE.isPlayerInTournament(uUID)) break;
                    this.serverPlayer.method_7346();
                    TournamentManager.INSTANCE.unregisterPlayer(this.serverPlayer);
                    break;
                }
                case 15: {
                    TournamentSession tournament;
                    TournamentSession tournamentSession = tournament = TournamentManager.INSTANCE.getActiveTournament();
                    if ((tournamentSession != null ? tournamentSession.getBracket() : null) == null) break;
                    this.serverPlayer.method_7346();
                    INSTANCE.openBracketMenu(this.serverPlayer);
                    break;
                }
                case 20: {
                    TournamentSession tournament = TournamentManager.INSTANCE.getActiveTournament();
                    if (tournament == null || tournament.getState() != TournamentState.IN_PROGRESS) break;
                    this.serverPlayer.method_7346();
                    UUID uUID = this.serverPlayer.method_5667();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                    if (TournamentManager.INSTANCE.isTournamentSpectator(uUID)) {
                        TournamentManager.INSTANCE.removeTournamentSpectator(this.serverPlayer);
                        break;
                    }
                    TournamentManager.addTournamentSpectator$default(TournamentManager.INSTANCE, this.serverPlayer, null, 2, null);
                    break;
                }
                case 22: {
                    this.serverPlayer.method_7346();
                }
            }
        }

        @NotNull
        public class_1799 method_7601(@NotNull class_1657 player, int index) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            class_1799 class_17992 = class_1799.field_8037;
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
            return class_17992;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/music176/pokemonleague/tournament/TournamentGUI$PositionConfigContainer;", "Lnet/minecraft/class_1707;", "", "containerId", "Lnet/minecraft/class_1661;", "playerInventory", "Lnet/minecraft/class_3222;", "serverPlayer", "<init>", "(ILnet/minecraft/class_1661;Lnet/minecraft/class_3222;)V", "", "setupItems", "()V", "slotId", "button", "Lnet/minecraft/class_1713;", "clickType", "Lnet/minecraft/class_1657;", "player", "clicked", "(IILnet/minecraft/class_1713;Lnet/minecraft/class_1657;)V", "index", "Lnet/minecraft/class_1799;", "quickMoveStack", "(Lnet/minecraft/class_1657;I)Lnet/minecraft/class_1799;", "Lnet/minecraft/class_3222;", "pokemon-league-mod"})
    @SourceDebugExtension(value={"SMAP\nTournamentGUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TournamentGUI.kt\ncom/music176/pokemonleague/tournament/TournamentGUI$PositionConfigContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1805:1\n1878#2,3:1806\n*S KotlinDebug\n*F\n+ 1 TournamentGUI.kt\ncom/music176/pokemonleague/tournament/TournamentGUI$PositionConfigContainer\n*L\n630#1:1806,3\n*E\n"})
    public static final class PositionConfigContainer
    extends class_1707 {
        @NotNull
        private final class_3222 serverPlayer;

        public PositionConfigContainer(int containerId, @NotNull class_1661 playerInventory, @NotNull class_3222 serverPlayer) {
            Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
            Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
            super(class_3917.field_18667, containerId, playerInventory, (class_1263)new class_1277(45), 5);
            this.serverPlayer = serverPlayer;
            this.setupItems();
        }

        /*
         * WARNING - void declaration
         */
        private final void setupItems() {
            Object[] objectArray;
            class_1263 container = this.method_7629();
            TournamentConfig config = TournamentManager.INSTANCE.getConfig();
            class_1799 filler = new class_1799((class_1935)class_1802.field_8871);
            filler.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)" "));
            for (int i = 0; i < 45; ++i) {
                container.method_5447(i, filler.method_7972());
            }
            class_1799 arenaHeader = new class_1799((class_1935)class_1802.field_22022);
            class_124[] class_124Array = new class_124[]{class_124.field_1061, class_124.field_1067};
            arenaHeader.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Arenes de Combat").method_27695(class_124Array));
            container.method_5447(4, arenaHeader);
            Iterable $this$forEachIndexed$iv = config.getArenas();
            boolean $i$f$forEachIndexed22 = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void arena;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                TournamentArena tournamentArena = (TournamentArena)item$iv;
                int index = n;
                boolean bl = false;
                int slot = 10 + index * 2;
                class_1799 arenaItem = arena.isConfigured() ? new class_1799((class_1935)class_1802.field_8839) : new class_1799((class_1935)class_1802.field_8197);
                objectArray = new class_124[]{arena.isConfigured() ? class_124.field_1060 : class_124.field_1061, class_124.field_1067};
                arenaItem.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)("Arene " + (index + 1))).method_27695((class_124[])objectArray));
                objectArray = new class_5250[]{class_2561.method_43470((String)("P1: " + (!(arena.getPlayer1Spawn().getX() == 0.0) ? "OK" : "Non defini"))).method_27692(!(arena.getPlayer1Spawn().getX() == 0.0) ? class_124.field_1060 : class_124.field_1061), class_2561.method_43470((String)("P2: " + (!(arena.getPlayer2Spawn().getX() == 0.0) ? "OK" : "Non defini"))).method_27692(!(arena.getPlayer2Spawn().getX() == 0.0) ? class_124.field_1060 : class_124.field_1061), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour configurer").method_27692(class_124.field_1054)};
                arenaItem.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray)));
                container.method_5447(slot, arenaItem);
            }
            class_1799 specialHeader = new class_1799((class_1935)class_1802.field_8634);
            class_124[] $i$f$forEachIndexed22 = new class_124[]{class_124.field_1076, class_124.field_1067};
            specialHeader.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Positions Speciales").method_27695($i$f$forEachIndexed22));
            container.method_5447(22, specialHeader);
            boolean waitingOk = !(config.getWaitingRoomPosition().getX() == 0.0);
            class_1799 waitingItem = waitingOk ? new class_1799((class_1935)class_1802.field_8839) : new class_1799((class_1935)class_1802.field_8197);
            waitingItem.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Salle d'Attente").method_27692(waitingOk ? class_124.field_1060 : class_124.field_1061));
            Object[] objectArray2 = new class_5250[]{waitingOk ? class_2561.method_43470((String)"Position definie").method_27692(class_124.field_1060) : class_2561.method_43470((String)"Non definie").method_27692(class_124.field_1061), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour definir").method_27692(class_124.field_1054)};
            waitingItem.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray2)));
            container.method_5447(28, waitingItem);
            boolean spectatorOk = !(config.getSpectatorAreaPosition().getX() == 0.0);
            class_1799 spectatorItem = spectatorOk ? new class_1799((class_1935)class_1802.field_8839) : new class_1799((class_1935)class_1802.field_8197);
            spectatorItem.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Zone Spectateur").method_27692(spectatorOk ? class_124.field_1060 : class_124.field_1061));
            Object[] objectArray3 = new class_5250[]{spectatorOk ? class_2561.method_43470((String)"Position definie").method_27692(class_124.field_1060) : class_2561.method_43470((String)"Non definie").method_27692(class_124.field_1061), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour definir").method_27692(class_124.field_1054)};
            spectatorItem.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray3)));
            container.method_5447(30, spectatorItem);
            boolean endZoneOk = !(config.getEndZonePosition().getX() == 0.0);
            class_1799 endZoneItem = endZoneOk ? new class_1799((class_1935)class_1802.field_8839) : new class_1799((class_1935)class_1802.field_8197);
            endZoneItem.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Zone de Fin").method_27692(endZoneOk ? class_124.field_1060 : class_124.field_1061));
            Object[] index = new class_5250[]{endZoneOk ? class_2561.method_43470((String)"Position definie").method_27692(class_124.field_1060) : class_2561.method_43470((String)"Non definie").method_27692(class_124.field_1061), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour definir").method_27692(class_124.field_1054)};
            endZoneItem.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])index)));
            container.method_5447(32, endZoneItem);
            boolean podium1Ok = !(config.getPodiumFirst().getX() == 0.0);
            class_1799 podium1Item = podium1Ok ? new class_1799((class_1935)class_1802.field_8494) : new class_1799((class_1935)class_1802.field_8197);
            Object[] slot = new class_124[]{class_124.field_1065, class_124.field_1067};
            podium1Item.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Podium 1ere Place").method_27695((class_124[])slot));
            slot = new class_5250[]{podium1Ok ? class_2561.method_43470((String)"Position definie").method_27692(class_124.field_1060) : class_2561.method_43470((String)"Non definie").method_27692(class_124.field_1061), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour definir").method_27692(class_124.field_1054)};
            podium1Item.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])slot)));
            container.method_5447(37, podium1Item);
            boolean podium2Ok = !(config.getPodiumSecond().getX() == 0.0);
            class_1799 podium2Item = podium2Ok ? new class_1799((class_1935)class_1802.field_8773) : new class_1799((class_1935)class_1802.field_8197);
            objectArray = new class_124[]{class_124.field_1068, class_124.field_1067};
            podium2Item.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Podium 2eme Place").method_27695((class_124[])objectArray));
            objectArray = new class_5250[]{podium2Ok ? class_2561.method_43470((String)"Position definie").method_27692(class_124.field_1060) : class_2561.method_43470((String)"Non definie").method_27692(class_124.field_1061), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour definir").method_27692(class_124.field_1054)};
            podium2Item.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray)));
            container.method_5447(38, podium2Item);
            boolean podium3Ok = !(config.getPodiumThird().getX() == 0.0);
            class_1799 podium3Item = podium3Ok ? new class_1799((class_1935)class_1802.field_27071) : new class_1799((class_1935)class_1802.field_8197);
            podium3Item.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Podium 3eme Place").method_27692(class_124.field_1065));
            Object[] objectArray4 = new class_5250[]{podium3Ok ? class_2561.method_43470((String)"Position definie").method_27692(class_124.field_1060) : class_2561.method_43470((String)"Non definie").method_27692(class_124.field_1061), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour definir").method_27692(class_124.field_1054)};
            podium3Item.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray4)));
            container.method_5447(39, podium3Item);
            class_1799 backButton = new class_1799((class_1935)class_1802.field_8107);
            backButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Retour").method_27692(class_124.field_1080));
            container.method_5447(36, backButton);
            class_1799 closeButton = new class_1799((class_1935)class_1802.field_8077);
            closeButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Fermer").method_27692(class_124.field_1061));
            container.method_5447(44, closeButton);
        }

        public void method_7593(int slotId, int button, @NotNull class_1713 clickType, @NotNull class_1657 player) {
            Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (slotId < 0 || slotId >= 45) {
                super.method_7593(slotId, button, clickType, player);
                return;
            }
            switch (slotId) {
                case 10: {
                    this.serverPlayer.method_7346();
                    INSTANCE.openArenaConfigMenu(this.serverPlayer, 1);
                    break;
                }
                case 12: {
                    this.serverPlayer.method_7346();
                    INSTANCE.openArenaConfigMenu(this.serverPlayer, 2);
                    break;
                }
                case 14: {
                    this.serverPlayer.method_7346();
                    INSTANCE.openArenaConfigMenu(this.serverPlayer, 3);
                    break;
                }
                case 16: {
                    this.serverPlayer.method_7346();
                    INSTANCE.openArenaConfigMenu(this.serverPlayer, 4);
                    break;
                }
                case 28: {
                    INSTANCE.setPositionAtPlayer(this.serverPlayer, PositionSetType.WAITING_ROOM);
                    break;
                }
                case 30: {
                    INSTANCE.setPositionAtPlayer(this.serverPlayer, PositionSetType.SPECTATOR_AREA);
                    break;
                }
                case 32: {
                    INSTANCE.setPositionAtPlayer(this.serverPlayer, PositionSetType.END_ZONE);
                    break;
                }
                case 37: {
                    INSTANCE.setPositionAtPlayer(this.serverPlayer, PositionSetType.PODIUM_1);
                    break;
                }
                case 38: {
                    INSTANCE.setPositionAtPlayer(this.serverPlayer, PositionSetType.PODIUM_2);
                    break;
                }
                case 39: {
                    INSTANCE.setPositionAtPlayer(this.serverPlayer, PositionSetType.PODIUM_3);
                    break;
                }
                case 36: {
                    this.serverPlayer.method_7346();
                    INSTANCE.openAdminMenu(this.serverPlayer);
                    break;
                }
                case 44: {
                    this.serverPlayer.method_7346();
                }
            }
        }

        @NotNull
        public class_1799 method_7601(@NotNull class_1657 player, int index) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            class_1799 class_17992 = class_1799.field_8037;
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
            return class_17992;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0011\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lcom/music176/pokemonleague/tournament/TournamentGUI$PositionSetType;", "", "<init>", "(Ljava/lang/String;I)V", "ARENA_1_PLAYER1", "ARENA_1_PLAYER2", "ARENA_2_PLAYER1", "ARENA_2_PLAYER2", "ARENA_3_PLAYER1", "ARENA_3_PLAYER2", "ARENA_4_PLAYER1", "ARENA_4_PLAYER2", "WAITING_ROOM", "SPECTATOR_AREA", "END_ZONE", "PODIUM_1", "PODIUM_2", "PODIUM_3", "pokemon-league-mod"})
    public static final class PositionSetType
    extends Enum<PositionSetType> {
        public static final /* enum */ PositionSetType ARENA_1_PLAYER1 = new PositionSetType();
        public static final /* enum */ PositionSetType ARENA_1_PLAYER2 = new PositionSetType();
        public static final /* enum */ PositionSetType ARENA_2_PLAYER1 = new PositionSetType();
        public static final /* enum */ PositionSetType ARENA_2_PLAYER2 = new PositionSetType();
        public static final /* enum */ PositionSetType ARENA_3_PLAYER1 = new PositionSetType();
        public static final /* enum */ PositionSetType ARENA_3_PLAYER2 = new PositionSetType();
        public static final /* enum */ PositionSetType ARENA_4_PLAYER1 = new PositionSetType();
        public static final /* enum */ PositionSetType ARENA_4_PLAYER2 = new PositionSetType();
        public static final /* enum */ PositionSetType WAITING_ROOM = new PositionSetType();
        public static final /* enum */ PositionSetType SPECTATOR_AREA = new PositionSetType();
        public static final /* enum */ PositionSetType END_ZONE = new PositionSetType();
        public static final /* enum */ PositionSetType PODIUM_1 = new PositionSetType();
        public static final /* enum */ PositionSetType PODIUM_2 = new PositionSetType();
        public static final /* enum */ PositionSetType PODIUM_3 = new PositionSetType();
        private static final /* synthetic */ PositionSetType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PositionSetType[] values() {
            return (PositionSetType[])$VALUES.clone();
        }

        public static PositionSetType valueOf(String value) {
            return Enum.valueOf(PositionSetType.class, value);
        }

        @NotNull
        public static EnumEntries<PositionSetType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = positionSetTypeArray = new PositionSetType[]{PositionSetType.ARENA_1_PLAYER1, PositionSetType.ARENA_1_PLAYER2, PositionSetType.ARENA_2_PLAYER1, PositionSetType.ARENA_2_PLAYER2, PositionSetType.ARENA_3_PLAYER1, PositionSetType.ARENA_3_PLAYER2, PositionSetType.ARENA_4_PLAYER1, PositionSetType.ARENA_4_PLAYER2, PositionSetType.WAITING_ROOM, PositionSetType.SPECTATOR_AREA, PositionSetType.END_ZONE, PositionSetType.PODIUM_1, PositionSetType.PODIUM_2, PositionSetType.PODIUM_3};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ/\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\rJ\u0017\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001eR\u0014\u0010\b\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/music176/pokemonleague/tournament/TournamentGUI$RewardChestContainer;", "Lnet/minecraft/class_1707;", "", "containerId", "Lnet/minecraft/class_1661;", "playerInventory", "Lnet/minecraft/class_3222;", "serverPlayer", "place", "<init>", "(ILnet/minecraft/class_1661;Lnet/minecraft/class_3222;I)V", "", "loadCurrentRewards", "()V", "setupControlButtons", "slotId", "button", "Lnet/minecraft/class_1713;", "clickType", "Lnet/minecraft/class_1657;", "player", "clicked", "(IILnet/minecraft/class_1713;Lnet/minecraft/class_1657;)V", "saveRewards", "removed", "(Lnet/minecraft/class_1657;)V", "index", "Lnet/minecraft/class_1799;", "quickMoveStack", "(Lnet/minecraft/class_1657;I)Lnet/minecraft/class_1799;", "Lnet/minecraft/class_3222;", "I", "pokemon-league-mod"})
    @SourceDebugExtension(value={"SMAP\nTournamentGUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TournamentGUI.kt\ncom/music176/pokemonleague/tournament/TournamentGUI$RewardChestContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1805:1\n1878#2,3:1806\n*S KotlinDebug\n*F\n+ 1 TournamentGUI.kt\ncom/music176/pokemonleague/tournament/TournamentGUI$RewardChestContainer\n*L\n1109#1:1806,3\n*E\n"})
    public static final class RewardChestContainer
    extends class_1707 {
        @NotNull
        private final class_3222 serverPlayer;
        private final int place;

        public RewardChestContainer(int containerId, @NotNull class_1661 playerInventory, @NotNull class_3222 serverPlayer, int place) {
            Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
            Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
            super(class_3917.field_18666, containerId, playerInventory, (class_1263)new class_1277(36), 4);
            this.serverPlayer = serverPlayer;
            this.place = place;
            this.loadCurrentRewards();
        }

        /*
         * WARNING - void declaration
         */
        private final void loadCurrentRewards() {
            TournamentSession tournamentSession = TournamentManager.INSTANCE.getActiveTournament();
            if (tournamentSession == null) {
                return;
            }
            TournamentSession tournament = tournamentSession;
            RuntimeRewards rewards = tournament.getRuntimeRewards();
            if (rewards != null) {
                List<class_1799> items = switch (this.place) {
                    case 1 -> rewards.getFirstPlace();
                    case 2 -> rewards.getSecondPlace();
                    case 3 -> rewards.getThirdPlace();
                    default -> CollectionsKt.emptyList();
                };
                Iterable $this$forEachIndexed$iv = items;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void item;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    class_1799 class_17992 = (class_1799)item$iv;
                    int index = n;
                    boolean bl = false;
                    if (index >= 27) continue;
                    this.method_7629().method_5447(index, item.method_7972());
                }
            }
            this.setupControlButtons();
        }

        private final void setupControlButtons() {
            class_1799 filler = new class_1799((class_1935)class_1802.field_8871);
            filler.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)" "));
            for (int i = 27; i < 36; ++i) {
                this.method_7629().method_5447(i, filler.method_7972());
            }
            class_1799 saveButton = new class_1799((class_1935)class_1802.field_8839);
            Object[] objectArray = new class_124[]{class_124.field_1060, class_124.field_1067};
            saveButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Sauvegarder").method_27695((class_124[])objectArray));
            objectArray = new class_5250[]{class_2561.method_43470((String)"Cliquez pour sauvegarder").method_27692(class_124.field_1080), class_2561.method_43470((String)"les recompenses").method_27692(class_124.field_1080)};
            saveButton.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray)));
            this.method_7629().method_5447(31, saveButton);
            class_1799 backButton = new class_1799((class_1935)class_1802.field_8107);
            backButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Retour").method_27692(class_124.field_1080));
            this.method_7629().method_5447(27, backButton);
            class_1799 clearButton = new class_1799((class_1935)class_1802.field_8197);
            clearButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Vider").method_27692(class_124.field_1061));
            this.method_7629().method_5447(35, clearButton);
        }

        public void method_7593(int slotId, int button, @NotNull class_1713 clickType, @NotNull class_1657 player) {
            Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            int n = slotId;
            if (n == 27) {
                this.saveRewards();
                this.serverPlayer.method_7346();
                INSTANCE.openRewardsConfigMenu(this.serverPlayer);
                return;
            }
            if (n == 31) {
                this.saveRewards();
                this.serverPlayer.method_43496((class_2561)class_2561.method_43470((String)"Recompenses sauvegardees!").method_27694(RewardChestContainer::clicked$lambda$0));
                return;
            }
            if (n == 35) {
                for (int i = 0; i < 27; ++i) {
                    this.method_7629().method_5447(i, class_1799.field_8037);
                }
                this.saveRewards();
                this.serverPlayer.method_43496((class_2561)class_2561.method_43470((String)"Recompenses videes!").method_27694(RewardChestContainer::clicked$lambda$1));
                return;
            }
            boolean bl = 27 <= n ? n < 36 : false;
            if (bl) {
                return;
            }
            super.method_7593(slotId, button, clickType, player);
        }

        private final void saveRewards() {
            TournamentSession tournamentSession = TournamentManager.INSTANCE.getActiveTournament();
            if (tournamentSession == null) {
                return;
            }
            TournamentSession tournament = tournamentSession;
            if (tournament.getRuntimeRewards() == null) {
                tournament.setRuntimeRewards(new RuntimeRewards(null, null, null, 7, null));
            }
            List items = new ArrayList();
            for (int i = 0; i < 27; ++i) {
                class_1799 item = this.method_7629().method_5438(i);
                if (item.method_7960()) continue;
                class_1799 class_17992 = item.method_7972();
                Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"copy(...)");
                items.add(class_17992);
            }
            RuntimeRewards runtimeRewards = tournament.getRuntimeRewards();
            Intrinsics.checkNotNull((Object)runtimeRewards);
            runtimeRewards.setRewardsForPlace(this.place, items);
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Saved " + items.size() + " reward items for place " + this.place);
        }

        public void method_7595(@NotNull class_1657 player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            this.saveRewards();
            super.method_7595(player);
        }

        @NotNull
        public class_1799 method_7601(@NotNull class_1657 player, int index) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            class_2371 class_23712 = this.field_7761;
            Intrinsics.checkNotNullExpressionValue((Object)class_23712, (String)"slots");
            class_1735 class_17352 = (class_1735)CollectionsKt.getOrNull((List)((List)class_23712), (int)index);
            if (class_17352 == null) {
                class_1799 class_17992 = class_1799.field_8037;
                Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
                return class_17992;
            }
            class_1735 slot = class_17352;
            if (!slot.method_7681()) {
                class_1799 class_17993 = class_1799.field_8037;
                Intrinsics.checkNotNullExpressionValue((Object)class_17993, (String)"EMPTY");
                return class_17993;
            }
            class_1799 stack = slot.method_7677();
            class_1799 originalStack = stack.method_7972();
            if (index < 27) {
                if (!this.method_7616(stack, 36, 72, true)) {
                    class_1799 class_17994 = class_1799.field_8037;
                    Intrinsics.checkNotNullExpressionValue((Object)class_17994, (String)"EMPTY");
                    return class_17994;
                }
            } else if (index >= 36 && !this.method_7616(stack, 0, 27, false)) {
                class_1799 class_17995 = class_1799.field_8037;
                Intrinsics.checkNotNullExpressionValue((Object)class_17995, (String)"EMPTY");
                return class_17995;
            }
            if (stack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            Intrinsics.checkNotNull((Object)originalStack);
            return originalStack;
        }

        private static final class_2583 clicked$lambda$0(class_2583 it) {
            return it.method_36139(0x55FF55);
        }

        private static final class_2583 clicked$lambda$1(class_2583 it) {
            return it.method_36139(0xFFFF55);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/music176/pokemonleague/tournament/TournamentGUI$RewardsConfigContainer;", "Lnet/minecraft/class_1707;", "", "containerId", "Lnet/minecraft/class_1661;", "playerInventory", "Lnet/minecraft/class_3222;", "serverPlayer", "<init>", "(ILnet/minecraft/class_1661;Lnet/minecraft/class_3222;)V", "", "setupItems", "()V", "slotId", "button", "Lnet/minecraft/class_1713;", "clickType", "Lnet/minecraft/class_1657;", "player", "clicked", "(IILnet/minecraft/class_1713;Lnet/minecraft/class_1657;)V", "index", "Lnet/minecraft/class_1799;", "quickMoveStack", "(Lnet/minecraft/class_1657;I)Lnet/minecraft/class_1799;", "Lnet/minecraft/class_3222;", "pokemon-league-mod"})
    public static final class RewardsConfigContainer
    extends class_1707 {
        @NotNull
        private final class_3222 serverPlayer;

        public RewardsConfigContainer(int containerId, @NotNull class_1661 playerInventory, @NotNull class_3222 serverPlayer) {
            Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
            Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
            super(class_3917.field_17326, containerId, playerInventory, (class_1263)new class_1277(27), 3);
            this.serverPlayer = serverPlayer;
            this.setupItems();
        }

        private final void setupItems() {
            TournamentSession tournament;
            class_1263 container = this.method_7629();
            TournamentSession tournamentSession = tournament = TournamentManager.INSTANCE.getActiveTournament();
            RuntimeRewards rewards = tournamentSession != null ? tournamentSession.getRuntimeRewards() : null;
            class_1799 filler = new class_1799((class_1935)class_1802.field_8871);
            filler.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)" "));
            for (int i = 0; i < 27; ++i) {
                container.method_5447(i, filler.method_7972());
            }
            class_1799 first = new class_1799((class_1935)class_1802.field_8494);
            class_124[] class_124Array = new class_124[]{class_124.field_1065, class_124.field_1067};
            first.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"1ere Place").method_27695(class_124Array));
            Object object = rewards;
            int firstCount = object != null && (object = ((RuntimeRewards)object).getFirstPlace()) != null ? object.size() : 0;
            Object[] objectArray = new class_5250[]{class_2561.method_43470((String)(firstCount + " items configures")).method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour configurer").method_27692(class_124.field_1054)};
            first.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray)));
            container.method_5447(11, first);
            class_1799 second = new class_1799((class_1935)class_1802.field_8773);
            class_124[] class_124Array2 = new class_124[]{class_124.field_1068, class_124.field_1067};
            second.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"2eme Place").method_27695(class_124Array2));
            Object object2 = rewards;
            int secondCount = object2 != null && (object2 = ((RuntimeRewards)object2).getSecondPlace()) != null ? object2.size() : 0;
            Object[] objectArray2 = new class_5250[]{class_2561.method_43470((String)(secondCount + " items configures")).method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour configurer").method_27692(class_124.field_1054)};
            second.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray2)));
            container.method_5447(13, second);
            class_1799 third = new class_1799((class_1935)class_1802.field_27071);
            third.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"3eme Place").method_27692(class_124.field_1065));
            Object object3 = rewards;
            int thirdCount = object3 != null && (object3 = ((RuntimeRewards)object3).getThirdPlace()) != null ? object3.size() : 0;
            Object[] objectArray3 = new class_5250[]{class_2561.method_43470((String)(thirdCount + " items configures")).method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43470((String)"Cliquez pour configurer").method_27692(class_124.field_1054)};
            third.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])objectArray3)));
            container.method_5447(15, third);
            class_1799 info = new class_1799((class_1935)class_1802.field_8529);
            info.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Information").method_27692(class_124.field_1075));
            if (tournament != null) {
                var12_15 = new class_5250[]{class_2561.method_43470((String)("Tournoi: " + tournament.getName())).method_27692(class_124.field_1068), class_2561.method_43473(), class_2561.method_43470((String)"Placez les items dans le chest").method_27692(class_124.field_1080), class_2561.method_43470((String)"pour definir les recompenses").method_27692(class_124.field_1080)};
                v4 = (class_9290)info.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])var12_15)));
            } else {
                var12_15 = new class_5250[]{class_2561.method_43470((String)"Aucun tournoi actif!").method_27692(class_124.field_1061), class_2561.method_43470((String)"Creez d'abord un tournoi").method_27692(class_124.field_1080)};
                v4 = (class_9290)info.method_57379(class_9334.field_49632, (Object)new class_9290(CollectionsKt.listOf((Object[])var12_15)));
            }
            container.method_5447(4, info);
            class_1799 backButton = new class_1799((class_1935)class_1802.field_8107);
            backButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Retour").method_27692(class_124.field_1080));
            container.method_5447(18, backButton);
            class_1799 closeButton = new class_1799((class_1935)class_1802.field_8077);
            closeButton.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Fermer").method_27692(class_124.field_1061));
            container.method_5447(26, closeButton);
        }

        public void method_7593(int slotId, int button, @NotNull class_1713 clickType, @NotNull class_1657 player) {
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (slotId < 0 || slotId >= 27) {
                super.method_7593(slotId, button, clickType, player);
                return;
            }
            TournamentSession tournament = TournamentManager.INSTANCE.getActiveTournament();
            if (tournament == null && CollectionsKt.listOf((Object[])(objectArray = new Integer[]{11, 13, 15})).contains(slotId)) {
                this.serverPlayer.method_43496((class_2561)class_2561.method_43470((String)"Creez d'abord un tournoi!").method_27694(RewardsConfigContainer::clicked$lambda$0));
                return;
            }
            switch (slotId) {
                case 11: {
                    this.serverPlayer.method_7346();
                    INSTANCE.openRewardChestMenu(this.serverPlayer, 1);
                    break;
                }
                case 13: {
                    this.serverPlayer.method_7346();
                    INSTANCE.openRewardChestMenu(this.serverPlayer, 2);
                    break;
                }
                case 15: {
                    this.serverPlayer.method_7346();
                    INSTANCE.openRewardChestMenu(this.serverPlayer, 3);
                    break;
                }
                case 18: {
                    this.serverPlayer.method_7346();
                    INSTANCE.openAdminMenu(this.serverPlayer);
                    break;
                }
                case 26: {
                    this.serverPlayer.method_7346();
                }
            }
        }

        @NotNull
        public class_1799 method_7601(@NotNull class_1657 player, int index) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            class_1799 class_17992 = class_1799.field_8037;
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
            return class_17992;
        }

        private static final class_2583 clicked$lambda$0(class_2583 it) {
            return it.method_36139(0xFF5555);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0015\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J:\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0018\u001a\u00020\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\bH\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u0013J\u0010\u0010\u001b\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\rR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\r\"\u0004\b\u001e\u0010\u001fR$\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010 \u001a\u0004\b!\u0010\u000f\"\u0004\b\"\u0010#R\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010$\u001a\u0004\b%\u0010\u0011\"\u0004\b&\u0010'R\"\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010(\u001a\u0004\b)\u0010\u0013\"\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lcom/music176/pokemonleague/tournament/TournamentGUI$TournamentCreationState;", "", "", "name", "Lcom/music176/pokemonleague/tournament/TournamentMode;", "mode", "Lcom/music176/pokemonleague/tournament/RoundFormats;", "roundFormats", "", "maxParticipants", "<init>", "(Ljava/lang/String;Lcom/music176/pokemonleague/tournament/TournamentMode;Lcom/music176/pokemonleague/tournament/RoundFormats;I)V", "component1", "()Ljava/lang/String;", "component2", "()Lcom/music176/pokemonleague/tournament/TournamentMode;", "component3", "()Lcom/music176/pokemonleague/tournament/RoundFormats;", "component4", "()I", "copy", "(Ljava/lang/String;Lcom/music176/pokemonleague/tournament/TournamentMode;Lcom/music176/pokemonleague/tournament/RoundFormats;I)Lcom/music176/pokemonleague/tournament/TournamentGUI$TournamentCreationState;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getName", "setName", "(Ljava/lang/String;)V", "Lcom/music176/pokemonleague/tournament/TournamentMode;", "getMode", "setMode", "(Lcom/music176/pokemonleague/tournament/TournamentMode;)V", "Lcom/music176/pokemonleague/tournament/RoundFormats;", "getRoundFormats", "setRoundFormats", "(Lcom/music176/pokemonleague/tournament/RoundFormats;)V", "I", "getMaxParticipants", "setMaxParticipants", "(I)V", "pokemon-league-mod"})
    public static final class TournamentCreationState {
        @NotNull
        private String name;
        @Nullable
        private TournamentMode mode;
        @NotNull
        private RoundFormats roundFormats;
        private int maxParticipants;

        public TournamentCreationState(@NotNull String name, @Nullable TournamentMode mode, @NotNull RoundFormats roundFormats, int maxParticipants) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)roundFormats, (String)"roundFormats");
            this.name = name;
            this.mode = mode;
            this.roundFormats = roundFormats;
            this.maxParticipants = maxParticipants;
        }

        public /* synthetic */ TournamentCreationState(String string, TournamentMode tournamentMode, RoundFormats roundFormats, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = "Tournoi";
            }
            if ((n2 & 2) != 0) {
                tournamentMode = null;
            }
            if ((n2 & 4) != 0) {
                roundFormats = new RoundFormats(null, null, null, 7, null);
            }
            if ((n2 & 8) != 0) {
                n = 32;
            }
            this(string, tournamentMode, roundFormats, n);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        @Nullable
        public final TournamentMode getMode() {
            return this.mode;
        }

        public final void setMode(@Nullable TournamentMode tournamentMode) {
            this.mode = tournamentMode;
        }

        @NotNull
        public final RoundFormats getRoundFormats() {
            return this.roundFormats;
        }

        public final void setRoundFormats(@NotNull RoundFormats roundFormats) {
            Intrinsics.checkNotNullParameter((Object)roundFormats, (String)"<set-?>");
            this.roundFormats = roundFormats;
        }

        public final int getMaxParticipants() {
            return this.maxParticipants;
        }

        public final void setMaxParticipants(int n) {
            this.maxParticipants = n;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final TournamentMode component2() {
            return this.mode;
        }

        @NotNull
        public final RoundFormats component3() {
            return this.roundFormats;
        }

        public final int component4() {
            return this.maxParticipants;
        }

        @NotNull
        public final TournamentCreationState copy(@NotNull String name, @Nullable TournamentMode mode, @NotNull RoundFormats roundFormats, int maxParticipants) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)roundFormats, (String)"roundFormats");
            return new TournamentCreationState(name, mode, roundFormats, maxParticipants);
        }

        public static /* synthetic */ TournamentCreationState copy$default(TournamentCreationState tournamentCreationState, String string, TournamentMode tournamentMode, RoundFormats roundFormats, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = tournamentCreationState.name;
            }
            if ((n2 & 2) != 0) {
                tournamentMode = tournamentCreationState.mode;
            }
            if ((n2 & 4) != 0) {
                roundFormats = tournamentCreationState.roundFormats;
            }
            if ((n2 & 8) != 0) {
                n = tournamentCreationState.maxParticipants;
            }
            return tournamentCreationState.copy(string, tournamentMode, roundFormats, n);
        }

        @NotNull
        public String toString() {
            return "TournamentCreationState(name=" + this.name + ", mode=" + this.mode + ", roundFormats=" + this.roundFormats + ", maxParticipants=" + this.maxParticipants + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + (this.mode == null ? 0 : this.mode.hashCode());
            result = result * 31 + this.roundFormats.hashCode();
            result = result * 31 + Integer.hashCode(this.maxParticipants);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TournamentCreationState)) {
                return false;
            }
            TournamentCreationState tournamentCreationState = (TournamentCreationState)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)tournamentCreationState.name)) {
                return false;
            }
            if (this.mode != tournamentCreationState.mode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.roundFormats, (Object)tournamentCreationState.roundFormats)) {
                return false;
            }
            return this.maxParticipants == tournamentCreationState.maxParticipants;
        }

        public TournamentCreationState() {
            this(null, null, null, 0, 15, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PositionSetType.values().length];
            try {
                nArray[PositionSetType.ARENA_1_PLAYER1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionSetType.ARENA_1_PLAYER2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionSetType.ARENA_2_PLAYER1.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionSetType.ARENA_2_PLAYER2.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionSetType.ARENA_3_PLAYER1.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionSetType.ARENA_3_PLAYER2.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionSetType.ARENA_4_PLAYER1.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionSetType.ARENA_4_PLAYER2.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionSetType.WAITING_ROOM.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionSetType.SPECTATOR_AREA.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionSetType.END_ZONE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionSetType.PODIUM_1.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionSetType.PODIUM_2.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionSetType.PODIUM_3.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

