/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.tournament;

import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.duel.BestOf;
import com.music176.pokemonleague.tournament.BracketRound;
import com.music176.pokemonleague.tournament.BracketType;
import com.music176.pokemonleague.tournament.MatchState;
import com.music176.pokemonleague.tournament.RoundFormats;
import com.music176.pokemonleague.tournament.TournamentMatch;
import com.music176.pokemonleague.tournament.TournamentParticipant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u001c\u0018\u0000 Y2\u00020\u0001:\u0001YB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\u000e\u001a\u00020\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0014\u001a\u00020\r2\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u000fJ\u0017\u0010\u0015\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\b\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010!\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\tH\u0002\u00a2\u0006\u0004\b!\u0010\"J'\u0010&\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010(\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\tH\u0002\u00a2\u0006\u0004\b(\u0010\"J'\u0010)\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\t2\u0006\u0010%\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b)\u0010*J\r\u0010,\u001a\u00020+\u00a2\u0006\u0004\b,\u0010-J%\u0010/\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\t0.\u00a2\u0006\u0004\b/\u00100J\u0017\u00102\u001a\u0004\u0018\u00010\u001a2\u0006\u00101\u001a\u00020\u0002\u00a2\u0006\u0004\b2\u00103J\u0017\u00105\u001a\u0004\u0018\u00010\u001a2\u0006\u00104\u001a\u00020\u0002\u00a2\u0006\u0004\b5\u00103J\u0013\u00106\u001a\b\u0012\u0004\u0012\u00020\u001a0\b\u00a2\u0006\u0004\b6\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00107\u001a\u0004\b8\u00109R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010:\u001a\u0004\b;\u0010<R\u001d\u0010?\u001a\b\u0012\u0004\u0012\u00020>0=8\u0006\u00a2\u0006\f\n\u0004\b?\u0010@\u001a\u0004\bA\u0010\u001cR\u001d\u0010B\u001a\b\u0012\u0004\u0012\u00020>0=8\u0006\u00a2\u0006\f\n\u0004\bB\u0010@\u001a\u0004\bC\u0010\u001cR$\u0010D\u001a\u0004\u0018\u00010\u001a8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bD\u0010E\u001a\u0004\bF\u0010G\"\u0004\bH\u0010\u001fR$\u0010I\u001a\u0004\u0018\u00010\u001a8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bI\u0010E\u001a\u0004\bJ\u0010G\"\u0004\bK\u0010\u001fR$\u0010L\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bL\u0010M\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR$\u0010R\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bR\u0010M\u001a\u0004\bS\u0010O\"\u0004\bT\u0010QR\u0017\u0010U\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\bU\u0010:\u001a\u0004\bV\u0010<R\u0017\u0010W\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\bW\u0010:\u001a\u0004\bX\u0010<\u00a8\u0006Z"}, d2={"Lcom/music176/pokemonleague/tournament/TournamentBracket;", "", "Ljava/util/UUID;", "tournamentId", "", "participantCount", "<init>", "(Ljava/util/UUID;I)V", "", "Lcom/music176/pokemonleague/tournament/TournamentParticipant;", "participants", "Lcom/music176/pokemonleague/tournament/RoundFormats;", "formats", "", "generate", "(Ljava/util/List;Lcom/music176/pokemonleague/tournament/RoundFormats;)V", "size", "generateSeedOrder", "(I)Ljava/util/List;", "seeded", "generateWinnerBracket", "generateLoserBracket", "(Lcom/music176/pokemonleague/tournament/RoundFormats;)V", "setupGrandFinal", "processInitialByes", "()V", "Lcom/music176/pokemonleague/tournament/TournamentMatch;", "getReadyMatches", "()Ljava/util/List;", "match", "advanceWinner", "(Lcom/music176/pokemonleague/tournament/TournamentMatch;)V", "winner", "advanceWinnerInWinnerBracket", "(Lcom/music176/pokemonleague/tournament/TournamentMatch;Lcom/music176/pokemonleague/tournament/TournamentParticipant;)V", "fromWinnerRound", "matchIndex", "loser", "dropToLoserBracket", "(IILcom/music176/pokemonleague/tournament/TournamentParticipant;)V", "advanceWinnerInLoserBracket", "handleGrandFinalResult", "(Lcom/music176/pokemonleague/tournament/TournamentMatch;Lcom/music176/pokemonleague/tournament/TournamentParticipant;Lcom/music176/pokemonleague/tournament/TournamentParticipant;)V", "", "isTournamentComplete", "()Z", "Lkotlin/Triple;", "getPlacements", "()Lkotlin/Triple;", "matchId", "findMatch", "(Ljava/util/UUID;)Lcom/music176/pokemonleague/tournament/TournamentMatch;", "playerId", "findMatchForPlayer", "getAllMatches", "Ljava/util/UUID;", "getTournamentId", "()Ljava/util/UUID;", "I", "getParticipantCount", "()I", "", "Lcom/music176/pokemonleague/tournament/BracketRound;", "winnerBracket", "Ljava/util/List;", "getWinnerBracket", "loserBracket", "getLoserBracket", "grandFinal", "Lcom/music176/pokemonleague/tournament/TournamentMatch;", "getGrandFinal", "()Lcom/music176/pokemonleague/tournament/TournamentMatch;", "setGrandFinal", "grandFinalReset", "getGrandFinalReset", "setGrandFinalReset", "winnerBracketChampion", "Lcom/music176/pokemonleague/tournament/TournamentParticipant;", "getWinnerBracketChampion", "()Lcom/music176/pokemonleague/tournament/TournamentParticipant;", "setWinnerBracketChampion", "(Lcom/music176/pokemonleague/tournament/TournamentParticipant;)V", "loserBracketChampion", "getLoserBracketChampion", "setLoserBracketChampion", "bracketSize", "getBracketSize", "byeCount", "getByeCount", "Companion", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nTournamentBracket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TournamentBracket.kt\ncom/music176/pokemonleague/tournament/TournamentBracket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,619:1\n1573#2:620\n1604#2,4:621\n1878#2,3:626\n1869#2,2:629\n360#2,7:631\n1869#2,2:638\n1869#2,2:640\n1#3:625\n*S KotlinDebug\n*F\n+ 1 TournamentBracket.kt\ncom/music176/pokemonleague/tournament/TournamentBracket\n*L\n56#1:620\n56#1:621,4\n68#1:626,3\n292#1:629,2\n445#1:631,7\n600#1:638,2\n601#1:640,2\n*E\n"})
public final class TournamentBracket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID tournamentId;
    private final int participantCount;
    @NotNull
    private final List<BracketRound> winnerBracket;
    @NotNull
    private final List<BracketRound> loserBracket;
    @Nullable
    private TournamentMatch grandFinal;
    @Nullable
    private TournamentMatch grandFinalReset;
    @Nullable
    private TournamentParticipant winnerBracketChampion;
    @Nullable
    private TournamentParticipant loserBracketChampion;
    private final int bracketSize;
    private final int byeCount;

    public TournamentBracket(@NotNull UUID tournamentId, int participantCount) {
        Intrinsics.checkNotNullParameter((Object)tournamentId, (String)"tournamentId");
        this.tournamentId = tournamentId;
        this.participantCount = participantCount;
        this.winnerBracket = new ArrayList();
        this.loserBracket = new ArrayList();
        this.bracketSize = Companion.nextPowerOfTwo(this.participantCount);
        this.byeCount = this.bracketSize - this.participantCount;
    }

    @NotNull
    public final UUID getTournamentId() {
        return this.tournamentId;
    }

    public final int getParticipantCount() {
        return this.participantCount;
    }

    @NotNull
    public final List<BracketRound> getWinnerBracket() {
        return this.winnerBracket;
    }

    @NotNull
    public final List<BracketRound> getLoserBracket() {
        return this.loserBracket;
    }

    @Nullable
    public final TournamentMatch getGrandFinal() {
        return this.grandFinal;
    }

    public final void setGrandFinal(@Nullable TournamentMatch tournamentMatch) {
        this.grandFinal = tournamentMatch;
    }

    @Nullable
    public final TournamentMatch getGrandFinalReset() {
        return this.grandFinalReset;
    }

    public final void setGrandFinalReset(@Nullable TournamentMatch tournamentMatch) {
        this.grandFinalReset = tournamentMatch;
    }

    @Nullable
    public final TournamentParticipant getWinnerBracketChampion() {
        return this.winnerBracketChampion;
    }

    public final void setWinnerBracketChampion(@Nullable TournamentParticipant tournamentParticipant) {
        this.winnerBracketChampion = tournamentParticipant;
    }

    @Nullable
    public final TournamentParticipant getLoserBracketChampion() {
        return this.loserBracketChampion;
    }

    public final void setLoserBracketChampion(@Nullable TournamentParticipant tournamentParticipant) {
        this.loserBracketChampion = tournamentParticipant;
    }

    public final int getBracketSize() {
        return this.bracketSize;
    }

    public final int getByeCount() {
        return this.byeCount;
    }

    /*
     * WARNING - void declaration
     */
    public final void generate(@NotNull List<TournamentParticipant> participants, @NotNull RoundFormats formats) {
        ArrayList<TournamentParticipant> arrayList;
        int n;
        void $this$mapIndexedTo$iv$iv2;
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)formats, (String)"formats");
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Generating bracket for " + participants.size() + " participants (bracket size: " + this.bracketSize + ")");
        Iterable $this$mapIndexed$iv = CollectionsKt.shuffled((Iterable)participants);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        ArrayList<TournamentParticipant> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        int $i$f$mapIndexedTo = 0;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv2) {
            void index;
            void p;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TournamentParticipant tournamentParticipant = (TournamentParticipant)item$iv$iv;
            int n2 = n;
            arrayList = destination$iv$iv;
            boolean bl = false;
            arrayList.add(TournamentParticipant.copy$default((TournamentParticipant)p, null, null, null, null, null, 0.0, 0.0, 0.0, 0.0f, 0.0f, 0, false, null, (int)(index + true), null, 24575, null));
        }
        List shuffled = destination$iv$iv;
        List<Integer> seedOrder = this.generateSeedOrder(this.bracketSize);
        int $this$mapIndexedTo$iv$iv2 = this.bracketSize;
        destination$iv$iv = new ArrayList<TournamentParticipant>($this$mapIndexedTo$iv$iv2);
        $i$f$mapIndexedTo = 0;
        while ($i$f$mapIndexedTo < $this$mapIndexedTo$iv$iv2) {
            int n3;
            int n4 = n3 = $i$f$mapIndexedTo++;
            arrayList = destination$iv$iv;
            boolean bl = false;
            arrayList.add(null);
        }
        List seeded = destination$iv$iv;
        Iterable $this$forEachIndexed$iv = seedOrder;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void seedNumber;
            int n5;
            if ((n5 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            n = ((Number)item$iv).intValue();
            int position = n5;
            boolean bl = false;
            if (seedNumber > shuffled.size()) continue;
            seeded.set(position, shuffled.get((int)(seedNumber - true)));
        }
        this.generateWinnerBracket(seeded, formats);
        this.generateLoserBracket(formats);
        this.setupGrandFinal(formats);
        this.processInitialByes();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Bracket generated: " + this.winnerBracket.size() + " winner rounds, " + this.loserBracket.size() + " loser rounds");
    }

    private final List<Integer> generateSeedOrder(int size) {
        if (size == 1) {
            return CollectionsKt.listOf((Object)1);
        }
        if (size == 2) {
            Object[] objectArray = new Integer[]{1, 2};
            return CollectionsKt.listOf((Object[])objectArray);
        }
        Object[] objectArray = new Integer[]{1, 2};
        List order = CollectionsKt.mutableListOf((Object[])objectArray);
        int currentSize = 2;
        while (currentSize < size) {
            int nextSize = currentSize * 2;
            List newOrder = new ArrayList();
            Iterator iterator = order.iterator();
            while (iterator.hasNext()) {
                int seed = ((Number)iterator.next()).intValue();
                newOrder.add(seed);
                newOrder.add(nextSize + 1 - seed);
            }
            order = newOrder;
            currentSize = nextSize;
        }
        return order;
    }

    private final void generateWinnerBracket(List<TournamentParticipant> seeded, RoundFormats formats) {
        List currentParticipants = seeded;
        int roundNumber = 1;
        while (currentParticipants.size() > 1) {
            List matches = new ArrayList();
            BestOf bestOf = formats.getWinnerFormat(roundNumber);
            int i = 0;
            int n = ((Collection)currentParticipants).size() + -1;
            int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
            if (i <= n2) {
                while (true) {
                    TournamentMatch match = new TournamentMatch(null, roundNumber, BracketType.WINNER, i / 2, currentParticipants.get(i), (TournamentParticipant)CollectionsKt.getOrNull(currentParticipants, (int)(i + 1)), null, null, bestOf, 0, 0, 0, null, null, null, null, 0L, 130753, null);
                    matches.add(match);
                    if (i == n2) break;
                    i += 2;
                }
            }
            this.winnerBracket.add(new BracketRound(roundNumber, BracketType.WINNER, matches));
            n = currentParticipants.size() / 2;
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                ArrayList<Object> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(null);
            }
            currentParticipants = arrayList;
            ++roundNumber;
        }
    }

    private final void generateLoserBracket(RoundFormats formats) {
        int losersFromPreviousWinnerRound;
        if (this.winnerBracket.isEmpty()) {
            return;
        }
        int winnerRoundCount = this.winnerBracket.size();
        int loserRoundNumber = 1;
        int currentLoserCount = losersFromPreviousWinnerRound = this.bracketSize / 2;
        int winnerRound = 1;
        if (winnerRound <= winnerRoundCount) {
            while (true) {
                if (winnerRound == 1) {
                    int matchCount = currentLoserCount / 2;
                    List matches = new ArrayList();
                    BestOf bestOf = formats.getLoserFormat(loserRoundNumber);
                    for (int i = 0; i < matchCount; ++i) {
                        matches.add(new TournamentMatch(null, loserRoundNumber, BracketType.LOSER, i, null, null, null, null, bestOf, 0, 0, 0, null, null, null, null, 0L, 130801, null));
                    }
                    if (!((Collection)matches).isEmpty()) {
                        this.loserBracket.add(new BracketRound(loserRoundNumber, BracketType.LOSER, matches));
                        ++loserRoundNumber;
                        currentLoserCount = matchCount;
                    }
                }
                if (winnerRound > 1 && winnerRound < winnerRoundCount) {
                    int droppersCount = this.winnerBracket.get(winnerRound - 1).getMatches().size();
                    int feedInMatchCount = Math.min(currentLoserCount, droppersCount);
                    if (feedInMatchCount > 0) {
                        List feedInMatches = new ArrayList();
                        BestOf bestOf = formats.getLoserFormat(loserRoundNumber);
                        for (int i = 0; i < feedInMatchCount; ++i) {
                            feedInMatches.add(new TournamentMatch(null, loserRoundNumber, BracketType.LOSER, i, null, null, null, null, bestOf, 0, 0, 0, null, null, null, null, 0L, 130801, null));
                        }
                        this.loserBracket.add(new BracketRound(loserRoundNumber, BracketType.LOSER, feedInMatches));
                        ++loserRoundNumber;
                        currentLoserCount = feedInMatchCount;
                    }
                    if (currentLoserCount > 1) {
                        int reductionMatchCount = currentLoserCount / 2;
                        List reductionMatches = new ArrayList();
                        BestOf bestOf = formats.getLoserFormat(loserRoundNumber);
                        for (int i = 0; i < reductionMatchCount; ++i) {
                            reductionMatches.add(new TournamentMatch(null, loserRoundNumber, BracketType.LOSER, i, null, null, null, null, bestOf, 0, 0, 0, null, null, null, null, 0L, 130801, null));
                        }
                        if (!((Collection)reductionMatches).isEmpty()) {
                            this.loserBracket.add(new BracketRound(loserRoundNumber, BracketType.LOSER, reductionMatches));
                            ++loserRoundNumber;
                            currentLoserCount = reductionMatchCount;
                        }
                    }
                }
                if (winnerRound == winnerRoundCount) break;
                ++winnerRound;
            }
        }
        if (currentLoserCount >= 1 && winnerRoundCount > 1) {
            TournamentMatch finalMatch = new TournamentMatch(null, loserRoundNumber, BracketType.LOSER, 0, null, null, null, null, formats.getLoserFormat(loserRoundNumber), 0, 0, 0, null, null, null, null, 0L, 130801, null);
            Object[] objectArray = new TournamentMatch[]{finalMatch};
            this.loserBracket.add(new BracketRound(loserRoundNumber, BracketType.LOSER, CollectionsKt.mutableListOf((Object[])objectArray)));
        }
    }

    private final void setupGrandFinal(RoundFormats formats) {
        this.grandFinal = new TournamentMatch(null, 0, BracketType.GRAND_FINAL, 0, null, null, null, null, formats.getGrandFinal(), 0, 0, 0, null, null, null, null, 0L, 130801, null);
    }

    private final void processInitialByes() {
        block2: {
            Object object = (BracketRound)CollectionsKt.firstOrNull(this.winnerBracket);
            if (object == null || (object = ((BracketRound)object).getMatches()) == null) break block2;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TournamentParticipant winner;
                TournamentMatch match = (TournamentMatch)element$iv;
                boolean bl = false;
                if (!match.isBye()) continue;
                TournamentParticipant tournamentParticipant = match.getParticipant1();
                if (tournamentParticipant == null) {
                    tournamentParticipant = match.getParticipant2();
                }
                if ((winner = tournamentParticipant) == null) continue;
                match.setWinner(winner);
                match.setState(MatchState.COMPLETED);
                this.advanceWinnerInWinnerBracket(match, winner);
                PokemonLeagueMod.INSTANCE.getLOGGER().info("Bye: " + winner.getDisplayName() + " advances automatically");
            }
        }
    }

    @NotNull
    public final List<TournamentMatch> getReadyMatches() {
        List ready;
        block7: {
            TournamentMatch it;
            ready = new ArrayList();
            for (BracketRound round : this.winnerBracket) {
                for (TournamentMatch match : round.getMatches()) {
                    if (!match.isReady() || match.isBye() || match.getState() != MatchState.PENDING) continue;
                    ready.add(match);
                }
            }
            for (BracketRound round : this.loserBracket) {
                for (TournamentMatch match : round.getMatches()) {
                    if (!match.isReady() || match.getState() != MatchState.PENDING) continue;
                    ready.add(match);
                }
            }
            TournamentMatch tournamentMatch = this.grandFinal;
            if (tournamentMatch != null) {
                it = tournamentMatch;
                boolean bl = false;
                if (it.isReady() && it.getState() == MatchState.PENDING) {
                    ready.add(it);
                }
            }
            TournamentMatch tournamentMatch2 = this.grandFinalReset;
            if (tournamentMatch2 == null) break block7;
            it = tournamentMatch2;
            boolean bl = false;
            if (it.isReady() && it.getState() == MatchState.PENDING) {
                ready.add(it);
            }
        }
        return ready;
    }

    public final void advanceWinner(@NotNull TournamentMatch match) {
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        TournamentParticipant tournamentParticipant = match.getWinner();
        if (tournamentParticipant == null) {
            return;
        }
        TournamentParticipant winner = tournamentParticipant;
        TournamentParticipant tournamentParticipant2 = match.getLoser();
        if (tournamentParticipant2 == null) {
            return;
        }
        TournamentParticipant loser = tournamentParticipant2;
        switch (WhenMappings.$EnumSwitchMapping$0[match.getBracketType().ordinal()]) {
            case 1: {
                this.advanceWinnerInWinnerBracket(match, winner);
                loser.recordLoss();
                this.dropToLoserBracket(match.getRoundNumber(), match.getMatchIndex(), loser);
                break;
            }
            case 2: {
                this.advanceWinnerInLoserBracket(match, winner);
                loser.recordLoss();
                PokemonLeagueMod.INSTANCE.getLOGGER().info(loser.getDisplayName() + " eliminated from tournament");
                break;
            }
            case 3: {
                this.handleGrandFinalResult(match, winner, loser);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void advanceWinnerInWinnerBracket(TournamentMatch match, TournamentParticipant winner) {
        int nextRoundIndex = match.getRoundNumber();
        if (nextRoundIndex >= this.winnerBracket.size()) {
            this.winnerBracketChampion = winner;
            TournamentMatch tournamentMatch = this.grandFinal;
            if (tournamentMatch != null) {
                tournamentMatch.setParticipant1(winner);
            }
            PokemonLeagueMod.INSTANCE.getLOGGER().info(winner.getDisplayName() + " is the Winner Bracket Champion!");
            return;
        }
        BracketRound nextRound = this.winnerBracket.get(nextRoundIndex);
        int nextMatchIndex = match.getMatchIndex() / 2;
        TournamentMatch nextMatch = (TournamentMatch)CollectionsKt.getOrNull(nextRound.getMatches(), (int)nextMatchIndex);
        if (nextMatch != null) {
            if (match.getMatchIndex() % 2 == 0) {
                nextMatch.setParticipant1(winner);
            } else {
                nextMatch.setParticipant2(winner);
            }
            PokemonLeagueMod.INSTANCE.getLOGGER().info(winner.getDisplayName() + " advances to Winner R" + (nextRoundIndex + 1));
        }
    }

    private final void dropToLoserBracket(int fromWinnerRound, int matchIndex, TournamentParticipant loser) {
        int targetLoserRound;
        if (this.loserBracket.isEmpty()) {
            return;
        }
        if (fromWinnerRound == 1) {
            v0 = 0;
        } else {
            int feedInRoundIndex = (fromWinnerRound - 1) * 2 - 1;
            v0 = targetLoserRound = Math.min(feedInRoundIndex, this.loserBracket.size() - 1);
        }
        if (targetLoserRound >= 0 && targetLoserRound < this.loserBracket.size()) {
            BracketRound loserRound = this.loserBracket.get(targetLoserRound);
            int targetMatchIndex = matchIndex / 2;
            TournamentMatch targetMatch = (TournamentMatch)CollectionsKt.getOrNull(loserRound.getMatches(), (int)targetMatchIndex);
            if (targetMatch != null) {
                if (targetMatch.getParticipant1() == null) {
                    targetMatch.setParticipant1(loser);
                } else if (targetMatch.getParticipant2() == null) {
                    targetMatch.setParticipant2(loser);
                }
                PokemonLeagueMod.INSTANCE.getLOGGER().info(loser.getDisplayName() + " drops to Loser R" + (targetLoserRound + 1));
            }
        }
    }

    private final void advanceWinnerInLoserBracket(TournamentMatch match, TournamentParticipant winner) {
        TournamentMatch nextMatch;
        int currentRoundIndex;
        block10: {
            int n;
            List<BracketRound> $this$indexOfFirst$iv = this.loserBracket;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<BracketRound> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                BracketRound item$iv;
                BracketRound it = item$iv = iterator.next();
                boolean bl = false;
                if (it.getRoundNumber() == match.getRoundNumber()) {
                    n = index$iv;
                    break block10;
                }
                ++index$iv;
            }
            n = currentRoundIndex = -1;
        }
        if (currentRoundIndex < 0) {
            return;
        }
        int nextRoundIndex = currentRoundIndex + 1;
        if (nextRoundIndex >= this.loserBracket.size()) {
            this.loserBracketChampion = winner;
            TournamentMatch tournamentMatch = this.grandFinal;
            if (tournamentMatch != null) {
                tournamentMatch.setParticipant2(winner);
            }
            PokemonLeagueMod.INSTANCE.getLOGGER().info(winner.getDisplayName() + " is the Loser Bracket Champion!");
            return;
        }
        BracketRound nextRound = this.loserBracket.get(nextRoundIndex);
        int nextMatchIndex = match.getMatchIndex() / 2;
        TournamentMatch tournamentMatch = (TournamentMatch)CollectionsKt.getOrNull(nextRound.getMatches(), (int)nextMatchIndex);
        if (tournamentMatch == null) {
            tournamentMatch = (TournamentMatch)CollectionsKt.getOrNull(nextRound.getMatches(), (int)0);
        }
        if ((nextMatch = tournamentMatch) != null) {
            if (nextMatch.getParticipant1() == null) {
                nextMatch.setParticipant1(winner);
            } else if (nextMatch.getParticipant2() == null) {
                nextMatch.setParticipant2(winner);
            }
            PokemonLeagueMod.INSTANCE.getLOGGER().info(winner.getDisplayName() + " advances in Loser Bracket");
        }
    }

    private final void handleGrandFinalResult(TournamentMatch match, TournamentParticipant winner, TournamentParticipant loser) {
        if (Intrinsics.areEqual((Object)winner, (Object)this.winnerBracketChampion)) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info(winner.getDisplayName() + " wins the tournament (Winner Bracket)!");
        } else if (this.grandFinalReset == null) {
            this.grandFinalReset = new TournamentMatch(null, 0, BracketType.GRAND_FINAL, 1, winner, loser, null, null, match.getBestOf(), 0, 0, 0, null, null, null, null, 0L, 130753, null);
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Bracket reset! " + winner.getDisplayName() + " forced a final match!");
        } else {
            PokemonLeagueMod.INSTANCE.getLOGGER().info(winner.getDisplayName() + " wins the tournament after bracket reset!");
        }
    }

    public final boolean isTournamentComplete() {
        TournamentMatch tournamentMatch = this.grandFinal;
        if (tournamentMatch != null) {
            TournamentMatch gf = tournamentMatch;
            boolean bl = false;
            if (gf.isComplete()) {
                if (Intrinsics.areEqual((Object)gf.getWinner(), (Object)this.winnerBracketChampion)) {
                    return true;
                }
                TournamentMatch tournamentMatch2 = this.grandFinalReset;
                if (tournamentMatch2 != null) {
                    TournamentMatch reset = tournamentMatch2;
                    boolean bl2 = false;
                    return reset.isComplete();
                }
            }
        }
        return false;
    }

    @NotNull
    public final Triple<TournamentParticipant, TournamentParticipant, TournamentParticipant> getPlacements() {
        TournamentMatch finalMatch;
        TournamentMatch tournamentMatch = this.grandFinalReset;
        if (tournamentMatch == null) {
            tournamentMatch = this.grandFinal;
        }
        TournamentMatch tournamentMatch2 = finalMatch = tournamentMatch;
        TournamentParticipant first = tournamentMatch2 != null ? tournamentMatch2.getWinner() : null;
        TournamentMatch tournamentMatch3 = finalMatch;
        TournamentParticipant second = tournamentMatch3 != null ? tournamentMatch3.getLoser() : null;
        Object object = (BracketRound)CollectionsKt.lastOrNull(this.loserBracket);
        TournamentParticipant third = object != null && (object = ((BracketRound)object).getMatches()) != null && (object = (TournamentMatch)CollectionsKt.firstOrNull((List)object)) != null ? ((TournamentMatch)object).getLoser() : null;
        return new Triple((Object)first, (Object)second, (Object)third);
    }

    @Nullable
    public final TournamentMatch findMatch(@NotNull UUID matchId) {
        TournamentMatch match;
        TournamentMatch it;
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)matchId, (String)"matchId");
        for (BracketRound round : this.winnerBracket) {
            Object v0;
            block6: {
                iterable = round.getMatches();
                for (Object t : iterable) {
                    it = (TournamentMatch)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getMatchId(), (Object)matchId)) continue;
                    v0 = t;
                    break block6;
                }
                v0 = null;
            }
            TournamentMatch tournamentMatch = match = (TournamentMatch)v0;
            if (tournamentMatch == null) continue;
            return tournamentMatch;
        }
        for (BracketRound round : this.loserBracket) {
            Object v2;
            block7: {
                iterable = round.getMatches();
                for (Object t : iterable) {
                    it = (TournamentMatch)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getMatchId(), (Object)matchId)) continue;
                    v2 = t;
                    break block7;
                }
                v2 = null;
            }
            TournamentMatch tournamentMatch = match = (TournamentMatch)v2;
            if (tournamentMatch == null) continue;
            return tournamentMatch;
        }
        TournamentMatch tournamentMatch = this.grandFinal;
        if (Intrinsics.areEqual((Object)(tournamentMatch != null ? tournamentMatch.getMatchId() : null), (Object)matchId)) {
            return this.grandFinal;
        }
        TournamentMatch tournamentMatch2 = this.grandFinalReset;
        if (Intrinsics.areEqual((Object)(tournamentMatch2 != null ? tournamentMatch2.getMatchId() : null), (Object)matchId)) {
            return this.grandFinalReset;
        }
        return null;
    }

    @Nullable
    public final TournamentMatch findMatchForPlayer(@NotNull UUID playerId) {
        TournamentMatch it;
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        for (BracketRound round : this.winnerBracket) {
            for (TournamentMatch match : round.getMatches()) {
                if (match.getState() == MatchState.COMPLETED || !match.getAllPlayerIds().contains(playerId)) continue;
                return match;
            }
        }
        for (BracketRound round : this.loserBracket) {
            for (TournamentMatch match : round.getMatches()) {
                if (match.getState() == MatchState.COMPLETED || !match.getAllPlayerIds().contains(playerId)) continue;
                return match;
            }
        }
        TournamentMatch tournamentMatch = this.grandFinal;
        if (tournamentMatch != null) {
            it = tournamentMatch;
            boolean bl = false;
            if (it.getState() != MatchState.COMPLETED && it.getAllPlayerIds().contains(playerId)) {
                return it;
            }
        }
        TournamentMatch tournamentMatch2 = this.grandFinalReset;
        if (tournamentMatch2 != null) {
            it = tournamentMatch2;
            boolean bl = false;
            if (it.getState() != MatchState.COMPLETED && it.getAllPlayerIds().contains(playerId)) {
                return it;
            }
        }
        return null;
    }

    @NotNull
    public final List<TournamentMatch> getAllMatches() {
        List all;
        block3: {
            TournamentMatch it;
            BracketRound round;
            all = new ArrayList();
            Iterable $this$forEach$iv = this.winnerBracket;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                round = (BracketRound)element$iv;
                boolean bl = false;
                all.addAll((Collection)round.getMatches());
            }
            $this$forEach$iv = this.loserBracket;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                round = (BracketRound)element$iv;
                boolean bl = false;
                all.addAll((Collection)round.getMatches());
            }
            TournamentMatch tournamentMatch = this.grandFinal;
            if (tournamentMatch != null) {
                it = tournamentMatch;
                boolean bl = false;
                all.add(it);
            }
            TournamentMatch tournamentMatch2 = this.grandFinalReset;
            if (tournamentMatch2 == null) break block3;
            it = tournamentMatch2;
            boolean bl = false;
            all.add(it);
        }
        return all;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/music176/pokemonleague/tournament/TournamentBracket$Companion;", "", "<init>", "()V", "", "n", "nextPowerOfTwo", "(I)I", "pokemon-league-mod"})
    public static final class Companion {
        private Companion() {
        }

        public final int nextPowerOfTwo(int n) {
            int power;
            for (power = 1; power < n; power *= 2) {
            }
            return power;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BracketType.values().length];
            try {
                nArray[BracketType.WINNER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BracketType.LOSER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BracketType.GRAND_FINAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

