/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.stats;

import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.stats.PlayerStats;
import com.music176.pokemonleague.stats.StatsData;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u0003J\r\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\u0003J\u001d\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0017\u0010\u0012J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00192\u0006\u0010\u0018\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010\"\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/music176/pokemonleague/stats/PlayerStatsManager;", "", "<init>", "()V", "Ljava/nio/file/Path;", "getStatsPath", "()Ljava/nio/file/Path;", "", "load", "save", "Ljava/util/UUID;", "playerId", "", "playerName", "Lcom/music176/pokemonleague/stats/PlayerStats;", "getOrCreateStats", "(Ljava/util/UUID;Ljava/lang/String;)Lcom/music176/pokemonleague/stats/PlayerStats;", "recordAttempt", "(Ljava/util/UUID;Ljava/lang/String;)V", "", "stageReached", "recordFailure", "(Ljava/util/UUID;Ljava/lang/String;I)V", "recordSuccess", "count", "", "getTopPlayers", "(I)Ljava/util/List;", "getPlayerStats", "(Ljava/util/UUID;)Lcom/music176/pokemonleague/stats/PlayerStats;", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "Lcom/music176/pokemonleague/stats/StatsData;", "statsData", "Lcom/music176/pokemonleague/stats/StatsData;", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nPlayerStatsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerStatsManager.kt\ncom/music176/pokemonleague/stats/PlayerStatsManager\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n222#2:80\n205#2:81\n382#3,7:82\n1#4:89\n1068#5:90\n*S KotlinDebug\n*F\n+ 1 PlayerStatsManager.kt\ncom/music176/pokemonleague/stats/PlayerStatsManager\n*L\n29#1:80\n42#1:81\n49#1:82,7\n71#1:90\n*E\n"})
public final class PlayerStatsManager {
    @NotNull
    public static final PlayerStatsManager INSTANCE = new PlayerStatsManager();
    @NotNull
    private static final Json json = JsonKt.Json$default(null, PlayerStatsManager::json$lambda$0, (int)1, null);
    @NotNull
    private static StatsData statsData = new StatsData(null, 1, null);

    private PlayerStatsManager() {
    }

    private final Path getStatsPath() {
        Path path = FabricLoader.getInstance().getConfigDir().resolve("pokemonleague").resolve("player_stats.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    public final void load() {
        Path path = this.getStatsPath();
        try {
            if (Files.exists(path, new LinkOption[0])) {
                void this_$iv;
                String content = Files.readString(path);
                Json json = PlayerStatsManager.json;
                Intrinsics.checkNotNull((Object)content);
                String string$iv = content;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                statsData = (StatsData)this_$iv.decodeFromString((DeserializationStrategy)StatsData.Companion.serializer(), string$iv);
                PokemonLeagueMod.INSTANCE.getLOGGER().info("Loaded stats for " + statsData.getPlayers().size() + " players");
            }
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to load player stats", (Throwable)e);
            statsData = new StatsData(null, 1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void save() {
        try {
            void this_$iv;
            Path path = this.getStatsPath();
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Json json = PlayerStatsManager.json;
            StatsData value$iv = statsData;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            Files.writeString(path, (CharSequence)this_$iv.encodeToString((SerializationStrategy)StatsData.Companion.serializer(), (Object)value$iv), new OpenOption[0]);
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to save player stats", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PlayerStats getOrCreateStats(@NotNull UUID playerId, @NotNull String playerName) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Map<String, PlayerStats> map = statsData.getPlayers();
        String key$iv = playerId.toString();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            String string = playerId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            PlayerStats answer$iv = new PlayerStats(string, playerName, 0, 0, 0, 0, 60, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        map = object;
        PlayerStats it = (PlayerStats)((Object)map);
        boolean bl = false;
        it.setPlayerName(playerName);
        return (PlayerStats)((Object)map);
    }

    public final void recordAttempt(@NotNull UUID playerId, @NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        this.getOrCreateStats(playerId, playerName).recordAttempt();
        this.save();
    }

    public final void recordFailure(@NotNull UUID playerId, @NotNull String playerName, int stageReached) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        this.getOrCreateStats(playerId, playerName).recordFailure(stageReached);
        this.save();
    }

    public final void recordSuccess(@NotNull UUID playerId, @NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        this.getOrCreateStats(playerId, playerName).recordSuccess();
        this.save();
    }

    @NotNull
    public final List<PlayerStats> getTopPlayers(int count) {
        Iterable $this$sortedByDescending$iv = statsData.getPlayers().values();
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PlayerStats it = (PlayerStats)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getTotalAttempts());
                it = (PlayerStats)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getTotalAttempts()));
            }
        }), (int)count);
    }

    @Nullable
    public final PlayerStats getPlayerStats(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return statsData.getPlayers().get(playerId.toString());
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setEncodeDefaults(true);
        return Unit.INSTANCE;
    }
}

