/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.ranked;

import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.economy.EconomyBridge;
import com.music176.pokemonleague.profile.PlayerProfile;
import com.music176.pokemonleague.profile.PlayerProfileManager;
import com.music176.pokemonleague.ranked.RankedManager;
import com.music176.pokemonleague.ranked.RankedRank;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002()B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u001d\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\tH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ%\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\tH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010!\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u001b\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b#\u0010$R \u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006*"}, d2={"Lcom/music176/pokemonleague/ranked/RankedRewards;", "", "<init>", "()V", "Lcom/music176/pokemonleague/ranked/RankedRank;", "rank", "Lcom/music176/pokemonleague/ranked/RankedRewards$RankReward;", "getRewardsForRank", "(Lcom/music176/pokemonleague/ranked/RankedRank;)Lcom/music176/pokemonleague/ranked/RankedRewards$RankReward;", "", "", "getRewardDescription", "(Lcom/music176/pokemonleague/ranked/RankedRank;)Ljava/util/List;", "", "distributeSeasonRewards", "Ljava/util/UUID;", "playerId", "", "giveRewards", "(Ljava/util/UUID;Lcom/music176/pokemonleague/ranked/RankedRank;)Z", "Lnet/minecraft/class_3222;", "player", "Lcom/music176/pokemonleague/ranked/RankedRewards$RewardItem;", "items", "giveItemsToPlayer", "(Lnet/minecraft/class_3222;Ljava/util/List;)V", "item", "giveItemViaCommand", "(Lnet/minecraft/class_3222;Lcom/music176/pokemonleague/ranked/RankedRewards$RewardItem;)V", "storePendingRewards", "(Ljava/util/UUID;Ljava/util/List;)V", "givePendingRewards", "(Lnet/minecraft/class_3222;)V", "notifyRewardsReceived", "(Lnet/minecraft/class_3222;Lcom/music176/pokemonleague/ranked/RankedRank;)V", "getNextSeasonRewardsPreview", "(Ljava/util/UUID;)Ljava/util/List;", "", "rankRewards", "Ljava/util/Map;", "RankReward", "RewardItem", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nRankedRewards.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RankedRewards.kt\ncom/music176/pokemonleague/ranked/RankedRewards\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,345:1\n1869#2,2:346\n1869#2:348\n1870#2:350\n1869#2,2:351\n1617#2,9:353\n1869#2:362\n1870#2:364\n1626#2:365\n1869#2,2:366\n1#3:349\n1#3:363\n*S KotlinDebug\n*F\n+ 1 RankedRewards.kt\ncom/music176/pokemonleague/ranked/RankedRewards\n*L\n115#1:346,2\n138#1:348\n138#1:350\n206#1:351,2\n266#1:353,9\n266#1:362\n266#1:364\n266#1:365\n316#1:366,2\n266#1:363\n*E\n"})
public final class RankedRewards {
    @NotNull
    public static final RankedRewards INSTANCE = new RankedRewards();
    @NotNull
    private static final Map<RankedRank, RankReward> rankRewards;

    private RankedRewards() {
    }

    @Nullable
    public final RankReward getRewardsForRank(@NotNull RankedRank rank) {
        Intrinsics.checkNotNullParameter((Object)((Object)rank), (String)"rank");
        return rankRewards.get((Object)rank);
    }

    @NotNull
    public final List<String> getRewardDescription(@NotNull RankedRank rank) {
        Intrinsics.checkNotNullParameter((Object)((Object)rank), (String)"rank");
        RankReward rankReward = rankRewards.get((Object)rank);
        if (rankReward == null) {
            return CollectionsKt.listOf((Object)"Aucune recompense");
        }
        RankReward reward = rankReward;
        List lines = new ArrayList();
        if (reward.getCredits() > 0) {
            lines.add(EconomyBridge.INSTANCE.formatBalance(reward.getCredits()) + " Pokedollars");
        }
        Iterable $this$forEach$iv = reward.getItems();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RewardItem item = (RewardItem)element$iv;
            boolean bl = false;
            lines.add(item.getCount() + "x " + item.getDisplayName());
        }
        if (lines.isEmpty()) {
            lines.add("Aucune recompense");
        }
        return lines;
    }

    public final void distributeSeasonRewards() {
        MinecraftServer minecraftServer = DistributionUtilsKt.server();
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        int currentSeason = RankedManager.INSTANCE.getConfig().getSeasonData().getCurrentSeason();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Distributing season " + currentSeason + " rewards...");
        int rewardsGiven = 0;
        Iterable $this$forEach$iv = PlayerProfileManager.INSTANCE.getAllProfiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 it;
            UUID uUID;
            RankedRank bestRank;
            PlayerProfile profile = (PlayerProfile)element$iv;
            boolean bl = false;
            RankedRank rank1v1 = RankedRank.Companion.fromElo(profile.getRankedStats().getHighestElo1v1());
            RankedRank rank2v2 = RankedRank.Companion.fromElo(profile.getRankedStats().getHighestElo2v2());
            RankedRank rankedRank = bestRank = rank1v1.getMinElo() >= rank2v2.getMinElo() ? rank1v1 : rank2v2;
            if (profile.getRankedStats().getLastSeasonRewardsClaimed() >= currentSeason) continue;
            try {
                uUID = UUID.fromString(profile.getPlayerId());
            }
            catch (Exception e) {
                continue;
            }
            UUID playerUuid = uUID;
            Intrinsics.checkNotNull((Object)playerUuid);
            if (!INSTANCE.giveRewards(playerUuid, bestRank)) continue;
            profile.getRankedStats().setLastSeasonRewardsClaimed(currentSeason);
            ++rewardsGiven;
            class_3222 player = server.method_3760().method_14602(playerUuid);
            if (player == null) continue;
            boolean bl2 = false;
            INSTANCE.notifyRewardsReceived(it, bestRank);
        }
        PlayerProfileManager.INSTANCE.saveProfiles();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Season rewards distributed to " + rewardsGiven + " players");
    }

    public final boolean giveRewards(@NotNull UUID playerId, @NotNull RankedRank rank) {
        PlayerProfile profile;
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)((Object)rank), (String)"rank");
        RankReward rankReward = rankRewards.get((Object)rank);
        if (rankReward == null) {
            return false;
        }
        RankReward reward = rankReward;
        if (reward.getCredits() == 0 && reward.getItems().isEmpty()) {
            return true;
        }
        MinecraftServer minecraftServer = DistributionUtilsKt.server();
        if (minecraftServer == null) {
            return false;
        }
        MinecraftServer server = minecraftServer;
        class_3222 player = server.method_3760().method_14602(playerId);
        if (reward.getCredits() > 0 && (profile = PlayerProfileManager.INSTANCE.getProfile(playerId)) != null) {
            PlayerProfile playerProfile = profile;
            playerProfile.setTotalCreditsEarned(playerProfile.getTotalCreditsEarned() + reward.getCredits());
            PlayerProfileManager.INSTANCE.saveProfiles();
        }
        if (player != null && !((Collection)reward.getItems()).isEmpty()) {
            this.giveItemsToPlayer(player, reward.getItems());
        } else if (!((Collection)reward.getItems()).isEmpty()) {
            this.storePendingRewards(playerId, reward.getItems());
        }
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Gave " + rank + " rewards to player " + playerId);
        return true;
    }

    private final void giveItemsToPlayer(class_3222 player, List<RewardItem> items) {
        MinecraftServer server = player.field_13995;
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RewardItem rewardItem = (RewardItem)element$iv;
            boolean bl = false;
            try {
                class_2960 itemLocation = class_2960.method_12829((String)rewardItem.getItemId());
                if (itemLocation == null) continue;
                Object object = class_7923.field_41178.method_10223(itemLocation);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                class_1792 item = (class_1792)object;
                if (!Intrinsics.areEqual((Object)item, (Object)class_1802.field_8162)) {
                    class_1799 stack = new class_1799((class_1935)item, rewardItem.getCount());
                    if (player.method_31548().method_7394(stack)) continue;
                    player.method_7328(stack, false);
                    continue;
                }
                INSTANCE.giveItemViaCommand(player, rewardItem);
            }
            catch (Exception e) {
                PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to give item " + rewardItem.getItemId() + " to " + player.method_5477().getString(), (Throwable)e);
                INSTANCE.giveItemViaCommand(player, rewardItem);
            }
        }
    }

    private final void giveItemViaCommand(class_3222 player, RewardItem item) {
        try {
            String command = "give " + player.method_5477().getString() + " " + item.getItemId() + " " + item.getCount();
            player.field_13995.method_3734().method_9235().execute(command, (Object)player.field_13995.method_3739());
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to give item via command: " + item.getItemId(), (Throwable)e);
        }
    }

    private final void storePendingRewards(UUID playerId, List<RewardItem> items) {
        PlayerProfile playerProfile = PlayerProfileManager.INSTANCE.getProfile(playerId);
        if (playerProfile == null) {
            return;
        }
        PlayerProfile profile = playerProfile;
        String pendingStr = CollectionsKt.joinToString$default((Iterable)items, (CharSequence)";", null, null, (int)0, null, RankedRewards::storePendingRewards$lambda$0, (int)30, null);
        profile.getRankedStats().setPendingRewards(pendingStr);
        PlayerProfileManager.INSTANCE.saveProfiles();
    }

    /*
     * WARNING - void declaration
     */
    public final void givePendingRewards(@NotNull class_3222 player) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerProfile playerProfile = PlayerProfileManager.INSTANCE.getProfile(uUID);
        if (playerProfile == null) {
            return;
        }
        PlayerProfile profile = playerProfile;
        String pendingStr = profile.getRankedStats().getPendingRewards();
        CharSequence charSequence = pendingStr;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        String[] stringArray = new String[]{";"};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)pendingStr, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RewardItem rewardItem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String entry = (String)element$iv$iv;
            boolean bl2 = false;
            String[] stringArray2 = new String[]{":"};
            List parts = StringsKt.split$default((CharSequence)entry, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            if (parts.size() == 2) {
                String itemId = (String)parts.get(0);
                Integer n = StringsKt.toIntOrNull((String)((String)parts.get(1)));
                if (n == null) {
                    rewardItem = null;
                } else {
                    String string;
                    int count = n;
                    String string2 = StringsKt.replace$default((String)StringsKt.substringAfter$default((String)itemId, (String)":", null, (int)2, null), (String)"_", (String)" ", (boolean)false, (int)4, null);
                    if (((CharSequence)string2).length() > 0) {
                        void it;
                        char c = string2.charAt(0);
                        StringBuilder stringBuilder = new StringBuilder();
                        boolean bl3 = false;
                        String string3 = String.valueOf((char)it);
                        Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
                        String string4 = string3.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                        StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
                        String string5 = string2;
                        int n2 = 1;
                        String string6 = string5.substring(n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                        string = stringBuilder2.append(string6).toString();
                    } else {
                        string = string2;
                    }
                    String displayName = string;
                    rewardItem = new RewardItem(itemId, count, displayName);
                }
            } else {
                rewardItem = null;
            }
            if (rewardItem == null) continue;
            RewardItem it$iv$iv = rewardItem;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List items = (List)destination$iv$iv;
        if (!((Collection)items).isEmpty()) {
            this.giveItemsToPlayer(player, items);
            player.method_43496((class_2561)class_2561.method_43470((String)"Vous avez recu vos recompenses de saison!").method_27694(RankedRewards::givePendingRewards$lambda$1));
            profile.getRankedStats().setPendingRewards(null);
            PlayerProfileManager.INSTANCE.saveProfiles();
        }
    }

    private final void notifyRewardsReceived(class_3222 player, RankedRank rank) {
        RankReward rankReward = rankRewards.get((Object)rank);
        if (rankReward == null) {
            return;
        }
        RankReward reward = rankReward;
        player.method_43496((class_2561)class_2561.method_43473());
        player.method_43496((class_2561)class_2561.method_43470((String)"=== RECOMPENSES DE SAISON ===").method_27694(RankedRewards::notifyRewardsReceived$lambda$0));
        player.method_43496((class_2561)class_2561.method_43470((String)("Rang atteint: " + rank.getDisplayName())).method_27694(arg_0 -> RankedRewards.notifyRewardsReceived$lambda$1(rank, arg_0)));
        if (reward.getCredits() > 0) {
            player.method_43496((class_2561)class_2561.method_43470((String)("+ " + EconomyBridge.INSTANCE.formatBalance(reward.getCredits()) + " Pokedollars")).method_27694(RankedRewards::notifyRewardsReceived$lambda$2));
        }
        Iterable $this$forEach$iv = reward.getItems();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RewardItem item = (RewardItem)element$iv;
            boolean bl = false;
            player.method_43496((class_2561)class_2561.method_43470((String)("+ " + item.getCount() + "x " + item.getDisplayName())).method_27694(RankedRewards::notifyRewardsReceived$lambda$3$0));
        }
        player.method_43496((class_2561)class_2561.method_43473());
    }

    @NotNull
    public final List<String> getNextSeasonRewardsPreview(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        PlayerProfile playerProfile = PlayerProfileManager.INSTANCE.getProfile(playerId);
        if (playerProfile == null) {
            return CollectionsKt.listOf((Object)"Aucun profil");
        }
        PlayerProfile profile = playerProfile;
        RankedRank rank1v1 = RankedRank.Companion.fromElo(profile.getRankedStats().getElo1v1());
        RankedRank rank2v2 = RankedRank.Companion.fromElo(profile.getRankedStats().getElo2v2());
        RankedRank currentBest = rank1v1.getMinElo() >= rank2v2.getMinElo() ? rank1v1 : rank2v2;
        List lines = new ArrayList();
        lines.add("Rang actuel: " + currentBest.getDisplayName());
        lines.add("");
        lines.add("Recompenses prevues:");
        lines.addAll((Collection)this.getRewardDescription(currentBest));
        return lines;
    }

    private static final CharSequence storePendingRewards$lambda$0(RewardItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getItemId() + ":" + it.getCount();
    }

    private static final class_2583 givePendingRewards$lambda$1(class_2583 it) {
        return it.method_36139(16766720).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 notifyRewardsReceived$lambda$0(class_2583 it) {
        return it.method_36139(16766720).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 notifyRewardsReceived$lambda$1(RankedRank $rank, class_2583 it) {
        return it.method_10977($rank.getColor());
    }

    private static final class_2583 notifyRewardsReceived$lambda$2(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final class_2583 notifyRewardsReceived$lambda$3$0(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    static {
        Pair[] pairArray = new Pair[8];
        pairArray[0] = TuplesKt.to((Object)((Object)RankedRank.POKE_BALL), (Object)new RankReward(RankedRank.POKE_BALL, 0, CollectionsKt.emptyList()));
        pairArray[1] = TuplesKt.to((Object)((Object)RankedRank.SUPER_BALL), (Object)new RankReward(RankedRank.SUPER_BALL, 500, CollectionsKt.emptyList()));
        pairArray[2] = TuplesKt.to((Object)((Object)RankedRank.HYPER_BALL), (Object)new RankReward(RankedRank.HYPER_BALL, 1000, CollectionsKt.listOf((Object)new RewardItem("cobblemon:rare_candy", 2, "Rare Candy"))));
        pairArray[3] = TuplesKt.to((Object)((Object)RankedRank.ULTRA_BALL), (Object)new RankReward(RankedRank.ULTRA_BALL, 2000, CollectionsKt.listOf((Object)new RewardItem("cobblemon:rare_candy", 5, "Rare Candy"))));
        Object[] objectArray = new RewardItem[]{new RewardItem("cobblemon:rare_candy", 5, "Rare Candy"), new RewardItem("cobblemon:pp_max", 1, "PP Max")};
        pairArray[4] = TuplesKt.to((Object)((Object)RankedRank.MASTER_BALL), (Object)new RankReward(RankedRank.MASTER_BALL, 3000, CollectionsKt.listOf((Object[])objectArray)));
        objectArray = new RewardItem[]{new RewardItem("cobblemon:rare_candy", 10, "Rare Candy"), new RewardItem("cobblemon:master_ball", 1, "Master Ball")};
        pairArray[5] = TuplesKt.to((Object)((Object)RankedRank.SAFARI_BALL), (Object)new RankReward(RankedRank.SAFARI_BALL, 5000, CollectionsKt.listOf((Object[])objectArray)));
        objectArray = new RewardItem[]{new RewardItem("cobblemon:rare_candy", 15, "Rare Candy"), new RewardItem("cobblemon:master_ball", 2, "Master Ball")};
        pairArray[6] = TuplesKt.to((Object)((Object)RankedRank.CHERISH_BALL), (Object)new RankReward(RankedRank.CHERISH_BALL, 10000, CollectionsKt.listOf((Object[])objectArray)));
        objectArray = new RewardItem[]{new RewardItem("cobblemon:rare_candy", 25, "Rare Candy"), new RewardItem("cobblemon:master_ball", 3, "Master Ball"), new RewardItem("cobblemon:ability_capsule", 1, "Ability Capsule")};
        pairArray[7] = TuplesKt.to((Object)((Object)RankedRank.POKEMON_MASTER), (Object)new RankReward(RankedRank.POKEMON_MASTER, 20000, CollectionsKt.listOf((Object[])objectArray)));
        rankRewards = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J4\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u000eJ\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\u000eR\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001f\u001a\u0004\b \u0010\u0010\u00a8\u0006!"}, d2={"Lcom/music176/pokemonleague/ranked/RankedRewards$RankReward;", "", "Lcom/music176/pokemonleague/ranked/RankedRank;", "rank", "", "credits", "", "Lcom/music176/pokemonleague/ranked/RankedRewards$RewardItem;", "items", "<init>", "(Lcom/music176/pokemonleague/ranked/RankedRank;ILjava/util/List;)V", "component1", "()Lcom/music176/pokemonleague/ranked/RankedRank;", "component2", "()I", "component3", "()Ljava/util/List;", "copy", "(Lcom/music176/pokemonleague/ranked/RankedRank;ILjava/util/List;)Lcom/music176/pokemonleague/ranked/RankedRewards$RankReward;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lcom/music176/pokemonleague/ranked/RankedRank;", "getRank", "I", "getCredits", "Ljava/util/List;", "getItems", "pokemon-league-mod"})
    public static final class RankReward {
        @NotNull
        private final RankedRank rank;
        private final int credits;
        @NotNull
        private final List<RewardItem> items;

        public RankReward(@NotNull RankedRank rank, int credits, @NotNull List<RewardItem> items) {
            Intrinsics.checkNotNullParameter((Object)((Object)rank), (String)"rank");
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.rank = rank;
            this.credits = credits;
            this.items = items;
        }

        @NotNull
        public final RankedRank getRank() {
            return this.rank;
        }

        public final int getCredits() {
            return this.credits;
        }

        @NotNull
        public final List<RewardItem> getItems() {
            return this.items;
        }

        @NotNull
        public final RankedRank component1() {
            return this.rank;
        }

        public final int component2() {
            return this.credits;
        }

        @NotNull
        public final List<RewardItem> component3() {
            return this.items;
        }

        @NotNull
        public final RankReward copy(@NotNull RankedRank rank, int credits, @NotNull List<RewardItem> items) {
            Intrinsics.checkNotNullParameter((Object)((Object)rank), (String)"rank");
            Intrinsics.checkNotNullParameter(items, (String)"items");
            return new RankReward(rank, credits, items);
        }

        public static /* synthetic */ RankReward copy$default(RankReward rankReward, RankedRank rankedRank, int n, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                rankedRank = rankReward.rank;
            }
            if ((n2 & 2) != 0) {
                n = rankReward.credits;
            }
            if ((n2 & 4) != 0) {
                list = rankReward.items;
            }
            return rankReward.copy(rankedRank, n, list);
        }

        @NotNull
        public String toString() {
            return "RankReward(rank=" + this.rank + ", credits=" + this.credits + ", items=" + this.items + ")";
        }

        public int hashCode() {
            int result = this.rank.hashCode();
            result = result * 31 + Integer.hashCode(this.credits);
            result = result * 31 + ((Object)this.items).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RankReward)) {
                return false;
            }
            RankReward rankReward = (RankReward)other;
            if (this.rank != rankReward.rank) {
                return false;
            }
            if (this.credits != rankReward.credits) {
                return false;
            }
            return Intrinsics.areEqual(this.items, rankReward.items);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\nJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\fJ\u0010\u0010\u0015\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\fR\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0016\u001a\u0004\b\u001a\u0010\n\u00a8\u0006\u001b"}, d2={"Lcom/music176/pokemonleague/ranked/RankedRewards$RewardItem;", "", "", "itemId", "", "count", "displayName", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "component1", "()Ljava/lang/String;", "component2", "()I", "component3", "copy", "(Ljava/lang/String;ILjava/lang/String;)Lcom/music176/pokemonleague/ranked/RankedRewards$RewardItem;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getItemId", "I", "getCount", "getDisplayName", "pokemon-league-mod"})
    public static final class RewardItem {
        @NotNull
        private final String itemId;
        private final int count;
        @NotNull
        private final String displayName;

        public RewardItem(@NotNull String itemId, int count, @NotNull String displayName) {
            Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            this.itemId = itemId;
            this.count = count;
            this.displayName = displayName;
        }

        @NotNull
        public final String getItemId() {
            return this.itemId;
        }

        public final int getCount() {
            return this.count;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final String component1() {
            return this.itemId;
        }

        public final int component2() {
            return this.count;
        }

        @NotNull
        public final String component3() {
            return this.displayName;
        }

        @NotNull
        public final RewardItem copy(@NotNull String itemId, int count, @NotNull String displayName) {
            Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            return new RewardItem(itemId, count, displayName);
        }

        public static /* synthetic */ RewardItem copy$default(RewardItem rewardItem, String string, int n, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = rewardItem.itemId;
            }
            if ((n2 & 2) != 0) {
                n = rewardItem.count;
            }
            if ((n2 & 4) != 0) {
                string2 = rewardItem.displayName;
            }
            return rewardItem.copy(string, n, string2);
        }

        @NotNull
        public String toString() {
            return "RewardItem(itemId=" + this.itemId + ", count=" + this.count + ", displayName=" + this.displayName + ")";
        }

        public int hashCode() {
            int result = this.itemId.hashCode();
            result = result * 31 + Integer.hashCode(this.count);
            result = result * 31 + this.displayName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RewardItem)) {
                return false;
            }
            RewardItem rewardItem = (RewardItem)other;
            if (!Intrinsics.areEqual((Object)this.itemId, (Object)rewardItem.itemId)) {
                return false;
            }
            if (this.count != rewardItem.count) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.displayName, (Object)rewardItem.displayName);
        }
    }
}

