/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.ranked;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.profile.PlayerProfile;
import com.music176.pokemonleague.profile.PlayerProfileManager;
import com.music176.pokemonleague.ranked.MatchResult;
import com.music176.pokemonleague.ranked.QueueEntry;
import com.music176.pokemonleague.ranked.QueueMode;
import com.music176.pokemonleague.ranked.RankedConfig;
import com.music176.pokemonleague.ranked.RankedMatchmaker;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00142\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00142\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001d\u0010\u001eJ+\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00142\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u001f2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b!\u0010\"J+\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00142\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u001f2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b#\u0010\"J\u0017\u0010$\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b$\u0010%J\r\u0010'\u001a\u00020&\u00a2\u0006\u0004\b'\u0010\u0003R&\u0010)\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u001f0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R \u0010+\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00110(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010*\u00a8\u0006,"}, d2={"Lcom/music176/pokemonleague/ranked/RankedQueue;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "Lcom/music176/pokemonleague/ranked/QueueMode;", "mode", "partner", "", "addToQueue", "(Lnet/minecraft/class_3222;Lcom/music176/pokemonleague/ranked/QueueMode;Lnet/minecraft/class_3222;)Z", "Ljava/util/UUID;", "playerId", "removeFromQueue", "(Ljava/util/UUID;)Z", "isInQueue", "Lcom/music176/pokemonleague/ranked/QueueEntry;", "getQueueEntry", "(Ljava/util/UUID;)Lcom/music176/pokemonleague/ranked/QueueEntry;", "", "getQueueEntries", "(Lcom/music176/pokemonleague/ranked/QueueMode;)Ljava/util/List;", "", "getQueueSize", "(Lcom/music176/pokemonleague/ranked/QueueMode;)I", "Lcom/music176/pokemonleague/ranked/RankedConfig;", "config", "Lcom/music176/pokemonleague/ranked/MatchResult;", "processQueue", "(Lcom/music176/pokemonleague/ranked/RankedConfig;)Ljava/util/List;", "", "queue", "findMatches1v1", "(Ljava/util/List;Lcom/music176/pokemonleague/ranked/RankedConfig;)Ljava/util/List;", "findMatches2v2", "calculateAveragePokemonLevel", "(Lnet/minecraft/class_3222;)I", "", "clearAllQueues", "Ljava/util/concurrent/ConcurrentHashMap;", "queues", "Ljava/util/concurrent/ConcurrentHashMap;", "playerInQueue", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nRankedQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RankedQueue.kt\ncom/music176/pokemonleague/ranked/RankedQueue\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,314:1\n1869#2:315\n1869#2,2:316\n1869#2,2:318\n1870#2:320\n1056#2:321\n774#2:322\n865#2,2:323\n774#2:325\n865#2,2:326\n1669#2,8:328\n1056#2:336\n774#2:337\n865#2,2:338\n1617#2,9:340\n1869#2:349\n1870#2:351\n1626#2:352\n1869#2,2:353\n1869#2,2:355\n1#3:350\n*S KotlinDebug\n*F\n+ 1 RankedQueue.kt\ncom/music176/pokemonleague/ranked/RankedQueue\n*L\n180#1:315\n181#1:316,2\n184#1:318,2\n180#1:320\n201#1:321\n207#1:322\n207#1:323,2\n233#1:325\n233#1:326,2\n234#1:328,8\n236#1:336\n242#1:337\n242#1:338,2\n290#1:340,9\n290#1:349\n290#1:351\n290#1:352\n301#1:353,2\n64#1:355,2\n290#1:350\n*E\n"})
public final class RankedQueue {
    @NotNull
    public static final RankedQueue INSTANCE = new RankedQueue();
    @NotNull
    private static final ConcurrentHashMap<QueueMode, List<QueueEntry>> queues = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<UUID, QueueEntry> playerInQueue = new ConcurrentHashMap();

    private RankedQueue() {
    }

    public final boolean addToQueue(@NotNull class_3222 player, @NotNull QueueMode mode, @Nullable class_3222 partner) {
        class_3222 class_32222;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        if (this.isInQueue(uUID)) {
            return false;
        }
        if (mode.is2v2() && partner != null) {
            UUID uUID2 = partner.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            if (this.isInQueue(uUID2)) {
                return false;
            }
        }
        UUID uUID3 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
        String string = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        PlayerProfile profile = PlayerProfileManager.INSTANCE.getOrCreateProfile(uUID3, string);
        int elo = mode.is2v2() ? profile.getRankedStats().getElo2v2() : profile.getRankedStats().getElo1v1();
        int avgLevel = this.calculateAveragePokemonLevel(player);
        UUID uUID4 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID4, (String)"getUUID(...)");
        String string2 = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        class_3222 class_32223 = partner;
        QueueEntry entry = new QueueEntry(uUID4, string2, mode, elo, avgLevel, 0L, class_32223 != null ? class_32223.method_5667() : null, (class_32222 = partner) != null && (class_32222 = class_32222.method_5477()) != null ? class_32222.getString() : null, 32, null);
        List<QueueEntry> list = queues.get((Object)mode);
        if (list != null) {
            list.add(entry);
        }
        ((Map)playerInQueue).put(player.method_5667(), entry);
        if (partner != null) {
            ((Map)playerInQueue).put(partner.method_5667(), entry);
        }
        PokemonLeagueMod.INSTANCE.getLOGGER().info(player.method_5477().getString() + " joined " + mode.getDisplayName() + " queue (ELO: " + elo + ", Avg Level: " + avgLevel + ")");
        return true;
    }

    public static /* synthetic */ boolean addToQueue$default(RankedQueue rankedQueue, class_3222 class_32222, QueueMode queueMode, class_3222 class_32223, int n, Object object) {
        if ((n & 4) != 0) {
            class_32223 = null;
        }
        return rankedQueue.addToQueue(class_32222, queueMode, class_32223);
    }

    public final boolean removeFromQueue(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        QueueEntry queueEntry = playerInQueue.remove(playerId);
        if (queueEntry == null) {
            return false;
        }
        QueueEntry entry = queueEntry;
        List<QueueEntry> list = queues.get((Object)entry.getMode());
        if (list != null) {
            list.removeIf(arg_0 -> RankedQueue.removeFromQueue$lambda$1(arg_0 -> RankedQueue.removeFromQueue$lambda$0(playerId, arg_0), arg_0));
        }
        if (entry.getPartnerId() != null) {
            playerInQueue.remove(entry.getPartnerId());
        }
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Player " + playerId + " removed from " + entry.getMode().getDisplayName() + " queue");
        return true;
    }

    public final boolean isInQueue(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return playerInQueue.containsKey(playerId);
    }

    @Nullable
    public final QueueEntry getQueueEntry(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return playerInQueue.get(playerId);
    }

    @NotNull
    public final List<QueueEntry> getQueueEntries(@NotNull QueueMode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        List list = queues.get((Object)mode);
        if (list == null || (list = CollectionsKt.toList((Iterable)list)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final int getQueueSize(@NotNull QueueMode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        List<QueueEntry> list = queues.get((Object)mode);
        return list != null ? list.size() : 0;
    }

    @NotNull
    public final List<MatchResult> processQueue(@NotNull RankedConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List results = new ArrayList();
        for (QueueMode mode : QueueMode.getEntries()) {
            List<QueueEntry> queue;
            if (queues.get((Object)mode) == null || queue.isEmpty()) continue;
            List<MatchResult> matches = mode.is2v2() ? this.findMatches2v2(queue, config) : this.findMatches1v1(queue, config);
            results.addAll((Collection)matches);
            Iterable $this$forEach$iv = matches;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                QueueEntry entry;
                MatchResult match = (MatchResult)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = match.getTeam1();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    entry = (QueueEntry)element$iv2;
                    boolean bl2 = false;
                    INSTANCE.removeFromQueue(entry.getPlayerId());
                }
                $this$forEach$iv2 = match.getTeam2();
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    entry = (QueueEntry)element$iv2;
                    boolean bl3 = false;
                    INSTANCE.removeFromQueue(entry.getPlayerId());
                }
            }
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MatchResult> findMatches1v1(List<QueueEntry> queue, RankedConfig config) {
        List results = new ArrayList();
        Set matched = new LinkedHashSet();
        Iterable $this$sortedBy$iv = queue;
        boolean $i$f$sortedBy = false;
        List sortedQueue = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                QueueEntry it = (QueueEntry)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getJoinedAt());
                it = (QueueEntry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getJoinedAt()));
            }
        });
        for (QueueEntry entry1 : sortedQueue) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            if (matched.contains(entry1.getPlayerId())) continue;
            Iterable iterable = sortedQueue;
            QueueEntry queueEntry = entry1;
            RankedMatchmaker rankedMatchmaker = RankedMatchmaker.INSTANCE;
            boolean $i$f$filter = false;
            void var11_12 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                QueueEntry it = (QueueEntry)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getPlayerId(), (Object)entry1.getPlayerId()) && !matched.contains(it.getPlayerId()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            QueueEntry opponent = rankedMatchmaker.findMatch1v1(queueEntry, list, config);
            if (opponent == null) continue;
            results.add(new MatchResult(entry1.getMode(), CollectionsKt.listOf((Object)entry1), CollectionsKt.listOf((Object)opponent)));
            matched.add(entry1.getPlayerId());
            matched.add(opponent.getPlayerId());
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MatchResult> findMatches2v2(List<QueueEntry> queue, RankedConfig config) {
        String key$iv;
        void $this$distinctBy$iv;
        void $this$filterTo$iv$iv;
        List results = new ArrayList();
        Set matched = new LinkedHashSet();
        Iterable $this$filter$iv = queue;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            QueueEntry it = (QueueEntry)element$iv$iv;
            boolean bl = false;
            if (!(it.getPartnerId() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<CallSite> set$iv = new HashSet<CallSite>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            QueueEntry it = (QueueEntry)e$iv;
            boolean bl = false;
            Comparable comparable = it.getPlayerId();
            UUID uUID = it.getPartnerId();
            Intrinsics.checkNotNull((Object)uUID);
            key$iv = ((UUID)ComparisonsKt.minOf((Comparable)comparable, (Comparable)uUID)).toString() + ComparisonsKt.maxOf((Comparable)it.getPlayerId(), (Comparable)it.getPartnerId());
            if (!set$iv.add((CallSite)((Object)key$iv))) continue;
            list$iv.add(e$iv);
        }
        List teams = list$iv;
        Iterable $this$sortedBy$iv = teams;
        boolean $i$f$sortedBy = false;
        List sortedTeams = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                QueueEntry it = (QueueEntry)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getJoinedAt());
                it = (QueueEntry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getJoinedAt()));
            }
        });
        for (QueueEntry team1Entry : sortedTeams) {
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            if (matched.contains(team1Entry.getPlayerId()) || CollectionsKt.contains((Iterable)matched, (Object)team1Entry.getPartnerId())) continue;
            Iterable $i$f$filterTo2 = sortedTeams;
            QueueEntry queueEntry = team1Entry;
            RankedMatchmaker rankedMatchmaker = RankedMatchmaker.INSTANCE;
            boolean $i$f$filter2 = false;
            key$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                QueueEntry it = (QueueEntry)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getPlayerId(), (Object)team1Entry.getPlayerId()) && !Intrinsics.areEqual((Object)it.getPartnerId(), (Object)team1Entry.getPlayerId()) && !Intrinsics.areEqual((Object)it.getPlayerId(), (Object)team1Entry.getPartnerId()) && !Intrinsics.areEqual((Object)it.getPartnerId(), (Object)team1Entry.getPartnerId()) && !matched.contains(it.getPlayerId()) && (it.getPartnerId() == null || !matched.contains(it.getPartnerId())))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            QueueEntry opposingTeam = rankedMatchmaker.findMatch2v2(queueEntry, list, config);
            if (opposingTeam == null) continue;
            UUID uUID = team1Entry.getPartnerId();
            Intrinsics.checkNotNull((Object)uUID);
            String string = team1Entry.getPartnerName();
            if (string == null) {
                string = "Unknown";
            }
            QueueEntry partner1 = new QueueEntry(uUID, string, team1Entry.getMode(), team1Entry.getElo(), team1Entry.getAveragePokemonLevel(), 0L, null, null, 224, null);
            UUID uUID2 = opposingTeam.getPartnerId();
            Intrinsics.checkNotNull((Object)uUID2);
            String string2 = opposingTeam.getPartnerName();
            if (string2 == null) {
                string2 = "Unknown";
            }
            QueueEntry partner2 = new QueueEntry(uUID2, string2, opposingTeam.getMode(), opposingTeam.getElo(), opposingTeam.getAveragePokemonLevel(), 0L, null, null, 224, null);
            Object[] objectArray = new QueueEntry[]{team1Entry, partner1};
            List list2 = CollectionsKt.listOf((Object[])objectArray);
            objectArray = new QueueEntry[]{opposingTeam, partner2};
            results.add(new MatchResult(team1Entry.getMode(), list2, CollectionsKt.listOf((Object[])objectArray)));
            matched.add(team1Entry.getPlayerId());
            matched.add(team1Entry.getPartnerId());
            matched.add(opposingTeam.getPlayerId());
            matched.add(opposingTeam.getPartnerId());
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private final int calculateAveragePokemonLevel(class_3222 player) {
        int n;
        try {
            void $this$mapNotNullTo$iv$iv;
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            Iterable $this$mapNotNull$iv = (Iterable)party;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Pokemon it = (Pokemon)element$iv$iv;
                boolean bl2 = false;
                Integer it$iv$iv = it.getLevel();
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List levels = (List)destination$iv$iv;
            n = levels.isEmpty() ? 50 : (int)CollectionsKt.averageOfInt((Iterable)levels);
        }
        catch (Exception e) {
            n = 50;
        }
        return n;
    }

    public final void clearAllQueues() {
        Collection<List<QueueEntry>> collection = queues.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            it.clear();
        }
        playerInQueue.clear();
    }

    private static final boolean removeFromQueue$lambda$0(UUID $playerId, QueueEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getPlayerId(), (Object)$playerId);
    }

    private static final boolean removeFromQueue$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Iterable $this$forEach$iv = (Iterable)QueueMode.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            QueueMode mode = (QueueMode)((Object)element$iv);
            boolean bl = false;
            ((Map)queues).put(mode, (List)new ArrayList());
        }
    }
}

