/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.ranked;

import com.music176.pokemonleague.ranked.MatchmakingPhase;
import com.music176.pokemonleague.ranked.QueueEntry;
import com.music176.pokemonleague.ranked.RankedConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ-\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\u000bJ/\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J/\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011J/\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0011J/\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0011J1\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001b\u0010\u001b\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/music176/pokemonleague/ranked/RankedMatchmaker;", "", "<init>", "()V", "Lcom/music176/pokemonleague/ranked/QueueEntry;", "entry", "", "candidates", "Lcom/music176/pokemonleague/ranked/RankedConfig;", "config", "findMatch1v1", "(Lcom/music176/pokemonleague/ranked/QueueEntry;Ljava/util/List;Lcom/music176/pokemonleague/ranked/RankedConfig;)Lcom/music176/pokemonleague/ranked/QueueEntry;", "teamEntry", "findMatch2v2", "", "range", "findByElo", "(Lcom/music176/pokemonleague/ranked/QueueEntry;Ljava/util/List;I)Lcom/music176/pokemonleague/ranked/QueueEntry;", "findByLevel", "findTeamByElo", "findTeamByLevel", "winnerElo", "loserElo", "Lkotlin/Pair;", "calculateEloChange", "(IILcom/music176/pokemonleague/ranked/RankedConfig;)Lkotlin/Pair;", "team", "calculateTeamAverageElo", "(Ljava/util/List;)I", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nRankedMatchmaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RankedMatchmaker.kt\ncom/music176/pokemonleague/ranked/RankedMatchmaker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n774#2:133\n865#2,2:134\n2423#2,14:136\n774#2:150\n865#2,2:151\n2423#2,14:153\n774#2:167\n865#2,2:168\n2423#2,14:170\n774#2:184\n865#2,2:185\n2423#2,14:187\n1563#2:201\n1634#2,3:202\n*S KotlinDebug\n*F\n+ 1 RankedMatchmaker.kt\ncom/music176/pokemonleague/ranked/RankedMatchmaker\n*L\n71#1:133\n71#1:134,2\n72#1:136,14\n80#1:150\n80#1:151,2\n81#1:153,14\n89#1:167\n89#1:168,2\n90#1:170,14\n98#1:184\n98#1:185,2\n99#1:187,14\n129#1:201\n129#1:202,3\n*E\n"})
public final class RankedMatchmaker {
    @NotNull
    public static final RankedMatchmaker INSTANCE = new RankedMatchmaker();

    private RankedMatchmaker() {
    }

    @Nullable
    public final QueueEntry findMatch1v1(@NotNull QueueEntry entry, @NotNull List<QueueEntry> candidates, @NotNull RankedConfig config) {
        QueueEntry queueEntry;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (candidates.isEmpty()) {
            return null;
        }
        MatchmakingPhase phase = entry.getCurrentPhase(config);
        switch (WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
            case 1: {
                queueEntry = this.findByElo(entry, candidates, config.getEloRangePhase1());
                break;
            }
            case 2: {
                queueEntry = this.findByElo(entry, candidates, config.getEloRangePhase1());
                if (queueEntry != null) break;
                queueEntry = this.findByLevel(entry, candidates, config.getLevelRangePhase2());
                break;
            }
            case 3: {
                queueEntry = this.findByElo(entry, candidates, config.getEloRangePhase1());
                if (queueEntry != null || (queueEntry = this.findByLevel(entry, candidates, config.getLevelRangePhase2())) != null) break;
                queueEntry = (QueueEntry)CollectionsKt.firstOrNull(candidates);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return queueEntry;
    }

    @Nullable
    public final QueueEntry findMatch2v2(@NotNull QueueEntry teamEntry, @NotNull List<QueueEntry> candidates, @NotNull RankedConfig config) {
        QueueEntry queueEntry;
        Intrinsics.checkNotNullParameter((Object)teamEntry, (String)"teamEntry");
        Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (candidates.isEmpty()) {
            return null;
        }
        MatchmakingPhase phase = teamEntry.getCurrentPhase(config);
        switch (WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
            case 1: {
                queueEntry = this.findTeamByElo(teamEntry, candidates, config.getEloRangePhase1());
                break;
            }
            case 2: {
                queueEntry = this.findTeamByElo(teamEntry, candidates, config.getEloRangePhase1());
                if (queueEntry != null) break;
                queueEntry = this.findTeamByLevel(teamEntry, candidates, config.getLevelRangePhase2());
                break;
            }
            case 3: {
                queueEntry = this.findTeamByElo(teamEntry, candidates, config.getEloRangePhase1());
                if (queueEntry != null || (queueEntry = this.findTeamByLevel(teamEntry, candidates, config.getLevelRangePhase2())) != null) break;
                queueEntry = (QueueEntry)CollectionsKt.firstOrNull(candidates);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return queueEntry;
    }

    /*
     * WARNING - void declaration
     */
    private final QueueEntry findByElo(QueueEntry entry, List<QueueEntry> candidates, int range) {
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = candidates;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            QueueEntry it = (QueueEntry)element$iv$iv;
            boolean bl = false;
            if (!(Math.abs(it.getElo() - entry.getElo()) <= range)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                QueueEntry it = (QueueEntry)minElem$iv;
                boolean bl = false;
                int minValue$iv = Math.abs(it.getElo() - entry.getElo());
                do {
                    Object e$iv = iterator$iv.next();
                    QueueEntry it2 = (QueueEntry)e$iv;
                    $i$a$-minByOrNull-RankedMatchmaker$findByElo$2 = false;
                    int v$iv = Math.abs(it2.getElo() - entry.getElo());
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final QueueEntry findByLevel(QueueEntry entry, List<QueueEntry> candidates, int range) {
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = candidates;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            QueueEntry it = (QueueEntry)element$iv$iv;
            boolean bl = false;
            if (!(Math.abs(it.getAveragePokemonLevel() - entry.getAveragePokemonLevel()) <= range)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                QueueEntry it = (QueueEntry)minElem$iv;
                boolean bl = false;
                int minValue$iv = Math.abs(it.getAveragePokemonLevel() - entry.getAveragePokemonLevel());
                do {
                    Object e$iv = iterator$iv.next();
                    QueueEntry it2 = (QueueEntry)e$iv;
                    $i$a$-minByOrNull-RankedMatchmaker$findByLevel$2 = false;
                    int v$iv = Math.abs(it2.getAveragePokemonLevel() - entry.getAveragePokemonLevel());
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final QueueEntry findTeamByElo(QueueEntry teamEntry, List<QueueEntry> candidates, int range) {
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = candidates;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            QueueEntry it = (QueueEntry)element$iv$iv;
            boolean bl = false;
            if (!(Math.abs(it.getElo() - teamEntry.getElo()) <= range)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                QueueEntry it = (QueueEntry)minElem$iv;
                boolean bl = false;
                int minValue$iv = Math.abs(it.getElo() - teamEntry.getElo());
                do {
                    Object e$iv = iterator$iv.next();
                    QueueEntry it2 = (QueueEntry)e$iv;
                    $i$a$-minByOrNull-RankedMatchmaker$findTeamByElo$2 = false;
                    int v$iv = Math.abs(it2.getElo() - teamEntry.getElo());
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final QueueEntry findTeamByLevel(QueueEntry teamEntry, List<QueueEntry> candidates, int range) {
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = candidates;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            QueueEntry it = (QueueEntry)element$iv$iv;
            boolean bl = false;
            if (!(Math.abs(it.getAveragePokemonLevel() - teamEntry.getAveragePokemonLevel()) <= range)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                QueueEntry it = (QueueEntry)minElem$iv;
                boolean bl = false;
                int minValue$iv = Math.abs(it.getAveragePokemonLevel() - teamEntry.getAveragePokemonLevel());
                do {
                    Object e$iv = iterator$iv.next();
                    QueueEntry it2 = (QueueEntry)e$iv;
                    $i$a$-minByOrNull-RankedMatchmaker$findTeamByLevel$2 = false;
                    int v$iv = Math.abs(it2.getAveragePokemonLevel() - teamEntry.getAveragePokemonLevel());
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    @NotNull
    public final Pair<Integer, Integer> calculateEloChange(int winnerElo, int loserElo, @NotNull RankedConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        int diff = loserElo - winnerElo;
        int winnerGain = diff >= config.getEloAdjustmentThreshold() ? config.getAdjustedEloGainHigh() : (diff <= -config.getEloAdjustmentThreshold() ? config.getAdjustedEloGainLow() : config.getBaseEloChange());
        int loserLoss = diff >= config.getEloAdjustmentThreshold() ? config.getAdjustedEloLossLow() : (diff <= -config.getEloAdjustmentThreshold() ? config.getAdjustedEloLossHigh() : config.getBaseEloChange());
        return new Pair((Object)winnerGain, (Object)loserLoss);
    }

    /*
     * WARNING - void declaration
     */
    public final int calculateTeamAverageElo(@NotNull List<QueueEntry> team) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(team, (String)"team");
        if (team.isEmpty()) {
            return 100;
        }
        Iterable $this$map$iv = team;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            QueueEntry queueEntry = (QueueEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getElo());
        }
        return (int)CollectionsKt.averageOfInt((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MatchmakingPhase.values().length];
            try {
                nArray[MatchmakingPhase.ELO_MATCHING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MatchmakingPhase.LEVEL_MATCHING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MatchmakingPhase.FCFS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

