/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.ranked;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.scheduling.SchedulingFunctionsKt;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.BattleStartResult;
import com.cobblemon.mod.common.battles.ErroredBattleStart;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.config.Position;
import com.music176.pokemonleague.duel.DuelManager;
import com.music176.pokemonleague.economy.EconomyManager;
import com.music176.pokemonleague.gym.GymData;
import com.music176.pokemonleague.gym.GymManager;
import com.music176.pokemonleague.integration.FTBQuestsIntegration;
import com.music176.pokemonleague.inventory.InventoryManager;
import com.music176.pokemonleague.league.LeagueManager;
import com.music176.pokemonleague.profile.PlayerProfile;
import com.music176.pokemonleague.profile.PlayerProfileManager;
import com.music176.pokemonleague.ranked.MatchResult;
import com.music176.pokemonleague.ranked.QueueEntry;
import com.music176.pokemonleague.ranked.RankedConfig;
import com.music176.pokemonleague.ranked.RankedMatchmaker;
import com.music176.pokemonleague.ranked.RankedPlayer;
import com.music176.pokemonleague.ranked.RankedQueue;
import com.music176.pokemonleague.ranked.RankedRank;
import com.music176.pokemonleague.ranked.RankedRewards;
import com.music176.pokemonleague.ranked.RankedSession;
import com.music176.pokemonleague.ranked.RankedSessionState;
import com.music176.pokemonleague.ranked.RankedStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003J\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u000f\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u0003J\u000f\u0010\u000e\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0003J\r\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001cJ'\u0010\"\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b\"\u0010#J3\u0010'\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0$H\u0002\u00a2\u0006\u0004\b'\u0010(J)\u0010,\u001a\u00020\u00062\f\u0010*\u001a\b\u0012\u0004\u0012\u00020)0$2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020)0$\u00a2\u0006\u0004\b,\u0010-J\u001f\u00100\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010/\u001a\u00020.H\u0002\u00a2\u0006\u0004\b0\u00101J\u001f\u00102\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010/\u001a\u00020.H\u0002\u00a2\u0006\u0004\b2\u00101J\u0017\u00103\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b3\u0010\u001cJ\u001d\u00106\u001a\u00020\u00062\u0006\u00104\u001a\u00020)2\u0006\u00105\u001a\u00020\u0016\u00a2\u0006\u0004\b6\u00107J\u0015\u00109\u001a\u00020\u00162\u0006\u00108\u001a\u00020)\u00a2\u0006\u0004\b9\u0010:J\u0015\u0010<\u001a\u00020\u00162\u0006\u0010;\u001a\u00020\u001f\u00a2\u0006\u0004\b<\u0010=J\u0017\u0010?\u001a\u0004\u0018\u00010\u00192\u0006\u0010>\u001a\u00020)\u00a2\u0006\u0004\b?\u0010@J\u0017\u0010A\u001a\u0004\u0018\u00010\u00192\u0006\u00108\u001a\u00020)\u00a2\u0006\u0004\bA\u0010@J\u0015\u0010B\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u001f\u00a2\u0006\u0004\bB\u0010CJ\u0015\u0010D\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u001f\u00a2\u0006\u0004\bD\u0010CJ\u001f\u0010G\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020EH\u0002\u00a2\u0006\u0004\bG\u0010HJ\u0017\u0010I\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\bI\u0010\u001cJ\u001f\u0010K\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010J\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\bK\u0010LJ\u0013\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00190M\u00a2\u0006\u0004\bN\u0010OJ\u0015\u0010P\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\bP\u0010\u0018R\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010QR$\u0010T\u001a\u00020R2\u0006\u0010S\u001a\u00020R8\u0006@BX\u0086.\u00a2\u0006\f\n\u0004\bT\u0010U\u001a\u0004\bV\u0010WR \u0010Y\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00190X8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bY\u0010ZR \u0010[\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020)0X8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b[\u0010ZR \u0010\\\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020)0X8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\\\u0010ZR\u0016\u0010]\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b]\u0010^\u00a8\u0006_"}, d2={"Lcom/music176/pokemonleague/ranked/RankedManager;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "initialize", "(Lnet/minecraft/server/MinecraftServer;)V", "shutdown", "reloadConfig", "startQueueProcessing", "processQueueLoop", "startSeasonChecker", "checkSeasonLoop", "performSeasonReset", "Lcom/music176/pokemonleague/ranked/MatchResult;", "match", "createSessionFromMatch", "(Lcom/music176/pokemonleague/ranked/MatchResult;)V", "", "arenaId", "", "isArenaAvailable", "(Ljava/lang/String;)Z", "Lcom/music176/pokemonleague/ranked/RankedSession;", "session", "teleportPlayersToArena", "(Lcom/music176/pokemonleague/ranked/RankedSession;)V", "startCountdown", "startBattle", "Lnet/minecraft/class_3222;", "player1", "player2", "start1v1Battle", "(Lcom/music176/pokemonleague/ranked/RankedSession;Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;)V", "", "team1Players", "team2Players", "start2v2Battle", "(Lcom/music176/pokemonleague/ranked/RankedSession;Ljava/util/List;Ljava/util/List;)V", "Ljava/util/UUID;", "winnerIds", "loserIds", "handleBattleResult", "(Ljava/util/List;Ljava/util/List;)V", "", "winningTeam", "updateElo", "(Lcom/music176/pokemonleague/ranked/RankedSession;I)V", "notifyBattleResult", "teleportPlayersBack", "sessionId", "cancelled", "endSession", "(Ljava/util/UUID;Z)V", "playerId", "isPlayerInSession", "(Ljava/util/UUID;)Z", "player", "canPlayerJoinQueue", "(Lnet/minecraft/class_3222;)Z", "battleId", "getSessionByBattleId", "(Ljava/util/UUID;)Lcom/music176/pokemonleague/ranked/RankedSession;", "getPlayerSession", "handlePlayerDisconnect", "(Lnet/minecraft/class_3222;)V", "playerQuit", "Lcom/music176/pokemonleague/config/Position;", "position", "teleportToPosition", "(Lnet/minecraft/class_3222;Lcom/music176/pokemonleague/config/Position;)V", "recallAllPokemon", "message", "notifyMatchPlayers", "(Lcom/music176/pokemonleague/ranked/MatchResult;Ljava/lang/String;)V", "", "getActiveSessions", "()Ljava/util/Collection;", "isArenaOccupiedByRanked", "Lnet/minecraft/server/MinecraftServer;", "Lcom/music176/pokemonleague/ranked/RankedConfig;", "value", "config", "Lcom/music176/pokemonleague/ranked/RankedConfig;", "getConfig", "()Lcom/music176/pokemonleague/ranked/RankedConfig;", "Ljava/util/concurrent/ConcurrentHashMap;", "activeSessions", "Ljava/util/concurrent/ConcurrentHashMap;", "playerToSession", "battleToSession", "isProcessingQueue", "Z", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nRankedManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RankedManager.kt\ncom/music176/pokemonleague/ranked/RankedManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,910:1\n1869#2,2:911\n1869#2,2:913\n1869#2,2:915\n1563#2:917\n1634#2,3:918\n774#2:921\n865#2,2:922\n1869#2,2:924\n1869#2,2:926\n1617#2,9:928\n1869#2:937\n1870#2:939\n1626#2:940\n1617#2,9:941\n1869#2:950\n1870#2:952\n1626#2:953\n1869#2,2:954\n1869#2,2:956\n1869#2,2:958\n1761#2,3:960\n1869#2,2:963\n1869#2,2:965\n1869#2,2:967\n1617#2,9:969\n1869#2:978\n1870#2:980\n1626#2:981\n1617#2,9:982\n1869#2:991\n1870#2:993\n1626#2:994\n774#2:995\n865#2,2:996\n1563#2:998\n1634#2,3:999\n774#2:1002\n865#2,2:1003\n1563#2:1005\n1634#2,3:1006\n774#2:1009\n865#2,2:1010\n1563#2:1012\n1634#2,3:1013\n774#2:1016\n865#2,2:1017\n1563#2:1019\n1634#2,3:1020\n1761#2,3:1024\n1869#2,2:1027\n1869#2,2:1029\n1869#2,2:1031\n1869#2,2:1033\n1869#2,2:1035\n1869#2,2:1037\n1869#2,2:1039\n774#2:1041\n865#2,2:1042\n1869#2,2:1044\n1869#2,2:1046\n1869#2:1048\n1869#2,2:1049\n1870#2:1051\n1869#2,2:1052\n1761#2,3:1054\n1869#2,2:1057\n1#3:938\n1#3:951\n1#3:979\n1#3:992\n1#3:1023\n*S KotlinDebug\n*F\n+ 1 RankedManager.kt\ncom/music176/pokemonleague/ranked/RankedManager\n*L\n69#1:911,2\n112#1:913,2\n165#1:915,2\n187#1:917\n187#1:918,3\n188#1:921\n188#1:922,2\n194#1:924,2\n200#1:926,2\n212#1:928,9\n212#1:937\n212#1:939\n212#1:940\n227#1:941,9\n227#1:950\n227#1:952\n227#1:953\n258#1:954,2\n268#1:956,2\n278#1:958,2\n310#1:960,3\n325#1:963,2\n334#1:965,2\n385#1:967,2\n405#1:969,9\n405#1:978\n405#1:980\n405#1:981\n406#1:982,9\n406#1:991\n406#1:993\n406#1:994\n433#1:995\n433#1:996,2\n433#1:998\n433#1:999,3\n434#1:1002\n434#1:1003,2\n434#1:1005\n434#1:1006,3\n480#1:1009\n480#1:1010,2\n480#1:1012\n480#1:1013,3\n492#1:1016\n492#1:1017,2\n492#1:1019\n492#1:1020,3\n554#1:1024,3\n560#1:1027,2\n599#1:1029,2\n635#1:1031,2\n673#1:1033,2\n697#1:1035,2\n726#1:1037,2\n735#1:1039,2\n815#1:1041\n815#1:1042,2\n816#1:1044,2\n845#1:1046,2\n874#1:1048\n878#1:1049,2\n874#1:1051\n889#1:1052,2\n907#1:1054,3\n355#1:1057,2\n212#1:938\n227#1:951\n405#1:979\n406#1:992\n*E\n"})
public final class RankedManager {
    @NotNull
    public static final RankedManager INSTANCE = new RankedManager();
    @Nullable
    private static MinecraftServer server;
    private static RankedConfig config;
    @NotNull
    private static final ConcurrentHashMap<UUID, RankedSession> activeSessions;
    @NotNull
    private static final ConcurrentHashMap<UUID, UUID> playerToSession;
    @NotNull
    private static final ConcurrentHashMap<UUID, UUID> battleToSession;
    private static boolean isProcessingQueue;

    private RankedManager() {
    }

    @NotNull
    public final RankedConfig getConfig() {
        RankedConfig rankedConfig = config;
        if (rankedConfig != null) {
            return rankedConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    public final void initialize(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        RankedManager.server = server;
        config = RankedConfig.Companion.load();
        this.startQueueProcessing();
        this.startSeasonChecker();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("RankedManager initialized - Season " + this.getConfig().getSeasonData().getCurrentSeason());
    }

    public final void shutdown() {
        isProcessingQueue = false;
        Set set = activeSessions.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)set);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID sessionId = (UUID)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)sessionId);
            INSTANCE.endSession(sessionId, true);
        }
        RankedQueue.INSTANCE.clearAllQueues();
        RankedConfig.Companion.save(this.getConfig());
        server = null;
        PokemonLeagueMod.INSTANCE.getLOGGER().info("RankedManager shutdown");
    }

    public final void reloadConfig() {
        config = RankedConfig.Companion.load();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("RankedManager config reloaded");
    }

    private final void startQueueProcessing() {
        isProcessingQueue = true;
        this.processQueueLoop();
    }

    private final void processQueueLoop() {
        if (!isProcessingQueue || server == null) {
            return;
        }
        try {
            List<MatchResult> matches = RankedQueue.INSTANCE.processQueue(this.getConfig());
            Iterable $this$forEach$iv = matches;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MatchResult match = (MatchResult)element$iv;
                boolean bl = false;
                INSTANCE.createSessionFromMatch(match);
            }
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Error processing ranked queue", (Throwable)e);
        }
        SchedulingFunctionsKt.afterOnServer((float)this.getConfig().getQueueProcessInterval(), RankedManager::processQueueLoop$lambda$1);
    }

    private final void startSeasonChecker() {
        this.checkSeasonLoop();
    }

    private final void checkSeasonLoop() {
        if (server == null) {
            return;
        }
        if (this.getConfig().getSeasonData().hasSeasonEnded()) {
            this.performSeasonReset();
        }
        SchedulingFunctionsKt.afterOnServer((float)3600.0f, RankedManager::checkSeasonLoop$lambda$0);
    }

    public final void performSeasonReset() {
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Performing season reset...");
        RankedRewards.INSTANCE.distributeSeasonRewards();
        PlayerProfileManager.INSTANCE.resetAllRankedElo();
        this.getConfig().getSeasonData().startNewSeason();
        RankedConfig.Companion.save(this.getConfig());
        Object object = server;
        if (object != null && (object = object.method_3760()) != null && (object = object.method_14571()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3222 player = (class_3222)element$iv;
                boolean bl = false;
                player.method_43496((class_2561)class_2561.method_43470((String)("=== NOUVELLE SAISON " + INSTANCE.getConfig().getSeasonData().getCurrentSeason() + " ===")).method_27694(RankedManager::performSeasonReset$lambda$0$0));
                player.method_43496((class_2561)class_2561.method_43470((String)"Tous les ELO ont ete reinitialises a 100!").method_27694(RankedManager::performSeasonReset$lambda$0$1));
            }
        }
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Season " + this.getConfig().getSeasonData().getCurrentSeason() + " started");
    }

    /*
     * WARNING - void declaration
     */
    private final void createSessionFromMatch(MatchResult match) {
        UUID playerId;
        void $this$mapNotNullTo$iv$iv;
        Object element$iv$iv$iv2;
        void $this$mapNotNullTo$iv$iv2;
        Iterator $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = GymManager.INSTANCE.getGymConfig().getGyms();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GymData gymData = (GymData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((GymData)((Object)it)).getGymId());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!INSTANCE.isArenaAvailable(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List availableArenas = (List)destination$iv$iv;
        if (availableArenas.isEmpty()) {
            class_3222 player;
            this.notifyMatchPlayers(match, "Aucune arene disponible! Vous restez en file d'attente.");
            Iterable $this$forEach$iv = match.getTeam1();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                QueueEntry entry = (QueueEntry)element$iv;
                boolean bl = false;
                MinecraftServer minecraftServer = server;
                player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(entry.getPlayerId()) : null;
                if (player == null) continue;
                RankedQueue.addToQueue$default(RankedQueue.INSTANCE, player, entry.getMode(), null, 4, null);
            }
            $this$forEach$iv = match.getTeam2();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                QueueEntry entry = (QueueEntry)element$iv;
                boolean bl = false;
                MinecraftServer minecraftServer = server;
                player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(entry.getPlayerId()) : null;
                if (player == null) continue;
                RankedQueue.addToQueue$default(RankedQueue.INSTANCE, player, entry.getMode(), null, 4, null);
            }
            return;
        }
        String arenaId = (String)CollectionsKt.random((Collection)availableArenas, (Random)((Random)Random.Default));
        Iterable $this$mapNotNull$iv = match.getTeam1();
        boolean $i$f$mapNotNull = false;
        Iterable entry = $this$mapNotNull$iv;
        Iterable<RankedPlayer> destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            RankedPlayer rankedPlayer;
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl = false;
            QueueEntry entry2 = (QueueEntry)element$iv$iv;
            boolean bl2 = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(entry2.getPlayerId())) == null) {
                rankedPlayer = null;
            } else {
                MinecraftServer player = minecraftServer;
                UUID uUID = entry2.getPlayerId();
                String string = entry2.getPlayerName();
                int n = entry2.getElo();
                String string2 = player.method_37908().method_27983().method_29177().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                rankedPlayer = new RankedPlayer(uUID, string, n, string2, player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
            }
            if (rankedPlayer == null) continue;
            RankedPlayer it$iv$iv = rankedPlayer;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List team1Players = (List)destination$iv$iv2;
        Iterable $this$mapNotNull$iv2 = match.getTeam2();
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv2 = $this$mapNotNull$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            RankedPlayer rankedPlayer;
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
            boolean bl = false;
            QueueEntry entry3 = (QueueEntry)element$iv$iv;
            boolean bl4 = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(entry3.getPlayerId())) == null) {
                rankedPlayer = null;
            } else {
                MinecraftServer player = minecraftServer;
                UUID uUID = entry3.getPlayerId();
                String string = entry3.getPlayerName();
                int n = entry3.getElo();
                String string3 = player.method_37908().method_27983().method_29177().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                rankedPlayer = new RankedPlayer(uUID, string, n, string3, player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
            }
            if (rankedPlayer == null) continue;
            RankedPlayer it$iv$iv = rankedPlayer;
            boolean bl5 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List team2Players = (List)destination$iv$iv3;
        if (team1Players.size() != match.getTeam1().size() || team2Players.size() != match.getTeam2().size()) {
            this.notifyMatchPlayers(match, "Un joueur s'est deconnecte! Match annule.");
            return;
        }
        RankedSession session = new RankedSession(null, match.getMode(), team1Players, team2Players, arenaId, null, null, 0L, 225, null);
        ((Map)activeSessions).put(session.getSessionId(), session);
        Iterable $this$forEach$iv = session.getAllPlayerIds();
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID playerId2 = (UUID)element$iv;
            boolean bl = false;
            ((Map)playerToSession).put(playerId2, session.getSessionId());
        }
        String modeText = match.getMode().getDisplayName();
        Object object = GymManager.INSTANCE.getGymConfig().getGym(arenaId);
        if (object == null || (object = ((GymData)object).getGymName()) == null) {
            object = arenaId;
        }
        Object arenaName = object;
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Ranked session created: " + session.getSessionId() + " (" + modeText + " at " + (String)arenaName + ")");
        Iterable $this$forEach$iv2 = session.getAllPlayerIds();
        boolean $i$f$forEach4 = false;
        for (Object element$iv : $this$forEach$iv2) {
            playerId = (UUID)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            class_3222 player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
            if (player == null) continue;
            String string = player.method_5477().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            int totalRanked = PlayerProfileManager.INSTANCE.recordRankedStarted(playerId, string);
            FTBQuestsIntegration.INSTANCE.checkAndCompleteRankedQuests(player, totalRanked);
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Player " + player.method_5477().getString() + " has started " + totalRanked + " ranked matches total");
        }
        $this$forEach$iv2 = session.getAllPlayerIds();
        $i$f$forEach4 = false;
        for (Object element$iv : $this$forEach$iv2) {
            class_3222 player;
            playerId = (UUID)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            class_3222 class_32222 = player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
            if (class_32222 != null) {
                class_32222.method_43496((class_2561)class_2561.method_43470((String)("Match trouve! " + modeText)).method_27694(RankedManager::createSessionFromMatch$lambda$8$0));
            }
            class_3222 class_32223 = player;
            if (class_32223 == null) continue;
            class_32223.method_43496((class_2561)class_2561.method_43470((String)("Arene: " + (String)arenaName)).method_27694(RankedManager::createSessionFromMatch$lambda$8$1));
        }
        this.teleportPlayersToArena(session);
        this.startCountdown(session);
    }

    private final boolean isArenaAvailable(String arenaId) {
        boolean bl;
        block5: {
            if (GymManager.INSTANCE.isGymOccupied(arenaId)) {
                return false;
            }
            if (DuelManager.INSTANCE.isArenaOccupiedByDuel(arenaId)) {
                return false;
            }
            Collection<RankedSession> collection = activeSessions.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RankedSession it = (RankedSession)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getArenaId(), (Object)arenaId)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return !bl;
    }

    private final void teleportPlayersToArena(RankedSession session) {
        GymData gymData = GymManager.INSTANCE.getGymConfig().getGym(session.getArenaId());
        if (gymData == null) {
            return;
        }
        GymData gymData2 = gymData;
        Position team1Spawn = gymData2.getPlayerSpawnPosition();
        Iterable $this$forEach$iv = session.getTeam1();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RankedPlayer rankedPlayer = (RankedPlayer)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(rankedPlayer.getPlayerId())) == null) continue;
            MinecraftServer player = minecraftServer;
            InventoryManager.INSTANCE.saveAndClearInventory((class_3222)player);
            INSTANCE.teleportToPosition((class_3222)player, team1Spawn);
        }
        Position team2Spawn = gymData2.getNpcSpawnPosition();
        Iterable $this$forEach$iv2 = session.getTeam2();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            RankedPlayer rankedPlayer = (RankedPlayer)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(rankedPlayer.getPlayerId())) == null) continue;
            MinecraftServer player = minecraftServer;
            InventoryManager.INSTANCE.saveAndClearInventory((class_3222)player);
            INSTANCE.teleportToPosition((class_3222)player, team2Spawn);
        }
    }

    private final void startCountdown(RankedSession session) {
        session.setState(RankedSessionState.COUNTDOWN);
        int countdownSeconds = this.getConfig().getCountdownSeconds();
        RankedManager.startCountdown$countdown(session, countdownSeconds);
    }

    /*
     * WARNING - void declaration
     */
    private final void startBattle(RankedSession session) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        Object element$iv2;
        if (!activeSessions.containsKey(session.getSessionId())) {
            return;
        }
        session.setState(RankedSessionState.IN_BATTLE);
        String modeText = session.getMode().getDisplayName();
        Iterable $this$forEach$iv = session.getAllPlayerIds();
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            class_3222 player;
            UUID playerId = (UUID)element$iv2;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            class_3222 class_32222 = player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
            if (class_32222 != null) {
                class_32222.method_43496((class_2561)class_2561.method_43470((String)("=== COMBAT " + modeText + " ===")).method_27694(RankedManager::startBattle$lambda$0$0));
            }
            if (session.getMode().isRanked()) {
                class_3222 class_32223 = player;
                if (class_32223 != null) {
                    class_32223.method_43496((class_2561)class_2561.method_43470((String)"ELO en jeu!").method_27694(RankedManager::startBattle$lambda$0$1));
                }
            }
            class_3222 class_32224 = player;
            if (class_32224 == null) continue;
            class_32224.method_43496((class_2561)class_2561.method_43470((String)"Les items sont desactives dans ce mode!").method_27694(RankedManager::startBattle$lambda$0$2));
        }
        Iterable $this$mapNotNull$iv = session.getTeam1();
        boolean $i$f$mapNotNull = false;
        element$iv2 = $this$mapNotNull$iv;
        Iterable<class_3222> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            class_3222 it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RankedPlayer it = (RankedPlayer)element$iv$iv;
            boolean bl2 = false;
            MinecraftServer minecraftServer = server;
            if ((minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(it.getPlayerId()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List team1Players = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv2 = session.getTeam2();
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            class_3222 it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            RankedPlayer it = (RankedPlayer)element$iv$iv;
            boolean bl4 = false;
            MinecraftServer minecraftServer = server;
            if ((minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(it.getPlayerId()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List team2Players = (List)destination$iv$iv2;
        if (team1Players.isEmpty() || team2Players.isEmpty()) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Not enough players to start ranked battle");
            this.endSession(session.getSessionId(), true);
            return;
        }
        try {
            if (session.getMode().is2v2()) {
                this.start2v2Battle(session, team1Players, team2Players);
            } else {
                this.start1v1Battle(session, (class_3222)team1Players.get(0), (class_3222)team2Players.get(0));
            }
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to start ranked battle", (Throwable)e);
            this.endSession(session.getSessionId(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void start1v1Battle(RankedSession session, class_3222 player1, class_3222 player2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Pokemon it;
        void $this$filterTo$iv$iv2;
        PlayerPartyStore party1 = Cobblemon.INSTANCE.getStorage().getParty(player1);
        PlayerPartyStore party2 = Cobblemon.INSTANCE.getStorage().getParty(player2);
        Iterable $this$filter$iv = (Iterable)party1;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (Pokemon)element$iv$iv;
            boolean bl = false;
            if (!(!it.isFainted())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (Pokemon)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BattlePokemon.Companion.playerOwned(it));
        }
        List pokemon1 = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = (Iterable)party2;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        BattleActor[] destination$iv$iv2 = (BattleActor[])new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pokemon it2 = (Pokemon)element$iv$iv;
            boolean bl = false;
            if (!(!it2.isFainted())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pokemon it2 = (Pokemon)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(BattlePokemon.Companion.playerOwned(it2));
        }
        List pokemon2 = (List)destination$iv$iv2;
        if (pokemon1.isEmpty() || pokemon2.isEmpty()) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Players don't have valid Pokemon for ranked battle");
            this.endSession(session.getSessionId(), true);
            return;
        }
        UUID uUID = player1.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerBattleActor actor1 = new PlayerBattleActor(uUID, pokemon1);
        UUID uUID2 = player2.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        PlayerBattleActor actor2 = new PlayerBattleActor(uUID2, pokemon2);
        destination$iv$iv2 = new BattleActor[]{actor1};
        BattleSide side1 = new BattleSide(destination$iv$iv2);
        BattleActor[] $i$f$mapTo22 = new BattleActor[]{actor2};
        BattleSide side2 = new BattleSide($i$f$mapTo22);
        BattleFormat format = BattleFormat.Companion.getGEN_9_SINGLES();
        Set originalRuleSet = format.getRuleSet();
        format.setRuleSet(SetsKt.plus((Set)originalRuleSet, (Object)"Bag Clause"));
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Starting 1v1 ranked with Bag Clause. RuleSet: " + format.getRuleSet());
        try {
            BattleStartResult result = BattleRegistry.startBattle((BattleFormat)format, (BattleSide)side1, (BattleSide)side2, (boolean)false);
            result.ifErrored(arg_0 -> RankedManager.start1v1Battle$lambda$4(session, arg_0));
            result.ifSuccessful(arg_0 -> RankedManager.start1v1Battle$lambda$5(session, arg_0));
        }
        finally {
            format.setRuleSet(originalRuleSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void start2v2Battle(RankedSession session, List<? extends class_3222> team1Players, List<? extends class_3222> team2Players) {
        BattleActor[] party;
        Collection collection;
        Iterable<BattlePokemon> destination$iv$iv;
        List team1Actors = new ArrayList();
        for (class_3222 class_32222 : team1Players) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl;
            Pokemon it;
            void $this$filterTo$iv$iv;
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(class_32222);
            Iterable $this$filter$iv = (Iterable)playerPartyStore;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Pokemon)element$iv$iv;
                bl = false;
                if (!(!it.isFainted())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Pokemon)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                collection.add((BattlePokemon)BattlePokemon.Companion.playerOwned(it));
            }
            List pokemon = (List)destination$iv$iv;
            if (pokemon.isEmpty()) {
                PokemonLeagueMod.INSTANCE.getLOGGER().error("Player " + class_32222.method_5477().getString() + " has no healthy Pokemon");
                this.endSession(session.getSessionId(), true);
                return;
            }
            UUID uUID = class_32222.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            team1Actors.add(new PlayerBattleActor(uUID, pokemon));
        }
        List team2Actors = new ArrayList();
        for (class_3222 class_32223 : team2Players) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl;
            Pokemon it;
            void $this$filterTo$iv$iv;
            party = Cobblemon.INSTANCE.getStorage().getParty(class_32223);
            Iterable $this$filter$iv = (Iterable)party;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Pokemon)element$iv$iv;
                bl = false;
                if (!(!it.isFainted())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Pokemon)item$iv$iv;
                collection = destination$iv$iv3;
                bl = false;
                collection.add(BattlePokemon.Companion.playerOwned(it));
            }
            List pokemon = (List)destination$iv$iv3;
            if (pokemon.isEmpty()) {
                PokemonLeagueMod.INSTANCE.getLOGGER().error("Player " + class_32223.method_5477().getString() + " has no healthy Pokemon");
                this.endSession(session.getSessionId(), true);
                return;
            }
            UUID uUID = class_32223.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            team2Actors.add(new PlayerBattleActor(uUID, pokemon));
        }
        if (team1Actors.size() != 2 || team2Actors.size() != 2) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Not enough players for 2v2: team1=" + team1Actors.size() + ", team2=" + team2Actors.size());
            this.endSession(session.getSessionId(), true);
            return;
        }
        BattleActor[] battleActorArray = new BattleActor[]{team1Actors.get(0), team1Actors.get(1)};
        BattleSide battleSide = new BattleSide(battleActorArray);
        party = new BattleActor[]{team2Actors.get(0), team2Actors.get(1)};
        BattleSide battleSide2 = new BattleSide(party);
        BattleFormat format = BattleFormat.Companion.getGEN_9_MULTI();
        Set originalRuleSet = format.getRuleSet();
        format.setRuleSet(SetsKt.plus((Set)originalRuleSet, (Object)"Bag Clause"));
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Starting 2v2 ranked with Bag Clause. RuleSet: " + format.getRuleSet());
        try {
            BattleStartResult result = BattleRegistry.startBattle((BattleFormat)format, (BattleSide)battleSide, (BattleSide)battleSide2, (boolean)false);
            result.ifErrored(arg_0 -> RankedManager.start2v2Battle$lambda$4(session, arg_0));
            result.ifSuccessful(arg_0 -> RankedManager.start2v2Battle$lambda$5(session, arg_0));
        }
        finally {
            format.setRuleSet(originalRuleSet);
        }
    }

    public final void handleBattleResult(@NotNull List<UUID> winnerIds, @NotNull List<UUID> loserIds) {
        boolean bl;
        RankedSession session;
        block13: {
            Object object;
            Object object2;
            block11: {
                Intrinsics.checkNotNullParameter(winnerIds, (String)"winnerIds");
                Intrinsics.checkNotNullParameter(loserIds, (String)"loserIds");
                for (Object it : (Iterable)winnerIds) {
                    boolean bl2 = false;
                    if ((it = playerToSession.get(it)) == null) continue;
                    object2 = it;
                    break block11;
                }
                object2 = object = null;
            }
            if (object2 == null) {
                Object object3;
                block12: {
                    for (UUID it : (Iterable)loserIds) {
                        boolean bl3 = false;
                        UUID uUID = playerToSession.get(it);
                        if (uUID == null) continue;
                        object3 = uUID;
                        break block12;
                    }
                    object3 = object = null;
                }
                if (object3 == null) {
                    return;
                }
            }
            Object sessionId = object;
            RankedSession rankedSession = activeSessions.get(sessionId);
            if (rankedSession == null) {
                return;
            }
            session = rankedSession;
            if (session.getState() != RankedSessionState.IN_BATTLE) {
                return;
            }
            session.setState(RankedSessionState.FINISHED);
            Iterable $this$any$iv = winnerIds;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UUID it = (UUID)element$iv;
                    boolean bl4 = false;
                    if (!session.isInTeam1(it)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        int winningTeam = bl ? 1 : 2;
        this.recallAllPokemon(session);
        Iterable $this$forEach$iv = session.getAllPlayerIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID playerId = (UUID)element$iv;
            boolean bl5 = false;
            MinecraftServer minecraftServer = server;
            class_3222 player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
            if (player == null) continue;
            Cobblemon.INSTANCE.getStorage().getParty(player).heal();
        }
        if (session.getMode().isRanked()) {
            this.updateElo(session, winningTeam);
        }
        this.notifyBattleResult(session, winningTeam);
        SchedulingFunctionsKt.afterOnServer((float)this.getConfig().getTeleportBackDelaySeconds(), () -> RankedManager.handleBattleResult$lambda$4(session));
    }

    private final void updateElo(RankedSession session, int winningTeam) {
        RankedStats serverPlayer;
        PlayerProfile profile;
        RankedPlayer player;
        int team1Elo = session.getTeam1AverageElo();
        int team2Elo = session.getTeam2AverageElo();
        Pair<Integer, Integer> pair = winningTeam == 1 ? RankedMatchmaker.INSTANCE.calculateEloChange(team1Elo, team2Elo, this.getConfig()) : RankedMatchmaker.INSTANCE.calculateEloChange(team2Elo, team1Elo, this.getConfig());
        int winnerGain = ((Number)pair.component1()).intValue();
        int loserLoss = ((Number)pair.component2()).intValue();
        List<RankedPlayer> winners = winningTeam == 1 ? session.getTeam1() : session.getTeam2();
        List<RankedPlayer> losers = winningTeam == 1 ? session.getTeam2() : session.getTeam1();
        Iterable $this$forEach$iv = winners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int winStreak;
            player = (RankedPlayer)element$iv;
            boolean bl = false;
            profile = PlayerProfileManager.INSTANCE.getOrCreateProfile(player.getPlayerId(), player.getPlayerName());
            if (session.getMode().is2v2()) {
                profile.getRankedStats().addElo2v2(winnerGain);
                var17_17 = profile.getRankedStats();
                var18_18 = var17_17.getWins2v2();
                var17_17.setWins2v2(var18_18 + 1);
            } else {
                profile.getRankedStats().addElo1v1(winnerGain);
                var17_17 = profile.getRankedStats();
                var18_18 = var17_17.getWins1v1();
                var17_17.setWins1v1(var18_18 + 1);
            }
            PlayerProfileManager.INSTANCE.saveProfiles();
            MinecraftServer minecraftServer = server;
            RankedStats rankedStats = serverPlayer = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(player.getPlayerId()) : null;
            if (rankedStats != null) {
                rankedStats.method_43496((class_2561)class_2561.method_43470((String)("+" + winnerGain + " ELO!")).method_27694(RankedManager::updateElo$lambda$0$0));
            }
            int newElo = session.getMode().is2v2() ? profile.getRankedStats().getElo2v2() : profile.getRankedStats().getElo1v1();
            RankedRank newRank = RankedRank.Companion.fromElo(newElo);
            int n = winStreak = session.getMode().is2v2() ? profile.getRankedStats().getWins2v2() : profile.getRankedStats().getWins1v1();
            if (serverPlayer != null) {
                EconomyManager.INSTANCE.giveRankedVictoryReward((class_3222)serverPlayer, newRank.name(), winStreak);
            }
            RankedRank oldRank = RankedRank.Companion.fromElo(player.getElo());
            if (newRank.ordinal() <= oldRank.ordinal()) continue;
            RankedStats rankedStats2 = serverPlayer;
            if (rankedStats2 == null) continue;
            rankedStats2.method_43496((class_2561)class_2561.method_43470((String)("Rang superieur: " + newRank.getDisplayName() + "!")).method_27694(arg_0 -> RankedManager.updateElo$lambda$0$1(newRank, arg_0)));
        }
        $this$forEach$iv = losers;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            player = (RankedPlayer)element$iv;
            boolean bl = false;
            profile = PlayerProfileManager.INSTANCE.getOrCreateProfile(player.getPlayerId(), player.getPlayerName());
            if (session.getMode().is2v2()) {
                profile.getRankedStats().removeElo2v2(loserLoss);
                serverPlayer = profile.getRankedStats();
                newElo = serverPlayer.getLosses2v2();
                serverPlayer.setLosses2v2(newElo + 1);
            } else {
                profile.getRankedStats().removeElo1v1(loserLoss);
                serverPlayer = profile.getRankedStats();
                newElo = serverPlayer.getLosses1v1();
                serverPlayer.setLosses1v1(newElo + 1);
            }
            PlayerProfileManager.INSTANCE.saveProfiles();
            MinecraftServer minecraftServer = server;
            RankedStats rankedStats = serverPlayer = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(player.getPlayerId()) : null;
            if (rankedStats != null) {
                rankedStats.method_43496((class_2561)class_2561.method_43470((String)("-" + loserLoss + " ELO")).method_27694(RankedManager::updateElo$lambda$1$0));
            }
            RankedRank oldRank = RankedRank.Companion.fromElo(player.getElo());
            int newElo = session.getMode().is2v2() ? profile.getRankedStats().getElo2v2() : profile.getRankedStats().getElo1v1();
            RankedRank newRank = RankedRank.Companion.fromElo(newElo);
            if (newRank.ordinal() >= oldRank.ordinal()) continue;
            RankedStats rankedStats3 = serverPlayer;
            if (rankedStats3 == null) continue;
            rankedStats3.method_43496((class_2561)class_2561.method_43470((String)("Rang inferieur: " + newRank.getDisplayName())).method_27694(RankedManager::updateElo$lambda$1$1));
        }
    }

    private final void notifyBattleResult(RankedSession session, int winningTeam) {
        List<RankedPlayer> winners = winningTeam == 1 ? session.getTeam1() : session.getTeam2();
        String winnerNames = CollectionsKt.joinToString$default((Iterable)winners, (CharSequence)", ", null, null, (int)0, null, RankedManager::notifyBattleResult$lambda$0, (int)30, null);
        int teamColor = winningTeam == 1 ? 0x5555FF : 0xFF5555;
        Iterable $this$forEach$iv = session.getAllPlayerIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 player;
            UUID playerId = (UUID)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            class_3222 class_32222 = player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
            if (class_32222 != null) {
                class_32222.method_43496((class_2561)class_2561.method_43473());
            }
            class_3222 class_32223 = player;
            if (class_32223 != null) {
                class_32223.method_43496((class_2561)class_2561.method_43470((String)"=== FIN DU COMBAT ===").method_27694(RankedManager::notifyBattleResult$lambda$1$0));
            }
            class_3222 class_32224 = player;
            if (class_32224 != null) {
                class_32224.method_43496((class_2561)class_2561.method_43470((String)("Vainqueur(s): " + winnerNames)).method_27694(arg_0 -> RankedManager.notifyBattleResult$lambda$1$1(teamColor, arg_0)));
            }
            if (session.getMode().isRanked()) continue;
            class_3222 class_32225 = player;
            if (class_32225 == null) continue;
            class_32225.method_43496((class_2561)class_2561.method_43470((String)"(Unranked - pas d'impact sur l'ELO)").method_27694(RankedManager::notifyBattleResult$lambda$1$2));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void teleportPlayersBack(RankedSession session) {
        $this$forEach$iv = session.getAllPlayers();
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block4: {
                rankedPlayer = (RankedPlayer)element$iv;
                $i$a$-forEach-RankedManager$teleportPlayersBack$1 = false;
                v0 = RankedManager.server;
                if (v0 == null || (v0 = v0.method_3760()) == null || (v0 = v0.method_14602(rankedPlayer.getPlayerId())) == null) continue;
                player = v0;
                worldKey = class_2960.method_12829((String)rankedPlayer.getOriginalWorld());
                var10_10 = RankedManager.server;
                if (var10_10 == null || (var11_11 = var10_10.method_29435()) == null) ** GOTO lbl-1000
                var12_12 = var11_11;
                for (T var14_14 : var12_12) {
                    it = (class_5321)var14_14;
                    $i$a$-find-RankedManager$teleportPlayersBack$1$level$1 = false;
                    if (!Intrinsics.areEqual((Object)it.method_29177(), (Object)worldKey)) continue;
                    v1 = var14_14;
                    break block4;
                }
                v1 = null;
            }
            var17_18 = v1;
            if (var17_18 == null) ** GOTO lbl-1000
            it = var17_18;
            $i$a$-let-RankedManager$teleportPlayersBack$1$level$2 = false;
            v2 = RankedManager.server;
            var18_19 /* !! */  = v2 != null ? v2.method_3847(it) : null;
            if (var18_19 /* !! */  != null) {
                v3 = var18_19 /* !! */ ;
            } else lbl-1000:
            // 3 sources

            {
                v3 = player.method_51469();
            }
            level = v3;
            player.method_14251(level, rankedPlayer.getOriginalX(), rankedPlayer.getOriginalY(), rankedPlayer.getOriginalZ(), rankedPlayer.getOriginalYaw(), rankedPlayer.getOriginalPitch());
            InventoryManager.INSTANCE.restoreInventory((class_3222)player);
        }
    }

    public final void endSession(@NotNull UUID sessionId, boolean cancelled) {
        UUID playerId;
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        RankedSession rankedSession = activeSessions.remove(sessionId);
        if (rankedSession == null) {
            return;
        }
        RankedSession session = rankedSession;
        Iterable $this$forEach$iv = session.getAllPlayerIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            playerId = (UUID)element$iv;
            boolean bl = false;
            playerToSession.remove(playerId);
        }
        UUID uUID = session.getBattleId();
        if (uUID != null) {
            UUID it = uUID;
            boolean bl = false;
            battleToSession.remove(it);
        }
        if (cancelled) {
            this.teleportPlayersBack(session);
            $this$forEach$iv = session.getAllPlayerIds();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3222 player;
                playerId = (UUID)element$iv;
                boolean bl = false;
                MinecraftServer minecraftServer = server;
                class_3222 class_32222 = player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
                if (class_32222 != null) {
                    class_32222.method_43496((class_2561)class_2561.method_43470((String)"Le match a ete annule.").method_27694(RankedManager::endSession$lambda$2$0));
                }
            }
        }
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Ranked session ended: " + sessionId + " (cancelled: " + cancelled + ")");
    }

    public final boolean isPlayerInSession(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return playerToSession.containsKey(playerId);
    }

    public final boolean canPlayerJoinQueue(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        if (this.isPlayerInSession(uUID)) {
            return false;
        }
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        if (RankedQueue.INSTANCE.isInQueue(uUID2)) {
            return false;
        }
        UUID uUID3 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
        if (DuelManager.INSTANCE.isPlayerInDuel(uUID3)) {
            return false;
        }
        UUID uUID4 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID4, (String)"getUUID(...)");
        if (GymManager.INSTANCE.isPlayerActive(uUID4)) {
            return false;
        }
        UUID uUID5 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID5, (String)"getUUID(...)");
        return !LeagueManager.INSTANCE.isPlayerActive(uUID5);
    }

    @Nullable
    public final RankedSession getSessionByBattleId(@NotNull UUID battleId) {
        Intrinsics.checkNotNullParameter((Object)battleId, (String)"battleId");
        UUID uUID = battleToSession.get(battleId);
        if (uUID == null) {
            return null;
        }
        UUID sessionId = uUID;
        return activeSessions.get(sessionId);
    }

    @Nullable
    public final RankedSession getPlayerSession(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        UUID uUID = playerToSession.get(playerId);
        if (uUID == null) {
            return null;
        }
        UUID sessionId = uUID;
        return activeSessions.get(sessionId);
    }

    /*
     * WARNING - void declaration
     */
    public final void handlePlayerDisconnect(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        if (InventoryManager.INSTANCE.hasSavedInventory(uUID)) {
            InventoryManager.INSTANCE.restoreInventory(player);
        }
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        RankedQueue.INSTANCE.removeFromQueue(uUID2);
        UUID uUID3 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
        RankedSession session = this.getPlayerSession(uUID3);
        if (session != null) {
            UUID uUID4 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID4, (String)"getUUID(...)");
            Integer playerTeam = session.getPlayerTeam(uUID4);
            if (playerTeam != null) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                int n = 1;
                int winningTeam = playerTeam == n ? 2 : 1;
                Iterable iterable = session.getAllPlayerIds();
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    UUID it = (UUID)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)player.method_5667()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    class_3222 p;
                    UUID playerId = (UUID)element$iv;
                    boolean bl = false;
                    MinecraftServer minecraftServer = server;
                    class_3222 class_32222 = p = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
                    if (class_32222 == null) continue;
                    class_32222.method_43496((class_2561)class_2561.method_43470((String)(player.method_5477().getString() + " s'est deconnecte!")).method_27694(RankedManager::handlePlayerDisconnect$lambda$1$0));
                }
                if (session.getMode().isRanked() && session.getState() == RankedSessionState.IN_BATTLE) {
                    this.updateElo(session, winningTeam);
                }
                this.teleportPlayersBack(session);
            }
            this.endSession(session.getSessionId(), false);
        }
    }

    public final void playerQuit(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        RankedSession rankedSession = this.getPlayerSession(uUID);
        if (rankedSession == null) {
            return;
        }
        RankedSession session = rankedSession;
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        Integer n = session.getPlayerTeam(uUID2);
        if (n == null) {
            return;
        }
        int playerTeam = n;
        int winningTeam = playerTeam == 1 ? 2 : 1;
        Iterable $this$forEach$iv = session.getAllPlayerIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 p;
            UUID playerId = (UUID)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            class_3222 class_32222 = p = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
            if (class_32222 == null) continue;
            class_32222.method_43496((class_2561)class_2561.method_43470((String)(player.method_5477().getString() + " a abandonne!")).method_27694(RankedManager::playerQuit$lambda$0$0));
        }
        if (session.getMode().isRanked()) {
            this.updateElo(session, winningTeam);
        }
        this.teleportPlayersBack(session);
        this.endSession(session.getSessionId(), false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void teleportToPosition(class_3222 player, Position position) {
        block3: {
            worldKey = class_2960.method_12829((String)position.getWorld());
            var5_4 = RankedManager.server;
            if (var5_4 == null || (var6_5 = var5_4.method_29435()) == null) ** GOTO lbl-1000
            var9_6 = var6_5;
            for (T var11_8 : var9_6) {
                it = (class_5321)var11_8;
                $i$a$-find-RankedManager$teleportToPosition$level$1 = false;
                if (!Intrinsics.areEqual((Object)it.method_29177(), (Object)worldKey)) continue;
                v0 = var11_8;
                break block3;
            }
            v0 = null;
        }
        var7_12 = v0;
        if (var7_12 == null) ** GOTO lbl-1000
        it = var7_12;
        $i$a$-let-RankedManager$teleportToPosition$level$2 = false;
        v1 = RankedManager.server;
        var8_13 /* !! */  = v1 != null ? v1.method_3847(it) : null;
        if (var8_13 /* !! */  != null) {
            v2 = var8_13 /* !! */ ;
        } else lbl-1000:
        // 3 sources

        {
            v2 = player.method_51469();
        }
        level = v2;
        player.method_14251(level, position.getX(), position.getY(), position.getZ(), position.getYaw(), position.getPitch());
    }

    private final void recallAllPokemon(RankedSession session) {
        Iterable $this$forEach$iv = session.getAllPlayerIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID playerId = (UUID)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(playerId)) == null) continue;
            MinecraftServer player = minecraftServer;
            try {
                PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty((class_3222)player);
                Iterable $this$forEach$iv2 = (Iterable)party;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Pokemon pokemon = (Pokemon)element$iv2;
                    boolean bl2 = false;
                    Object object = pokemon.getEntity();
                    if (object != null && (object = object.recallWithAnimation()) != null) continue;
                    pokemon.recall();
                    object = Unit.INSTANCE;
                }
            }
            catch (Exception e) {
                PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to recall Pokemon", (Throwable)e);
            }
        }
    }

    private final void notifyMatchPlayers(MatchResult match, String message) {
        List allPlayers = CollectionsKt.plus((Collection)match.getTeam1(), (Iterable)match.getTeam2());
        Iterable $this$forEach$iv = allPlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 player;
            QueueEntry entry = (QueueEntry)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            class_3222 class_32222 = player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(entry.getPlayerId()) : null;
            if (class_32222 == null) continue;
            class_32222.method_43496((class_2561)class_2561.method_43470((String)message).method_27694(RankedManager::notifyMatchPlayers$lambda$0$0));
        }
    }

    @NotNull
    public final Collection<RankedSession> getActiveSessions() {
        Collection<RankedSession> collection = activeSessions.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    public final boolean isArenaOccupiedByRanked(@NotNull String arenaId) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
            Collection<RankedSession> collection = activeSessions.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RankedSession it = (RankedSession)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getArenaId(), (Object)arenaId)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Unit processQueueLoop$lambda$1() {
        INSTANCE.processQueueLoop();
        return Unit.INSTANCE;
    }

    private static final Unit checkSeasonLoop$lambda$0() {
        INSTANCE.checkSeasonLoop();
        return Unit.INSTANCE;
    }

    private static final class_2583 performSeasonReset$lambda$0$0(class_2583 it) {
        return it.method_36139(16766720).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 performSeasonReset$lambda$0$1(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2583 createSessionFromMatch$lambda$8$0(class_2583 it) {
        return it.method_36139(0x55FF55).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 createSessionFromMatch$lambda$8$1(class_2583 it) {
        return it.method_36139(0xAAAAAA);
    }

    private static final void startCountdown$countdown(RankedSession $session, int seconds) {
        if (seconds > 0) {
            if (!activeSessions.containsKey($session.getSessionId())) {
                return;
            }
            Iterable $this$forEach$iv = $session.getAllPlayerIds();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3222 player;
                UUID playerId = (UUID)element$iv;
                boolean bl = false;
                MinecraftServer minecraftServer = server;
                class_3222 class_32222 = player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
                if (class_32222 == null) continue;
                class_32222.method_43496((class_2561)class_2561.method_43470((String)("Combat dans " + seconds + "...")).method_27694(RankedManager::startCountdown$countdown$lambda$0$0));
            }
            SchedulingFunctionsKt.afterOnServer((float)1.0f, () -> RankedManager.startCountdown$countdown$lambda$1(seconds, $session));
        } else {
            INSTANCE.startBattle($session);
        }
    }

    private static final class_2583 startCountdown$countdown$lambda$0$0(class_2583 it) {
        return it.method_36139(0xFFFF55).method_10982(Boolean.valueOf(true));
    }

    private static final Unit startCountdown$countdown$lambda$1(int $seconds, RankedSession $session) {
        RankedManager.startCountdown$countdown($session, $seconds - 1);
        return Unit.INSTANCE;
    }

    private static final class_2583 startBattle$lambda$0$0(class_2583 it) {
        return it.method_36139(0x55FF55).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 startBattle$lambda$0$1(class_2583 it) {
        return it.method_36139(0xFFAA00);
    }

    private static final class_2583 startBattle$lambda$0$2(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final Unit start1v1Battle$lambda$4(RankedSession $session, ErroredBattleStart error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to start 1v1 ranked: " + CollectionsKt.joinToString$default((Iterable)error.getErrors(), null, null, null, (int)0, null, null, (int)63, null));
        INSTANCE.endSession($session.getSessionId(), true);
        return Unit.INSTANCE;
    }

    private static final Unit start1v1Battle$lambda$5(RankedSession $session, PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        $session.setBattleId(battle.getBattleId());
        ((Map)battleToSession).put(battle.getBattleId(), $session.getSessionId());
        PokemonLeagueMod.INSTANCE.getLOGGER().info("1v1 ranked battle started: " + battle.getBattleId());
        return Unit.INSTANCE;
    }

    private static final Unit start2v2Battle$lambda$4(RankedSession $session, ErroredBattleStart error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to start 2v2 ranked: " + CollectionsKt.joinToString$default((Iterable)error.getErrors(), null, null, null, (int)0, null, null, (int)63, null));
        INSTANCE.endSession($session.getSessionId(), true);
        return Unit.INSTANCE;
    }

    private static final Unit start2v2Battle$lambda$5(RankedSession $session, PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        $session.setBattleId(battle.getBattleId());
        ((Map)battleToSession).put(battle.getBattleId(), $session.getSessionId());
        PokemonLeagueMod.INSTANCE.getLOGGER().info("2v2 ranked battle started: " + battle.getBattleId());
        return Unit.INSTANCE;
    }

    private static final Unit handleBattleResult$lambda$4(RankedSession $session) {
        INSTANCE.teleportPlayersBack($session);
        INSTANCE.endSession($session.getSessionId(), false);
        return Unit.INSTANCE;
    }

    private static final class_2583 updateElo$lambda$0$0(class_2583 it) {
        return it.method_36139(0x55FF55).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 updateElo$lambda$0$1(RankedRank $newRank, class_2583 it) {
        return it.method_10977($newRank.getColor()).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 updateElo$lambda$1$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 updateElo$lambda$1$1(class_2583 it) {
        return it.method_36139(0xFFAA00);
    }

    private static final CharSequence notifyBattleResult$lambda$0(RankedPlayer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPlayerName();
    }

    private static final class_2583 notifyBattleResult$lambda$1$0(class_2583 it) {
        return it.method_36139(16766720).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 notifyBattleResult$lambda$1$1(int $teamColor, class_2583 it) {
        return it.method_36139($teamColor).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 notifyBattleResult$lambda$1$2(class_2583 it) {
        return it.method_36139(0xAAAAAA);
    }

    private static final class_2583 endSession$lambda$2$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 handlePlayerDisconnect$lambda$1$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 playerQuit$lambda$0$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 notifyMatchPlayers$lambda$0$0(class_2583 it) {
        return it.method_36139(0xFFAA00);
    }

    static {
        activeSessions = new ConcurrentHashMap();
        playerToSession = new ConcurrentHashMap();
        battleToSession = new ConcurrentHashMap();
    }
}

