/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.ranked;

import com.music176.pokemonleague.profile.PlayerProfile;
import com.music176.pokemonleague.profile.PlayerProfileManager;
import com.music176.pokemonleague.ranked.RankedRank;
import com.music176.pokemonleague.ranked.RankedStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002,-B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\tJ\u0017\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00072\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001d\u0010\u001eJ)\u0010 \u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\u001f\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\u0004\b \u0010!J\u0019\u0010\"\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\u0004\b\"\u0010#J%\u0010'\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010&\u001a\u00020%\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010*\u001a\u00020)2\b\b\u0002\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\u0004\b*\u0010+\u00a8\u0006."}, d2={"Lcom/music176/pokemonleague/ranked/RankedLeaderboard;", "", "<init>", "()V", "", "count", "", "Lcom/music176/pokemonleague/ranked/RankedLeaderboard$LeaderboardEntry;", "getTop1v1", "(I)Ljava/util/List;", "getTop2v2", "Ljava/util/UUID;", "playerId", "getPosition1v1", "(Ljava/util/UUID;)Ljava/lang/Integer;", "getPosition2v2", "entry", "", "showDetails", "Lnet/minecraft/class_2561;", "formatEntry", "(Lcom/music176/pokemonleague/ranked/RankedLeaderboard$LeaderboardEntry;Z)Lnet/minecraft/class_2561;", "Lnet/minecraft/class_3222;", "player", "is2v2", "", "sendLeaderboardToPlayer", "(Lnet/minecraft/class_3222;Z)V", "", "getHudSummary", "(Z)Ljava/util/List;", "n", "isInTop", "(Ljava/util/UUID;IZ)Z", "getTopPlayer", "(Z)Lcom/music176/pokemonleague/ranked/RankedLeaderboard$LeaderboardEntry;", "newTopPlayer", "Lnet/minecraft/server/MinecraftServer;", "server", "broadcastTopPlayerChange", "(Ljava/lang/String;ZLnet/minecraft/server/MinecraftServer;)V", "Lcom/music176/pokemonleague/ranked/RankedLeaderboard$LeaderboardStats;", "getLeaderboardStats", "(Z)Lcom/music176/pokemonleague/ranked/RankedLeaderboard$LeaderboardStats;", "LeaderboardEntry", "LeaderboardStats", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nRankedLeaderboard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RankedLeaderboard.kt\ncom/music176/pokemonleague/ranked/RankedLeaderboard\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n1573#2:249\n1604#2,4:250\n1573#2:254\n1604#2,4:255\n1869#2,2:259\n1869#2,2:261\n1869#2,2:263\n774#2:265\n865#2,2:266\n1563#2:268\n1634#2,3:269\n*S KotlinDebug\n*F\n+ 1 RankedLeaderboard.kt\ncom/music176/pokemonleague/ranked/RankedLeaderboard\n*L\n34#1:249\n34#1:250,4\n53#1:254\n53#1:255,4\n128#1:259,2\n160#1:261,2\n189#1:263,2\n203#1:265\n203#1:266,2\n217#1:268\n217#1:269,3\n*E\n"})
public final class RankedLeaderboard {
    @NotNull
    public static final RankedLeaderboard INSTANCE = new RankedLeaderboard();

    private RankedLeaderboard() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LeaderboardEntry> getTop1v1(int count) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = PlayerProfileManager.INSTANCE.getTopRanked1v1(count);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void profile;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PlayerProfile playerProfile = (PlayerProfile)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            RankedStats stats = profile.getRankedStats();
            void v0 = index + true;
            UUID uUID = UUID.fromString(profile.getPlayerId());
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
            collection.add(new LeaderboardEntry((int)v0, uUID, profile.getPlayerName(), stats.getElo1v1(), stats.getRank1v1(), stats.getWins1v1(), stats.getLosses1v1(), stats.getWinRate1v1()));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getTop1v1$default(RankedLeaderboard rankedLeaderboard, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        return rankedLeaderboard.getTop1v1(n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LeaderboardEntry> getTop2v2(int count) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = PlayerProfileManager.INSTANCE.getTopRanked2v2(count);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void profile;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PlayerProfile playerProfile = (PlayerProfile)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            RankedStats stats = profile.getRankedStats();
            void v0 = index + true;
            UUID uUID = UUID.fromString(profile.getPlayerId());
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
            collection.add(new LeaderboardEntry((int)v0, uUID, profile.getPlayerName(), stats.getElo2v2(), stats.getRank2v2(), stats.getWins2v2(), stats.getLosses2v2(), stats.getWinRate2v2()));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getTop2v2$default(RankedLeaderboard rankedLeaderboard, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        return rankedLeaderboard.getTop2v2(n);
    }

    @Nullable
    public final Integer getPosition1v1(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return PlayerProfileManager.INSTANCE.getRank1v1Position(playerId);
    }

    @Nullable
    public final Integer getPosition2v2(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return PlayerProfileManager.INSTANCE.getRank2v2Position(playerId);
    }

    @NotNull
    public final class_2561 formatEntry(@NotNull LeaderboardEntry entry, boolean showDetails) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        int medalColor = switch (entry.getPosition()) {
            case 1 -> 16766720;
            case 2 -> 0xC0C0C0;
            case 3 -> 13467442;
            default -> 0xFFFFFF;
        };
        class_5250 baseText = class_2561.method_43470((String)("#" + entry.getPosition() + " " + entry.getPlayerName())).method_27694(arg_0 -> RankedLeaderboard.formatEntry$lambda$0(medalColor, arg_0));
        if (showDetails) {
            class_5250 class_52502 = baseText.method_10852((class_2561)class_2561.method_43470((String)" - ").method_27694(RankedLeaderboard::formatEntry$lambda$1)).method_10852((class_2561)class_2561.method_43470((String)entry.getRank().getDisplayName()).method_27694(arg_0 -> RankedLeaderboard.formatEntry$lambda$2(entry, arg_0))).method_10852((class_2561)class_2561.method_43470((String)(" (" + entry.getElo() + " ELO)")).method_27694(RankedLeaderboard::formatEntry$lambda$3));
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"append(...)");
            return (class_2561)class_52502;
        }
        Intrinsics.checkNotNull((Object)baseText);
        return (class_2561)baseText;
    }

    public static /* synthetic */ class_2561 formatEntry$default(RankedLeaderboard rankedLeaderboard, LeaderboardEntry leaderboardEntry, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return rankedLeaderboard.formatEntry(leaderboardEntry, bl);
    }

    public final void sendLeaderboardToPlayer(@NotNull class_3222 player, boolean is2v2) {
        Integer playerPosition;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        List<LeaderboardEntry> entries = is2v2 ? this.getTop2v2(10) : this.getTop1v1(10);
        String modeText = is2v2 ? "2v2" : "1v1";
        player.method_43496((class_2561)class_2561.method_43473());
        player.method_43496((class_2561)class_2561.method_43470((String)("=== Top 10 Ranked " + modeText + " ===")).method_27694(RankedLeaderboard::sendLeaderboardToPlayer$lambda$0));
        if (entries.isEmpty()) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Aucun joueur classe!").method_27694(RankedLeaderboard::sendLeaderboardToPlayer$lambda$1));
        } else {
            Iterable $this$forEach$iv = entries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LeaderboardEntry entry = (LeaderboardEntry)element$iv;
                boolean bl = false;
                player.method_43496(RankedLeaderboard.formatEntry$default(INSTANCE, entry, false, 2, null));
            }
        }
        if (is2v2) {
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            v1 = this.getPosition2v2(uUID);
        } else {
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            v1 = playerPosition = this.getPosition1v1(uUID);
        }
        if (playerPosition != null && playerPosition > 10) {
            player.method_43496((class_2561)class_2561.method_43473());
            player.method_43496((class_2561)class_2561.method_43470((String)("Votre position: #" + playerPosition)).method_27694(RankedLeaderboard::sendLeaderboardToPlayer$lambda$3));
        }
        player.method_43496((class_2561)class_2561.method_43473());
    }

    public static /* synthetic */ void sendLeaderboardToPlayer$default(RankedLeaderboard rankedLeaderboard, class_3222 class_32222, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        rankedLeaderboard.sendLeaderboardToPlayer(class_32222, bl);
    }

    @NotNull
    public final List<String> getHudSummary(boolean is2v2) {
        List<LeaderboardEntry> entries = is2v2 ? this.getTop2v2(5) : this.getTop1v1(5);
        String modeText = is2v2 ? "2v2" : "1v1";
        List lines = new ArrayList();
        lines.add("Top 5 Ranked " + modeText);
        lines.add("");
        if (entries.isEmpty()) {
            lines.add("Aucun joueur");
        } else {
            Iterable $this$forEach$iv = entries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LeaderboardEntry entry = (LeaderboardEntry)element$iv;
                boolean bl = false;
                lines.add("#" + entry.getPosition() + " " + entry.getPlayerName() + " - " + entry.getElo());
            }
        }
        return lines;
    }

    public static /* synthetic */ List getHudSummary$default(RankedLeaderboard rankedLeaderboard, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return rankedLeaderboard.getHudSummary(bl);
    }

    public final boolean isInTop(@NotNull UUID playerId, int n, boolean is2v2) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Integer position = is2v2 ? this.getPosition2v2(playerId) : this.getPosition1v1(playerId);
        return position != null && position <= n;
    }

    public static /* synthetic */ boolean isInTop$default(RankedLeaderboard rankedLeaderboard, UUID uUID, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 10;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return rankedLeaderboard.isInTop(uUID, n, bl);
    }

    @Nullable
    public final LeaderboardEntry getTopPlayer(boolean is2v2) {
        List<LeaderboardEntry> top = is2v2 ? this.getTop2v2(1) : this.getTop1v1(1);
        return (LeaderboardEntry)CollectionsKt.firstOrNull(top);
    }

    public static /* synthetic */ LeaderboardEntry getTopPlayer$default(RankedLeaderboard rankedLeaderboard, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return rankedLeaderboard.getTopPlayer(bl);
    }

    public final void broadcastTopPlayerChange(@NotNull String newTopPlayer, boolean is2v2, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)newTopPlayer, (String)"newTopPlayer");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        String modeText = is2v2 ? "2v2" : "1v1";
        List list = server.method_3760().method_14571();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 player = (class_3222)element$iv;
            boolean bl = false;
            player.method_43496((class_2561)class_2561.method_43470((String)(newTopPlayer + " est maintenant #1 en Ranked " + modeText + "!")).method_27694(RankedLeaderboard::broadcastTopPlayerChange$lambda$0$0));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LeaderboardStats getLeaderboardStats(boolean is2v2) {
        int n;
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Collection<PlayerProfile> allProfiles = PlayerProfileManager.INSTANCE.getAllProfiles();
        Iterable $this$filter$iv = allProfiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerProfile profile = (PlayerProfile)element$iv$iv;
            boolean bl = false;
            RankedStats stats = profile.getRankedStats();
            boolean bl2 = is2v2 ? stats.getWins2v2() + stats.getLosses2v2() > 0 : stats.getWins1v1() + stats.getLosses1v1() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List activeProfiles = (List)destination$iv$iv;
        if (activeProfiles.isEmpty()) {
            return new LeaderboardStats(0, 0, 0, 0.0);
        }
        int totalPlayers = activeProfiles.size();
        Iterable $this$map$iv = activeProfiles;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void profile;
            PlayerProfile playerProfile = (PlayerProfile)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(is2v2 ? profile.getRankedStats().getElo2v2() : profile.getRankedStats().getElo1v1());
        }
        double avgElo = CollectionsKt.averageOfInt((Iterable)((List)destination$iv$iv2));
        iterator = ((Iterable)activeProfiles).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        PlayerProfile profile = (PlayerProfile)iterator.next();
        boolean bl = false;
        int n2 = n = is2v2 ? profile.getRankedStats().getElo2v2() : profile.getRankedStats().getElo1v1();
        while (iterator.hasNext()) {
            PlayerProfile profile2 = (PlayerProfile)iterator.next();
            $i$a$-maxOf-RankedLeaderboard$getLeaderboardStats$highestElo$1 = false;
            int n3 = is2v2 ? profile2.getRankedStats().getElo2v2() : profile2.getRankedStats().getElo1v1();
            if (n >= n3) continue;
            n = n3;
        }
        int highestElo = n;
        iterator = activeProfiles;
        n = 0;
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            void profile3;
            Object item$iv$iv;
            Object t = iterator2.next();
            item$iv$iv = (PlayerProfile)t;
            int n4 = n;
            boolean bl3 = false;
            RankedStats stats = profile3.getRankedStats();
            int n5 = is2v2 ? stats.getWins2v2() + stats.getLosses2v2() : stats.getWins1v1() + stats.getLosses1v1();
            n = n4 + n5;
        }
        int totalMatches = n;
        return new LeaderboardStats(totalPlayers, (int)avgElo, highestElo, (double)totalMatches / 2.0);
    }

    public static /* synthetic */ LeaderboardStats getLeaderboardStats$default(RankedLeaderboard rankedLeaderboard, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return rankedLeaderboard.getLeaderboardStats(bl);
    }

    private static final class_2583 formatEntry$lambda$0(int $medalColor, class_2583 it) {
        return it.method_36139($medalColor);
    }

    private static final class_2583 formatEntry$lambda$1(class_2583 it) {
        return it.method_36139(0xAAAAAA);
    }

    private static final class_2583 formatEntry$lambda$2(LeaderboardEntry $entry, class_2583 it) {
        return it.method_10977($entry.getRank().getColor());
    }

    private static final class_2583 formatEntry$lambda$3(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2583 sendLeaderboardToPlayer$lambda$0(class_2583 it) {
        return it.method_36139(16766720).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 sendLeaderboardToPlayer$lambda$1(class_2583 it) {
        return it.method_36139(0xAAAAAA);
    }

    private static final class_2583 sendLeaderboardToPlayer$lambda$3(class_2583 it) {
        return it.method_36139(0x55FFFF);
    }

    private static final class_2583 broadcastTopPlayerChange$lambda$0$0(class_2583 it) {
        return it.method_36139(16766720).method_10982(Boolean.valueOf(true));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u0002\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0012J\u0010\u0010\u0018\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u0012J\u0010\u0010\u001b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u0012J\u0010\u0010\u001c\u001a\u00020\rH\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ`\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\u000e\u001a\u00020\rH\u00c6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001a\u0010\"\u001a\u00020!2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\"\u0010#J\u0010\u0010$\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b$\u0010\u0012J\u0010\u0010%\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b%\u0010\u0016R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010&\u001a\u0004\b'\u0010\u0012R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010(\u001a\u0004\b)\u0010\u0014R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010*\u001a\u0004\b+\u0010\u0016R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010&\u001a\u0004\b,\u0010\u0012R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010-\u001a\u0004\b.\u0010\u0019R\u0017\u0010\u000b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010&\u001a\u0004\b/\u0010\u0012R\u0017\u0010\f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\f\u0010&\u001a\u0004\b0\u0010\u0012R\u0017\u0010\u000e\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u00101\u001a\u0004\b2\u0010\u001d\u00a8\u00063"}, d2={"Lcom/music176/pokemonleague/ranked/RankedLeaderboard$LeaderboardEntry;", "", "", "position", "Ljava/util/UUID;", "playerId", "", "playerName", "elo", "Lcom/music176/pokemonleague/ranked/RankedRank;", "rank", "wins", "losses", "", "winRate", "<init>", "(ILjava/util/UUID;Ljava/lang/String;ILcom/music176/pokemonleague/ranked/RankedRank;IID)V", "component1", "()I", "component2", "()Ljava/util/UUID;", "component3", "()Ljava/lang/String;", "component4", "component5", "()Lcom/music176/pokemonleague/ranked/RankedRank;", "component6", "component7", "component8", "()D", "copy", "(ILjava/util/UUID;Ljava/lang/String;ILcom/music176/pokemonleague/ranked/RankedRank;IID)Lcom/music176/pokemonleague/ranked/RankedLeaderboard$LeaderboardEntry;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "I", "getPosition", "Ljava/util/UUID;", "getPlayerId", "Ljava/lang/String;", "getPlayerName", "getElo", "Lcom/music176/pokemonleague/ranked/RankedRank;", "getRank", "getWins", "getLosses", "D", "getWinRate", "pokemon-league-mod"})
    public static final class LeaderboardEntry {
        private final int position;
        @NotNull
        private final UUID playerId;
        @NotNull
        private final String playerName;
        private final int elo;
        @NotNull
        private final RankedRank rank;
        private final int wins;
        private final int losses;
        private final double winRate;

        public LeaderboardEntry(int position, @NotNull UUID playerId, @NotNull String playerName, int elo, @NotNull RankedRank rank, int wins, int losses, double winRate) {
            Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
            Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
            Intrinsics.checkNotNullParameter((Object)((Object)rank), (String)"rank");
            this.position = position;
            this.playerId = playerId;
            this.playerName = playerName;
            this.elo = elo;
            this.rank = rank;
            this.wins = wins;
            this.losses = losses;
            this.winRate = winRate;
        }

        public final int getPosition() {
            return this.position;
        }

        @NotNull
        public final UUID getPlayerId() {
            return this.playerId;
        }

        @NotNull
        public final String getPlayerName() {
            return this.playerName;
        }

        public final int getElo() {
            return this.elo;
        }

        @NotNull
        public final RankedRank getRank() {
            return this.rank;
        }

        public final int getWins() {
            return this.wins;
        }

        public final int getLosses() {
            return this.losses;
        }

        public final double getWinRate() {
            return this.winRate;
        }

        public final int component1() {
            return this.position;
        }

        @NotNull
        public final UUID component2() {
            return this.playerId;
        }

        @NotNull
        public final String component3() {
            return this.playerName;
        }

        public final int component4() {
            return this.elo;
        }

        @NotNull
        public final RankedRank component5() {
            return this.rank;
        }

        public final int component6() {
            return this.wins;
        }

        public final int component7() {
            return this.losses;
        }

        public final double component8() {
            return this.winRate;
        }

        @NotNull
        public final LeaderboardEntry copy(int position, @NotNull UUID playerId, @NotNull String playerName, int elo, @NotNull RankedRank rank, int wins, int losses, double winRate) {
            Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
            Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
            Intrinsics.checkNotNullParameter((Object)((Object)rank), (String)"rank");
            return new LeaderboardEntry(position, playerId, playerName, elo, rank, wins, losses, winRate);
        }

        public static /* synthetic */ LeaderboardEntry copy$default(LeaderboardEntry leaderboardEntry, int n, UUID uUID, String string, int n2, RankedRank rankedRank, int n3, int n4, double d, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = leaderboardEntry.position;
            }
            if ((n5 & 2) != 0) {
                uUID = leaderboardEntry.playerId;
            }
            if ((n5 & 4) != 0) {
                string = leaderboardEntry.playerName;
            }
            if ((n5 & 8) != 0) {
                n2 = leaderboardEntry.elo;
            }
            if ((n5 & 0x10) != 0) {
                rankedRank = leaderboardEntry.rank;
            }
            if ((n5 & 0x20) != 0) {
                n3 = leaderboardEntry.wins;
            }
            if ((n5 & 0x40) != 0) {
                n4 = leaderboardEntry.losses;
            }
            if ((n5 & 0x80) != 0) {
                d = leaderboardEntry.winRate;
            }
            return leaderboardEntry.copy(n, uUID, string, n2, rankedRank, n3, n4, d);
        }

        @NotNull
        public String toString() {
            return "LeaderboardEntry(position=" + this.position + ", playerId=" + this.playerId + ", playerName=" + this.playerName + ", elo=" + this.elo + ", rank=" + this.rank + ", wins=" + this.wins + ", losses=" + this.losses + ", winRate=" + this.winRate + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.position);
            result = result * 31 + this.playerId.hashCode();
            result = result * 31 + this.playerName.hashCode();
            result = result * 31 + Integer.hashCode(this.elo);
            result = result * 31 + this.rank.hashCode();
            result = result * 31 + Integer.hashCode(this.wins);
            result = result * 31 + Integer.hashCode(this.losses);
            result = result * 31 + Double.hashCode(this.winRate);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LeaderboardEntry)) {
                return false;
            }
            LeaderboardEntry leaderboardEntry = (LeaderboardEntry)other;
            if (this.position != leaderboardEntry.position) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.playerId, (Object)leaderboardEntry.playerId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.playerName, (Object)leaderboardEntry.playerName)) {
                return false;
            }
            if (this.elo != leaderboardEntry.elo) {
                return false;
            }
            if (this.rank != leaderboardEntry.rank) {
                return false;
            }
            if (this.wins != leaderboardEntry.wins) {
                return false;
            }
            if (this.losses != leaderboardEntry.losses) {
                return false;
            }
            return Double.compare(this.winRate, leaderboardEntry.winRate) == 0;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\u000bJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ8\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u000bJ\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u000bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001a\u001a\u0004\b\u001c\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001d\u0010\u000bR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001e\u001a\u0004\b\u001f\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/music176/pokemonleague/ranked/RankedLeaderboard$LeaderboardStats;", "", "", "totalPlayers", "averageElo", "highestElo", "", "totalMatches", "<init>", "(IIID)V", "component1", "()I", "component2", "component3", "component4", "()D", "copy", "(IIID)Lcom/music176/pokemonleague/ranked/RankedLeaderboard$LeaderboardStats;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getTotalPlayers", "getAverageElo", "getHighestElo", "D", "getTotalMatches", "pokemon-league-mod"})
    public static final class LeaderboardStats {
        private final int totalPlayers;
        private final int averageElo;
        private final int highestElo;
        private final double totalMatches;

        public LeaderboardStats(int totalPlayers, int averageElo, int highestElo, double totalMatches) {
            this.totalPlayers = totalPlayers;
            this.averageElo = averageElo;
            this.highestElo = highestElo;
            this.totalMatches = totalMatches;
        }

        public final int getTotalPlayers() {
            return this.totalPlayers;
        }

        public final int getAverageElo() {
            return this.averageElo;
        }

        public final int getHighestElo() {
            return this.highestElo;
        }

        public final double getTotalMatches() {
            return this.totalMatches;
        }

        public final int component1() {
            return this.totalPlayers;
        }

        public final int component2() {
            return this.averageElo;
        }

        public final int component3() {
            return this.highestElo;
        }

        public final double component4() {
            return this.totalMatches;
        }

        @NotNull
        public final LeaderboardStats copy(int totalPlayers, int averageElo, int highestElo, double totalMatches) {
            return new LeaderboardStats(totalPlayers, averageElo, highestElo, totalMatches);
        }

        public static /* synthetic */ LeaderboardStats copy$default(LeaderboardStats leaderboardStats, int n, int n2, int n3, double d, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = leaderboardStats.totalPlayers;
            }
            if ((n4 & 2) != 0) {
                n2 = leaderboardStats.averageElo;
            }
            if ((n4 & 4) != 0) {
                n3 = leaderboardStats.highestElo;
            }
            if ((n4 & 8) != 0) {
                d = leaderboardStats.totalMatches;
            }
            return leaderboardStats.copy(n, n2, n3, d);
        }

        @NotNull
        public String toString() {
            return "LeaderboardStats(totalPlayers=" + this.totalPlayers + ", averageElo=" + this.averageElo + ", highestElo=" + this.highestElo + ", totalMatches=" + this.totalMatches + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.totalPlayers);
            result = result * 31 + Integer.hashCode(this.averageElo);
            result = result * 31 + Integer.hashCode(this.highestElo);
            result = result * 31 + Double.hashCode(this.totalMatches);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LeaderboardStats)) {
                return false;
            }
            LeaderboardStats leaderboardStats = (LeaderboardStats)other;
            if (this.totalPlayers != leaderboardStats.totalPlayers) {
                return false;
            }
            if (this.averageElo != leaderboardStats.averageElo) {
                return false;
            }
            if (this.highestElo != leaderboardStats.highestElo) {
                return false;
            }
            return Double.compare(this.totalMatches, leaderboardStats.totalMatches) == 0;
        }
    }
}

