/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.ranked;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleFledEvent;
import com.cobblemon.mod.common.api.events.battles.BattleStartedEvent;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.duel.DuelManager;
import com.music176.pokemonleague.ranked.RankedManager;
import com.music176.pokemonleague.tournament.TournamentManager;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\fJ\r\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u0015\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\fR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/music176/pokemonleague/ranked/RankedItemBlocker;", "", "<init>", "()V", "", "initialize", "Ljava/util/UUID;", "playerId", "", "isPlayerInItemBlockedBattle", "(Ljava/util/UUID;)Z", "addPlayer", "(Ljava/util/UUID;)V", "removePlayer", "clear", "notifyItemBlocked", "", "playersInItemBlockedBattle", "Ljava/util/Set;", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nRankedItemBlocker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RankedItemBlocker.kt\ncom/music176/pokemonleague/ranked/RankedItemBlocker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1869#2,2:145\n1761#2,3:147\n1869#2,2:150\n1869#2,2:152\n*S KotlinDebug\n*F\n+ 1 RankedItemBlocker.kt\ncom/music176/pokemonleague/ranked/RankedItemBlocker\n*L\n31#1:145,2\n38#1:147,3\n57#1:150,2\n75#1:152,2\n*E\n"})
public final class RankedItemBlocker {
    @NotNull
    public static final RankedItemBlocker INSTANCE = new RankedItemBlocker();
    @NotNull
    private static final Set<UUID> playersInItemBlockedBattle = new LinkedHashSet();

    private RankedItemBlocker() {
    }

    public final void initialize() {
        CobblemonEvents.BATTLE_STARTED_PRE.subscribe(Priority.HIGHEST, RankedItemBlocker::initialize$lambda$0);
        CobblemonEvents.BATTLE_STARTED_POST.subscribe(Priority.HIGHEST, RankedItemBlocker::initialize$lambda$1);
        Observable.subscribe$default((Observable)((Observable)CobblemonEvents.BATTLE_VICTORY), null, RankedItemBlocker::initialize$lambda$2, (int)1, null);
        Observable.subscribe$default((Observable)((Observable)CobblemonEvents.BATTLE_FLED), null, RankedItemBlocker::initialize$lambda$3, (int)1, null);
        CobblemonEvents.HELD_ITEM_PRE.subscribe(Priority.HIGHEST, RankedItemBlocker::initialize$lambda$4);
        PokemonLeagueMod.INSTANCE.getLOGGER().info("RankedItemBlocker initialized");
    }

    public final boolean isPlayerInItemBlockedBattle(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return playersInItemBlockedBattle.contains(playerId);
    }

    public final void addPlayer(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        playersInItemBlockedBattle.add(playerId);
    }

    public final void removePlayer(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        playersInItemBlockedBattle.remove(playerId);
    }

    public final void clear() {
        playersInItemBlockedBattle.clear();
    }

    public final void notifyItemBlocked(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        MinecraftServer minecraftServer = DistributionUtilsKt.server();
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        class_3222 class_32222 = server.method_3760().method_14602(playerId);
        if (class_32222 == null) {
            return;
        }
        class_3222 player = class_32222;
        player.method_43496((class_2561)class_2561.method_43470((String)"Les items sont desactives dans les combats ranked/unranked/duel/tournoi!").method_27694(RankedItemBlocker::notifyItemBlocked$lambda$0));
    }

    private static final Unit initialize$lambda$0(BattleStartedEvent.Pre event) {
        boolean shouldBlockItems;
        block6: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            PokemonLeagueMod.INSTANCE.getLOGGER().info("BATTLE_STARTED_PRE triggered, checking actors...");
            Iterable $this$forEach$iv = event.getBattle().getActors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BattleActor actor = (BattleActor)element$iv;
                boolean bl = false;
                boolean inRanked = RankedManager.INSTANCE.isPlayerInSession(actor.getUuid());
                boolean inDuel = DuelManager.INSTANCE.isPlayerInDuel(actor.getUuid());
                boolean inTournament = TournamentManager.INSTANCE.isPlayerInMatch(actor.getUuid());
                PokemonLeagueMod.INSTANCE.getLOGGER().info("Actor " + actor.getUuid() + ": inRanked=" + inRanked + ", inDuel=" + inDuel + ", inTournament=" + inTournament);
            }
            Iterable $this$any$iv = event.getBattle().getActors();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BattleActor actor = (BattleActor)element$iv;
                    boolean bl = false;
                    if (!(RankedManager.INSTANCE.isPlayerInSession(actor.getUuid()) || DuelManager.INSTANCE.isPlayerInDuel(actor.getUuid()) || TournamentManager.INSTANCE.isPlayerInMatch(actor.getUuid()))) continue;
                    v0 = true;
                    break block6;
                }
                v0 = shouldBlockItems = false;
            }
        }
        if (shouldBlockItems) {
            Set oldRuleSet = event.getBattle().getFormat().getRuleSet();
            event.getBattle().getFormat().setRuleSet(SetsKt.plus((Set)event.getBattle().getFormat().getRuleSet(), (Object)"Bag Clause"));
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Added Bag Clause to battle format. Old: " + oldRuleSet + ", New: " + event.getBattle().getFormat().getRuleSet());
        } else {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("No ranked/duel players detected, skipping Bag Clause");
        }
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$1(BattleStartedEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$forEach$iv = event.getBattle().getActors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BattleActor actor = (BattleActor)element$iv;
            boolean bl = false;
            if (RankedManager.INSTANCE.isPlayerInSession(actor.getUuid())) {
                playersInItemBlockedBattle.add(actor.getUuid());
                PokemonLeagueMod.INSTANCE.getLOGGER().info("Player " + actor.getUuid() + " marked for item blocking in ranked/unranked battle");
            }
            if (DuelManager.INSTANCE.isPlayerInDuel(actor.getUuid())) {
                playersInItemBlockedBattle.add(actor.getUuid());
                PokemonLeagueMod.INSTANCE.getLOGGER().info("Player " + actor.getUuid() + " marked for item blocking in duel");
            }
            if (!TournamentManager.INSTANCE.isPlayerInMatch(actor.getUuid())) continue;
            playersInItemBlockedBattle.add(actor.getUuid());
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Player " + actor.getUuid() + " marked for item blocking in tournament");
        }
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$2(BattleVictoryEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$forEach$iv = event.getBattle().getActors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BattleActor actor = (BattleActor)element$iv;
            boolean bl = false;
            playersInItemBlockedBattle.remove(actor.getUuid());
        }
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$3(BattleFledEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        playersInItemBlockedBattle.remove(event.getPlayer().getUuid());
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$4(HeldItemEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        UUID playerId = event.getPokemon().getOwnerUUID();
        if (playerId != null && INSTANCE.isPlayerInItemBlockedBattle(playerId)) {
            class_3222 player;
            event.cancel();
            MinecraftServer server = DistributionUtilsKt.server();
            MinecraftServer minecraftServer = server;
            class_3222 class_32222 = player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
            if (class_32222 != null) {
                class_32222.method_43496((class_2561)class_2561.method_43470((String)"Les items sont desactives dans ce combat!").method_27694(RankedItemBlocker::initialize$lambda$4$0));
            }
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Blocked held item interaction for player " + playerId);
        }
        return Unit.INSTANCE;
    }

    private static final class_2583 initialize$lambda$4$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 notifyItemBlocked$lambda$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }
}

