/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.ranked;

import com.music176.pokemonleague.ranked.MatchmakingPhase;
import com.music176.pokemonleague.ranked.QueueMode;
import com.music176.pokemonleague.ranked.RankedConfig;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u0086\b\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010 \u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b \u0010\u001fJ\u0010\u0010!\u001a\u00020\u000bH\u00c6\u0003\u00a2\u0006\u0004\b!\u0010\u0012J\u0012\u0010\"\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\"\u0010\u0019J\u0012\u0010#\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003\u00a2\u0006\u0004\b#\u0010\u001bJd\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001\u00a2\u0006\u0004\b$\u0010%J\u001a\u0010(\u001a\u00020'2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b(\u0010)J\u0010\u0010*\u001a\u00020\bH\u00d6\u0001\u00a2\u0006\u0004\b*\u0010\u001fJ\u0010\u0010+\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b+\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010,\u001a\u0004\b-\u0010\u0019R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010.\u001a\u0004\b/\u0010\u001bR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u00100\u001a\u0004\b1\u0010\u001dR\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u00102\u001a\u0004\b3\u0010\u001fR\u0017\u0010\n\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\n\u00102\u001a\u0004\b4\u0010\u001fR\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u00105\u001a\u0004\b6\u0010\u0012R\u0019\u0010\r\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010,\u001a\u0004\b7\u0010\u0019R\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010.\u001a\u0004\b8\u0010\u001b\u00a8\u00069"}, d2={"Lcom/music176/pokemonleague/ranked/QueueEntry;", "", "Ljava/util/UUID;", "playerId", "", "playerName", "Lcom/music176/pokemonleague/ranked/QueueMode;", "mode", "", "elo", "averagePokemonLevel", "", "joinedAt", "partnerId", "partnerName", "<init>", "(Ljava/util/UUID;Ljava/lang/String;Lcom/music176/pokemonleague/ranked/QueueMode;IIJLjava/util/UUID;Ljava/lang/String;)V", "getWaitTimeSeconds", "()J", "Lcom/music176/pokemonleague/ranked/RankedConfig;", "config", "Lcom/music176/pokemonleague/ranked/MatchmakingPhase;", "getCurrentPhase", "(Lcom/music176/pokemonleague/ranked/RankedConfig;)Lcom/music176/pokemonleague/ranked/MatchmakingPhase;", "component1", "()Ljava/util/UUID;", "component2", "()Ljava/lang/String;", "component3", "()Lcom/music176/pokemonleague/ranked/QueueMode;", "component4", "()I", "component5", "component6", "component7", "component8", "copy", "(Ljava/util/UUID;Ljava/lang/String;Lcom/music176/pokemonleague/ranked/QueueMode;IIJLjava/util/UUID;Ljava/lang/String;)Lcom/music176/pokemonleague/ranked/QueueEntry;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/util/UUID;", "getPlayerId", "Ljava/lang/String;", "getPlayerName", "Lcom/music176/pokemonleague/ranked/QueueMode;", "getMode", "I", "getElo", "getAveragePokemonLevel", "J", "getJoinedAt", "getPartnerId", "getPartnerName", "pokemon-league-mod"})
public final class QueueEntry {
    @NotNull
    private final UUID playerId;
    @NotNull
    private final String playerName;
    @NotNull
    private final QueueMode mode;
    private final int elo;
    private final int averagePokemonLevel;
    private final long joinedAt;
    @Nullable
    private final UUID partnerId;
    @Nullable
    private final String partnerName;

    public QueueEntry(@NotNull UUID playerId, @NotNull String playerName, @NotNull QueueMode mode, int elo, int averagePokemonLevel, long joinedAt, @Nullable UUID partnerId, @Nullable String partnerName) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.playerId = playerId;
        this.playerName = playerName;
        this.mode = mode;
        this.elo = elo;
        this.averagePokemonLevel = averagePokemonLevel;
        this.joinedAt = joinedAt;
        this.partnerId = partnerId;
        this.partnerName = partnerName;
    }

    public /* synthetic */ QueueEntry(UUID uUID, String string, QueueMode queueMode, int n, int n2, long l, UUID uUID2, String string2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x20) != 0) {
            l = System.currentTimeMillis();
        }
        if ((n3 & 0x40) != 0) {
            uUID2 = null;
        }
        if ((n3 & 0x80) != 0) {
            string2 = null;
        }
        this(uUID, string, queueMode, n, n2, l, uUID2, string2);
    }

    @NotNull
    public final UUID getPlayerId() {
        return this.playerId;
    }

    @NotNull
    public final String getPlayerName() {
        return this.playerName;
    }

    @NotNull
    public final QueueMode getMode() {
        return this.mode;
    }

    public final int getElo() {
        return this.elo;
    }

    public final int getAveragePokemonLevel() {
        return this.averagePokemonLevel;
    }

    public final long getJoinedAt() {
        return this.joinedAt;
    }

    @Nullable
    public final UUID getPartnerId() {
        return this.partnerId;
    }

    @Nullable
    public final String getPartnerName() {
        return this.partnerName;
    }

    public final long getWaitTimeSeconds() {
        return (System.currentTimeMillis() - this.joinedAt) / (long)1000;
    }

    @NotNull
    public final MatchmakingPhase getCurrentPhase(@NotNull RankedConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        long waitTime = this.getWaitTimeSeconds();
        return waitTime < (long)config.getMatchmakingPhase1Duration() ? MatchmakingPhase.ELO_MATCHING : (waitTime < (long)(config.getMatchmakingPhase1Duration() + config.getMatchmakingPhase2Duration()) ? MatchmakingPhase.LEVEL_MATCHING : MatchmakingPhase.FCFS);
    }

    @NotNull
    public final UUID component1() {
        return this.playerId;
    }

    @NotNull
    public final String component2() {
        return this.playerName;
    }

    @NotNull
    public final QueueMode component3() {
        return this.mode;
    }

    public final int component4() {
        return this.elo;
    }

    public final int component5() {
        return this.averagePokemonLevel;
    }

    public final long component6() {
        return this.joinedAt;
    }

    @Nullable
    public final UUID component7() {
        return this.partnerId;
    }

    @Nullable
    public final String component8() {
        return this.partnerName;
    }

    @NotNull
    public final QueueEntry copy(@NotNull UUID playerId, @NotNull String playerName, @NotNull QueueMode mode, int elo, int averagePokemonLevel, long joinedAt, @Nullable UUID partnerId, @Nullable String partnerName) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return new QueueEntry(playerId, playerName, mode, elo, averagePokemonLevel, joinedAt, partnerId, partnerName);
    }

    public static /* synthetic */ QueueEntry copy$default(QueueEntry queueEntry, UUID uUID, String string, QueueMode queueMode, int n, int n2, long l, UUID uUID2, String string2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            uUID = queueEntry.playerId;
        }
        if ((n3 & 2) != 0) {
            string = queueEntry.playerName;
        }
        if ((n3 & 4) != 0) {
            queueMode = queueEntry.mode;
        }
        if ((n3 & 8) != 0) {
            n = queueEntry.elo;
        }
        if ((n3 & 0x10) != 0) {
            n2 = queueEntry.averagePokemonLevel;
        }
        if ((n3 & 0x20) != 0) {
            l = queueEntry.joinedAt;
        }
        if ((n3 & 0x40) != 0) {
            uUID2 = queueEntry.partnerId;
        }
        if ((n3 & 0x80) != 0) {
            string2 = queueEntry.partnerName;
        }
        return queueEntry.copy(uUID, string, queueMode, n, n2, l, uUID2, string2);
    }

    @NotNull
    public String toString() {
        return "QueueEntry(playerId=" + this.playerId + ", playerName=" + this.playerName + ", mode=" + this.mode + ", elo=" + this.elo + ", averagePokemonLevel=" + this.averagePokemonLevel + ", joinedAt=" + this.joinedAt + ", partnerId=" + this.partnerId + ", partnerName=" + this.partnerName + ")";
    }

    public int hashCode() {
        int result = this.playerId.hashCode();
        result = result * 31 + this.playerName.hashCode();
        result = result * 31 + this.mode.hashCode();
        result = result * 31 + Integer.hashCode(this.elo);
        result = result * 31 + Integer.hashCode(this.averagePokemonLevel);
        result = result * 31 + Long.hashCode(this.joinedAt);
        result = result * 31 + (this.partnerId == null ? 0 : this.partnerId.hashCode());
        result = result * 31 + (this.partnerName == null ? 0 : this.partnerName.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QueueEntry)) {
            return false;
        }
        QueueEntry queueEntry = (QueueEntry)other;
        if (!Intrinsics.areEqual((Object)this.playerId, (Object)queueEntry.playerId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.playerName, (Object)queueEntry.playerName)) {
            return false;
        }
        if (this.mode != queueEntry.mode) {
            return false;
        }
        if (this.elo != queueEntry.elo) {
            return false;
        }
        if (this.averagePokemonLevel != queueEntry.averagePokemonLevel) {
            return false;
        }
        if (this.joinedAt != queueEntry.joinedAt) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.partnerId, (Object)queueEntry.partnerId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.partnerName, (Object)queueEntry.partnerName);
    }
}

