/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.profile;

import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.duel.DuelMode;
import com.music176.pokemonleague.profile.Badge;
import com.music176.pokemonleague.profile.DuelStats;
import com.music176.pokemonleague.profile.GymStats;
import com.music176.pokemonleague.profile.PlayerProfile;
import com.music176.pokemonleague.profile.PlayerProfile$;
import com.music176.pokemonleague.profile.PlayerProfileManager$ProfilesData$;
import com.music176.pokemonleague.profile.TournamentStats;
import com.music176.pokemonleague.ranked.RankedManager;
import com.music176.pokemonleague.ranked.RankedStats;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u001d\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0016\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ%\u0010\u001e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t\u00a2\u0006\u0004\b\u001e\u0010\u001fJ-\u0010!\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u0014\u00a2\u0006\u0004\b!\u0010\"J-\u0010%\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b%\u0010&J%\u0010(\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0014\u00a2\u0006\u0004\b(\u0010)J%\u0010*\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0014\u00a2\u0006\u0004\b*\u0010)J\u0015\u0010+\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b+\u0010\u001aJ/\u00100\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020/0.0-2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u0014\u00a2\u0006\u0004\b0\u00101J/\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020/0.0-2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u0014\u00a2\u0006\u0004\b2\u00101J\u0017\u00103\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b3\u00104J\u0013\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b05\u00a2\u0006\u0004\b6\u00107J%\u0010:\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u00109\u001a\u000208\u00a2\u0006\u0004\b:\u0010;J%\u0010<\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u00109\u001a\u000208\u00a2\u0006\u0004\b<\u0010;J\u001d\u0010=\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b=\u0010>J\u0015\u0010?\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b?\u0010\u001cJ\u001b\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000b0-2\u0006\u0010,\u001a\u00020\u0014\u00a2\u0006\u0004\b@\u0010AJ\u001d\u0010B\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\bB\u0010CJ\u001d\u0010D\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\bD\u0010CJ\u001d\u0010E\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\bE\u0010CJ\u001d\u0010F\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\bF\u0010>J\u0015\u0010G\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\bG\u0010\u001cJ\r\u0010H\u001a\u00020\u0004\u00a2\u0006\u0004\bH\u0010\u0003J\r\u0010I\u001a\u00020\u0004\u00a2\u0006\u0004\bI\u0010\u0003J\u001b\u0010J\u001a\b\u0012\u0004\u0012\u00020\u000b0-2\u0006\u0010,\u001a\u00020\u0014\u00a2\u0006\u0004\bJ\u0010AJ\u001b\u0010K\u001a\b\u0012\u0004\u0012\u00020\u000b0-2\u0006\u0010,\u001a\u00020\u0014\u00a2\u0006\u0004\bK\u0010AJ\u0017\u0010L\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\bL\u0010MJ\u0017\u0010N\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\bN\u0010MJ\u001d\u0010O\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\bO\u0010CJ\u0015\u0010P\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\bP\u0010QJ\r\u0010R\u001a\u00020\u0004\u00a2\u0006\u0004\bR\u0010\u0003J\u0015\u0010S\u001a\u00020#2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\bS\u0010TR\u0014\u0010V\u001a\u00020U8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bV\u0010WR \u0010Y\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0X8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bY\u0010ZR \u0010[\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020#0X8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b[\u0010ZR\u001b\u0010a\u001a\u00020\\8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b]\u0010^\u001a\u0004\b_\u0010`\u00a8\u0006c"}, d2={"Lcom/music176/pokemonleague/profile/PlayerProfileManager;", "", "<init>", "()V", "", "load", "save", "Ljava/util/UUID;", "playerId", "", "playerName", "Lcom/music176/pokemonleague/profile/PlayerProfile;", "getOrCreateProfile", "(Ljava/util/UUID;Ljava/lang/String;)Lcom/music176/pokemonleague/profile/PlayerProfile;", "getProfile", "(Ljava/util/UUID;)Lcom/music176/pokemonleague/profile/PlayerProfile;", "badgeId", "", "awardBadge", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;)Z", "", "gymNumber", "canChallengeGym", "(Ljava/util/UUID;I)Z", "hasRequiredBadgeForGym", "canAccessLeague", "(Ljava/util/UUID;)Z", "getBadgeCount", "(Ljava/util/UUID;)I", "gymId", "recordGymAttempt", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;)V", "phaseReached", "recordGymFailure", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;I)V", "", "timeMs", "recordGymSuccess", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;J)V", "amount", "recordCreditsEarned", "(Ljava/util/UUID;Ljava/lang/String;I)V", "recordCreditsSpent", "resetBadges", "count", "", "Lkotlin/Pair;", "Lcom/music176/pokemonleague/profile/GymStats;", "getTopPlayersByGym", "(Ljava/lang/String;I)Ljava/util/List;", "getTopPlayersBySpeed", "gymIdToBadgeId", "(Ljava/lang/String;)Ljava/lang/String;", "", "getAllProfiles", "()Ljava/util/Collection;", "Lcom/music176/pokemonleague/duel/DuelMode;", "mode", "recordDuelWin", "(Ljava/util/UUID;Ljava/lang/String;Lcom/music176/pokemonleague/duel/DuelMode;)V", "recordDuelLoss", "recordDuelStarted", "(Ljava/util/UUID;Ljava/lang/String;)I", "getTotalDuelsStarted", "getTopDuelPlayers", "(I)Ljava/util/List;", "recordTournamentParticipation", "(Ljava/util/UUID;Ljava/lang/String;)V", "recordTournamentVictory", "recordTournamentPodium", "recordRankedStarted", "getTotalRankedStarted", "saveProfiles", "resetAllRankedElo", "getTopRanked1v1", "getTopRanked2v2", "getRank1v1Position", "(Ljava/util/UUID;)Ljava/lang/Integer;", "getRank2v2Position", "onPlayerJoin", "onPlayerDisconnect", "(Ljava/util/UUID;)V", "flushAllPlaytimes", "getCurrentPlaytimeMinutes", "(Ljava/util/UUID;)J", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "Ljava/util/concurrent/ConcurrentHashMap;", "profiles", "Ljava/util/concurrent/ConcurrentHashMap;", "sessionStartTimes", "Ljava/io/File;", "profilesFile$delegate", "Lkotlin/Lazy;", "getProfilesFile", "()Ljava/io/File;", "profilesFile", "ProfilesData", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nPlayerProfileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerProfileManager.kt\ncom/music176/pokemonleague/profile/PlayerProfileManager\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,544:1\n222#2:545\n205#2:554\n216#3,2:546\n216#3:641\n217#3:643\n478#4:548\n424#4:549\n382#4,7:558\n382#4,7:565\n382#4,7:572\n1252#5,4:550\n1617#5,9:579\n1869#5:588\n1870#5:590\n1626#5:591\n1617#5,9:592\n1869#5:601\n1870#5:603\n1626#5:604\n1056#5:605\n774#5:606\n865#5,2:607\n1869#5,2:609\n774#5:611\n865#5,2:612\n1068#5:614\n774#5:615\n865#5,2:616\n1068#5:618\n774#5:619\n865#5,2:620\n1068#5:622\n360#5,7:623\n774#5:630\n865#5,2:631\n1068#5:633\n360#5,7:634\n72#6,2:555\n1#7:557\n1#7:589\n1#7:602\n1#7:642\n*S KotlinDebug\n*F\n+ 1 PlayerProfileManager.kt\ncom/music176/pokemonleague/profile/PlayerProfileManager\n*L\n42#1:545\n69#1:554\n44#1:546,2\n522#1:641\n522#1:643\n67#1:548\n67#1:549\n160#1:558,7\n179#1:565,7\n195#1:572,7\n67#1:550,4\n254#1:579,9\n254#1:588\n254#1:590\n254#1:591\n272#1:592,9\n272#1:601\n272#1:603\n272#1:604\n279#1:605\n369#1:606\n369#1:607,2\n441#1:609,2\n454#1:611\n454#1:612,2\n455#1:614\n464#1:615\n464#1:616,2\n465#1:618\n474#1:619\n474#1:620,2\n475#1:622\n477#1:623,7\n486#1:630\n486#1:631,2\n487#1:633\n489#1:634,7\n80#1:555,2\n80#1:557\n254#1:589\n272#1:602\n*E\n"})
public final class PlayerProfileManager {
    @NotNull
    public static final PlayerProfileManager INSTANCE = new PlayerProfileManager();
    @NotNull
    private static final Json json = JsonKt.Json$default(null, PlayerProfileManager::json$lambda$0, (int)1, null);
    @NotNull
    private static final ConcurrentHashMap<UUID, PlayerProfile> profiles = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<UUID, Long> sessionStartTimes = new ConcurrentHashMap();
    @NotNull
    private static final Lazy profilesFile$delegate = LazyKt.lazy(PlayerProfileManager::profilesFile_delegate$lambda$0);

    private PlayerProfileManager() {
    }

    private final File getProfilesFile() {
        Lazy lazy = profilesFile$delegate;
        return (File)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void load() {
        try {
            if (this.getProfilesFile().exists()) {
                void this_$iv;
                Json json = PlayerProfileManager.json;
                String string$iv = FilesKt.readText$default((File)this.getProfilesFile(), null, (int)1, null);
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                ProfilesData data = (ProfilesData)this_$iv.decodeFromString((DeserializationStrategy)ProfilesData.Companion.serializer(), string$iv);
                profiles.clear();
                Map<String, PlayerProfile> $this$forEach$iv = data.getProfiles();
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, PlayerProfile>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, PlayerProfile> element$iv;
                    Map.Entry<String, PlayerProfile> entry = element$iv = iterator.next();
                    boolean bl = false;
                    String uuidStr = entry.getKey();
                    PlayerProfile profile = entry.getValue();
                    try {
                        ((Map)profiles).put(UUID.fromString(uuidStr), profile);
                    }
                    catch (IllegalArgumentException e) {
                        PokemonLeagueMod.INSTANCE.getLOGGER().warn("Invalid UUID in profiles: " + uuidStr);
                    }
                }
                PokemonLeagueMod.INSTANCE.getLOGGER().info("Loaded " + profiles.size() + " player profiles");
            } else {
                PokemonLeagueMod.INSTANCE.getLOGGER().info("No player profiles file found, starting fresh");
            }
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to load player profiles: " + e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void save() {
        try {
            void this_$iv;
            void $this$associateByTo$iv$iv$iv;
            void $this$mapKeysTo$iv$iv;
            File file = this.getProfilesFile().getParentFile();
            if (file != null) {
                file.mkdirs();
            }
            Map $this$mapKeys$iv = profiles;
            boolean $i$f$mapKeys = false;
            Map map = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable iterable = $this$mapKeysTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                String string;
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)((UUID)it.getKey()).toString(), (String)"toString(...)");
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map3 = map2;
                boolean bl2 = false;
                entry = it$iv$iv.getValue();
                map3.put(string, entry);
            }
            Map map4 = destination$iv$iv$iv;
            ProfilesData data = new ProfilesData(map4);
            File file2 = this.getProfilesFile();
            $this$mapKeys$iv = json;
            ProfilesData value$iv = data;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            FilesKt.writeText$default((File)file2, (String)this_$iv.encodeToString((SerializationStrategy)ProfilesData.Companion.serializer(), (Object)value$iv), null, (int)2, null);
            PokemonLeagueMod.INSTANCE.getLOGGER().debug("Saved " + profiles.size() + " player profiles");
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to save player profiles: " + e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PlayerProfile getOrCreateProfile(@NotNull UUID playerId, @NotNull String playerName) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        ConcurrentMap concurrentMap = profiles;
        UUID key$iv = playerId;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            String string = playerId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            PlayerProfile default$iv = new PlayerProfile(string, playerName, null, 0, 0, 0, 0, null, 0, 0, 0, 0, null, null, null, 0L, 65532, null);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        concurrentMap = object;
        PlayerProfile it = (PlayerProfile)((Object)concurrentMap);
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it.getPlayerName(), (Object)playerName)) {
            it.setPlayerName(playerName);
        }
        ConcurrentMap concurrentMap2 = concurrentMap;
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"also(...)");
        return (PlayerProfile)((Object)concurrentMap2);
    }

    @Nullable
    public final PlayerProfile getProfile(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return profiles.get(playerId);
    }

    public final boolean awardBadge(@NotNull UUID playerId, @NotNull String playerName, @NotNull String badgeId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter((Object)badgeId, (String)"badgeId");
        PlayerProfile profile = this.getOrCreateProfile(playerId, playerName);
        boolean awarded = profile.getBadges().awardBadge(badgeId);
        if (awarded) {
            this.save();
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Awarded badge " + badgeId + " to " + playerName);
        }
        return awarded;
    }

    public final boolean canChallengeGym(@NotNull UUID playerId, int gymNumber) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        if (gymNumber == 1) {
            return true;
        }
        PlayerProfile playerProfile = profiles.get(playerId);
        if (playerProfile == null) {
            return gymNumber == 1;
        }
        PlayerProfile profile = playerProfile;
        boolean requiredBadge = switch (gymNumber) {
            case 2 -> profile.getBadges().getRockBadge().getObtained();
            case 3 -> profile.getBadges().getCascadeBadge().getObtained();
            case 4 -> profile.getBadges().getThunderBadge().getObtained();
            case 5 -> profile.getBadges().getRainbowBadge().getObtained();
            case 6 -> profile.getBadges().getMarshBadge().getObtained();
            default -> false;
        };
        return requiredBadge;
    }

    public final boolean hasRequiredBadgeForGym(@NotNull UUID playerId, int gymNumber) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return this.canChallengeGym(playerId, gymNumber);
    }

    public final boolean canAccessLeague(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        PlayerProfile playerProfile = profiles.get(playerId);
        if (playerProfile == null) {
            return false;
        }
        PlayerProfile profile = playerProfile;
        return profile.getBadges().canAccessLeague();
    }

    public final int getBadgeCount(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        PlayerProfile playerProfile = profiles.get(playerId);
        if (playerProfile == null) {
            return 0;
        }
        PlayerProfile profile = playerProfile;
        return profile.getBadges().getCount();
    }

    /*
     * WARNING - void declaration
     */
    public final void recordGymAttempt(@NotNull UUID playerId, @NotNull String playerName, @NotNull String gymId) {
        Object object;
        void $this$getOrPut$iv22;
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
        PlayerProfile profile = this.getOrCreateProfile(playerId, playerName);
        Map<String, GymStats> map = profile.getGymStats();
        String key$iv = gymId;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv22.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            GymStats answer$iv = new GymStats(gymId, 0, 0, 0, null, null, 0, 126, null);
            $this$getOrPut$iv22.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        GymStats gymStats = (GymStats)object;
        int $this$getOrPut$iv22 = gymStats.getTotalAttempts();
        gymStats.setTotalAttempts($this$getOrPut$iv22 + 1);
        gymStats.setLastAttemptDate(System.currentTimeMillis());
        String badgeId = this.gymIdToBadgeId(gymId);
        Badge badge = profile.getBadges().getBadgeById(badgeId);
        if (badge != null) {
            Badge it = badge;
            boolean bl = false;
            int n = it.getAttempts();
            it.setAttempts(n + 1);
        }
        this.save();
    }

    /*
     * WARNING - void declaration
     */
    public final void recordGymFailure(@NotNull UUID playerId, @NotNull String playerName, @NotNull String gymId, int phaseReached) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
        PlayerProfile profile = this.getOrCreateProfile(playerId, playerName);
        Map<String, GymStats> map = profile.getGymStats();
        String key$iv = gymId;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            GymStats answer$iv = new GymStats(gymId, 0, 0, 0, null, null, 0, 126, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        GymStats gymStats = (GymStats)object;
        int n = gymStats.getFailedRuns();
        gymStats.setFailedRuns(n + 1);
        if (phaseReached > gymStats.getHighestPhaseReached()) {
            gymStats.setHighestPhaseReached(phaseReached);
        }
        n = profile.getTotalBattlesLost();
        profile.setTotalBattlesLost(n + 1);
        this.save();
    }

    /*
     * WARNING - void declaration
     */
    public final void recordGymSuccess(@NotNull UUID playerId, @NotNull String playerName, @NotNull String gymId, long timeMs) {
        int n;
        PlayerProfile profile;
        block6: {
            GymStats gymStats;
            block5: {
                Object object;
                void $this$getOrPut$iv;
                Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
                Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
                Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
                profile = this.getOrCreateProfile(playerId, playerName);
                Map<String, GymStats> map = profile.getGymStats();
                String key$iv = gymId;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    GymStats answer$iv = new GymStats(gymId, 0, 0, 0, null, null, 0, 126, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                gymStats = (GymStats)object;
                n = gymStats.getSuccessfulRuns();
                gymStats.setSuccessfulRuns(n + 1);
                gymStats.setHighestPhaseReached(4);
                if (gymStats.getFastestTime() == null) break block5;
                Long l = gymStats.getFastestTime();
                Intrinsics.checkNotNull((Object)l);
                if (timeMs >= l) break block6;
            }
            gymStats.setFastestTime(timeMs);
        }
        n = profile.getTotalBattlesWon();
        profile.setTotalBattlesWon(n + 1);
        this.save();
    }

    public final void recordCreditsEarned(@NotNull UUID playerId, @NotNull String playerName, int amount) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        PlayerProfile profile = this.getOrCreateProfile(playerId, playerName);
        profile.setTotalCreditsEarned(profile.getTotalCreditsEarned() + amount);
        this.save();
    }

    public final void recordCreditsSpent(@NotNull UUID playerId, @NotNull String playerName, int amount) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        PlayerProfile profile = this.getOrCreateProfile(playerId, playerName);
        profile.setTotalCreditsSpent(profile.getTotalCreditsSpent() + amount);
        this.save();
    }

    public final boolean resetBadges(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        PlayerProfile playerProfile = profiles.get(playerId);
        if (playerProfile == null) {
            return false;
        }
        PlayerProfile profile = playerProfile;
        profile.getBadges().getRockBadge().setObtained(false);
        profile.getBadges().getRockBadge().setObtainedDate(null);
        profile.getBadges().getCascadeBadge().setObtained(false);
        profile.getBadges().getCascadeBadge().setObtainedDate(null);
        profile.getBadges().getThunderBadge().setObtained(false);
        profile.getBadges().getThunderBadge().setObtainedDate(null);
        profile.getBadges().getRainbowBadge().setObtained(false);
        profile.getBadges().getRainbowBadge().setObtainedDate(null);
        profile.getBadges().getMarshBadge().setObtained(false);
        profile.getBadges().getMarshBadge().setObtainedDate(null);
        profile.getBadges().getVolcanoBadge().setObtained(false);
        profile.getBadges().getVolcanoBadge().setObtainedDate(null);
        this.save();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<PlayerProfile, GymStats>> getTopPlayersByGym(@NotNull String gymId, int count) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
        Collection<PlayerProfile> collection = profiles.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PlayerProfile profile = (PlayerProfile)element$iv$iv;
            boolean bl2 = false;
            if (profile.getGymStats().get(gymId) != null) {
                GymStats stats;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)profile, (Object)stats);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Function1[] function1Array = new Function1[]{PlayerProfileManager::getTopPlayersByGym$lambda$1, PlayerProfileManager::getTopPlayersByGym$lambda$2};
        return CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array)), (int)count);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<PlayerProfile, GymStats>> getTopPlayersBySpeed(@NotNull String gymId, int count) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
        Collection<PlayerProfile> collection = profiles.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PlayerProfile profile = (PlayerProfile)element$iv$iv;
            boolean bl2 = false;
            if (profile.getGymStats().get(gymId) != null) {
                GymStats stats;
                boolean bl3 = false;
                pair = stats.getFastestTime() != null && stats.getSuccessfulRuns() > 0 ? TuplesKt.to((Object)profile, (Object)stats) : null;
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = ((GymStats)it.getSecond()).getFastestTime();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((GymStats)it.getSecond()).getFastestTime());
            }
        }), (int)count);
    }

    private final String gymIdToBadgeId(String gymId) {
        return switch (gymId) {
            case "rock" -> "rock_badge";
            case "water" -> "cascade_badge";
            case "electric" -> "thunder_badge";
            case "grass" -> "rainbow_badge";
            case "psychic" -> "marsh_badge";
            case "fire" -> "volcano_badge";
            default -> gymId + "_badge";
        };
    }

    @NotNull
    public final Collection<PlayerProfile> getAllProfiles() {
        Collection<PlayerProfile> collection = profiles.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    public final void recordDuelWin(@NotNull UUID playerId, @NotNull String playerName, @NotNull DuelMode mode) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        PlayerProfile profile = this.getOrCreateProfile(playerId, playerName);
        DuelStats stats = profile.getDuelStats();
        int n = stats.getWins();
        stats.setWins(n + 1);
        n = stats.getCurrentWinStreak();
        stats.setCurrentWinStreak(n + 1);
        if (stats.getCurrentWinStreak() > stats.getBestWinStreak()) {
            stats.setBestWinStreak(stats.getCurrentWinStreak());
        }
        stats.setLastDuelDate(System.currentTimeMillis());
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                int n2 = stats.getWins1v1();
                stats.setWins1v1(n2 + 1);
                break;
            }
            case 2: {
                int n3 = stats.getWins2v2();
                stats.setWins2v2(n3 + 1);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        n = profile.getTotalBattlesWon();
        profile.setTotalBattlesWon(n + 1);
        this.save();
    }

    public final void recordDuelLoss(@NotNull UUID playerId, @NotNull String playerName, @NotNull DuelMode mode) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        PlayerProfile profile = this.getOrCreateProfile(playerId, playerName);
        DuelStats stats = profile.getDuelStats();
        int n = stats.getLosses();
        stats.setLosses(n + 1);
        stats.setCurrentWinStreak(0);
        stats.setLastDuelDate(System.currentTimeMillis());
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                int n2 = stats.getLosses1v1();
                stats.setLosses1v1(n2 + 1);
                break;
            }
            case 2: {
                int n3 = stats.getLosses2v2();
                stats.setLosses2v2(n3 + 1);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        n = profile.getTotalBattlesLost();
        profile.setTotalBattlesLost(n + 1);
        this.save();
    }

    public final int recordDuelStarted(@NotNull UUID playerId, @NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        PlayerProfile profile = this.getOrCreateProfile(playerId, playerName);
        DuelStats duelStats = profile.getDuelStats();
        int n = duelStats.getTotalDuelsStarted();
        duelStats.setTotalDuelsStarted(n + 1);
        this.save();
        return profile.getDuelStats().getTotalDuelsStarted();
    }

    public final int getTotalDuelsStarted(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Object object = profiles.get(playerId);
        return object != null && (object = ((PlayerProfile)object).getDuelStats()) != null ? ((DuelStats)object).getTotalDuelsStarted() : 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PlayerProfile> getTopDuelPlayers(int count) {
        void $this$filterTo$iv$iv;
        Collection<PlayerProfile> collection = profiles.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerProfile it = (PlayerProfile)element$iv$iv;
            boolean bl = false;
            if (!(it.getDuelStats().getWins() + it.getDuelStats().getLosses() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Function1[] function1Array = new Function1[]{PlayerProfileManager::getTopDuelPlayers$lambda$1, PlayerProfileManager::getTopDuelPlayers$lambda$2, PlayerProfileManager::getTopDuelPlayers$lambda$3};
        return CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array)), (int)count);
    }

    public final void recordTournamentParticipation(@NotNull UUID playerId, @NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        PlayerProfile profile = this.getOrCreateProfile(playerId, playerName);
        TournamentStats tournamentStats = profile.getTournamentStats();
        int n = tournamentStats.getParticipations();
        tournamentStats.setParticipations(n + 1);
        profile.getTournamentStats().setLastTournamentDate(System.currentTimeMillis());
        this.save();
    }

    public final void recordTournamentVictory(@NotNull UUID playerId, @NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        PlayerProfile profile = this.getOrCreateProfile(playerId, playerName);
        TournamentStats tournamentStats = profile.getTournamentStats();
        int n = tournamentStats.getVictories();
        tournamentStats.setVictories(n + 1);
        tournamentStats = profile.getTournamentStats();
        n = tournamentStats.getPodiums();
        tournamentStats.setPodiums(n + 1);
        this.save();
    }

    public final void recordTournamentPodium(@NotNull UUID playerId, @NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        PlayerProfile profile = this.getOrCreateProfile(playerId, playerName);
        TournamentStats tournamentStats = profile.getTournamentStats();
        int n = tournamentStats.getPodiums();
        tournamentStats.setPodiums(n + 1);
        this.save();
    }

    public final int recordRankedStarted(@NotNull UUID playerId, @NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        PlayerProfile profile = this.getOrCreateProfile(playerId, playerName);
        RankedStats rankedStats = profile.getRankedStats();
        int n = rankedStats.getTotalRankedStarted();
        rankedStats.setTotalRankedStarted(n + 1);
        this.save();
        return profile.getRankedStats().getTotalRankedStarted();
    }

    public final int getTotalRankedStarted(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Object object = profiles.get(playerId);
        return object != null && (object = ((PlayerProfile)object).getRankedStats()) != null ? ((RankedStats)object).getTotalRankedStarted() : 0;
    }

    public final void saveProfiles() {
        this.save();
    }

    public final void resetAllRankedElo() {
        int season = RankedManager.INSTANCE.getConfig().getSeasonData().getCurrentSeason();
        int baseElo = RankedManager.INSTANCE.getConfig().getBaseElo();
        Collection<PlayerProfile> collection = profiles.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerProfile profile = (PlayerProfile)element$iv;
            boolean bl = false;
            profile.getRankedStats().resetForNewSeason(season, baseElo);
        }
        this.save();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Reset all ranked ELO to " + baseElo + " for season " + season);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PlayerProfile> getTopRanked1v1(int count) {
        void $this$filterTo$iv$iv;
        Collection<PlayerProfile> collection = profiles.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerProfile it = (PlayerProfile)element$iv$iv;
            boolean bl = false;
            if (!(it.getRankedStats().getWins1v1() + it.getRankedStats().getLosses1v1() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PlayerProfile it = (PlayerProfile)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getRankedStats().getElo1v1());
                it = (PlayerProfile)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getRankedStats().getElo1v1()));
            }
        }), (int)count);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PlayerProfile> getTopRanked2v2(int count) {
        void $this$filterTo$iv$iv;
        Collection<PlayerProfile> collection = profiles.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerProfile it = (PlayerProfile)element$iv$iv;
            boolean bl = false;
            if (!(it.getRankedStats().getWins2v2() + it.getRankedStats().getLosses2v2() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PlayerProfile it = (PlayerProfile)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getRankedStats().getElo2v2());
                it = (PlayerProfile)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getRankedStats().getElo2v2()));
            }
        }), (int)count);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Integer getRank1v1Position(@NotNull UUID playerId) {
        int n;
        block3: {
            List sorted;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
            Collection<PlayerProfile> collection = profiles.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PlayerProfile it = (PlayerProfile)element$iv$iv;
                boolean bl = false;
                if (!(it.getRankedStats().getWins1v1() + it.getRankedStats().getLosses1v1() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
            boolean $i$f$sortedByDescending = false;
            List $this$indexOfFirst$iv = sorted = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PlayerProfile it = (PlayerProfile)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getRankedStats().getElo1v1());
                    it = (PlayerProfile)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getRankedStats().getElo1v1()));
                }
            });
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                PlayerProfile it = (PlayerProfile)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getPlayerId(), (Object)playerId.toString())) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        int index = n;
        return index >= 0 ? Integer.valueOf(index + 1) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Integer getRank2v2Position(@NotNull UUID playerId) {
        int n;
        block3: {
            List sorted;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
            Collection<PlayerProfile> collection = profiles.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PlayerProfile it = (PlayerProfile)element$iv$iv;
                boolean bl = false;
                if (!(it.getRankedStats().getWins2v2() + it.getRankedStats().getLosses2v2() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
            boolean $i$f$sortedByDescending = false;
            List $this$indexOfFirst$iv = sorted = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PlayerProfile it = (PlayerProfile)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getRankedStats().getElo2v2());
                    it = (PlayerProfile)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getRankedStats().getElo2v2()));
                }
            });
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                PlayerProfile it = (PlayerProfile)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getPlayerId(), (Object)playerId.toString())) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        int index = n;
        return index >= 0 ? Integer.valueOf(index + 1) : null;
    }

    public final void onPlayerJoin(@NotNull UUID playerId, @NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        ((Map)sessionStartTimes).put(playerId, System.currentTimeMillis());
        this.getOrCreateProfile(playerId, playerName);
    }

    public final void onPlayerDisconnect(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Long l = sessionStartTimes.remove(playerId);
        if (l == null) {
            return;
        }
        long startTime = l;
        long sessionMinutes = (System.currentTimeMillis() - startTime) / (long)60000;
        if (sessionMinutes > 0L) {
            PlayerProfile playerProfile = profiles.get(playerId);
            if (playerProfile == null) {
                return;
            }
            PlayerProfile profile = playerProfile;
            profile.setTotalPlaytimeMinutes(profile.getTotalPlaytimeMinutes() + sessionMinutes);
            this.save();
        }
    }

    public final void flushAllPlaytimes() {
        long now = System.currentTimeMillis();
        Map $this$forEach$iv = sessionStartTimes;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            PlayerProfile it;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            UUID playerId = (UUID)entry.getKey();
            long startTime = ((Number)entry.getValue()).longValue();
            long sessionMinutes = (now - startTime) / (long)60000;
            if (sessionMinutes <= 0L) continue;
            if (profiles.get(playerId) == null) continue;
            boolean bl2 = false;
            it.setTotalPlaytimeMinutes(it.getTotalPlaytimeMinutes() + sessionMinutes);
        }
        sessionStartTimes.clear();
    }

    public final long getCurrentPlaytimeMinutes(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        PlayerProfile playerProfile = profiles.get(playerId);
        if (playerProfile == null) {
            return 0L;
        }
        PlayerProfile profile = playerProfile;
        long savedMinutes = profile.getTotalPlaytimeMinutes();
        Long sessionStart = sessionStartTimes.get(playerId);
        long currentSessionMinutes = sessionStart != null ? (System.currentTimeMillis() - sessionStart) / (long)60000 : 0L;
        return savedMinutes + currentSessionMinutes;
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setEncodeDefaults(true);
        return Unit.INSTANCE;
    }

    private static final File profilesFile_delegate$lambda$0() {
        return new File("config/pokemonleague/player_profiles.json");
    }

    private static final Comparable getTopPlayersByGym$lambda$1(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(-((GymStats)it.getSecond()).getSuccessfulRuns());
    }

    private static final Comparable getTopPlayersByGym$lambda$2(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Long l = ((GymStats)it.getSecond()).getFastestTime();
        return l != null ? (Comparable)l : (Comparable)Long.valueOf(Long.MAX_VALUE);
    }

    private static final Comparable getTopDuelPlayers$lambda$1(PlayerProfile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(-it.getDuelStats().getWins());
    }

    private static final Comparable getTopDuelPlayers$lambda$2(PlayerProfile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Double.valueOf(-it.getDuelStats().getWinRate());
    }

    private static final Comparable getTopDuelPlayers$lambda$3(PlayerProfile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(-it.getDuelStats().getBestWinStreak());
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0083\b\u0018\u0000 $2\u00020\u0001:\u0002%$B\u001d\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007B1\b\u0010\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0002\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0006\u0010\fJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ&\u0010\u000f\u001a\u00020\u00002\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\bH\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010!\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0001\u00a2\u0006\u0004\b\u001f\u0010 R#\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\"\u001a\u0004\b#\u0010\u000e\u00a8\u0006&"}, d2={"Lcom/music176/pokemonleague/profile/PlayerProfileManager$ProfilesData;", "", "", "", "Lcom/music176/pokemonleague/profile/PlayerProfile;", "profiles", "<init>", "(Ljava/util/Map;)V", "", "seen0", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "serializationConstructorMarker", "(ILjava/util/Map;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "component1", "()Ljava/util/Map;", "copy", "(Ljava/util/Map;)Lcom/music176/pokemonleague/profile/PlayerProfileManager$ProfilesData;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toString", "()Ljava/lang/String;", "self", "Lkotlinx/serialization/encoding/CompositeEncoder;", "output", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialDesc", "", "write$Self$pokemon_league_mod", "(Lcom/music176/pokemonleague/profile/PlayerProfileManager$ProfilesData;Lkotlinx/serialization/encoding/CompositeEncoder;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "write$Self", "Ljava/util/Map;", "getProfiles", "Companion", ".serializer", "pokemon-league-mod"})
    private static final class ProfilesData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<String, PlayerProfile> profiles;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public ProfilesData(@NotNull Map<String, PlayerProfile> profiles) {
            Intrinsics.checkNotNullParameter(profiles, (String)"profiles");
            this.profiles = profiles;
        }

        public /* synthetic */ ProfilesData(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @NotNull
        public final Map<String, PlayerProfile> getProfiles() {
            return this.profiles;
        }

        @NotNull
        public final Map<String, PlayerProfile> component1() {
            return this.profiles;
        }

        @NotNull
        public final ProfilesData copy(@NotNull Map<String, PlayerProfile> profiles) {
            Intrinsics.checkNotNullParameter(profiles, (String)"profiles");
            return new ProfilesData(profiles);
        }

        public static /* synthetic */ ProfilesData copy$default(ProfilesData profilesData, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = profilesData.profiles;
            }
            return profilesData.copy(map);
        }

        @NotNull
        public String toString() {
            return "ProfilesData(profiles=" + this.profiles + ")";
        }

        public int hashCode() {
            return ((Object)this.profiles).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProfilesData)) {
                return false;
            }
            ProfilesData profilesData = (ProfilesData)other;
            return Intrinsics.areEqual(this.profiles, profilesData.profiles);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$pokemon_league_mod(ProfilesData self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : !Intrinsics.areEqual(self.profiles, (Object)MapsKt.emptyMap())) {
                output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), self.profiles);
            }
        }

        public /* synthetic */ ProfilesData(int seen0, Map profiles, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)ProfilesData$$serializer.INSTANCE.getDescriptor());
            }
            this.profiles = (seen0 & 1) == 0 ? MapsKt.emptyMap() : profiles;
        }

        public ProfilesData() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)PlayerProfile$.serializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/music176/pokemonleague/profile/PlayerProfileManager$ProfilesData$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lcom/music176/pokemonleague/profile/PlayerProfileManager$ProfilesData;", "serializer", "()Lkotlinx/serialization/KSerializer;", "pokemon-league-mod"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<ProfilesData> serializer() {
                return (KSerializer)ProfilesData$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DuelMode.values().length];
            try {
                nArray[DuelMode.DUEL_1V1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DuelMode.DUEL_2V2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

