/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.npc;

import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.config.LeagueConfig;
import com.music176.pokemonleague.config.RewardConfig;
import com.music176.pokemonleague.config.StageConfig;
import com.music176.pokemonleague.economy.EconomyBridge;
import com.music176.pokemonleague.league.LeagueManager;
import com.music176.pokemonleague.league.LeagueSession;
import com.music176.pokemonleague.spectator.LeagueSpectatorManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\bJ\u001f\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J!\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/music176/pokemonleague/npc/ReceptionistInteraction;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "", "openLeagueGUI", "(Lnet/minecraft/class_3222;)V", "sendHeader", "sendStageInfo", "", "entryFee", "sendEconomyInfo", "(Lnet/minecraft/class_3222;I)V", "Lcom/music176/pokemonleague/league/LeagueSession;", "session", "sendStatus", "(Lnet/minecraft/class_3222;Lcom/music176/pokemonleague/league/LeagueSession;)V", "sendActionButtons", "sendFooter", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nReceptionistInteraction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReceptionistInteraction.kt\ncom/music176/pokemonleague/npc/ReceptionistInteraction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,300:1\n1869#2,2:301\n*S KotlinDebug\n*F\n+ 1 ReceptionistInteraction.kt\ncom/music176/pokemonleague/npc/ReceptionistInteraction\n*L\n84#1:301,2\n*E\n"})
public final class ReceptionistInteraction {
    @NotNull
    public static final ReceptionistInteraction INSTANCE = new ReceptionistInteraction();

    private ReceptionistInteraction() {
    }

    public final void openLeagueGUI(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        LeagueSession session = LeagueManager.INSTANCE.getActiveSession();
        LeagueConfig config = PokemonLeagueMod.INSTANCE.getConfig();
        player.method_43496((class_2561)class_2561.method_43473());
        this.sendHeader(player);
        this.sendStageInfo(player);
        this.sendEconomyInfo(player, config.getEntryFee());
        this.sendStatus(player, session);
        this.sendActionButtons(player, session);
        this.sendFooter(player);
    }

    private final void sendHeader(class_3222 player) {
        String separator = "==========================================";
        player.method_43496((class_2561)class_2561.method_43470((String)separator).method_27692(class_124.field_1065));
        class_124[] class_124Array = new class_124[]{class_124.field_1065, class_124.field_1067};
        player.method_43496((class_2561)class_2561.method_43470((String)"          LIGUE POKEMON").method_27695(class_124Array));
        player.method_43496((class_2561)class_2561.method_43470((String)separator).method_27692(class_124.field_1065));
        player.method_43496((class_2561)class_2561.method_43473());
    }

    private final void sendStageInfo(class_3222 player) {
        class_124[] class_124Array = new class_124[]{class_124.field_1054, class_124.field_1067};
        player.method_43496((class_2561)class_2561.method_43470((String)"Les 7 Etages:").method_27695(class_124Array));
        Object[] objectArray = new Triple[]{new Triple((Object)1, (Object)"Feu", (Object)class_124.field_1061), new Triple((Object)2, (Object)"Plante", (Object)class_124.field_1060), new Triple((Object)3, (Object)"Roche", (Object)class_124.field_1080), new Triple((Object)4, (Object)"Insecte", (Object)class_124.field_1077), new Triple((Object)5, (Object)"Eau", (Object)class_124.field_1078), new Triple((Object)6, (Object)"Tenebres", (Object)class_124.field_1064), new Triple((Object)7, (Object)"Dragon", (Object)class_124.field_1076)};
        List stages = CollectionsKt.listOf((Object[])objectArray);
        LeagueConfig config = PokemonLeagueMod.INSTANCE.getConfig();
        Iterable $this$forEach$iv = stages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StageConfig stageConfig;
            Triple triple = (Triple)element$iv;
            boolean bl = false;
            int num = ((Number)triple.component1()).intValue();
            String type = (String)triple.component2();
            class_124 color = (class_124)triple.component3();
            StageConfig stageConfig2 = stageConfig = (StageConfig)CollectionsKt.getOrNull(config.getStages(), (int)(num - 1));
            int level = stageConfig2 != null ? stageConfig2.getLevel() : 60 + num * 5;
            Object object = stageConfig;
            int reward = object != null && (object = ((StageConfig)object).getRewards()) != null ? ((RewardConfig)object).getCredits() : 1000 * num;
            class_124[] class_124Array2 = new class_124[]{color, class_124.field_1067};
            player.method_43496((class_2561)class_2561.method_43470((String)("  Etage " + num + ": ")).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)type).method_27695(class_124Array2)).method_10852((class_2561)class_2561.method_43470((String)(" - Nv." + level + " - " + reward + "cr")).method_27692(class_124.field_1080)));
        }
        player.method_43496((class_2561)class_2561.method_43473());
    }

    private final void sendEconomyInfo(class_3222 player, int entryFee) {
        class_124[] class_124Array = new class_124[]{class_124.field_1065, class_124.field_1067};
        player.method_43496((class_2561)class_2561.method_43470((String)"Droit d'entree: ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)(EconomyBridge.INSTANCE.formatBalance(entryFee) + " Pokedollars")).method_27695(class_124Array)));
        if (EconomyBridge.INSTANCE.isAvailable()) {
            long balance = EconomyBridge.INSTANCE.getBalance(player);
            class_124 balanceColor = balance >= (long)entryFee ? class_124.field_1060 : class_124.field_1061;
            player.method_43496((class_2561)class_2561.method_43470((String)"Votre solde: ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)(EconomyBridge.INSTANCE.formatBalance(balance) + " Pokedollars")).method_27692(balanceColor)));
        }
        player.method_43496((class_2561)class_2561.method_43473());
    }

    private final void sendStatus(class_3222 player, LeagueSession session) {
        if (session == null) {
            class_124[] class_124Array = new class_124[]{class_124.field_1060, class_124.field_1067};
            player.method_43496((class_2561)class_2561.method_43470((String)"Statut: ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)"LIBRE").method_27695(class_124Array)));
        } else {
            player.method_43496((class_2561)class_2561.method_43470((String)"Statut: ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)("OCCUPEE par " + session.getPlayerName())).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(" (Etage " + session.getCurrentStage() + ")")).method_27692(class_124.field_1080)));
            int spectatorCount = LeagueSpectatorManager.INSTANCE.getSpectatorCount();
            if (spectatorCount > 0) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Spectateurs: ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(spectatorCount)).method_27692(class_124.field_1075)));
            }
        }
        player.method_43496((class_2561)class_2561.method_43473());
    }

    private final void sendActionButtons(class_3222 player, LeagueSession session) {
        class_124[] class_124Array = new class_124[]{class_124.field_1054, class_124.field_1067};
        player.method_43496((class_2561)class_2561.method_43470((String)"Actions disponibles:").method_27695(class_124Array));
        if (session == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)"  [ENTRER LA LIGUE]").method_27696(class_2583.field_24360.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/league start")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Cliquez pour entrer dans la ligue!")))));
        } else if (Intrinsics.areEqual((Object)session.getPlayerId(), (Object)player.method_5667())) {
            player.method_43496((class_2561)class_2561.method_43470((String)"  [ABANDONNER]").method_27696(class_2583.field_24360.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/league quit")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Cliquez pour abandonner la ligue")))));
        } else if (LeagueSpectatorManager.INSTANCE.isSpectating(player)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"  [ARRETER DE REGARDER]").method_27696(class_2583.field_24360.method_10977(class_124.field_1054).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/league stopspectate")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Cliquez pour arreter de regarder")))));
        } else {
            player.method_43496((class_2561)class_2561.method_43470((String)"  [REGARDER]").method_27696(class_2583.field_24360.method_10977(class_124.field_1075).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/league spectate")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Cliquez pour regarder " + session.getPlayerName()))))));
        }
        player.method_43496((class_2561)class_2561.method_43470((String)"  [VOIR STATUT]").method_27696(class_2583.field_24360.method_10977(class_124.field_1080).method_10958(new class_2558(class_2558.class_2559.field_11750, "/league status")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Voir le statut de la ligue")))));
    }

    private final void sendFooter(class_3222 player) {
        player.method_43496((class_2561)class_2561.method_43473());
        String separator = "==========================================";
        player.method_43496((class_2561)class_2561.method_43470((String)separator).method_27692(class_124.field_1065));
    }
}

