/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.league;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.npc.NPCClass;
import com.cobblemon.mod.common.api.npc.NPCClasses;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.scheduling.SchedulingFunctionsKt;
import com.cobblemon.mod.common.api.storage.party.NPCPartyStore;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.BattleStartResult;
import com.cobblemon.mod.common.battles.ErroredBattleStart;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.npc.NPCEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.battle.ChampionBattleActor;
import com.music176.pokemonleague.config.ItemReward;
import com.music176.pokemonleague.config.LeagueConfig;
import com.music176.pokemonleague.config.Position;
import com.music176.pokemonleague.config.RewardConfig;
import com.music176.pokemonleague.config.StageConfig;
import com.music176.pokemonleague.economy.EconomyManager;
import com.music176.pokemonleague.gym.GymManager;
import com.music176.pokemonleague.hud.LeagueHUD;
import com.music176.pokemonleague.integration.FTBQuestsIntegration;
import com.music176.pokemonleague.league.LeagueSession;
import com.music176.pokemonleague.league.StageReward;
import com.music176.pokemonleague.profile.Badge;
import com.music176.pokemonleague.profile.PlayerProfile;
import com.music176.pokemonleague.profile.PlayerProfileManager;
import com.music176.pokemonleague.rewards.RewardDispenser;
import com.music176.pokemonleague.spectator.LeagueSpectatorManager;
import com.music176.pokemonleague.stats.PlayerStatsManager;
import com.music176.pokemonleague.util.Messages;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003J\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010!\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010#\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010%\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b%\u0010$J\u0015\u0010&\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b&\u0010$J\u0015\u0010'\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b'\u0010$J\u0015\u0010(\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b(\u0010$J\u0015\u0010)\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b)\u0010$J\u0015\u0010*\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b*\u0010\u000eJ\u000f\u0010+\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b+\u0010\u0003J\u0017\u0010,\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b,\u0010$J\u001f\u0010/\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010.\u001a\u00020-H\u0002\u00a2\u0006\u0004\b/\u00100J/\u00107\u001a\u0002062\u0006\u00102\u001a\u0002012\u0006\u00103\u001a\u0002012\u0006\u00104\u001a\u0002012\u0006\u00105\u001a\u000201H\u0002\u00a2\u0006\u0004\b7\u00108J\u0017\u00109\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b9\u0010$J\u0017\u0010<\u001a\u00020\u00062\u0006\u0010;\u001a\u00020:H\u0002\u00a2\u0006\u0004\b<\u0010=J\r\u0010>\u001a\u00020\u001b\u00a2\u0006\u0004\b>\u0010?J\u001d\u0010@\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020-\u00a2\u0006\u0004\b@\u0010AJ\u001d\u0010B\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020-\u00a2\u0006\u0004\bB\u0010AR\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010CR\u0018\u0010D\u001a\u0004\u0018\u00010\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010ER \u0010H\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020G0F8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010IR\u001a\u0010K\u001a\b\u0012\u0004\u0012\u00020\n0J8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bK\u0010L\u00a8\u0006M"}, d2={"Lcom/music176/pokemonleague/league/LeagueManager;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "initialize", "(Lnet/minecraft/server/MinecraftServer;)V", "shutdown", "Ljava/util/UUID;", "playerId", "", "isPlayerActive", "(Ljava/util/UUID;)Z", "Lcom/music176/pokemonleague/league/LeagueSession;", "getActiveSession", "()Lcom/music176/pokemonleague/league/LeagueSession;", "isOccupied", "()Z", "", "getCurrentPlayerName", "()Ljava/lang/String;", "Lnet/minecraft/class_3222;", "player", "startSession", "(Lnet/minecraft/class_3222;)Z", "", "stageNumber", "startStage", "(Lnet/minecraft/class_3222;I)V", "Lcom/music176/pokemonleague/config/StageConfig;", "stageConfig", "createChampionAndStartBattle", "(Lnet/minecraft/class_3222;Lcom/music176/pokemonleague/config/StageConfig;)V", "handleVictory", "(Lnet/minecraft/class_3222;)V", "handleFinalVictory", "handleDefeat", "quitSession", "handlePlayerDisconnect", "handlePlayerReconnect", "needsTeleportOnReconnect", "cleanupChampionNPCs", "endPlayerBattle", "Lcom/music176/pokemonleague/config/Position;", "position", "teleportToPosition", "(Lnet/minecraft/class_3222;Lcom/music176/pokemonleague/config/Position;)V", "", "fromX", "fromZ", "toX", "toZ", "", "calculateYawToFace", "(DDDD)F", "spawnFireworks", "Lnet/minecraft/class_2561;", "message", "broadcastMessage", "(Lnet/minecraft/class_2561;)V", "getCurrentStage", "()I", "setPlayerSpawnPosition", "(ILcom/music176/pokemonleague/config/Position;)Z", "setNpcSpawnPosition", "Lnet/minecraft/server/MinecraftServer;", "activeSession", "Lcom/music176/pokemonleague/league/LeagueSession;", "", "Lcom/cobblemon/mod/common/entity/npc/NPCEntity;", "championNPCs", "Ljava/util/Map;", "", "pendingTeleportToLobby", "Ljava/util/Set;", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nLeagueManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeagueManager.kt\ncom/music176/pokemonleague/league/LeagueManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,678:1\n1869#2,2:679\n2746#2,3:681\n1878#2,3:684\n774#2:687\n865#2,2:688\n1563#2:690\n1634#2,3:691\n1617#2,9:694\n1869#2:703\n1870#2:705\n1626#2:706\n774#2:707\n865#2,2:708\n1563#2:710\n1634#2,3:711\n1563#2:714\n1634#2,3:715\n1869#2,2:718\n1869#2,2:721\n1#3:704\n1#3:720\n*S KotlinDebug\n*F\n+ 1 LeagueManager.kt\ncom/music176/pokemonleague/league/LeagueManager\n*L\n62#1:679,2\n137#1:681,3\n253#1:684,3\n277#1:687\n277#1:688,2\n278#1:690\n278#1:691,3\n293#1:694,9\n293#1:703\n293#1:705\n293#1:706\n294#1:707\n294#1:708,2\n295#1:710\n295#1:711,3\n363#1:714\n363#1:715,3\n555#1:718,2\n626#1:721,2\n293#1:704\n*E\n"})
public final class LeagueManager {
    @NotNull
    public static final LeagueManager INSTANCE = new LeagueManager();
    @Nullable
    private static MinecraftServer server;
    @Nullable
    private static LeagueSession activeSession;
    @NotNull
    private static final Map<UUID, NPCEntity> championNPCs;
    @NotNull
    private static final Set<UUID> pendingTeleportToLobby;

    private LeagueManager() {
    }

    public final void initialize(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        LeagueManager.server = server;
        PokemonLeagueMod.INSTANCE.getLOGGER().info("LeagueManager initialized");
    }

    public final void shutdown() {
        LeagueSession leagueSession = activeSession;
        if (leagueSession != null) {
            LeagueSession session = leagueSession;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null && (minecraftServer = minecraftServer.method_14602(session.getPlayerId())) != null) {
                MinecraftServer player = minecraftServer;
                boolean bl2 = false;
                INSTANCE.handlePlayerDisconnect((class_3222)player);
            }
        }
        Iterable $this$forEach$iv = championNPCs.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NPCEntity npc = (NPCEntity)element$iv;
            boolean bl = false;
            npc.method_5650(class_1297.class_5529.field_26999);
        }
        championNPCs.clear();
        server = null;
        PokemonLeagueMod.INSTANCE.getLOGGER().info("LeagueManager shutdown complete");
    }

    public final boolean isPlayerActive(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        LeagueSession leagueSession = activeSession;
        return Intrinsics.areEqual((Object)(leagueSession != null ? leagueSession.getPlayerId() : null), (Object)playerId);
    }

    @Nullable
    public final LeagueSession getActiveSession() {
        return activeSession;
    }

    public final boolean isOccupied() {
        return activeSession != null;
    }

    @Nullable
    public final String getCurrentPlayerName() {
        LeagueSession leagueSession = activeSession;
        return leagueSession != null ? leagueSession.getPlayerName() : null;
    }

    public final boolean startSession(@NotNull class_3222 player) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (activeSession != null) {
                LeagueSession leagueSession = activeSession;
                Intrinsics.checkNotNull((Object)leagueSession);
                Messages.INSTANCE.enterFailOccupied(player, leagueSession.getPlayerName());
                return false;
            }
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            if (GymManager.INSTANCE.isPlayerActive(uUID)) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Vous etes deja dans une arene! Terminez-la d'abord.").method_27694(LeagueManager::startSession$lambda$0));
                return false;
            }
            UUID uUID2 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            if (!PlayerProfileManager.INSTANCE.canAccessLeague(uUID2)) {
                UUID uUID3 = player.method_5667();
                Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
                String string = player.method_5477().getString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                PlayerProfile profile = PlayerProfileManager.INSTANCE.getOrCreateProfile(uUID3, string);
                int badgeCount = profile.getBadges().getCount();
                List<Badge> missingBadges = profile.getBadges().getMissingBadges();
                player.method_43496((class_2561)class_2561.method_43470((String)"Vous devez obtenir les 5 badges d'arene pour acceder a la Ligue!").method_27694(LeagueManager::startSession$lambda$1));
                player.method_43496((class_2561)class_2561.method_43470((String)("Badges: " + badgeCount + "/5")).method_27694(LeagueManager::startSession$lambda$2));
                if (!((Collection)missingBadges).isEmpty()) {
                    player.method_43496((class_2561)class_2561.method_43470((String)("Manquants: " + CollectionsKt.joinToString$default((Iterable)missingBadges, null, null, null, (int)0, null, LeagueManager::startSession$lambda$3, (int)31, null))).method_27694(LeagueManager::startSession$lambda$4));
                }
                return false;
            }
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            Iterable $this$none$iv = (Iterable)party;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Pokemon it = (Pokemon)element$iv;
                    boolean bl2 = false;
                    if (!(it.getCurrentHealth() > 0)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (bl) {
            Messages.INSTANCE.enterFailTeam(player);
            return false;
        }
        int entryFee = EconomyManager.INSTANCE.getLeagueEntryFee();
        if (!EconomyManager.INSTANCE.chargeLeagueEntryFee(player)) {
            Messages.INSTANCE.enterFailBalance(player, entryFee);
            return false;
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        String string = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        PlayerProfileManager.INSTANCE.recordCreditsSpent(uUID, string, entryFee);
        UUID uUID4 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID4, (String)"getUUID(...)");
        String string2 = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        activeSession = new LeagueSession(uUID4, string2, null, 0, false, null, 60, null);
        UUID uUID5 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID5, (String)"getUUID(...)");
        String string3 = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        PlayerStatsManager.INSTANCE.recordAttempt(uUID5, string3);
        LeagueHUD.INSTANCE.updateHUD();
        Messages.INSTANCE.enterSuccess(player);
        String string4 = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
        this.broadcastMessage(Messages.INSTANCE.broadcastEnter(string4));
        this.startStage(player, 1);
        return true;
    }

    public final void startStage(@NotNull class_3222 player, int stageNumber) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        LeagueSession leagueSession = activeSession;
        if (leagueSession == null) {
            return;
        }
        LeagueSession session = leagueSession;
        if (!Intrinsics.areEqual((Object)session.getPlayerId(), (Object)player.method_5667())) {
            return;
        }
        LeagueConfig config = PokemonLeagueMod.INSTANCE.getConfig();
        StageConfig stageConfig = (StageConfig)CollectionsKt.getOrNull(config.getStages(), (int)(stageNumber - 1));
        if (stageConfig == null) {
            return;
        }
        StageConfig stageConfig2 = stageConfig;
        this.teleportToPosition(player, stageConfig2.getPlayerSpawnPosition());
        Messages.INSTANCE.stageStart(player, stageNumber, stageConfig2.getChampionName(), stageConfig2.getType());
        SchedulingFunctionsKt.afterOnServer((float)2.0f, () -> LeagueManager.startStage$lambda$0(player, stageConfig2));
    }

    /*
     * WARNING - void declaration
     */
    private final void createChampionAndStartBattle(class_3222 player, StageConfig stageConfig) {
        class_2960 skinId;
        NPCClass npcClass;
        LeagueSession leagueSession = activeSession;
        if (leagueSession == null) {
            return;
        }
        LeagueSession session = leagueSession;
        session.setInBattle(true);
        class_3218 world = player.method_51469();
        Position npcPos = stageConfig.getNpcSpawnPosition();
        Intrinsics.checkNotNull((Object)world);
        NPCEntity npc = new NPCEntity((class_1937)world);
        class_2960 class_29602 = class_2960.method_12829((String)stageConfig.getNpcSkin());
        if (class_29602 == null) {
            class_29602 = MiscUtilsKt.cobblemonResource((String)"standard");
        }
        if ((npcClass = NPCClasses.getByIdentifier((class_2960)(skinId = class_29602))) != null) {
            npc.setNpc(npcClass);
            PokemonLeagueMod.INSTANCE.getLOGGER().info("NPC class set to: " + npcClass.getId());
        } else {
            NPCClass fallbackClass = NPCClasses.getByIdentifier((class_2960)MiscUtilsKt.cobblemonResource((String)"standard"));
            if (fallbackClass != null) {
                npc.setNpc(fallbackClass);
            }
            PokemonLeagueMod.INSTANCE.getLOGGER().warn("Could not find NPC class '" + stageConfig.getNpcSkin() + "', using 'cobblemon:standard'");
        }
        npc.method_5808(npcPos.getX(), npcPos.getY(), npcPos.getZ(), npcPos.getYaw(), npcPos.getPitch());
        npc.method_5665((class_2561)class_2561.method_43470((String)stageConfig.getChampionName()));
        npc.method_5880(true);
        npc.method_5648(false);
        npc.method_5875(false);
        npc.setInvulnerable(Boolean.valueOf(true));
        npc.setMovable(Boolean.valueOf(false));
        npc.method_5977(true);
        npc.method_5971();
        NPCPartyStore npcParty = new NPCPartyStore(npc);
        Iterable $this$forEachIndexed$iv = stageConfig.getPokemon();
        boolean $i$f$forEachIndexed = false;
        int index$iv22 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void pokemonSpec;
            int n;
            if ((n = index$iv22++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            try {
                Pokemon pokemon = PokemonProperties.create$default((PokemonProperties)PokemonProperties.Companion.parse$default((PokemonProperties.Companion)PokemonProperties.Companion, (String)pokemonSpec, null, null, (int)6, null), null, (int)1, null);
                npcParty.set(index, pokemon);
                PokemonLeagueMod.INSTANCE.getLOGGER().info("Created pokemon: " + pokemon.getSpecies().getName() + " for champion " + stageConfig.getChampionName());
            }
            catch (Exception e) {
                PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to create pokemon: " + (String)pokemonSpec, (Throwable)e);
            }
        }
        npc.setParty(npcParty);
        world.method_8649((class_1297)npc);
        championNPCs.put(npc.method_5667(), npc);
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Champion NPC spawned: " + stageConfig.getChampionName() + " with " + CollectionsKt.count((Iterable)((Iterable)npcParty)) + " pokemon");
        try {
            BattleActor[] $this$mapTo$iv$iv;
            void $this$map$iv;
            Pokemon it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Collection collection;
            Iterable $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Pokemon it2;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            Object item$iv;
            PlayerPartyStore playerParty = Cobblemon.INSTANCE.getStorage().getParty(player);
            Iterable index$iv22 = (Iterable)playerParty;
            boolean $i$f$filter = false;
            item$iv = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it2 = (Pokemon)element$iv$iv;
                boolean bl = false;
                if (!(!it2.isFainted())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo232 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                it2 = (Pokemon)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(BattlePokemon.Companion.playerOwned((Pokemon)it3));
            }
            List playerPokemonList = (List)destination$iv$iv;
            if (playerPokemonList.isEmpty()) {
                PokemonLeagueMod.INSTANCE.getLOGGER().error("Player has no usable pokemon!");
                session.setInBattle(false);
                npc.method_5650(class_1297.class_5529.field_26999);
                championNPCs.remove(npc.method_5667());
                return;
            }
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            PlayerBattleActor playerActor = new PlayerBattleActor(uUID, playerPokemonList);
            $this$mapTo$iv$iv2 = (Iterable)npcParty;
            boolean $i$f$mapNotNull = false;
            void $i$f$mapTo232 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean bl = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pokemon it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Pokemon it3 = (Pokemon)element$iv$iv;
                boolean bl22 = false;
                if (it3 == null) continue;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv2;
            boolean $i$f$filter2 = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            BattleActor[] destination$iv$iv3 = (BattleActor[])new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object t : $this$filterTo$iv$iv) {
                it = (Pokemon)t;
                boolean bl3 = false;
                if (!(!it.isFainted())) continue;
                destination$iv$iv3.add(t);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                it = (Pokemon)t;
                collection = destination$iv$iv3;
                boolean bl4 = false;
                collection.add(BattlePokemon.Companion.safeCopyOf(it));
            }
            List npcPokemonList = (List)destination$iv$iv3;
            if (npcPokemonList.isEmpty()) {
                PokemonLeagueMod.INSTANCE.getLOGGER().error("NPC has no usable pokemon!");
                session.setInBattle(false);
                npc.method_5650(class_1297.class_5529.field_26999);
                championNPCs.remove(npc.method_5667());
                return;
            }
            String string = stageConfig.getChampionName();
            class_1309 class_13092 = (class_1309)npc;
            UUID uUID2 = npc.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            ChampionBattleActor npcActor = new ChampionBattleActor(string, class_13092, uUID2, npcPokemonList, 3);
            $this$mapTo$iv$iv = new BattleActor[]{playerActor};
            BattleSide side1 = new BattleSide($this$mapTo$iv$iv);
            destination$iv$iv3 = new BattleActor[]{npcActor};
            BattleSide side2 = new BattleSide(destination$iv$iv3);
            BattleStartResult result = BattleRegistry.startBattle((BattleFormat)BattleFormat.Companion.getGEN_9_SINGLES(), (BattleSide)side1, (BattleSide)side2, (boolean)true);
            result.ifErrored(arg_0 -> LeagueManager.createChampionAndStartBattle$lambda$6(session, npc, arg_0));
            result.ifSuccessful(arg_0 -> LeagueManager.createChampionAndStartBattle$lambda$7(stageConfig, arg_0));
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Exception starting battle", (Throwable)e);
            session.setInBattle(false);
            npc.method_5650(class_1297.class_5529.field_26999);
            championNPCs.remove(npc.method_5667());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void handleVictory(@NotNull class_3222 player) {
        Collection<CallSite> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        LeagueSession leagueSession = activeSession;
        if (leagueSession == null) {
            return;
        }
        LeagueSession session = leagueSession;
        if (!Intrinsics.areEqual((Object)session.getPlayerId(), (Object)player.method_5667())) {
            return;
        }
        session.setInBattle(false);
        int stageNumber = session.getCurrentStage();
        StageConfig stageConfig = (StageConfig)CollectionsKt.getOrNull(PokemonLeagueMod.INSTANCE.getConfig().getStages(), (int)(stageNumber - 1));
        if (stageConfig == null) {
            return;
        }
        StageConfig stageConfig2 = stageConfig;
        this.cleanupChampionNPCs();
        int moneyReward = EconomyManager.INSTANCE.giveLeagueStageReward(player, stageNumber);
        RewardConfig rewards = stageConfig2.getRewards();
        RewardDispenser.INSTANCE.giveItems(player, rewards.getItems());
        Iterable iterable = rewards.getItems();
        int n = moneyReward;
        int n2 = stageNumber;
        List<StageReward> list = session.getEarnedRewards();
        boolean $i$f$map = false;
        void var9_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ItemReward itemReward = (ItemReward)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CallSite)((Object)(it.getCount() + "x " + it.getItem())));
        }
        Collection<CallSite> collection2 = collection = (List)destination$iv$iv;
        int n3 = n;
        int n4 = n2;
        list.add(new StageReward(n4, n3, (List<String>)collection2));
        Messages.INSTANCE.victoryStage(player, stageNumber, moneyReward);
        Cobblemon.INSTANCE.getStorage().getParty(player).heal();
        Messages.INSTANCE.healTeam(player);
        if (stageNumber >= 7) {
            this.handleFinalVictory(player);
        } else {
            session.advanceStage();
            int nextStage = session.getCurrentStage();
            SchedulingFunctionsKt.afterOnServer((float)3.0f, () -> LeagueManager.handleVictory$lambda$1(player, nextStage));
        }
    }

    private final void handleFinalVictory(class_3222 player) {
        LeagueSession leagueSession = activeSession;
        if (leagueSession == null) {
            return;
        }
        LeagueSession session = leagueSession;
        PlayerStatsManager.INSTANCE.recordSuccess(session.getPlayerId(), session.getPlayerName());
        FTBQuestsIntegration.INSTANCE.completeLeagueChampionQuest(player);
        EconomyManager.INSTANCE.giveLeagueCompletionBonus(player);
        LeagueHUD.INSTANCE.updateHUD();
        Messages.INSTANCE.finalVictory(player);
        String string = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        this.broadcastMessage(Messages.INSTANCE.broadcastVictory(string));
        this.spawnFireworks(player);
        player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15195, class_3419.field_15248, 1.0f, 1.0f);
        SchedulingFunctionsKt.afterOnServer((float)5.0f, () -> LeagueManager.handleFinalVictory$lambda$0(player));
    }

    public final void handleDefeat(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        LeagueSession leagueSession = activeSession;
        if (leagueSession == null) {
            return;
        }
        LeagueSession session = leagueSession;
        if (!Intrinsics.areEqual((Object)session.getPlayerId(), (Object)player.method_5667())) {
            return;
        }
        session.setInBattle(false);
        int stageNumber = session.getCurrentStage();
        PlayerStatsManager.INSTANCE.recordFailure(session.getPlayerId(), session.getPlayerName(), stageNumber);
        LeagueHUD.INSTANCE.updateHUD();
        this.cleanupChampionNPCs();
        Messages.INSTANCE.defeat(player, stageNumber);
        this.teleportToPosition(player, PokemonLeagueMod.INSTANCE.getConfig().getSpawnPosition());
        LeagueSpectatorManager.INSTANCE.endAllSpectators();
        activeSession = null;
    }

    public final void quitSession(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        LeagueSession leagueSession = activeSession;
        if (leagueSession == null) {
            return;
        }
        LeagueSession session = leagueSession;
        if (!Intrinsics.areEqual((Object)session.getPlayerId(), (Object)player.method_5667())) {
            return;
        }
        PlayerStatsManager.INSTANCE.recordFailure(session.getPlayerId(), session.getPlayerName(), session.getCurrentStage());
        LeagueHUD.INSTANCE.updateHUD();
        this.endPlayerBattle(player);
        this.cleanupChampionNPCs();
        Messages.INSTANCE.quit(player);
        this.teleportToPosition(player, PokemonLeagueMod.INSTANCE.getConfig().getSpawnPosition());
        LeagueSpectatorManager.INSTANCE.endAllSpectators();
        activeSession = null;
    }

    public final void handlePlayerDisconnect(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        LeagueSession leagueSession = activeSession;
        if (leagueSession == null) {
            return;
        }
        LeagueSession session = leagueSession;
        if (!Intrinsics.areEqual((Object)session.getPlayerId(), (Object)player.method_5667())) {
            return;
        }
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Player " + player.method_5477().getString() + " disconnected during league session");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        pendingTeleportToLobby.add(uUID);
        this.endPlayerBattle(player);
        this.cleanupChampionNPCs();
        LeagueSpectatorManager.INSTANCE.endAllSpectators();
        activeSession = null;
    }

    public final void handlePlayerReconnect(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (pendingTeleportToLobby.remove(player.method_5667())) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Teleporting " + player.method_5477().getString() + " to league lobby after reconnect");
            this.teleportToPosition(player, PokemonLeagueMod.INSTANCE.getConfig().getSpawnPosition());
            player.method_43496((class_2561)class_2561.method_43470((String)"Vous avez ete teleporte au lobby de la Ligue apres votre deconnexion.").method_27694(LeagueManager::handlePlayerReconnect$lambda$0));
        }
    }

    public final boolean needsTeleportOnReconnect(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return pendingTeleportToLobby.contains(playerId);
    }

    private final void cleanupChampionNPCs() {
        Iterable $this$forEach$iv = championNPCs.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NPCEntity npc = (NPCEntity)element$iv;
            boolean bl = false;
            try {
                npc.method_5650(class_1297.class_5529.field_26999);
            }
            catch (Exception e) {
                PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to remove champion NPC", (Throwable)e);
            }
        }
        championNPCs.clear();
    }

    private final void endPlayerBattle(class_3222 player) {
        try {
            PokemonBattle battle = BattleRegistry.getBattleByParticipatingPlayer((class_3222)player);
            if (battle != null) {
                PokemonLeagueMod.INSTANCE.getLOGGER().info("Ending active battle for player " + player.method_5477().getString());
                battle.end();
            }
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to end battle for player " + player.method_5477().getString(), (Throwable)e);
        }
    }

    private final void teleportToPosition(class_3222 player, Position position) {
        Object object;
        block6: {
            block5: {
                Object v1;
                block4: {
                    class_2960 worldKey = class_2960.method_12829((String)position.getWorld());
                    object = server;
                    if (object == null || (object = object.method_29435()) == null) break block5;
                    Iterable iterable = (Iterable)object;
                    for (Object t : iterable) {
                        class_5321 it = (class_5321)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.method_29177(), (Object)worldKey)) continue;
                        v1 = t;
                        break block4;
                    }
                    v1 = null;
                }
                if ((object = (class_5321)v1) == null) break block5;
                Object it = object;
                boolean bl = false;
                MinecraftServer minecraftServer = server;
                Object object2 = minecraftServer != null ? minecraftServer.method_3847((class_5321)it) : null;
                object = object2;
                if (object2 != null) break block6;
            }
            object = player.method_51469();
        }
        Object level = object;
        player.method_14251((class_3218)level, position.getX(), position.getY(), position.getZ(), position.getYaw(), position.getPitch());
    }

    private final float calculateYawToFace(double fromX, double fromZ, double toX, double toZ) {
        double deltaX = toX - fromX;
        double deltaZ = toZ - fromZ;
        return (float)Math.toDegrees(Math.atan2(-deltaX, deltaZ));
    }

    private final void spawnFireworks(class_3222 player) {
        class_3218 world = player.method_51469();
        class_243 pos = player.method_19538();
        for (int i = 0; i < 21; ++i) {
            world.method_14199((class_2394)class_2398.field_11248, pos.field_1352 + (Math.random() - 0.5) * (double)5, pos.field_1351 + Math.random() * (double)3, pos.field_1350 + (Math.random() - 0.5) * (double)5, 10, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private final void broadcastMessage(class_2561 message) {
        block1: {
            Object object = server;
            if (object == null || (object = object.method_3760()) == null || (object = object.method_14571()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3222 player = (class_3222)element$iv;
                boolean bl = false;
                player.method_43496(message);
            }
        }
    }

    public final int getCurrentStage() {
        LeagueSession leagueSession = activeSession;
        return leagueSession != null ? leagueSession.getCurrentStage() : 0;
    }

    public final boolean setPlayerSpawnPosition(int stageNumber, @NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (stageNumber < 1 || stageNumber > 7) {
            return false;
        }
        int stageIndex = stageNumber - 1;
        LeagueConfig config = PokemonLeagueMod.INSTANCE.getConfig();
        List updatedStages = CollectionsKt.toMutableList((Collection)config.getStages());
        if (stageIndex >= updatedStages.size()) {
            return false;
        }
        updatedStages.set(stageIndex, StageConfig.copy$default((StageConfig)updatedStages.get(stageIndex), 0, null, null, 0, 0, null, null, position, null, null, 895, null));
        LeagueConfig newConfig = LeagueConfig.copy$default(config, 0, null, null, updatedStages, 7, null);
        PokemonLeagueMod.INSTANCE.setConfig(newConfig);
        LeagueConfig.Companion.save(newConfig);
        return true;
    }

    public final boolean setNpcSpawnPosition(int stageNumber, @NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (stageNumber < 1 || stageNumber > 7) {
            return false;
        }
        int stageIndex = stageNumber - 1;
        LeagueConfig config = PokemonLeagueMod.INSTANCE.getConfig();
        List updatedStages = CollectionsKt.toMutableList((Collection)config.getStages());
        if (stageIndex >= updatedStages.size()) {
            return false;
        }
        updatedStages.set(stageIndex, StageConfig.copy$default((StageConfig)updatedStages.get(stageIndex), 0, null, null, 0, 0, null, null, null, position, null, 767, null));
        LeagueConfig newConfig = LeagueConfig.copy$default(config, 0, null, null, updatedStages, 7, null);
        PokemonLeagueMod.INSTANCE.setConfig(newConfig);
        LeagueConfig.Companion.save(newConfig);
        return true;
    }

    private static final class_2583 startSession$lambda$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 startSession$lambda$1(class_2583 it) {
        return it.method_36139(0xFF5555).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 startSession$lambda$2(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final CharSequence startSession$lambda$3(Badge it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getBadgeName();
    }

    private static final class_2583 startSession$lambda$4(class_2583 it) {
        return it.method_36139(0xAAAAAA);
    }

    private static final Unit startStage$lambda$0(class_3222 $player, StageConfig $stageConfig) {
        if (activeSession != null) {
            LeagueSession leagueSession = activeSession;
            if (Intrinsics.areEqual((Object)(leagueSession != null ? leagueSession.getPlayerId() : null), (Object)$player.method_5667())) {
                LeagueSpectatorManager.INSTANCE.teleportSpectatorsToPlayer($player);
                INSTANCE.createChampionAndStartBattle($player, $stageConfig);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit createChampionAndStartBattle$lambda$6(LeagueSession $session, NPCEntity $npc, ErroredBattleStart error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to start battle: " + CollectionsKt.joinToString$default((Iterable)error.getErrors(), null, null, null, (int)0, null, null, (int)63, null));
        $session.setInBattle(false);
        $npc.method_5650(class_1297.class_5529.field_26999);
        championNPCs.remove($npc.method_5667());
        return Unit.INSTANCE;
    }

    private static final Unit createChampionAndStartBattle$lambda$7(StageConfig $stageConfig, PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Battle started successfully against " + $stageConfig.getChampionName());
        return Unit.INSTANCE;
    }

    private static final Unit handleVictory$lambda$1(class_3222 $player, int $nextStage) {
        if (activeSession != null) {
            LeagueSession leagueSession = activeSession;
            if (Intrinsics.areEqual((Object)(leagueSession != null ? leagueSession.getPlayerId() : null), (Object)$player.method_5667())) {
                INSTANCE.startStage($player, $nextStage);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit handleFinalVictory$lambda$0(class_3222 $player) {
        INSTANCE.teleportToPosition($player, PokemonLeagueMod.INSTANCE.getConfig().getSpawnPosition());
        LeagueSpectatorManager.INSTANCE.endAllSpectators();
        activeSession = null;
        return Unit.INSTANCE;
    }

    private static final class_2583 handlePlayerReconnect$lambda$0(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    static {
        championNPCs = new ConcurrentHashMap();
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        pendingTeleportToLobby = keySetView;
    }
}

