/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.inventory;

import com.music176.pokemonleague.PokemonLeagueMod;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\u0015\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ)\u0010\u0012\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0014\u0010\rJ\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0018\u0010\u0017J\r\u0010\u0019\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0019\u0010\u0003J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001d\u0010\u001eR2\u0010 \u001a \u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000e0\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!RT\u0010$\u001aB\u0012\f\u0012\n #*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n #*\u0004\u0018\u00010\u00060\u0006 #* \u0012\f\u0012\n #*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n #*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\"0\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/music176/pokemonleague/inventory/InventoryManager;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "", "saveAndClearInventory", "(Lnet/minecraft/class_3222;)Z", "restoreInventory", "Ljava/util/UUID;", "playerId", "hasSavedInventory", "(Ljava/util/UUID;)Z", "", "Lkotlin/Pair;", "", "Lnet/minecraft/class_1799;", "getSavedInventory", "(Ljava/util/UUID;)Ljava/util/List;", "isInventoryLocked", "", "unlockInventory", "(Ljava/util/UUID;)V", "forceUnlock", "clearAll", "", "getLockedPlayers", "()Ljava/util/Set;", "getSavedCount", "()I", "Ljava/util/concurrent/ConcurrentHashMap;", "savedInventories", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "kotlin.jvm.PlatformType", "lockedPlayers", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "pokemon-league-mod"})
public final class InventoryManager {
    @NotNull
    public static final InventoryManager INSTANCE = new InventoryManager();
    @NotNull
    private static final ConcurrentHashMap<UUID, List<Pair<Integer, class_1799>>> savedInventories = new ConcurrentHashMap();
    private static final ConcurrentHashMap.KeySetView<UUID, Boolean> lockedPlayers = ConcurrentHashMap.newKeySet();

    private InventoryManager() {
    }

    public final boolean saveAndClearInventory(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        try {
            class_1661 inventory = player.method_31548();
            List savedItems = new ArrayList();
            int n = inventory.method_5439();
            for (int i = 0; i < n; ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (stack.method_7960()) continue;
                savedItems.add(new Pair((Object)i, (Object)stack.method_7972()));
            }
            ((Map)savedInventories).put(player.method_5667(), savedItems);
            inventory.method_5448();
            lockedPlayers.add(player.method_5667());
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Saved and cleared inventory for " + player.method_5477().getString() + " (" + savedItems.size() + " items)");
            return true;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to save inventory for " + player.method_5477().getString(), (Throwable)e);
            return false;
        }
    }

    public final boolean restoreInventory(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        try {
            List<Pair<Integer, class_1799>> savedItems = savedInventories.remove(player.method_5667());
            lockedPlayers.remove(player.method_5667());
            if (savedItems == null) {
                PokemonLeagueMod.INSTANCE.getLOGGER().warn("No saved inventory found for " + player.method_5477().getString());
                return false;
            }
            class_1661 inventory = player.method_31548();
            for (Pair<Integer, class_1799> pair : savedItems) {
                int slot = ((Number)pair.component1()).intValue();
                class_1799 stack = (class_1799)pair.component2();
                inventory.method_5447(slot, stack.method_7972());
            }
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Restored inventory for " + player.method_5477().getString() + " (" + savedItems.size() + " items)");
            return true;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to restore inventory for " + player.method_5477().getString(), (Throwable)e);
            return false;
        }
    }

    public final boolean hasSavedInventory(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return savedInventories.containsKey(playerId);
    }

    @Nullable
    public final List<Pair<Integer, class_1799>> getSavedInventory(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return savedInventories.get(playerId);
    }

    public final boolean isInventoryLocked(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return lockedPlayers.contains(playerId);
    }

    public final void unlockInventory(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        lockedPlayers.remove(playerId);
    }

    public final void forceUnlock(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        lockedPlayers.remove(playerId);
        savedInventories.remove(playerId);
    }

    public final void clearAll() {
        savedInventories.clear();
        lockedPlayers.clear();
    }

    @NotNull
    public final Set<UUID> getLockedPlayers() {
        ConcurrentHashMap.KeySetView<UUID, Boolean> keySetView = lockedPlayers;
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"lockedPlayers");
        return CollectionsKt.toSet((Iterable)keySetView);
    }

    public final int getSavedCount() {
        return savedInventories.size();
    }
}

