/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.inventory;

import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.inventory.InventoryManager;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u0003R\u0016\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lcom/music176/pokemonleague/inventory/InventoryLockHandler;", "", "<init>", "()V", "", "initialize", "Lnet/minecraft/server/MinecraftServer;", "server", "onServerTick", "(Lnet/minecraft/server/MinecraftServer;)V", "Lnet/minecraft/class_3222;", "player", "dropAllItems", "(Lnet/minecraft/class_3222;)V", "shutdown", "", "initialized", "Z", "", "tickCounter", "I", "CHECK_INTERVAL", "pokemon-league-mod"})
public final class InventoryLockHandler {
    @NotNull
    public static final InventoryLockHandler INSTANCE = new InventoryLockHandler();
    private static boolean initialized;
    private static int tickCounter;
    private static final int CHECK_INTERVAL = 5;

    private InventoryLockHandler() {
    }

    public final void initialize() {
        if (initialized) {
            return;
        }
        ServerTickEvents.END_SERVER_TICK.register(InventoryLockHandler::initialize$lambda$0);
        initialized = true;
        PokemonLeagueMod.INSTANCE.getLOGGER().info("InventoryLockHandler initialized");
    }

    private final void onServerTick(MinecraftServer server) {
        int n = tickCounter;
        if ((tickCounter = n + 1) < 5) {
            return;
        }
        tickCounter = 0;
        Set<UUID> lockedPlayers = InventoryManager.INSTANCE.getLockedPlayers();
        if (lockedPlayers.isEmpty()) {
            return;
        }
        for (UUID playerId : lockedPlayers) {
            class_3222 player;
            if (server.method_3760().method_14602(playerId) == null) continue;
            this.dropAllItems(player);
        }
    }

    private final void dropAllItems(class_3222 player) {
        class_1661 inventory = player.method_31548();
        boolean droppedAny = false;
        int n = inventory.method_5439();
        for (int i = 0; i < n; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            class_1542 itemEntity = new class_1542(player.method_37908(), player.method_23317(), player.method_23318(), player.method_23321(), stack.method_7972());
            itemEntity.method_6982(100);
            player.method_37908().method_8649((class_1297)itemEntity);
            inventory.method_5447(i, class_1799.field_8037);
            droppedAny = true;
        }
        class_1799 cursorStack = player.field_7512.method_34255();
        if (!cursorStack.method_7960()) {
            class_1542 itemEntity = new class_1542(player.method_37908(), player.method_23317(), player.method_23318(), player.method_23321(), cursorStack.method_7972());
            itemEntity.method_6982(100);
            player.method_37908().method_8649((class_1297)itemEntity);
            player.field_7512.method_34254(class_1799.field_8037);
            droppedAny = true;
        }
        if (droppedAny) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Dropped items from locked player " + player.method_5477().getString());
        }
    }

    public final void shutdown() {
    }

    private static final void initialize$lambda$0(MinecraftServer server) {
        Intrinsics.checkNotNull((Object)server);
        INSTANCE.onServerTick(server);
    }
}

