/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.integration;

import com.music176.pokemonleague.PokemonLeagueMod;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003J\u001d\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u001d\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\f\u00a2\u0006\u0004\b\u0014\u0010\u000fJ\u001d\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u001d\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001d\u0010 \u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0015\u00a2\u0006\u0004\b \u0010\u0018J'\u0010#\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b#\u0010$J\r\u0010%\u001a\u00020\u001b\u00a2\u0006\u0004\b%\u0010&R\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010'R\u0016\u0010(\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)R \u0010+\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R \u0010-\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010,R \u0010.\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010,R \u0010/\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u0010,R \u00100\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u0010,R \u00101\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u0010,R \u00102\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u0010,\u00a8\u00063"}, d2={"Lcom/music176/pokemonleague/integration/FTBQuestsIntegration;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "initialize", "(Lnet/minecraft/server/MinecraftServer;)V", "shutdown", "Lnet/minecraft/class_3222;", "player", "", "badgeId", "completeBadgeQuest", "(Lnet/minecraft/class_3222;Ljava/lang/String;)V", "completeLeagueChampionQuest", "(Lnet/minecraft/class_3222;)V", "completeElite4MasterQuest", "rank", "completeRankedQuest", "", "totalDuels", "checkAndCompleteDuelQuests", "(Lnet/minecraft/class_3222;I)V", "totalRanked", "checkAndCompleteRankedQuests", "", "won", "completeTournamentQuest", "(Lnet/minecraft/class_3222;Z)V", "count", "completeLegendaryQuest", "taskId", "description", "completeTask", "(Lnet/minecraft/class_3222;Ljava/lang/String;Ljava/lang/String;)V", "isAvailable", "()Z", "Lnet/minecraft/server/MinecraftServer;", "ftbQuestsAvailable", "Z", "", "badgeToTaskId", "Ljava/util/Map;", "leagueTaskIds", "rankedTaskIds", "duelTaskIds", "rankedMatchTaskIds", "tournamentTaskIds", "legendaryTaskIds", "pokemon-league-mod"})
public final class FTBQuestsIntegration {
    @NotNull
    public static final FTBQuestsIntegration INSTANCE = new FTBQuestsIntegration();
    @Nullable
    private static MinecraftServer server;
    private static boolean ftbQuestsAvailable;
    @NotNull
    private static final Map<String, String> badgeToTaskId;
    @NotNull
    private static final Map<String, String> leagueTaskIds;
    @NotNull
    private static final Map<String, String> rankedTaskIds;
    @NotNull
    private static final Map<String, String> duelTaskIds;
    @NotNull
    private static final Map<String, String> rankedMatchTaskIds;
    @NotNull
    private static final Map<String, String> tournamentTaskIds;
    @NotNull
    private static final Map<String, String> legendaryTaskIds;

    private FTBQuestsIntegration() {
    }

    public final void initialize(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        FTBQuestsIntegration.server = server;
        try {
            ftbQuestsAvailable = true;
            PokemonLeagueMod.INSTANCE.getLOGGER().info("FTBQuestsIntegration initialized - FTB Quests commands will be used");
        }
        catch (Exception e) {
            ftbQuestsAvailable = false;
            PokemonLeagueMod.INSTANCE.getLOGGER().warn("FTB Quests not detected, quest integration disabled");
        }
    }

    public final void shutdown() {
        server = null;
    }

    public final void completeBadgeQuest(@NotNull class_3222 player, @NotNull String badgeId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)badgeId, (String)"badgeId");
        String taskId = badgeToTaskId.get(badgeId);
        if (taskId == null) {
            PokemonLeagueMod.INSTANCE.getLOGGER().warn("Unknown badge ID for FTB Quest completion: " + badgeId);
            return;
        }
        this.completeTask(player, taskId, "Badge quest (" + badgeId + ")");
    }

    public final void completeLeagueChampionQuest(@NotNull class_3222 player) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            String string = leagueTaskIds.get("leagueChampion");
            if (string == null) break block0;
            String taskId = string;
            boolean bl = false;
            INSTANCE.completeTask(player, taskId, "League Champion quest");
        }
    }

    public final void completeElite4MasterQuest(@NotNull class_3222 player) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            String string = leagueTaskIds.get("elite4Master");
            if (string == null) break block0;
            String taskId = string;
            boolean bl = false;
            INSTANCE.completeTask(player, taskId, "Elite 4 Master quest");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void completeRankedQuest(@NotNull class_3222 player, @NotNull String rank) {
        String taskId;
        String string;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)rank, (String)"rank");
                String string2 = rank.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                String string3 = string2;
                switch (string3.hashCode()) {
                    case 3178592: {
                        if (!string3.equals("gold")) {
                            return;
                        }
                        break block6;
                    }
                    case -902311155: {
                        if (string3.equals("silver")) break;
                        return;
                    }
                    case -1380612710: {
                        if (!string3.equals("bronze")) return;
                        string = rankedTaskIds.get("bronzeRank");
                        break block7;
                    }
                }
                string = rankedTaskIds.get("silverRank");
                break block7;
            }
            string = rankedTaskIds.get("goldRank");
            break block7;
            return;
        }
        String string4 = taskId = string;
        if (string4 == null) return;
        String it = string4;
        boolean bl = false;
        INSTANCE.completeTask(player, it, "Ranked " + rank + " quest");
    }

    public final void checkAndCompleteDuelQuests(@NotNull class_3222 player, int totalDuels) {
        block5: {
            String it;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (totalDuels >= 5) {
                String string = duelTaskIds.get("duel5");
                if (string != null) {
                    it = string;
                    boolean bl = false;
                    INSTANCE.completeTask(player, it, "Duel quest (5 duels)");
                }
            }
            if (totalDuels >= 15) {
                String string = duelTaskIds.get("duel15");
                if (string != null) {
                    it = string;
                    boolean bl = false;
                    INSTANCE.completeTask(player, it, "Duel quest (15 duels)");
                }
            }
            if (totalDuels < 30) break block5;
            String string = duelTaskIds.get("duel30");
            if (string != null) {
                it = string;
                boolean bl = false;
                INSTANCE.completeTask(player, it, "Duel quest (30 duels)");
            }
        }
    }

    public final void checkAndCompleteRankedQuests(@NotNull class_3222 player, int totalRanked) {
        block5: {
            String it;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (totalRanked >= 5) {
                String string = rankedMatchTaskIds.get("ranked5");
                if (string != null) {
                    it = string;
                    boolean bl = false;
                    INSTANCE.completeTask(player, it, "Ranked quest (5 ranked)");
                }
            }
            if (totalRanked >= 15) {
                String string = rankedMatchTaskIds.get("ranked15");
                if (string != null) {
                    it = string;
                    boolean bl = false;
                    INSTANCE.completeTask(player, it, "Ranked quest (15 ranked)");
                }
            }
            if (totalRanked < 30) break block5;
            String string = rankedMatchTaskIds.get("ranked30");
            if (string != null) {
                it = string;
                boolean bl = false;
                INSTANCE.completeTask(player, it, "Ranked quest (30 ranked)");
            }
        }
    }

    public final void completeTournamentQuest(@NotNull class_3222 player, boolean won) {
        block0: {
            String taskId;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            String string = taskId = won ? tournamentTaskIds.get("tournamentWinner") : tournamentTaskIds.get("tournamentParticipant");
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            INSTANCE.completeTask(player, it, won ? "Tournament Winner quest" : "Tournament Participant quest");
        }
    }

    public final void completeLegendaryQuest(@NotNull class_3222 player, int count) {
        block0: {
            String taskId;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            String string = taskId = count >= 3 ? legendaryTaskIds.get("legendaryCapture3") : (count >= 1 ? legendaryTaskIds.get("legendaryCapture1") : null);
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            INSTANCE.completeTask(player, it, "Legendary capture quest (" + count + ")");
        }
    }

    private final void completeTask(class_3222 player, String taskId, String description) {
        if (!ftbQuestsAvailable) {
            PokemonLeagueMod.INSTANCE.getLOGGER().debug("FTB Quests not available, skipping: " + description);
            return;
        }
        MinecraftServer minecraftServer = server;
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer srv = minecraftServer;
        try {
            String command = "ftbquests change_progress " + player.method_5477().getString() + " complete " + taskId;
            class_2168 commandSource = srv.method_3739().method_9217().method_9206(4);
            srv.method_3734().method_44252(commandSource, command);
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Completed FTB Quest task for " + player.method_5477().getString() + ": " + description + " (task: " + taskId + ")");
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().warn("Failed to complete FTB Quest task: " + description + " - " + e.getMessage());
        }
    }

    public final boolean isAvailable() {
        return ftbQuestsAvailable && server != null;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"rock_badge", (Object)"6A3F456296C76F7B"), TuplesKt.to((Object)"cascade_badge", (Object)"78EF8A20633D6778"), TuplesKt.to((Object)"thunder_badge", (Object)"0D4211D1708D34C8"), TuplesKt.to((Object)"rainbow_badge", (Object)"113BD595B6696781"), TuplesKt.to((Object)"marsh_badge", (Object)"7FCFCE5737597963"), TuplesKt.to((Object)"volcano_badge", (Object)"BADGE00000206")};
        badgeToTaskId = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"leagueChampion", (Object)"189FAB85030BA551"), TuplesKt.to((Object)"elite4Master", (Object)"CC70000000000001")};
        leagueTaskIds = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"bronzeRank", (Object)"CC60000000000001"), TuplesKt.to((Object)"silverRank", (Object)"CC60000000000002"), TuplesKt.to((Object)"goldRank", (Object)"CC60000000000003")};
        rankedTaskIds = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"duel5", (Object)"23D9518F9843519A"), TuplesKt.to((Object)"duel15", (Object)"5BD38F34E23138FD"), TuplesKt.to((Object)"duel30", (Object)"3690581227245496")};
        duelTaskIds = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"ranked5", (Object)"4A1B2C3D4E5F6A01"), TuplesKt.to((Object)"ranked15", (Object)"4A1B2C3D4E5F6A02"), TuplesKt.to((Object)"ranked30", (Object)"4A1B2C3D4E5F6A03")};
        rankedMatchTaskIds = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"tournamentParticipant", (Object)"CC18000000000001"), TuplesKt.to((Object)"tournamentWinner", (Object)"CC18000000000002")};
        tournamentTaskIds = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"legendaryCapture1", (Object)"CC90000000000001"), TuplesKt.to((Object)"legendaryCapture3", (Object)"CC90000000000002")};
        legendaryTaskIds = MapsKt.mapOf((Pair[])pairArray);
    }
}

