/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.hud;

import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.config.LeagueConfig;
import com.music176.pokemonleague.config.Position;
import com.music176.pokemonleague.league.LeagueManager;
import com.music176.pokemonleague.league.LeagueSession;
import com.music176.pokemonleague.stats.PlayerStats;
import com.music176.pokemonleague.stats.PlayerStatsManager;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_8113;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003J\u0015\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\u0003J\r\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u001c\u0010\rR\u0014\u0010\u001d\u001a\u00020\u00188\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010!R)\u0010)\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"8BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010%\u0012\u0004\b(\u0010\u0003\u001a\u0004\b&\u0010'\u00a8\u0006*"}, d2={"Lcom/music176/pokemonleague/hud/LeagueHUD;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "initialize", "(Lnet/minecraft/server/MinecraftServer;)V", "shutdown", "Lcom/music176/pokemonleague/config/Position;", "position", "spawnHUD", "(Lcom/music176/pokemonleague/config/Position;)V", "removeHUD", "updateHUD", "Lnet/minecraft/class_8113$class_8123;", "display", "updateText", "(Lnet/minecraft/class_8113$class_8123;)V", "Lnet/minecraft/class_3218;", "level", "cleanupOrphanedDisplays", "(Lnet/minecraft/class_3218;Lcom/music176/pokemonleague/config/Position;)V", "", "worldId", "getLevel", "(Ljava/lang/String;)Lnet/minecraft/class_3218;", "setHUDPosition", "HUD_TAG", "Ljava/lang/String;", "textDisplayEntity", "Lnet/minecraft/class_8113$class_8123;", "Lnet/minecraft/server/MinecraftServer;", "Lnet/minecraft/class_2940;", "", "DATA_LINE_WIDTH$delegate", "Lkotlin/Lazy;", "getDATA_LINE_WIDTH", "()Lnet/minecraft/class_2940;", "getDATA_LINE_WIDTH$annotations", "DATA_LINE_WIDTH", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nLeagueHUD.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeagueHUD.kt\ncom/music176/pokemonleague/hud/LeagueHUD\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,171:1\n1#2:172\n1#2:191\n1878#3,3:173\n1869#3,2:176\n1617#3,9:181\n1869#3:190\n1870#3:192\n1626#3:193\n3919#4:178\n4434#4,2:179\n*S KotlinDebug\n*F\n+ 1 LeagueHUD.kt\ncom/music176/pokemonleague/hud/LeagueHUD\n*L\n28#1:191\n122#1:173,3\n150#1:176,2\n28#1:181,9\n28#1:190\n28#1:192\n28#1:193\n27#1:178\n27#1:179,2\n*E\n"})
public final class LeagueHUD {
    @NotNull
    public static final LeagueHUD INSTANCE = new LeagueHUD();
    @NotNull
    private static final String HUD_TAG = "pokemonleague_leaguehud";
    @Nullable
    private static class_8113.class_8123 textDisplayEntity;
    @Nullable
    private static MinecraftServer server;
    @NotNull
    private static final Lazy DATA_LINE_WIDTH$delegate;

    private LeagueHUD() {
    }

    private final class_2940<Integer> getDATA_LINE_WIDTH() {
        Lazy lazy = DATA_LINE_WIDTH$delegate;
        return (class_2940)lazy.getValue();
    }

    private static /* synthetic */ void getDATA_LINE_WIDTH$annotations() {
    }

    public final void initialize(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        LeagueHUD.server = server;
        Position hudPos = PokemonLeagueMod.INSTANCE.getConfig().getHudPosition();
        if (hudPos != null) {
            this.spawnHUD(hudPos);
            PokemonLeagueMod.INSTANCE.getLOGGER().info("HUD initialized at " + hudPos.getX() + ", " + hudPos.getY() + ", " + hudPos.getZ());
        }
    }

    public final void shutdown() {
        this.removeHUD();
        server = null;
    }

    public final void spawnHUD(@NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.removeHUD();
        class_3218 class_32182 = this.getLevel(position.getWorld());
        if (class_32182 == null) {
            LeagueHUD $this$spawnHUD_u24lambda_u240 = this;
            boolean bl = false;
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to spawn HUD: world " + position.getWorld() + " not found");
            return;
        }
        class_3218 level = class_32182;
        int chunkX = (int)position.getX() >> 4;
        int chunkZ = (int)position.getZ() >> 4;
        level.method_8497(chunkX, chunkZ);
        this.cleanupOrphanedDisplays(level, position);
        class_8113.class_8123 textDisplay = new class_8113.class_8123(class_1299.field_42457, (class_1937)level);
        textDisplay.method_5808(position.getX(), position.getY(), position.getZ(), position.getYaw(), position.getPitch());
        textDisplay.method_5780(HUD_TAG);
        textDisplay.method_48847(class_8113.class_8114.field_42409);
        class_2940<Integer> class_29402 = this.getDATA_LINE_WIDTH();
        if (class_29402 != null) {
            class_2940<Integer> accessor = class_29402;
            boolean bl = false;
            textDisplay.method_5841().method_12778(accessor, (Object)400);
        }
        this.updateText(textDisplay);
        level.method_8649((class_1297)textDisplay);
        textDisplayEntity = textDisplay;
        PokemonLeagueMod.INSTANCE.getLOGGER().info("HUD spawned at " + position.getX() + ", " + position.getY() + ", " + position.getZ());
    }

    public final void removeHUD() {
        class_8113.class_8123 class_81232 = textDisplayEntity;
        if (class_81232 != null) {
            class_8113.class_8123 entity = class_81232;
            boolean bl = false;
            entity.method_5650(class_1297.class_5529.field_26999);
            PokemonLeagueMod.INSTANCE.getLOGGER().info("HUD removed");
        }
        textDisplayEntity = null;
    }

    public final void updateHUD() {
        block0: {
            class_8113.class_8123 class_81232 = textDisplayEntity;
            if (class_81232 == null) break block0;
            class_8113.class_8123 it = class_81232;
            boolean bl = false;
            INSTANCE.updateText(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateText(class_8113.class_8123 display) {
        StringBuilder stringBuilder;
        LeagueSession session = LeagueManager.INSTANCE.getActiveSession();
        List<PlayerStats> topPlayers = PlayerStatsManager.INSTANCE.getTopPlayers(2);
        StringBuilder $this$updateText_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$updateText_u24lambda_u240.append("\u00a76\u00a7l=== LIGUE POKEMON ===").append('\n');
        $this$updateText_u24lambda_u240.append('\n');
        $this$updateText_u24lambda_u240.append("\u00a7e\u00a7lChampion Actuel:").append('\n');
        StringBuilder stringBuilder2 = session != null ? $this$updateText_u24lambda_u240.append("\u00a7a" + session.getPlayerName() + " \u00a77(Etage " + session.getCurrentStage() + "/7)").append('\n') : $this$updateText_u24lambda_u240.append("\u00a77Aucun - Ligue libre").append('\n');
        $this$updateText_u24lambda_u240.append('\n');
        $this$updateText_u24lambda_u240.append("\u00a7d\u00a7lClassement:").append('\n');
        if (topPlayers.isEmpty()) {
            $this$updateText_u24lambda_u240.append("\u00a77Aucune statistique").append('\n');
        } else {
            Iterable $this$forEachIndexed$iv = topPlayers;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void stats;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                PlayerStats playerStats = (PlayerStats)item$iv;
                int index = n;
                boolean bl2 = false;
                String medal = index == 0 ? "\u00a76#1" : "\u00a77#2";
                $this$updateText_u24lambda_u240.append(medal + " \u00a7f" + stats.getPlayerName()).append('\n');
                $this$updateText_u24lambda_u240.append("  \u00a77" + stats.getTotalAttempts() + " tentatives, \u00a7c" + stats.getFailedRuns() + " echoue, \u00a7a" + stats.getSuccessfulRuns() + " reussis").append('\n');
            }
        }
        String text = stringBuilder.toString();
        display.method_48911((class_2561)class_2561.method_43470((String)text));
    }

    private final void cleanupOrphanedDisplays(class_3218 level, Position position) {
        double searchRadius = 5.0;
        class_238 area = new class_238(position.getX() - searchRadius, position.getY() - searchRadius, position.getZ() - searchRadius, position.getX() + searchRadius, position.getY() + searchRadius, position.getZ() + searchRadius);
        List orphanedEntities = level.method_8333(null, area, arg_0 -> LeagueHUD.cleanupOrphanedDisplays$lambda$1(LeagueHUD::cleanupOrphanedDisplays$lambda$0, arg_0));
        Intrinsics.checkNotNull((Object)orphanedEntities);
        if (!((Collection)orphanedEntities).isEmpty()) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Cleaning up " + orphanedEntities.size() + " orphaned TextDisplay entities near League HUD at " + position.getX() + ", " + position.getY() + ", " + position.getZ());
            Iterable $this$forEach$iv = orphanedEntities;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_1297 entity = (class_1297)element$iv;
                boolean bl = false;
                entity.method_5650(class_1297.class_5529.field_26999);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final class_3218 getLevel(String worldId) {
        Object v4;
        Object object;
        block2: {
            class_2960 class_29602 = class_2960.method_12829((String)worldId);
            if (class_29602 == null) {
                return null;
            }
            class_2960 worldKey = class_29602;
            MinecraftServer minecraftServer = server;
            object = minecraftServer;
            if (minecraftServer == null) return null;
            Set set = object.method_29435();
            object = set;
            if (set == null) return null;
            Iterable iterable = (Iterable)object;
            for (Object t : iterable) {
                class_5321 it = (class_5321)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.method_29177(), (Object)worldKey)) continue;
                v4 = t;
                break block2;
            }
            v4 = null;
        }
        class_5321 class_53212 = v4;
        object = class_53212;
        if (class_53212 == null) return null;
        Object object2 = object;
        boolean bl = false;
        MinecraftServer minecraftServer = server;
        if (minecraftServer == null) return null;
        class_3218 class_32182 = minecraftServer.method_3847((class_5321)object2);
        return class_32182;
    }

    public final void setHUDPosition(@NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        LeagueConfig config = LeagueConfig.copy$default(PokemonLeagueMod.INSTANCE.getConfig(), 0, null, position, null, 11, null);
        LeagueConfig.Companion.save(config);
        PokemonLeagueMod.INSTANCE.reloadConfig();
        this.spawnHUD(position);
    }

    /*
     * WARNING - void declaration
     */
    private static final class_2940 DATA_LINE_WIDTH_delegate$lambda$0() {
        Object object;
        try {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Field[] fieldArray = class_8113.class_8123.class.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
            Object[] $this$filter$iv = fieldArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Field it = (Field)element$iv$iv;
                boolean bl = false;
                if (!(Modifier.isStatic(it.getModifiers()) && Modifier.isPrivate(it.getModifiers()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                class_2940 it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Field field = (Field)element$iv$iv;
                boolean bl2 = false;
                field.setAccessible(true);
                Object object2 = field.get(null);
                if ((object2 instanceof class_2940 ? (class_2940)object2 : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            object = CollectionsKt.firstOrNull((List)CollectionsKt.drop((Iterable)((List)destination$iv$iv), (int)1));
            object = object instanceof class_2940 ? (class_2940)object : null;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().warn("Could not find line width accessor for LeagueHUD", (Throwable)e);
            object = null;
        }
        return object;
    }

    private static final boolean cleanupOrphanedDisplays$lambda$0(class_1297 entity) {
        return entity instanceof class_8113.class_8123 && entity != textDisplayEntity;
    }

    private static final boolean cleanupOrphanedDisplays$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        DATA_LINE_WIDTH$delegate = LazyKt.lazy(LeagueHUD::DATA_LINE_WIDTH_delegate$lambda$0);
    }
}

