/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.gym;

import com.music176.pokemonleague.gym.GymData;
import com.music176.pokemonleague.gym.TrainerData;
import java.time.Instant;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b1\b\u0086\b\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\r\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\r\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u000f\u0010\u0017\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010\u001e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\u0004\u00a2\u0006\u0004\b \u0010\u001fJ\r\u0010!\u001a\u00020\r\u00a2\u0006\u0004\b!\u0010\u0014J\r\u0010\"\u001a\u00020\r\u00a2\u0006\u0004\b\"\u0010\u0014J\u0010\u0010#\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b#\u0010$J\u0010\u0010%\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b%\u0010\u001fJ\u0010\u0010&\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b&\u0010\u001fJ\u0010\u0010'\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b'\u0010(J\u0010\u0010)\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b)\u0010*J\u0010\u0010+\u001a\u00020\u000bH\u00c6\u0003\u00a2\u0006\u0004\b+\u0010\u001aJ\u0010\u0010,\u001a\u00020\rH\u00c6\u0003\u00a2\u0006\u0004\b,\u0010\u0014J\u0010\u0010-\u001a\u00020\rH\u00c6\u0003\u00a2\u0006\u0004\b-\u0010\u0014J\u0012\u0010.\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b.\u0010$Jl\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\r2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b/\u00100J\u001a\u00102\u001a\u00020\r2\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b2\u00103J\u0010\u00104\u001a\u00020\u000bH\u00d6\u0001\u00a2\u0006\u0004\b4\u0010\u001aJ\u0010\u00105\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b5\u0010\u001fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00106\u001a\u0004\b7\u0010$R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u00108\u001a\u0004\b9\u0010\u001fR\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u00108\u001a\u0004\b:\u0010\u001fR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010;\u001a\u0004\b<\u0010(R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010=\u001a\u0004\b>\u0010*R\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010?\u001a\u0004\b@\u0010\u001a\"\u0004\bA\u0010BR\"\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010C\u001a\u0004\bD\u0010\u0014\"\u0004\bE\u0010FR\"\u0010\u000f\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010C\u001a\u0004\bG\u0010\u0014\"\u0004\bH\u0010FR$\u0010\u0010\u001a\u0004\u0018\u00010\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u00106\u001a\u0004\bI\u0010$\"\u0004\bJ\u0010K\u00a8\u0006L"}, d2={"Lcom/music176/pokemonleague/gym/GymSession;", "", "Ljava/util/UUID;", "playerId", "", "playerName", "gymId", "Lcom/music176/pokemonleague/gym/GymData;", "gymData", "Ljava/time/Instant;", "startTime", "", "currentPhase", "", "inBattle", "healedBeforeChampion", "currentTrainerNpcId", "<init>", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;Lcom/music176/pokemonleague/gym/GymData;Ljava/time/Instant;IZZLjava/util/UUID;)V", "isTrainerPhase", "()Z", "isChampionPhase", "Lcom/music176/pokemonleague/gym/TrainerData;", "getCurrentTrainer", "()Lcom/music176/pokemonleague/gym/TrainerData;", "getTotalPhases", "()I", "", "getElapsedTimeMs", "()J", "getFormattedElapsedTime", "()Ljava/lang/String;", "getProgressString", "isLastTrainerBeforeChampion", "advancePhase", "component1", "()Ljava/util/UUID;", "component2", "component3", "component4", "()Lcom/music176/pokemonleague/gym/GymData;", "component5", "()Ljava/time/Instant;", "component6", "component7", "component8", "component9", "copy", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;Lcom/music176/pokemonleague/gym/GymData;Ljava/time/Instant;IZZLjava/util/UUID;)Lcom/music176/pokemonleague/gym/GymSession;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/util/UUID;", "getPlayerId", "Ljava/lang/String;", "getPlayerName", "getGymId", "Lcom/music176/pokemonleague/gym/GymData;", "getGymData", "Ljava/time/Instant;", "getStartTime", "I", "getCurrentPhase", "setCurrentPhase", "(I)V", "Z", "getInBattle", "setInBattle", "(Z)V", "getHealedBeforeChampion", "setHealedBeforeChampion", "getCurrentTrainerNpcId", "setCurrentTrainerNpcId", "(Ljava/util/UUID;)V", "pokemon-league-mod"})
public final class GymSession {
    @NotNull
    private final UUID playerId;
    @NotNull
    private final String playerName;
    @NotNull
    private final String gymId;
    @NotNull
    private final GymData gymData;
    @NotNull
    private final Instant startTime;
    private int currentPhase;
    private boolean inBattle;
    private boolean healedBeforeChampion;
    @Nullable
    private UUID currentTrainerNpcId;

    public GymSession(@NotNull UUID playerId, @NotNull String playerName, @NotNull String gymId, @NotNull GymData gymData, @NotNull Instant startTime, int currentPhase, boolean inBattle, boolean healedBeforeChampion, @Nullable UUID currentTrainerNpcId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
        Intrinsics.checkNotNullParameter((Object)gymData, (String)"gymData");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        this.playerId = playerId;
        this.playerName = playerName;
        this.gymId = gymId;
        this.gymData = gymData;
        this.startTime = startTime;
        this.currentPhase = currentPhase;
        this.inBattle = inBattle;
        this.healedBeforeChampion = healedBeforeChampion;
        this.currentTrainerNpcId = currentTrainerNpcId;
    }

    public /* synthetic */ GymSession(UUID uUID, String string, String string2, GymData gymData, Instant instant, int n, boolean bl, boolean bl2, UUID uUID2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        if ((n2 & 0x20) != 0) {
            n = 1;
        }
        if ((n2 & 0x40) != 0) {
            bl = false;
        }
        if ((n2 & 0x80) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x100) != 0) {
            uUID2 = null;
        }
        this(uUID, string, string2, gymData, instant, n, bl, bl2, uUID2);
    }

    @NotNull
    public final UUID getPlayerId() {
        return this.playerId;
    }

    @NotNull
    public final String getPlayerName() {
        return this.playerName;
    }

    @NotNull
    public final String getGymId() {
        return this.gymId;
    }

    @NotNull
    public final GymData getGymData() {
        return this.gymData;
    }

    @NotNull
    public final Instant getStartTime() {
        return this.startTime;
    }

    public final int getCurrentPhase() {
        return this.currentPhase;
    }

    public final void setCurrentPhase(int n) {
        this.currentPhase = n;
    }

    public final boolean getInBattle() {
        return this.inBattle;
    }

    public final void setInBattle(boolean bl) {
        this.inBattle = bl;
    }

    public final boolean getHealedBeforeChampion() {
        return this.healedBeforeChampion;
    }

    public final void setHealedBeforeChampion(boolean bl) {
        this.healedBeforeChampion = bl;
    }

    @Nullable
    public final UUID getCurrentTrainerNpcId() {
        return this.currentTrainerNpcId;
    }

    public final void setCurrentTrainerNpcId(@Nullable UUID uUID) {
        this.currentTrainerNpcId = uUID;
    }

    public final boolean isTrainerPhase() {
        int n = this.currentPhase;
        return 1 <= n ? n < 4 : false;
    }

    public final boolean isChampionPhase() {
        return this.currentPhase == 4;
    }

    @Nullable
    public final TrainerData getCurrentTrainer() {
        int n = this.currentPhase;
        return (1 <= n ? n < 4 : false) ? (TrainerData)CollectionsKt.getOrNull(this.gymData.getTrainers(), (int)(this.currentPhase - 1)) : (n == 4 ? this.gymData.getChampion() : null);
    }

    public final int getTotalPhases() {
        return 4;
    }

    public final long getElapsedTimeMs() {
        return Instant.now().toEpochMilli() - this.startTime.toEpochMilli();
    }

    @NotNull
    public final String getFormattedElapsedTime() {
        long totalSeconds = this.getElapsedTimeMs() / (long)1000;
        long minutes = totalSeconds / (long)60;
        long seconds = totalSeconds % (long)60;
        String string = "%02d:%02d";
        Object[] objectArray = new Object[]{minutes, seconds};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public final String getProgressString() {
        return "Phase " + this.currentPhase + "/" + this.getTotalPhases();
    }

    public final boolean isLastTrainerBeforeChampion() {
        return this.currentPhase == 3;
    }

    public final boolean advancePhase() {
        if (this.currentPhase < this.getTotalPhases()) {
            int n = this.currentPhase;
            this.currentPhase = n + 1;
            return true;
        }
        return false;
    }

    @NotNull
    public final UUID component1() {
        return this.playerId;
    }

    @NotNull
    public final String component2() {
        return this.playerName;
    }

    @NotNull
    public final String component3() {
        return this.gymId;
    }

    @NotNull
    public final GymData component4() {
        return this.gymData;
    }

    @NotNull
    public final Instant component5() {
        return this.startTime;
    }

    public final int component6() {
        return this.currentPhase;
    }

    public final boolean component7() {
        return this.inBattle;
    }

    public final boolean component8() {
        return this.healedBeforeChampion;
    }

    @Nullable
    public final UUID component9() {
        return this.currentTrainerNpcId;
    }

    @NotNull
    public final GymSession copy(@NotNull UUID playerId, @NotNull String playerName, @NotNull String gymId, @NotNull GymData gymData, @NotNull Instant startTime, int currentPhase, boolean inBattle, boolean healedBeforeChampion, @Nullable UUID currentTrainerNpcId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
        Intrinsics.checkNotNullParameter((Object)gymData, (String)"gymData");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        return new GymSession(playerId, playerName, gymId, gymData, startTime, currentPhase, inBattle, healedBeforeChampion, currentTrainerNpcId);
    }

    public static /* synthetic */ GymSession copy$default(GymSession gymSession, UUID uUID, String string, String string2, GymData gymData, Instant instant, int n, boolean bl, boolean bl2, UUID uUID2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            uUID = gymSession.playerId;
        }
        if ((n2 & 2) != 0) {
            string = gymSession.playerName;
        }
        if ((n2 & 4) != 0) {
            string2 = gymSession.gymId;
        }
        if ((n2 & 8) != 0) {
            gymData = gymSession.gymData;
        }
        if ((n2 & 0x10) != 0) {
            instant = gymSession.startTime;
        }
        if ((n2 & 0x20) != 0) {
            n = gymSession.currentPhase;
        }
        if ((n2 & 0x40) != 0) {
            bl = gymSession.inBattle;
        }
        if ((n2 & 0x80) != 0) {
            bl2 = gymSession.healedBeforeChampion;
        }
        if ((n2 & 0x100) != 0) {
            uUID2 = gymSession.currentTrainerNpcId;
        }
        return gymSession.copy(uUID, string, string2, gymData, instant, n, bl, bl2, uUID2);
    }

    @NotNull
    public String toString() {
        return "GymSession(playerId=" + this.playerId + ", playerName=" + this.playerName + ", gymId=" + this.gymId + ", gymData=" + this.gymData + ", startTime=" + this.startTime + ", currentPhase=" + this.currentPhase + ", inBattle=" + this.inBattle + ", healedBeforeChampion=" + this.healedBeforeChampion + ", currentTrainerNpcId=" + this.currentTrainerNpcId + ")";
    }

    public int hashCode() {
        int result = this.playerId.hashCode();
        result = result * 31 + this.playerName.hashCode();
        result = result * 31 + this.gymId.hashCode();
        result = result * 31 + this.gymData.hashCode();
        result = result * 31 + this.startTime.hashCode();
        result = result * 31 + Integer.hashCode(this.currentPhase);
        result = result * 31 + Boolean.hashCode(this.inBattle);
        result = result * 31 + Boolean.hashCode(this.healedBeforeChampion);
        result = result * 31 + (this.currentTrainerNpcId == null ? 0 : this.currentTrainerNpcId.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GymSession)) {
            return false;
        }
        GymSession gymSession = (GymSession)other;
        if (!Intrinsics.areEqual((Object)this.playerId, (Object)gymSession.playerId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.playerName, (Object)gymSession.playerName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.gymId, (Object)gymSession.gymId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.gymData, (Object)gymSession.gymData)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startTime, (Object)gymSession.startTime)) {
            return false;
        }
        if (this.currentPhase != gymSession.currentPhase) {
            return false;
        }
        if (this.inBattle != gymSession.inBattle) {
            return false;
        }
        if (this.healedBeforeChampion != gymSession.healedBeforeChampion) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.currentTrainerNpcId, (Object)gymSession.currentTrainerNpcId);
    }
}

