/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.gym;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.npc.NPCClass;
import com.cobblemon.mod.common.api.npc.NPCClasses;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.scheduling.SchedulingFunctionsKt;
import com.cobblemon.mod.common.api.storage.party.NPCPartyStore;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.BattleStartResult;
import com.cobblemon.mod.common.battles.ErroredBattleStart;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.npc.NPCEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.battle.ChampionBattleActor;
import com.music176.pokemonleague.config.Position;
import com.music176.pokemonleague.duel.DuelManager;
import com.music176.pokemonleague.economy.EconomyBridge;
import com.music176.pokemonleague.economy.EconomyManager;
import com.music176.pokemonleague.gym.GymConfig;
import com.music176.pokemonleague.gym.GymData;
import com.music176.pokemonleague.gym.GymHUD;
import com.music176.pokemonleague.gym.GymSession;
import com.music176.pokemonleague.gym.ItemReward;
import com.music176.pokemonleague.gym.TrainerData;
import com.music176.pokemonleague.integration.FTBQuestsIntegration;
import com.music176.pokemonleague.league.LeagueManager;
import com.music176.pokemonleague.profile.Badge;
import com.music176.pokemonleague.profile.PlayerProfile;
import com.music176.pokemonleague.profile.PlayerProfileManager;
import com.music176.pokemonleague.rewards.RewardDispenser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003J\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u0003J\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0019\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010\u001e\u001a\u00020\r\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b \u0010!J\u001d\u0010$\u001a\u00020\r2\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b$\u0010%J\u001d\u0010(\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\"2\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0004\b(\u0010)J\u001f\u0010,\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\"2\u0006\u0010+\u001a\u00020*H\u0002\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010.\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b.\u0010/J\u0017\u00100\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b0\u0010/J\u0015\u00101\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b1\u0010/J\u0015\u00102\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b2\u0010/J\u0015\u00103\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b3\u0010/J\u001f\u00104\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b4\u00105J\u0017\u00106\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b6\u00107J\u0017\u00108\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b8\u0010/J\u0017\u00109\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b9\u0010/J\u001f\u0010<\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\"2\u0006\u0010;\u001a\u00020:H\u0002\u00a2\u0006\u0004\b<\u0010=J\u0017\u0010>\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b>\u0010/J\u0017\u0010A\u001a\u00020\u00062\u0006\u0010@\u001a\u00020?H\u0002\u00a2\u0006\u0004\bA\u0010BJ\u001d\u0010C\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010;\u001a\u00020:\u00a2\u0006\u0004\bC\u0010DJ\u001d\u0010E\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010;\u001a\u00020:\u00a2\u0006\u0004\bE\u0010DJ\u001d\u0010F\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010;\u001a\u00020:\u00a2\u0006\u0004\bF\u0010DJ\u001d\u0010G\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010;\u001a\u00020:\u00a2\u0006\u0004\bG\u0010DJ\u0015\u0010H\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\bH\u0010\u001aR\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010IR \u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100J8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bK\u0010LR \u0010M\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00150J8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bM\u0010LR,\u0010P\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020O\u0012\u0004\u0012\u00020\u00150N0J8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bP\u0010LR$\u0010S\u001a\u00020Q2\u0006\u0010R\u001a\u00020Q8\u0006@BX\u0086.\u00a2\u0006\f\n\u0004\bS\u0010T\u001a\u0004\bU\u0010V\u00a8\u0006W"}, d2={"Lcom/music176/pokemonleague/gym/GymManager;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "initialize", "(Lnet/minecraft/server/MinecraftServer;)V", "shutdown", "reloadConfig", "Ljava/util/UUID;", "playerId", "", "isPlayerActive", "(Ljava/util/UUID;)Z", "Lcom/music176/pokemonleague/gym/GymSession;", "getPlayerSession", "(Ljava/util/UUID;)Lcom/music176/pokemonleague/gym/GymSession;", "getActiveSession", "()Lcom/music176/pokemonleague/gym/GymSession;", "", "gymId", "getActiveSessionForGym", "(Ljava/lang/String;)Lcom/music176/pokemonleague/gym/GymSession;", "isGymOccupied", "(Ljava/lang/String;)Z", "", "getAllActiveSessions", "()Ljava/util/Map;", "isOccupied", "()Z", "getCurrentGymId", "()Ljava/lang/String;", "Lnet/minecraft/class_3222;", "player", "startGymChallenge", "(Lnet/minecraft/class_3222;Ljava/lang/String;)Z", "", "phase", "startPhase", "(Lnet/minecraft/class_3222;I)V", "Lcom/music176/pokemonleague/gym/TrainerData;", "trainerData", "createTrainerAndStartBattle", "(Lnet/minecraft/class_3222;Lcom/music176/pokemonleague/gym/TrainerData;)V", "handleVictory", "(Lnet/minecraft/class_3222;)V", "handleChampionVictory", "handleDefeat", "quitSession", "handlePlayerDisconnect", "clearSession", "(Ljava/lang/String;Ljava/util/UUID;)V", "cleanupTrainerNPCsForGym", "(Ljava/lang/String;)V", "endPlayerBattle", "recallAllPokemon", "Lcom/music176/pokemonleague/config/Position;", "position", "teleportToPosition", "(Lnet/minecraft/class_3222;Lcom/music176/pokemonleague/config/Position;)V", "spawnFireworks", "Lnet/minecraft/class_2561;", "message", "broadcastMessage", "(Lnet/minecraft/class_2561;)V", "setPlayerSpawnPosition", "(Ljava/lang/String;Lcom/music176/pokemonleague/config/Position;)Z", "setNpcSpawnPosition", "setLobbyPosition", "setHudPosition", "removeHud", "Lnet/minecraft/server/MinecraftServer;", "Ljava/util/concurrent/ConcurrentHashMap;", "activeSessions", "Ljava/util/concurrent/ConcurrentHashMap;", "playerToGym", "Lkotlin/Pair;", "Lcom/cobblemon/mod/common/entity/npc/NPCEntity;", "trainerNPCs", "Lcom/music176/pokemonleague/gym/GymConfig;", "value", "gymConfig", "Lcom/music176/pokemonleague/gym/GymConfig;", "getGymConfig", "()Lcom/music176/pokemonleague/gym/GymConfig;", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nGymManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GymManager.kt\ncom/music176/pokemonleague/gym/GymManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,853:1\n1869#2,2:854\n1869#2,2:856\n2746#2,3:858\n1878#2,3:861\n774#2:864\n865#2,2:865\n1563#2:867\n1634#2,3:868\n1617#2,9:871\n1869#2:880\n1870#2:882\n1626#2:883\n774#2:884\n865#2,2:885\n1563#2:887\n1634#2,3:888\n1563#2:891\n1634#2,3:892\n774#2:895\n865#2,2:896\n1869#2,2:898\n1869#2,2:900\n1869#2,2:903\n360#2,7:905\n360#2,7:912\n360#2,7:919\n360#2,7:926\n360#2,7:933\n1#3:881\n1#3:902\n*S KotlinDebug\n*F\n+ 1 GymManager.kt\ncom/music176/pokemonleague/gym/GymManager\n*L\n60#1:854,2\n67#1:856,2\n200#1:858,3\n355#1:861,3\n377#1:864\n377#1:865,2\n378#1:867\n378#1:868,3\n391#1:871,9\n391#1:880\n391#1:882\n391#1:883\n392#1:884\n392#1:885,2\n393#1:887\n393#1:888,3\n508#1:891\n508#1:892,3\n681#1:895\n681#1:896,2\n682#1:898,2\n713#1:900,2\n762#1:903,2\n771#1:905,7\n787#1:912,7\n803#1:919,7\n819#1:926,7\n838#1:933,7\n391#1:881\n*E\n"})
public final class GymManager {
    @NotNull
    public static final GymManager INSTANCE = new GymManager();
    @Nullable
    private static MinecraftServer server;
    @NotNull
    private static final ConcurrentHashMap<String, GymSession> activeSessions;
    @NotNull
    private static final ConcurrentHashMap<UUID, String> playerToGym;
    @NotNull
    private static final ConcurrentHashMap<UUID, Pair<NPCEntity, String>> trainerNPCs;
    private static GymConfig gymConfig;

    private GymManager() {
    }

    @NotNull
    public final GymConfig getGymConfig() {
        GymConfig gymConfig = GymManager.gymConfig;
        if (gymConfig != null) {
            return gymConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"gymConfig");
        return null;
    }

    public final void initialize(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        GymManager.server = server;
        gymConfig = GymConfig.Companion.load();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("GymManager initialized with " + this.getGymConfig().getGyms().size() + " gyms");
    }

    public final void shutdown() {
        Collection<GymSession> collection = activeSessions.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)collection);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GymSession session = (GymSession)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(session.getPlayerId())) == null) continue;
            MinecraftServer player = minecraftServer;
            boolean bl2 = false;
            INSTANCE.handlePlayerDisconnect((class_3222)player);
        }
        Collection<Pair<NPCEntity, String>> collection2 = trainerNPCs.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        $this$forEach$iv = collection2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            NPCEntity npc = (NPCEntity)pair.component1();
            npc.method_5650(class_1297.class_5529.field_26999);
        }
        trainerNPCs.clear();
        server = null;
        PokemonLeagueMod.INSTANCE.getLOGGER().info("GymManager shutdown complete");
    }

    public final void reloadConfig() {
        gymConfig = GymConfig.Companion.load();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("GymConfig reloaded");
    }

    public final boolean isPlayerActive(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return playerToGym.containsKey(playerId);
    }

    @Nullable
    public final GymSession getPlayerSession(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        String string = playerToGym.get(playerId);
        if (string == null) {
            return null;
        }
        String gymId = string;
        return activeSessions.get(gymId);
    }

    @Nullable
    public final GymSession getActiveSession() {
        return null;
    }

    @Nullable
    public final GymSession getActiveSessionForGym(@NotNull String gymId) {
        Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
        return activeSessions.get(gymId);
    }

    public final boolean isGymOccupied(@NotNull String gymId) {
        Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
        return activeSessions.containsKey(gymId);
    }

    @NotNull
    public final Map<String, GymSession> getAllActiveSessions() {
        return MapsKt.toMap((Map)activeSessions);
    }

    public final boolean isOccupied() {
        return !((Map)activeSessions).isEmpty();
    }

    @Nullable
    public final String getCurrentGymId() {
        Set set = activeSessions.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return (String)CollectionsKt.firstOrNull((Iterable)set);
    }

    public final boolean startGymChallenge(@NotNull class_3222 player, @NotNull String gymId) {
        boolean bl;
        boolean hasBadge;
        GymData gymData;
        block18: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
            gymData = this.getGymConfig().getGym(gymId);
            if (gymData == null) {
                player.method_43496((class_2561)class_2561.method_43470((String)("Arene '" + gymId + "' introuvable!")));
                return false;
            }
            GymSession existingSession = activeSessions.get(gymId);
            if (existingSession != null) {
                player.method_43496((class_2561)class_2561.method_43470((String)("L'arene " + gymData.getGymName() + " est deja occupee par " + existingSession.getPlayerName() + "!")).method_27694(GymManager::startGymChallenge$lambda$0));
                return false;
            }
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            if (this.isPlayerActive(uUID)) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Vous etes deja dans une arene!").method_27694(GymManager::startGymChallenge$lambda$1));
                return false;
            }
            UUID uUID2 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            if (LeagueManager.INSTANCE.isPlayerActive(uUID2)) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Vous etes deja dans la Ligue Pokemon!").method_27694(GymManager::startGymChallenge$lambda$2));
                return false;
            }
            if (DuelManager.INSTANCE.isArenaOccupiedByDuel(gymId)) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Cette arene est occupee par un duel!").method_27694(GymManager::startGymChallenge$lambda$3));
                return false;
            }
            UUID uUID3 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
            if (!PlayerProfileManager.INSTANCE.canChallengeGym(uUID3, gymData.getGymNumber())) {
                String requiredBadgeName = switch (gymData.getGymNumber()) {
                    case 2 -> "Badge Roche";
                    case 3 -> "Badge Cascade";
                    case 4 -> "Badge Foudre";
                    case 5 -> "Badge Prisme";
                    default -> "Badge precedent";
                };
                player.method_43496((class_2561)class_2561.method_43470((String)("Vous devez d'abord obtenir le " + requiredBadgeName + "!")).method_27694(GymManager::startGymChallenge$lambda$4));
                return false;
            }
            UUID uUID4 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID4, (String)"getUUID(...)");
            String string = player.method_5477().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            PlayerProfile profile = PlayerProfileManager.INSTANCE.getOrCreateProfile(uUID4, string);
            Badge badge = profile.getBadges().getBadgeById(gymData.getBadgeId());
            hasBadge = badge != null ? badge.getObtained() : false;
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            Iterable $this$none$iv = (Iterable)party;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Pokemon it = (Pokemon)element$iv;
                    boolean bl2 = false;
                    if (!(it.getCurrentHealth() > 0)) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
        }
        if (bl) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Vous n'avez pas de Pokemon en etat de combattre!").method_27694(GymManager::startGymChallenge$lambda$6));
            return false;
        }
        int entryFee = gymData.getEntryFee();
        if (!EconomyBridge.INSTANCE.withdraw(player, entryFee)) {
            player.method_43496((class_2561)class_2561.method_43470((String)("Vous n'avez pas assez de Pokedollars! (" + EconomyBridge.INSTANCE.formatBalance(entryFee) + " requis)")).method_27694(GymManager::startGymChallenge$lambda$7));
            return false;
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        String string = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        PlayerProfileManager.INSTANCE.recordCreditsSpent(uUID, string, entryFee);
        UUID uUID5 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID5, (String)"getUUID(...)");
        String string2 = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        GymSession session = new GymSession(uUID5, string2, gymId, gymData, null, 0, false, false, null, 496, null);
        ((Map)activeSessions).put(gymId, session);
        ((Map)playerToGym).put(player.method_5667(), gymId);
        UUID uUID6 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID6, (String)"getUUID(...)");
        String string3 = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        PlayerProfileManager.INSTANCE.recordGymAttempt(uUID6, string3, gymId);
        GymHUD.INSTANCE.updateHUD(gymId);
        player.method_43496((class_2561)class_2561.method_43470((String)("Vous entrez dans l'" + gymData.getGymName() + "!")).method_27694(GymManager::startGymChallenge$lambda$8));
        if (hasBadge) {
            player.method_43496((class_2561)class_2561.method_43470((String)("(Vous possedez deja le " + gymData.getBadgeName() + ")")).method_27694(GymManager::startGymChallenge$lambda$9));
        }
        class_5250 class_52502 = class_2561.method_43470((String)"[Arene] ").method_27694(GymManager::startGymChallenge$lambda$10).method_10852((class_2561)class_2561.method_43470((String)(player.method_5477().getString() + " defie l'" + gymData.getGymName() + "!")).method_27694(GymManager::startGymChallenge$lambda$11));
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"append(...)");
        this.broadcastMessage((class_2561)class_52502);
        this.startPhase(player, 1);
        return true;
    }

    public final void startPhase(@NotNull class_3222 player, int phase) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        GymSession gymSession = this.getPlayerSession(uUID);
        if (gymSession == null) {
            return;
        }
        GymSession session = gymSession;
        if (!Intrinsics.areEqual((Object)session.getPlayerId(), (Object)player.method_5667())) {
            return;
        }
        session.setCurrentPhase(phase);
        TrainerData trainerData = session.getCurrentTrainer();
        if (trainerData == null) {
            return;
        }
        TrainerData trainerData2 = trainerData;
        this.teleportToPosition(player, session.getGymData().getPlayerSpawnPosition());
        String phaseType = phase <= 3 ? "Dresseur" : "Champion";
        player.method_43496((class_2561)class_2561.method_43470((String)("=== " + phaseType + " " + (phase <= 3 ? Integer.valueOf(phase) : "") + ": " + trainerData2.getName() + " ===")).method_27694(GymManager::startPhase$lambda$0));
        if (phase == 4 && !session.getHealedBeforeChampion()) {
            Cobblemon.INSTANCE.getStorage().getParty(player).heal();
            session.setHealedBeforeChampion(true);
            player.method_43496((class_2561)class_2561.method_43470((String)"Votre equipe a ete soignee avant le combat du Champion!").method_27694(GymManager::startPhase$lambda$1));
        }
        GymHUD.INSTANCE.updateHUD(session.getGymId());
        String gymId = session.getGymId();
        SchedulingFunctionsKt.afterOnServer((float)2.0f, () -> GymManager.startPhase$lambda$2(gymId, player, trainerData2));
    }

    /*
     * WARNING - void declaration
     */
    private final void createTrainerAndStartBattle(class_3222 player, TrainerData trainerData) {
        class_2960 skinId;
        NPCClass npcClass;
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        GymSession gymSession = this.getPlayerSession(uUID);
        if (gymSession == null) {
            return;
        }
        GymSession session = gymSession;
        session.setInBattle(true);
        class_3218 world = player.method_51469();
        Position npcPos = session.getGymData().getNpcSpawnPosition();
        Intrinsics.checkNotNull((Object)world);
        NPCEntity npc = new NPCEntity((class_1937)world);
        class_2960 class_29602 = class_2960.method_12829((String)trainerData.getNpcSkin());
        if (class_29602 == null) {
            class_29602 = MiscUtilsKt.cobblemonResource((String)"standard");
        }
        if ((npcClass = NPCClasses.getByIdentifier((class_2960)(skinId = class_29602))) != null) {
            npc.setNpc(npcClass);
        } else {
            NPCClass fallbackClass = NPCClasses.getByIdentifier((class_2960)MiscUtilsKt.cobblemonResource((String)"standard"));
            if (fallbackClass != null) {
                npc.setNpc(fallbackClass);
            }
        }
        npc.method_5808(npcPos.getX(), npcPos.getY(), npcPos.getZ(), npcPos.getYaw(), npcPos.getPitch());
        npc.method_5665((class_2561)class_2561.method_43470((String)(trainerData.getTitle() + " " + trainerData.getName())));
        npc.method_5880(true);
        npc.method_5648(false);
        npc.method_5875(false);
        npc.setInvulnerable(Boolean.valueOf(true));
        npc.setMovable(Boolean.valueOf(false));
        npc.method_5977(true);
        npc.method_5971();
        NPCPartyStore npcParty = new NPCPartyStore(npc);
        Iterable $this$forEachIndexed$iv = trainerData.getPokemon();
        boolean $i$f$forEachIndexed = false;
        int index$iv22 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void pokemonSpec;
            int n;
            if ((n = index$iv22++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            try {
                Pokemon pokemon = PokemonProperties.create$default((PokemonProperties)PokemonProperties.Companion.parse$default((PokemonProperties.Companion)PokemonProperties.Companion, (String)pokemonSpec, null, null, (int)6, null), null, (int)1, null);
                npcParty.set(index, pokemon);
            }
            catch (Exception e) {
                PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to create pokemon: " + (String)pokemonSpec, (Throwable)e);
            }
        }
        npc.setParty(npcParty);
        world.method_8649((class_1297)npc);
        ((Map)trainerNPCs).put(npc.method_5667(), TuplesKt.to((Object)npc, (Object)session.getGymId()));
        session.setCurrentTrainerNpcId(npc.method_5667());
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Trainer NPC spawned: " + trainerData.getName() + " with " + CollectionsKt.count((Iterable)((Iterable)npcParty)) + " pokemon");
        try {
            BattleActor[] $this$mapTo$iv$iv;
            void $this$map$iv;
            Pokemon it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Collection collection;
            Iterable $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Pokemon it2;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            Object item$iv;
            PlayerPartyStore playerParty = Cobblemon.INSTANCE.getStorage().getParty(player);
            Iterable index$iv22 = (Iterable)playerParty;
            boolean $i$f$filter = false;
            item$iv = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it2 = (Pokemon)element$iv$iv;
                boolean bl = false;
                if (!(!it2.isFainted())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo232 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                it2 = (Pokemon)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(BattlePokemon.Companion.playerOwned((Pokemon)it3));
            }
            List playerPokemonList = (List)destination$iv$iv;
            if (playerPokemonList.isEmpty()) {
                PokemonLeagueMod.INSTANCE.getLOGGER().error("Player has no usable pokemon!");
                session.setInBattle(false);
                npc.method_5650(class_1297.class_5529.field_26999);
                trainerNPCs.remove(npc.method_5667());
                return;
            }
            UUID uUID2 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            PlayerBattleActor playerActor = new PlayerBattleActor(uUID2, playerPokemonList);
            $this$mapTo$iv$iv2 = (Iterable)npcParty;
            boolean $i$f$mapNotNull = false;
            void $i$f$mapTo232 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean bl = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pokemon it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Pokemon it3 = (Pokemon)element$iv$iv;
                boolean bl22 = false;
                if (it3 == null) continue;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv2;
            boolean $i$f$filter2 = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            BattleActor[] destination$iv$iv3 = (BattleActor[])new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object t : $this$filterTo$iv$iv) {
                it = (Pokemon)t;
                boolean bl3 = false;
                if (!(!it.isFainted())) continue;
                destination$iv$iv3.add(t);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                it = (Pokemon)t;
                collection = destination$iv$iv3;
                boolean bl4 = false;
                collection.add(BattlePokemon.Companion.safeCopyOf(it));
            }
            List npcPokemonList = (List)destination$iv$iv3;
            if (npcPokemonList.isEmpty()) {
                PokemonLeagueMod.INSTANCE.getLOGGER().error("NPC has no usable pokemon!");
                session.setInBattle(false);
                npc.method_5650(class_1297.class_5529.field_26999);
                trainerNPCs.remove(npc.method_5667());
                return;
            }
            String string = trainerData.getName();
            class_1309 class_13092 = (class_1309)npc;
            UUID uUID3 = npc.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
            ChampionBattleActor npcActor = new ChampionBattleActor(string, class_13092, uUID3, npcPokemonList, trainerData.getSkill());
            $this$mapTo$iv$iv = new BattleActor[]{playerActor};
            BattleSide side1 = new BattleSide($this$mapTo$iv$iv);
            destination$iv$iv3 = new BattleActor[]{npcActor};
            BattleSide side2 = new BattleSide(destination$iv$iv3);
            BattleStartResult result = BattleRegistry.startBattle((BattleFormat)BattleFormat.Companion.getGEN_9_SINGLES(), (BattleSide)side1, (BattleSide)side2, (boolean)true);
            result.ifErrored(arg_0 -> GymManager.createTrainerAndStartBattle$lambda$6(session, npc, arg_0));
            result.ifSuccessful(arg_0 -> GymManager.createTrainerAndStartBattle$lambda$7(trainerData, arg_0));
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Exception starting gym battle", (Throwable)e);
            session.setInBattle(false);
            npc.method_5650(class_1297.class_5529.field_26999);
            trainerNPCs.remove(npc.method_5667());
        }
    }

    public final void handleVictory(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        GymSession gymSession = this.getPlayerSession(uUID);
        if (gymSession == null) {
            return;
        }
        GymSession session = gymSession;
        if (!Intrinsics.areEqual((Object)session.getPlayerId(), (Object)player.method_5667())) {
            return;
        }
        session.setInBattle(false);
        int phase = session.getCurrentPhase();
        String gymId = session.getGymId();
        this.cleanupTrainerNPCsForGym(gymId);
        this.recallAllPokemon(player);
        if (phase < 4) {
            player.method_43496((class_2561)class_2561.method_43470((String)("Dresseur " + phase + " vaincu!")).method_27694(GymManager::handleVictory$lambda$0));
            if (phase == 3) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Preparez-vous a affronter le Champion!").method_27694(GymManager::handleVictory$lambda$1));
            }
            SchedulingFunctionsKt.afterOnServer((float)3.0f, () -> GymManager.handleVictory$lambda$2(gymId, player, phase));
        } else {
            this.handleChampionVictory(player);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleChampionVictory(class_3222 player) {
        Collection<com.music176.pokemonleague.config.ItemReward> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        GymSession gymSession = this.getPlayerSession(uUID);
        if (gymSession == null) {
            return;
        }
        GymSession session = gymSession;
        GymData gymData = session.getGymData();
        String gymId = session.getGymId();
        long elapsedTime = session.getElapsedTimeMs();
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        String string = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        PlayerProfileManager.INSTANCE.recordGymSuccess(uUID2, string, gymData.getGymId(), elapsedTime);
        UUID uUID3 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
        String string2 = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        boolean badgeAwarded = PlayerProfileManager.INSTANCE.awardBadge(uUID3, string2, gymData.getBadgeId());
        if (badgeAwarded) {
            FTBQuestsIntegration.INSTANCE.completeBadgeQuest(player, gymData.getBadgeId());
        }
        int moneyReward = EconomyManager.INSTANCE.giveGymVictoryReward(player, gymData.getGymNumber());
        UUID uUID4 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID4, (String)"getUUID(...)");
        String string3 = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        PlayerProfileManager.INSTANCE.recordCreditsEarned(uUID4, string3, moneyReward);
        if (badgeAwarded) {
            UUID uUID5 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID5, (String)"getUUID(...)");
            if (PlayerProfileManager.INSTANCE.canAccessLeague(uUID5)) {
                int bonus = EconomyManager.INSTANCE.giveAllBadgesBonus(player);
                UUID uUID6 = player.method_5667();
                Intrinsics.checkNotNullExpressionValue((Object)uUID6, (String)"getUUID(...)");
                String string4 = player.method_5477().getString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
                PlayerProfileManager.INSTANCE.recordCreditsEarned(uUID6, string4, bonus);
            }
        }
        Iterable bonus = gymData.getRewards().getItems();
        class_3222 class_32222 = player;
        RewardDispenser rewardDispenser = RewardDispenser.INSTANCE;
        boolean $i$f$map = false;
        void var11_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ItemReward itemReward = (ItemReward)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new com.music176.pokemonleague.config.ItemReward(it.getItem(), it.getCount()));
        }
        collection = (List)destination$iv$iv;
        rewardDispenser.giveItems(class_32222, (List<com.music176.pokemonleague.config.ItemReward>)collection);
        player.method_43496((class_2561)class_2561.method_43470((String)"=== VICTOIRE! ===").method_27694(GymManager::handleChampionVictory$lambda$1));
        player.method_43496((class_2561)class_2561.method_43470((String)("Vous avez vaincu " + gymData.getChampionName() + "!")).method_27694(GymManager::handleChampionVictory$lambda$2));
        if (badgeAwarded) {
            player.method_43496((class_2561)class_2561.method_43470((String)("Vous avez obtenu le " + gymData.getBadgeName() + "!")).method_27694(GymManager::handleChampionVictory$lambda$3));
        }
        player.method_43496((class_2561)class_2561.method_43470((String)("Temps: " + session.getFormattedElapsedTime())).method_27694(GymManager::handleChampionVictory$lambda$4));
        class_5250 class_52502 = class_2561.method_43470((String)"[Arene] ").method_27694(GymManager::handleChampionVictory$lambda$5).method_10852((class_2561)class_2561.method_43470((String)(player.method_5477().getString() + " a vaincu " + gymData.getChampionName() + " et obtenu le " + gymData.getBadgeName() + "!")).method_27694(GymManager::handleChampionVictory$lambda$6));
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"append(...)");
        this.broadcastMessage((class_2561)class_52502);
        GymHUD.INSTANCE.updateHUD(gymData.getGymId());
        this.spawnFireworks(player);
        player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15195, class_3419.field_15248, 1.0f, 1.0f);
        Position lobbyPos = gymData.getLobbyPosition();
        SchedulingFunctionsKt.afterOnServer((float)5.0f, () -> GymManager.handleChampionVictory$lambda$7(player, lobbyPos, gymId));
    }

    public final void handleDefeat(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        GymSession gymSession = this.getPlayerSession(uUID);
        if (gymSession == null) {
            return;
        }
        GymSession session = gymSession;
        if (!Intrinsics.areEqual((Object)session.getPlayerId(), (Object)player.method_5667())) {
            return;
        }
        session.setInBattle(false);
        int phase = session.getCurrentPhase();
        String gymId = session.getGymId();
        Position lobbyPos = session.getGymData().getLobbyPosition();
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        String string = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        PlayerProfileManager.INSTANCE.recordGymFailure(uUID2, string, session.getGymId(), phase);
        GymHUD.INSTANCE.updateHUD(session.getGymId());
        this.cleanupTrainerNPCsForGym(gymId);
        String defeatedBy = phase <= 3 ? "le Dresseur " + phase : "le Champion " + session.getGymData().getChampionName();
        player.method_43496((class_2561)class_2561.method_43470((String)("Defaite contre " + defeatedBy + "!")).method_27694(GymManager::handleDefeat$lambda$0));
        player.method_43496((class_2561)class_2561.method_43470((String)("Vous avez atteint la phase " + phase + "/4")).method_27694(GymManager::handleDefeat$lambda$1));
        this.teleportToPosition(player, lobbyPos);
        UUID uUID3 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
        this.clearSession(gymId, uUID3);
    }

    public final void quitSession(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        GymSession gymSession = this.getPlayerSession(uUID);
        if (gymSession == null) {
            return;
        }
        GymSession session = gymSession;
        if (!Intrinsics.areEqual((Object)session.getPlayerId(), (Object)player.method_5667())) {
            return;
        }
        String gymId = session.getGymId();
        Position lobbyPos = session.getGymData().getLobbyPosition();
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        String string = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        PlayerProfileManager.INSTANCE.recordGymFailure(uUID2, string, session.getGymId(), session.getCurrentPhase());
        GymHUD.INSTANCE.updateHUD(session.getGymId());
        this.endPlayerBattle(player);
        this.cleanupTrainerNPCsForGym(gymId);
        player.method_43496((class_2561)class_2561.method_43470((String)"Vous avez abandonne le defi de l'arene.").method_27694(GymManager::quitSession$lambda$0));
        this.teleportToPosition(player, lobbyPos);
        UUID uUID3 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
        this.clearSession(gymId, uUID3);
    }

    public final void handlePlayerDisconnect(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        GymSession gymSession = this.getPlayerSession(uUID);
        if (gymSession == null) {
            return;
        }
        GymSession session = gymSession;
        if (!Intrinsics.areEqual((Object)session.getPlayerId(), (Object)player.method_5667())) {
            return;
        }
        String gymId = session.getGymId();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Player " + player.method_5477().getString() + " disconnected during gym challenge");
        this.endPlayerBattle(player);
        this.cleanupTrainerNPCsForGym(gymId);
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        this.clearSession(gymId, uUID2);
    }

    private final void clearSession(String gymId, UUID playerId) {
        activeSessions.remove(gymId);
        playerToGym.remove(playerId);
        GymHUD.INSTANCE.updateHUD(gymId);
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanupTrainerNPCsForGym(String gymId) {
        void $this$filterTo$iv$iv;
        Set<Map.Entry<UUID, Pair<NPCEntity, String>>> set = trainerNPCs.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            Pair value = (Pair)v;
            if (!Intrinsics.areEqual((Object)value.getSecond(), (Object)gymId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toRemove = (List)destination$iv$iv;
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            UUID npcId = (UUID)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            Pair npcPair = (Pair)v;
            try {
                ((NPCEntity)npcPair.getFirst()).method_5650(class_1297.class_5529.field_26999);
            }
            catch (Exception e) {
                PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to remove trainer NPC", (Throwable)e);
            }
            trainerNPCs.remove(npcId);
        }
    }

    private final void endPlayerBattle(class_3222 player) {
        try {
            PokemonBattle battle = BattleRegistry.getBattleByParticipatingPlayer((class_3222)player);
            if (battle != null) {
                PokemonLeagueMod.INSTANCE.getLOGGER().info("Ending active battle for player " + player.method_5477().getString());
                battle.end();
            }
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to end battle for player " + player.method_5477().getString(), (Throwable)e);
        }
    }

    private final void recallAllPokemon(class_3222 player) {
        try {
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            Iterable $this$forEach$iv = (Iterable)party;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pokemon pokemon = (Pokemon)element$iv;
                boolean bl = false;
                Object object = pokemon.getEntity();
                if (object != null) {
                    PokemonEntity entity = object;
                    boolean bl2 = false;
                    PokemonLeagueMod.INSTANCE.getLOGGER().info("Recalling Pokemon: " + pokemon.getSpecies().getName());
                    CompletableFuture completableFuture = entity.recallWithAnimation();
                    object = completableFuture;
                    if (completableFuture != null) continue;
                }
                GymManager $this$recallAllPokemon_u24lambda_u240_u241 = INSTANCE;
                boolean bl3 = false;
                pokemon.recall();
                object = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to recall Pokemon for player " + player.method_5477().getString(), (Throwable)e);
        }
    }

    private final void teleportToPosition(class_3222 player, Position position) {
        Object object;
        block6: {
            block5: {
                Object v1;
                block4: {
                    class_2960 worldKey = class_2960.method_12829((String)position.getWorld());
                    object = server;
                    if (object == null || (object = object.method_29435()) == null) break block5;
                    Iterable iterable = (Iterable)object;
                    for (Object t : iterable) {
                        class_5321 it = (class_5321)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.method_29177(), (Object)worldKey)) continue;
                        v1 = t;
                        break block4;
                    }
                    v1 = null;
                }
                if ((object = (class_5321)v1) == null) break block5;
                Object it = object;
                boolean bl = false;
                MinecraftServer minecraftServer = server;
                Object object2 = minecraftServer != null ? minecraftServer.method_3847((class_5321)it) : null;
                object = object2;
                if (object2 != null) break block6;
            }
            object = player.method_51469();
        }
        Object level = object;
        player.method_14251((class_3218)level, position.getX(), position.getY(), position.getZ(), position.getYaw(), position.getPitch());
    }

    private final void spawnFireworks(class_3222 player) {
        class_3218 world = player.method_51469();
        class_243 pos = player.method_19538();
        for (int i = 0; i < 21; ++i) {
            world.method_14199((class_2394)class_2398.field_11248, pos.field_1352 + (Math.random() - 0.5) * (double)5, pos.field_1351 + Math.random() * (double)3, pos.field_1350 + (Math.random() - 0.5) * (double)5, 10, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private final void broadcastMessage(class_2561 message) {
        block1: {
            Object object = server;
            if (object == null || (object = object.method_3760()) == null || (object = object.method_14571()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3222 player = (class_3222)element$iv;
                boolean bl = false;
                player.method_43496(message);
            }
        }
    }

    public final boolean setPlayerSpawnPosition(@NotNull String gymId, @NotNull Position position) {
        int gymIndex;
        block3: {
            int n;
            Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            List<GymData> $this$indexOfFirst$iv = this.getGymConfig().getGyms();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<GymData> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                GymData item$iv;
                GymData it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getGymId(), (Object)gymId)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = gymIndex = -1;
        }
        if (gymIndex < 0) {
            return false;
        }
        List updatedGyms = CollectionsKt.toMutableList((Collection)this.getGymConfig().getGyms());
        updatedGyms.set(gymIndex, GymData.copy$default((GymData)updatedGyms.get(gymIndex), null, 0, null, null, null, null, null, 0, null, position, null, null, null, null, null, null, 65023, null));
        gymConfig = this.getGymConfig().copy(updatedGyms);
        GymConfig.Companion.save(this.getGymConfig());
        return true;
    }

    public final boolean setNpcSpawnPosition(@NotNull String gymId, @NotNull Position position) {
        int gymIndex;
        block3: {
            int n;
            Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            List<GymData> $this$indexOfFirst$iv = this.getGymConfig().getGyms();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<GymData> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                GymData item$iv;
                GymData it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getGymId(), (Object)gymId)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = gymIndex = -1;
        }
        if (gymIndex < 0) {
            return false;
        }
        List updatedGyms = CollectionsKt.toMutableList((Collection)this.getGymConfig().getGyms());
        updatedGyms.set(gymIndex, GymData.copy$default((GymData)updatedGyms.get(gymIndex), null, 0, null, null, null, null, null, 0, null, null, position, null, null, null, null, null, 64511, null));
        gymConfig = this.getGymConfig().copy(updatedGyms);
        GymConfig.Companion.save(this.getGymConfig());
        return true;
    }

    public final boolean setLobbyPosition(@NotNull String gymId, @NotNull Position position) {
        int gymIndex;
        block3: {
            int n;
            Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            List<GymData> $this$indexOfFirst$iv = this.getGymConfig().getGyms();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<GymData> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                GymData item$iv;
                GymData it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getGymId(), (Object)gymId)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = gymIndex = -1;
        }
        if (gymIndex < 0) {
            return false;
        }
        List updatedGyms = CollectionsKt.toMutableList((Collection)this.getGymConfig().getGyms());
        updatedGyms.set(gymIndex, GymData.copy$default((GymData)updatedGyms.get(gymIndex), null, 0, null, null, null, null, null, 0, null, null, null, position, null, null, null, null, 63487, null));
        gymConfig = this.getGymConfig().copy(updatedGyms);
        GymConfig.Companion.save(this.getGymConfig());
        return true;
    }

    public final boolean setHudPosition(@NotNull String gymId, @NotNull Position position) {
        int gymIndex;
        block3: {
            int n;
            Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            List<GymData> $this$indexOfFirst$iv = this.getGymConfig().getGyms();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<GymData> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                GymData item$iv;
                GymData it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getGymId(), (Object)gymId)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = gymIndex = -1;
        }
        if (gymIndex < 0) {
            return false;
        }
        List updatedGyms = CollectionsKt.toMutableList((Collection)this.getGymConfig().getGyms());
        updatedGyms.set(gymIndex, GymData.copy$default((GymData)updatedGyms.get(gymIndex), null, 0, null, null, null, null, null, 0, null, null, null, null, position, null, null, null, 61439, null));
        gymConfig = this.getGymConfig().copy(updatedGyms);
        GymConfig.Companion.save(this.getGymConfig());
        GymHUD.INSTANCE.spawnHUD(gymId, position);
        return true;
    }

    public final boolean removeHud(@NotNull String gymId) {
        int gymIndex;
        block3: {
            int n;
            Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
            List<GymData> $this$indexOfFirst$iv = this.getGymConfig().getGyms();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<GymData> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                GymData item$iv;
                GymData it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getGymId(), (Object)gymId)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = gymIndex = -1;
        }
        if (gymIndex < 0) {
            return false;
        }
        List updatedGyms = CollectionsKt.toMutableList((Collection)this.getGymConfig().getGyms());
        updatedGyms.set(gymIndex, GymData.copy$default((GymData)updatedGyms.get(gymIndex), null, 0, null, null, null, null, null, 0, null, null, null, null, null, null, null, null, 61439, null));
        gymConfig = this.getGymConfig().copy(updatedGyms);
        GymConfig.Companion.save(this.getGymConfig());
        GymHUD.INSTANCE.removeHUD(gymId);
        return true;
    }

    private static final class_2583 startGymChallenge$lambda$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 startGymChallenge$lambda$1(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 startGymChallenge$lambda$2(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 startGymChallenge$lambda$3(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 startGymChallenge$lambda$4(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 startGymChallenge$lambda$6(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 startGymChallenge$lambda$7(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 startGymChallenge$lambda$8(class_2583 it) {
        return it.method_36139(0x55FF55).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 startGymChallenge$lambda$9(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2583 startGymChallenge$lambda$10(class_2583 it) {
        return it.method_36139(0xFFAA00);
    }

    private static final class_2583 startGymChallenge$lambda$11(class_2583 it) {
        return it.method_36139(0xFFFFFF);
    }

    private static final class_2583 startPhase$lambda$0(class_2583 it) {
        return it.method_36139(0xFFAA00).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 startPhase$lambda$1(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final Unit startPhase$lambda$2(String $gymId, class_3222 $player, TrainerData $trainerData) {
        GymSession gymSession = activeSessions.get($gymId);
        if (Intrinsics.areEqual((Object)(gymSession != null ? gymSession.getPlayerId() : null), (Object)$player.method_5667())) {
            INSTANCE.createTrainerAndStartBattle($player, $trainerData);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createTrainerAndStartBattle$lambda$6(GymSession $session, NPCEntity $npc, ErroredBattleStart error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to start gym battle: " + CollectionsKt.joinToString$default((Iterable)error.getErrors(), null, null, null, (int)0, null, null, (int)63, null));
        $session.setInBattle(false);
        $npc.method_5650(class_1297.class_5529.field_26999);
        trainerNPCs.remove($npc.method_5667());
        return Unit.INSTANCE;
    }

    private static final Unit createTrainerAndStartBattle$lambda$7(TrainerData $trainerData, PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Gym battle started against " + $trainerData.getName());
        return Unit.INSTANCE;
    }

    private static final class_2583 handleVictory$lambda$0(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final class_2583 handleVictory$lambda$1(class_2583 it) {
        return it.method_36139(0xFFAA00).method_10982(Boolean.valueOf(true));
    }

    private static final Unit handleVictory$lambda$2(String $gymId, class_3222 $player, int $phase) {
        GymSession gymSession = activeSessions.get($gymId);
        if (Intrinsics.areEqual((Object)(gymSession != null ? gymSession.getPlayerId() : null), (Object)$player.method_5667())) {
            INSTANCE.startPhase($player, $phase + 1);
        }
        return Unit.INSTANCE;
    }

    private static final class_2583 handleChampionVictory$lambda$1(class_2583 it) {
        return it.method_36139(16766720).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 handleChampionVictory$lambda$2(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final class_2583 handleChampionVictory$lambda$3(class_2583 it) {
        return it.method_36139(0x55FFFF).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 handleChampionVictory$lambda$4(class_2583 it) {
        return it.method_36139(0xAAAAAA);
    }

    private static final class_2583 handleChampionVictory$lambda$5(class_2583 it) {
        return it.method_36139(0xFFAA00);
    }

    private static final class_2583 handleChampionVictory$lambda$6(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final Unit handleChampionVictory$lambda$7(class_3222 $player, Position $lobbyPos, String $gymId) {
        INSTANCE.teleportToPosition($player, $lobbyPos);
        UUID uUID = $player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        INSTANCE.clearSession($gymId, uUID);
        return Unit.INSTANCE;
    }

    private static final class_2583 handleDefeat$lambda$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 handleDefeat$lambda$1(class_2583 it) {
        return it.method_36139(0xAAAAAA);
    }

    private static final class_2583 quitSession$lambda$0(class_2583 it) {
        return it.method_36139(0xFFAA00);
    }

    static {
        activeSessions = new ConcurrentHashMap();
        playerToGym = new ConcurrentHashMap();
        trainerNPCs = new ConcurrentHashMap();
    }
}

