/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.gym;

import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.config.Position;
import com.music176.pokemonleague.gym.GymData;
import com.music176.pokemonleague.gym.GymManager;
import com.music176.pokemonleague.gym.GymSession;
import com.music176.pokemonleague.profile.GymStats;
import com.music176.pokemonleague.profile.PlayerProfile;
import com.music176.pokemonleague.profile.PlayerProfileManager;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_8113;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003J\u001d\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0012\u0010\u0011J\r\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0013\u0010\u0003J\u001f\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0018\u0010\bJ'\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0019\u0010\u001e\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR \u0010!\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00140 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010#R)\u0010+\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$8BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b&\u0010'\u0012\u0004\b*\u0010\u0003\u001a\u0004\b(\u0010)R\u0014\u0010,\u001a\u00020\n8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lcom/music176/pokemonleague/gym/GymHUD;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "initialize", "(Lnet/minecraft/server/MinecraftServer;)V", "shutdown", "", "gymId", "Lcom/music176/pokemonleague/config/Position;", "position", "spawnHUD", "(Ljava/lang/String;Lcom/music176/pokemonleague/config/Position;)V", "removeHUD", "(Ljava/lang/String;)V", "updateHUD", "updateAllHUDs", "Lnet/minecraft/class_8113$class_8123;", "display", "updateText", "(Ljava/lang/String;Lnet/minecraft/class_8113$class_8123;)V", "cleanupAllTaggedDisplays", "Lnet/minecraft/class_3218;", "level", "cleanupOrphanedDisplays", "(Lnet/minecraft/class_3218;Lcom/music176/pokemonleague/config/Position;Ljava/lang/String;)V", "worldId", "getLevel", "(Ljava/lang/String;)Lnet/minecraft/class_3218;", "Ljava/util/concurrent/ConcurrentHashMap;", "hudEntities", "Ljava/util/concurrent/ConcurrentHashMap;", "Lnet/minecraft/server/MinecraftServer;", "Lnet/minecraft/class_2940;", "", "DATA_LINE_WIDTH$delegate", "Lkotlin/Lazy;", "getDATA_LINE_WIDTH", "()Lnet/minecraft/class_2940;", "getDATA_LINE_WIDTH$annotations", "DATA_LINE_WIDTH", "HUD_TAG_PREFIX", "Ljava/lang/String;", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nGymHUD.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GymHUD.kt\ncom/music176/pokemonleague/gym/GymHUD\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,279:1\n1869#2,2:280\n1869#2,2:282\n1878#2,3:287\n1617#2,9:290\n1869#2:299\n1870#2:301\n1626#2:302\n1761#2,3:303\n1869#2,2:306\n1869#2,2:308\n1617#2,9:313\n1869#2:322\n1870#2:324\n1626#2:325\n216#3,2:284\n1#4:286\n1#4:300\n1#4:323\n3919#5:310\n4434#5,2:311\n*S KotlinDebug\n*F\n+ 1 GymHUD.kt\ncom/music176/pokemonleague/gym/GymHUD\n*L\n54#1:280,2\n64#1:282,2\n180#1:287,3\n212#1:290,9\n212#1:299\n212#1:301\n212#1:302\n230#1:303,3\n237#1:306,2\n268#1:308,2\n32#1:313,9\n32#1:322\n32#1:324\n32#1:325\n138#1:284,2\n212#1:300\n32#1:323\n31#1:310\n31#1:311,2\n*E\n"})
public final class GymHUD {
    @NotNull
    public static final GymHUD INSTANCE = new GymHUD();
    @NotNull
    private static final ConcurrentHashMap<String, class_8113.class_8123> hudEntities = new ConcurrentHashMap();
    @Nullable
    private static MinecraftServer server;
    @NotNull
    private static final Lazy DATA_LINE_WIDTH$delegate;
    @NotNull
    private static final String HUD_TAG_PREFIX = "pokemonleague_gymhud_";

    private GymHUD() {
    }

    private final class_2940<Integer> getDATA_LINE_WIDTH() {
        Lazy lazy = DATA_LINE_WIDTH$delegate;
        return (class_2940)lazy.getValue();
    }

    private static /* synthetic */ void getDATA_LINE_WIDTH$annotations() {
    }

    public final void initialize(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        GymHUD.server = server;
        this.cleanupAllTaggedDisplays(server);
        Iterable $this$forEach$iv = GymManager.INSTANCE.getGymConfig().getGyms();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Position position;
            GymData gymData = (GymData)element$iv;
            boolean bl = false;
            if (gymData.getHudPosition() == null) continue;
            boolean bl2 = false;
            INSTANCE.spawnHUD(gymData.getGymId(), position);
        }
        PokemonLeagueMod.INSTANCE.getLOGGER().info("GymHUD initialized with " + hudEntities.size() + " HUDs");
    }

    public final void shutdown() {
        Collection<class_8113.class_8123> collection = hudEntities.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_8113.class_8123 entity = (class_8113.class_8123)element$iv;
            boolean bl = false;
            entity.method_5650(class_1297.class_5529.field_26999);
        }
        hudEntities.clear();
        server = null;
    }

    public final void spawnHUD(@NotNull String gymId, @NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.removeHUD(gymId);
        class_3218 class_32182 = this.getLevel(position.getWorld());
        if (class_32182 == null) {
            GymHUD $this$spawnHUD_u24lambda_u240 = this;
            boolean bl = false;
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to spawn gym HUD: world " + position.getWorld() + " not found");
            return;
        }
        class_3218 level = class_32182;
        int chunkX = (int)position.getX() >> 4;
        int chunkZ = (int)position.getZ() >> 4;
        level.method_8497(chunkX, chunkZ);
        this.cleanupOrphanedDisplays(level, position, gymId);
        class_8113.class_8123 textDisplay = new class_8113.class_8123(class_1299.field_42457, (class_1937)level);
        textDisplay.method_5808(position.getX(), position.getY(), position.getZ(), position.getYaw(), position.getPitch());
        textDisplay.method_5780(HUD_TAG_PREFIX + gymId);
        textDisplay.method_48847(class_8113.class_8114.field_42409);
        class_2940<Integer> class_29402 = this.getDATA_LINE_WIDTH();
        if (class_29402 != null) {
            class_2940<Integer> accessor = class_29402;
            boolean bl = false;
            textDisplay.method_5841().method_12778(accessor, (Object)400);
        }
        this.updateText(gymId, textDisplay);
        level.method_8649((class_1297)textDisplay);
        ((Map)hudEntities).put(gymId, textDisplay);
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Gym HUD spawned for '" + gymId + "' at " + position.getX() + ", " + position.getY() + ", " + position.getZ());
    }

    public final void removeHUD(@NotNull String gymId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
            class_8113.class_8123 class_81232 = hudEntities.remove(gymId);
            if (class_81232 == null) break block0;
            class_8113.class_8123 entity = class_81232;
            boolean bl = false;
            entity.method_5650(class_1297.class_5529.field_26999);
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Gym HUD removed for '" + gymId + "'");
        }
    }

    public final void updateHUD(@NotNull String gymId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)gymId, (String)"gymId");
            class_8113.class_8123 class_81232 = hudEntities.get(gymId);
            if (class_81232 == null) break block0;
            class_8113.class_8123 display = class_81232;
            boolean bl = false;
            INSTANCE.updateText(gymId, display);
        }
    }

    public final void updateAllHUDs() {
        Map $this$forEach$iv = hudEntities;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String gymId = (String)entry.getKey();
            class_8113.class_8123 display = (class_8113.class_8123)entry.getValue();
            INSTANCE.updateText(gymId, display);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateText(String gymId, class_8113.class_8123 display) {
        String string;
        GymData gymData = GymManager.INSTANCE.getGymConfig().getGym(gymId);
        if (gymData == null) {
            return;
        }
        GymData gymData2 = gymData;
        GymSession session = GymManager.INSTANCE.getActiveSessionForGym(gymId);
        List<Pair<PlayerProfile, GymStats>> topSpeedPlayers = PlayerProfileManager.INSTANCE.getTopPlayersBySpeed(gymId, 3);
        List lines = new ArrayList();
        String string2 = gymData2.getGymName().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        lines.add("\u00a76\u00a7l=== " + string2 + " ===");
        List list = lines;
        String string3 = gymData2.getType();
        if (((CharSequence)string3).length() > 0) {
            void it22;
            char c = string3.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            List list2 = list;
            int n = 0;
            String string4 = String.valueOf((char)it22);
            Intrinsics.checkNotNull((Object)string4, (String)"null cannot be cast to non-null type java.lang.String");
            String string5 = string4.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
            CharSequence charSequence = string5;
            list = list2;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence);
            String it22 = string3;
            n = 1;
            String string6 = it22.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            string = stringBuilder2.append(string6).toString();
        } else {
            string = string3;
        }
        list.add("\u00a77Type: \u00a7e" + string);
        lines.add("");
        lines.add("\u00a7d\u00a7lChampion: \u00a7f" + gymData2.getChampionName());
        lines.add("\u00a77Badge: \u00a7b" + gymData2.getBadgeName());
        lines.add("");
        lines.add("\u00a7e\u00a7lDefi en cours:");
        if (session != null) {
            Object phaseText = switch (session.getCurrentPhase()) {
                case 1, 2, 3 -> "Dresseur " + session.getCurrentPhase() + "/3";
                case 4 -> "Champion";
                default -> "Phase " + session.getCurrentPhase();
            };
            lines.add("\u00a7a" + session.getPlayerName());
            v9 = lines.add("\u00a77(" + (String)phaseText + ")");
        } else {
            v9 = lines.add("\u00a77Aucun - Arene libre");
        }
        lines.add("");
        lines.add("\u00a7e\u00a7lRecords de vitesse:");
        if (topSpeedPlayers.isEmpty()) {
            lines.add("\u00a77Aucun record");
        } else {
            Iterable $this$forEachIndexed$iv = topSpeedPlayers;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int index = n;
                boolean bl = false;
                PlayerProfile profile = (PlayerProfile)pair.component1();
                GymStats stats = (GymStats)pair.component2();
                String medal = switch (index) {
                    case 0 -> "\u00a76\u00a7l\u2b50 #1";
                    case 1 -> "\u00a7f#2";
                    case 2 -> "\u00a77#3";
                    default -> "\u00a77#" + (index + 1);
                };
                Long l = stats.getFastestTime();
                Intrinsics.checkNotNull((Object)l);
                long time = l;
                long minutes = time / (long)60000;
                long seconds = time % (long)60000 / (long)1000;
                lines.add(medal + " \u00a7f" + profile.getPlayerName() + " \u00a7a" + minutes + "m" + seconds + "s");
            }
        }
        String text = CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        display.method_48911((class_2561)class_2561.method_43470((String)text));
    }

    private final void cleanupAllTaggedDisplays(MinecraftServer server) {
        Iterator $this$mapNotNullTo$iv$iv;
        int totalRemoved = 0;
        Iterable $this$mapNotNull$iv = GymManager.INSTANCE.getGymConfig().getGyms();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GymData gymData = (GymData)element$iv$iv;
            boolean bl2 = false;
            if (gymData.getHudPosition() != null) {
                Position pos;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)pos, (Object)gymData.getGymId());
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List hudPositions = (List)destination$iv$iv;
        for (class_3218 level : server.method_3738()) {
            $this$mapNotNullTo$iv$iv = hudPositions.iterator();
            while ($this$mapNotNullTo$iv$iv.hasNext()) {
                String levelKey;
                Position position = (Position)((Pair)$this$mapNotNullTo$iv$iv.next()).component1();
                Intrinsics.checkNotNullExpressionValue((Object)level.method_27983().method_29177().toString(), (String)"toString(...)");
                if (!Intrinsics.areEqual((Object)levelKey, (Object)position.getWorld())) continue;
                int chunkX = (int)position.getX() >> 4;
                int chunkZ = (int)position.getZ() >> 4;
                level.method_8497(chunkX, chunkZ);
            }
            List toRemove = new ArrayList();
            for (class_1297 entity : level.method_27909()) {
                boolean bl;
                block11: {
                    if (!(entity instanceof class_8113.class_8123)) continue;
                    Set set = ((class_8113.class_8123)entity).method_5752();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTags(...)");
                    Iterable $this$any$iv = set;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl5 = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!StringsKt.startsWith$default((String)it, (String)HUD_TAG_PREFIX, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                toRemove.add(entity);
            }
            if (!(!((Collection)toRemove).isEmpty())) continue;
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Removing " + toRemove.size() + " tagged gym HUD entities from " + level.method_27983().method_29177());
            Iterable $this$forEach$iv = toRemove;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                class_1297 it = (class_1297)element$iv;
                boolean bl = false;
                it.method_5650(class_1297.class_5529.field_26999);
            }
            totalRemoved += toRemove.size();
        }
        if (totalRemoved > 0) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Global cleanup: removed " + totalRemoved + " orphaned gym HUD entities total");
        }
    }

    private final void cleanupOrphanedDisplays(class_3218 level, Position position, String gymId) {
        double searchRadius = 5.0;
        class_238 area = new class_238(position.getX() - searchRadius, position.getY() - searchRadius, position.getZ() - searchRadius, position.getX() + searchRadius, position.getY() + searchRadius, position.getZ() + searchRadius);
        List orphanedEntities = level.method_8333(null, area, arg_0 -> GymHUD.cleanupOrphanedDisplays$lambda$1(arg_0 -> GymHUD.cleanupOrphanedDisplays$lambda$0(gymId, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)orphanedEntities);
        if (!((Collection)orphanedEntities).isEmpty()) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Cleaning up " + orphanedEntities.size() + " orphaned TextDisplay entities near " + position.getX() + ", " + position.getY() + ", " + position.getZ() + " for gym '" + gymId + "'");
            Iterable $this$forEach$iv = orphanedEntities;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_1297 entity = (class_1297)element$iv;
                boolean bl = false;
                entity.method_5650(class_1297.class_5529.field_26999);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final class_3218 getLevel(String worldId) {
        Object v4;
        Object object;
        block2: {
            class_2960 class_29602 = class_2960.method_12829((String)worldId);
            if (class_29602 == null) {
                return null;
            }
            class_2960 worldKey = class_29602;
            MinecraftServer minecraftServer = server;
            object = minecraftServer;
            if (minecraftServer == null) return null;
            Set set = object.method_29435();
            object = set;
            if (set == null) return null;
            Iterable iterable = (Iterable)object;
            for (Object t : iterable) {
                class_5321 it = (class_5321)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.method_29177(), (Object)worldKey)) continue;
                v4 = t;
                break block2;
            }
            v4 = null;
        }
        class_5321 class_53212 = v4;
        object = class_53212;
        if (class_53212 == null) return null;
        Object object2 = object;
        boolean bl = false;
        MinecraftServer minecraftServer = server;
        if (minecraftServer == null) return null;
        class_3218 class_32182 = minecraftServer.method_3847((class_5321)object2);
        return class_32182;
    }

    /*
     * WARNING - void declaration
     */
    private static final class_2940 DATA_LINE_WIDTH_delegate$lambda$0() {
        Object object;
        try {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Field[] fieldArray = class_8113.class_8123.class.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
            Object[] $this$filter$iv = fieldArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Field it = (Field)element$iv$iv;
                boolean bl = false;
                if (!(Modifier.isStatic(it.getModifiers()) && Modifier.isPrivate(it.getModifiers()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                class_2940 it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Field field = (Field)element$iv$iv;
                boolean bl2 = false;
                field.setAccessible(true);
                Object object2 = field.get(null);
                if ((object2 instanceof class_2940 ? (class_2940)object2 : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            object = CollectionsKt.firstOrNull((List)CollectionsKt.drop((Iterable)((List)destination$iv$iv), (int)1));
            object = object instanceof class_2940 ? (class_2940)object : null;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().warn("Could not find line width accessor, text may wrap incorrectly", (Throwable)e);
            object = null;
        }
        return object;
    }

    private static final boolean cleanupOrphanedDisplays$lambda$0(String $gymId, class_1297 entity) {
        return entity instanceof class_8113.class_8123 && entity != hudEntities.get($gymId);
    }

    private static final boolean cleanupOrphanedDisplays$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        DATA_LINE_WIDTH$delegate = LazyKt.lazy(GymHUD::DATA_LINE_WIDTH_delegate$lambda$0);
    }
}

