/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.economy;

import com.music176.pokemonleague.PokemonLeagueMod;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0019\u0010\u001b\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010 \u00a8\u0006\""}, d2={"Lcom/music176/pokemonleague/economy/ImpactorBridge;", "", "<init>", "()V", "", "initialize", "", "isAvailable", "()Z", "Lnet/minecraft/class_3222;", "player", "", "getBalance", "(Lnet/minecraft/class_3222;)I", "amount", "withdraw", "(Lnet/minecraft/class_3222;I)Z", "deposit", "Ljava/util/UUID;", "uuid", "getAccount", "(Ljava/util/UUID;)Ljava/lang/Object;", "account", "Ljava/math/BigDecimal;", "getBalanceFromAccount", "(Ljava/lang/Object;)Ljava/math/BigDecimal;", "result", "isTransactionSuccessful", "(Ljava/lang/Object;)Z", "economyAvailable", "Z", "economyService", "Ljava/lang/Object;", "primaryCurrency", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nImpactorBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImpactorBridge.kt\ncom/music176/pokemonleague/economy/ImpactorBridge\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n3919#2:241\n4434#2,2:242\n3919#2:244\n4434#2,2:245\n3919#2:247\n4434#2,2:248\n1#3:250\n*S KotlinDebug\n*F\n+ 1 ImpactorBridge.kt\ncom/music176/pokemonleague/economy/ImpactorBridge\n*L\n92#1:241\n92#1:242,2\n134#1:244\n134#1:245,2\n191#1:247\n191#1:248,2\n*E\n"})
public final class ImpactorBridge {
    @NotNull
    public static final ImpactorBridge INSTANCE = new ImpactorBridge();
    private static boolean economyAvailable;
    @Nullable
    private static Object economyService;
    @Nullable
    private static Object primaryCurrency;

    private ImpactorBridge() {
    }

    public final void initialize() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> impactorClass = Class.forName("net.impactdev.impactor.api.Impactor", true, classLoader);
            Object impactor = impactorClass.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
            Object services = impactorClass.getMethod("services", new Class[0]).invoke(impactor, new Object[0]);
            Class<?> economyServiceClass = Class.forName("net.impactdev.impactor.api.economy.EconomyService");
            Object[] objectArray = new Class[]{Class.class};
            Method method = services.getClass().getMethod("provide", (Class<?>[])objectArray);
            objectArray = new Object[]{economyServiceClass};
            Object object = economyService = method.invoke(services, objectArray);
            Intrinsics.checkNotNull((Object)object);
            Object currencies = object.getClass().getMethod("currencies", new Class[0]).invoke(economyService, new Object[0]);
            primaryCurrency = currencies.getClass().getMethod("primary", new Class[0]).invoke(currencies, new Object[0]);
            economyAvailable = true;
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Impactor Economy integration enabled");
        }
        catch (ClassNotFoundException e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Impactor not found, economy features disabled (free entry)");
            economyAvailable = false;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().warn("Failed to initialize Impactor integration: " + e.getMessage());
            economyAvailable = false;
        }
    }

    public final boolean isAvailable() {
        return economyAvailable;
    }

    public final int getBalance(@NotNull class_3222 player) {
        int n;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!economyAvailable || economyService == null) {
            return Integer.MAX_VALUE;
        }
        try {
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            Object object = this.getAccount(uUID);
            if (object == null) {
                return Integer.MAX_VALUE;
            }
            Object account = object;
            BigDecimal bigDecimal = this.getBalanceFromAccount(account);
            if (bigDecimal == null) {
                return Integer.MAX_VALUE;
            }
            BigDecimal balance = bigDecimal;
            n = balance.intValue();
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to get player balance: " + e.getMessage());
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean withdraw(@NotNull class_3222 player, int amount) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!economyAvailable || economyService == null) {
            return true;
        }
        try {
            void $this$filterTo$iv$iv;
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            Object object = this.getAccount(uUID);
            if (object == null) {
                return true;
            }
            Object account = object;
            BigDecimal bigDecimal = this.getBalanceFromAccount(account);
            if (bigDecimal == null) {
                return true;
            }
            BigDecimal balance = bigDecimal;
            if (balance.intValue() < amount) {
                return false;
            }
            BigDecimal withdrawAmount = new BigDecimal(amount);
            Method[] methodArray = account.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
            Object[] $this$filter$iv = methodArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Method it = (Method)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"withdraw")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List withdrawMethods = (List)destination$iv$iv;
            for (Method method : withdrawMethods) {
                try {
                    Object result;
                    Class<?>[] paramTypes = method.getParameterTypes();
                    if (paramTypes.length == 1 && Intrinsics.areEqual(paramTypes[0], BigDecimal.class)) {
                        Object[] objectArray2 = new Object[]{withdrawAmount};
                        result = method.invoke(account, objectArray2);
                        return this.isTransactionSuccessful(result);
                    }
                    if (paramTypes.length != 2) continue;
                    Object[] objectArray3 = new Object[]{primaryCurrency, withdrawAmount};
                    result = method.invoke(account, objectArray3);
                    return this.isTransactionSuccessful(result);
                }
                catch (Exception e) {
                }
            }
            PokemonLeagueMod.INSTANCE.getLOGGER().warn("Could not find compatible withdraw method");
            bl = true;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to withdraw from player account: " + e.getMessage());
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean deposit(@NotNull class_3222 player, int amount) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!economyAvailable || economyService == null) {
            return true;
        }
        try {
            void $this$filterTo$iv$iv;
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            Object object = this.getAccount(uUID);
            if (object == null) {
                return true;
            }
            Object account = object;
            BigDecimal depositAmount = new BigDecimal(amount);
            Method[] methodArray = account.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
            Object[] $this$filter$iv = methodArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Method it = (Method)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"deposit")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List depositMethods = (List)destination$iv$iv;
            for (Method method : depositMethods) {
                try {
                    Object result;
                    Class<?>[] paramTypes = method.getParameterTypes();
                    if (paramTypes.length == 1 && Intrinsics.areEqual(paramTypes[0], BigDecimal.class)) {
                        Object[] objectArray2 = new Object[]{depositAmount};
                        result = method.invoke(account, objectArray2);
                        return this.isTransactionSuccessful(result);
                    }
                    if (paramTypes.length != 2) continue;
                    Object[] objectArray3 = new Object[]{primaryCurrency, depositAmount};
                    result = method.invoke(account, objectArray3);
                    return this.isTransactionSuccessful(result);
                }
                catch (Exception e) {
                }
            }
            PokemonLeagueMod.INSTANCE.getLOGGER().warn("Could not find compatible deposit method");
            bl = true;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to deposit to player account: " + e.getMessage());
            bl = true;
        }
        return bl;
    }

    private final Object getAccount(UUID uuid) {
        Object var2_9;
        try {
            Object object;
            Object[] objectArray;
            Method accountMethod;
            Object object2;
            Object object3;
            block8: {
                Object object4 = economyService;
                Intrinsics.checkNotNull((Object)object4);
                Method[] methodArray = object4.getClass().getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
                for (Object object5 : (Object[])methodArray) {
                    Method it = (Method)object5;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"account") && it.getParameterTypes().length == 1)) continue;
                    object3 = object5;
                    break block8;
                }
                object3 = null;
            }
            if ((object2 = (accountMethod = (Method)object3)) == null || (object2 = ((Method)object2).invoke(economyService, objectArray = new Object[]{uuid})) == null) {
                return null;
            }
            Object result = object2;
            if (result instanceof CompletableFuture) {
                object = ((CompletableFuture)result).join();
            } else {
                String string = result.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Optional", (boolean)false, (int)2, null)) {
                    objectArray = new Class[]{Object.class};
                    Method orElse = result.getClass().getMethod("orElse", (Class<?>[])objectArray);
                    objectArray = new Object[]{null};
                    object = orElse.invoke(result, objectArray);
                } else {
                    object = result;
                }
            }
            var2_9 = object;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to get account: " + e.getMessage());
            var2_9 = null;
        }
        return var2_9;
    }

    /*
     * WARNING - void declaration
     */
    private final BigDecimal getBalanceFromAccount(Object account) {
        Object var2_20;
        try {
            void $this$filterTo$iv$iv;
            Method[] methodArray = account.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
            Object[] $this$filter$iv = methodArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Method it = (Method)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"balance")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List balanceMethods = (List)destination$iv$iv;
            for (Method method : balanceMethods) {
                try {
                    BigDecimal bigDecimal;
                    Method[] result;
                    Method[] methodArray2;
                    Class<?>[] paramTypes = method.getParameterTypes();
                    Intrinsics.checkNotNull(paramTypes);
                    if (paramTypes.length == 0) {
                        methodArray2 = method.invoke(account, new Object[0]);
                    } else {
                        if (paramTypes.length != 1 || primaryCurrency == null) continue;
                        Object[] objectArray2 = new Object[]{primaryCurrency};
                        methodArray2 = method.invoke(account, objectArray2);
                    }
                    Method[] methodArray3 = result = methodArray2;
                    if (methodArray3 instanceof BigDecimal) {
                        bigDecimal = (BigDecimal)result;
                    } else if (methodArray3 instanceof Number) {
                        bigDecimal = new BigDecimal(((Number)result).doubleValue());
                    } else {
                        Method toBigDecimal;
                        Method method2;
                        block15: {
                            Method[] methodArray4 = result;
                            if (result != null && (methodArray4 = methodArray4.getClass()) != null && (methodArray4 = methodArray4.getMethods()) != null) {
                                Method[] methodArray5 = methodArray4;
                                int n = methodArray5.length;
                                for (int i = 0; i < n; ++i) {
                                    Method method3;
                                    Method it = method3 = methodArray5[i];
                                    boolean bl = false;
                                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"toBigDecimal")) continue;
                                    method2 = method3;
                                    break block15;
                                }
                                method2 = null;
                            } else {
                                method2 = null;
                            }
                        }
                        Method method4 = toBigDecimal = method2;
                        Object object = method4 != null ? method4.invoke((Object)result, new Object[0]) : null;
                        bigDecimal = object instanceof BigDecimal ? (BigDecimal)object : null;
                    }
                    return bigDecimal;
                }
                catch (Exception e) {
                }
            }
            var2_20 = null;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to get balance: " + e.getMessage());
            var2_20 = null;
        }
        return var2_20;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isTransactionSuccessful(Object result) {
        if (result == null) {
            return false;
        }
        try {
            block6: {
                v0 = result.getClass().getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getMethods(...)");
                for (Object var7_5 : (Object[])v0) {
                    it = (Method)var7_5;
                    $i$a$-find-ImpactorBridge$isTransactionSuccessful$successMethod$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"successful")) ** GOTO lbl-1000
                    v1 = it.getParameterTypes();
                    Intrinsics.checkNotNullExpressionValue(v1, (String)"getParameterTypes(...)");
                    if (((Object[])v1).length == 0) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    if (!v2) continue;
                    v3 = var7_5;
                    break block6;
                }
                v3 = null;
            }
            v4 = successMethod = (Method)v3;
            var4_2 = v4 != null ? v4.invoke(result, new Object[0]) : null;
            v5 = var4_2 instanceof Boolean != false ? (Boolean)var4_2 : null;
            var2_9 = v5 != null ? v5 : true;
        }
        catch (Exception e) {
            var2_9 = true;
        }
        return var2_9;
    }
}

