/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.economy;

import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.economy.EconomyBridge;
import com.music176.pokemonleague.economy.EconomyRewardsConfig;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0019\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\f\u00a2\u0006\u0004\b\u0017\u0010\u000fJ\u0015\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0018\u0010\u0011J\r\u0010\u0019\u001a\u00020\f\u00a2\u0006\u0004\b\u0019\u0010\u0013J\u0015\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u001a\u0010\u0015J%\u0010\u001e\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\f\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010 \u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b \u0010!J\r\u0010\"\u001a\u00020\f\u00a2\u0006\u0004\b\"\u0010\u0013J\r\u0010#\u001a\u00020\f\u00a2\u0006\u0004\b#\u0010\u0013J%\u0010'\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\f\u00a2\u0006\u0004\b'\u0010(J\u001d\u0010+\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\f\u00a2\u0006\u0004\b+\u0010,J%\u0010/\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f\u00a2\u0006\u0004\b/\u00100J\u0015\u00101\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b1\u0010\u0011J\u001d\u00103\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u00102\u001a\u00020\f\u00a2\u0006\u0004\b3\u00104J\u0015\u00106\u001a\u0002052\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b6\u00107R$\u0010:\u001a\u0002082\u0006\u00109\u001a\u0002088\u0006@BX\u0086.\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\u00a8\u0006>"}, d2={"Lcom/music176/pokemonleague/economy/EconomyManager;", "", "<init>", "()V", "", "initialize", "reloadConfig", "", "isEconomyAvailable", "()Z", "Lnet/minecraft/class_3222;", "player", "", "gymNumber", "giveGymVictoryReward", "(Lnet/minecraft/class_3222;I)I", "giveAllBadgesBonus", "(Lnet/minecraft/class_3222;)I", "getLeagueEntryFee", "()I", "chargeLeagueEntryFee", "(Lnet/minecraft/class_3222;)Z", "stageNumber", "giveLeagueStageReward", "giveLeagueCompletionBonus", "getRankedEntryFee", "chargeRankedEntryFee", "", "rankName", "winStreak", "giveRankedVictoryReward", "(Lnet/minecraft/class_3222;Ljava/lang/String;I)I", "refundRankedEntryFee", "(Lnet/minecraft/class_3222;)V", "getDuelMinBet", "getDuelMaxBet", "player1", "player2", "betAmount", "chargeDuelBet", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;I)Z", "winner", "totalPot", "giveDuelWinnings", "(Lnet/minecraft/class_3222;I)V", "placement", "matchWins", "giveTournamentReward", "(Lnet/minecraft/class_3222;II)I", "giveTournamentParticipationReward", "amount", "hasEnough", "(Lnet/minecraft/class_3222;I)Z", "", "getBalance", "(Lnet/minecraft/class_3222;)J", "Lcom/music176/pokemonleague/economy/EconomyRewardsConfig;", "value", "config", "Lcom/music176/pokemonleague/economy/EconomyRewardsConfig;", "getConfig", "()Lcom/music176/pokemonleague/economy/EconomyRewardsConfig;", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nEconomyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EconomyManager.kt\ncom/music176/pokemonleague/economy/EconomyManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,327:1\n1#2:328\n*E\n"})
public final class EconomyManager {
    @NotNull
    public static final EconomyManager INSTANCE = new EconomyManager();
    private static EconomyRewardsConfig config;

    private EconomyManager() {
    }

    @NotNull
    public final EconomyRewardsConfig getConfig() {
        EconomyRewardsConfig economyRewardsConfig = config;
        if (economyRewardsConfig != null) {
            return economyRewardsConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    public final void initialize() {
        EconomyBridge.INSTANCE.initialize();
        config = EconomyRewardsConfig.Companion.load();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("EconomyManager initialized with rewards config");
    }

    public final void reloadConfig() {
        config = EconomyRewardsConfig.Companion.load();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Economy rewards config reloaded");
    }

    public final boolean isEconomyAvailable() {
        return EconomyBridge.INSTANCE.isAvailable();
    }

    public final int giveGymVictoryReward(@NotNull class_3222 player, int gymNumber) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int index = gymNumber - 1;
        List<Integer> list = this.getConfig().getGymRewards().getGymVictoryRewards();
        boolean bl = 0 <= index ? index < list.size() : false;
        if (bl) {
            n = list.get(index);
        } else {
            int it = index;
            boolean bl2 = false;
            n = 500;
        }
        int amount = ((Number)n).intValue();
        if (EconomyBridge.INSTANCE.deposit(player, amount)) {
            player.method_43496((class_2561)class_2561.method_43470((String)("+" + EconomyBridge.INSTANCE.formatBalance(amount) + " Pokedollars (Victoire Arene " + gymNumber + ")")).method_27694(EconomyManager::giveGymVictoryReward$lambda$1));
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Gave " + EconomyBridge.INSTANCE.formatBalance(amount) + " Pokedollars to " + player.method_5477().getString() + " for gym " + gymNumber + " victory");
        }
        return amount;
    }

    public final int giveAllBadgesBonus(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int amount = this.getConfig().getGymRewards().getAllBadgesBonus();
        if (amount > 0 && EconomyBridge.INSTANCE.deposit(player, amount)) {
            player.method_43496((class_2561)class_2561.method_43470((String)("+" + EconomyBridge.INSTANCE.formatBalance(amount) + " Pokedollars (Bonus tous les badges!)")).method_27694(EconomyManager::giveAllBadgesBonus$lambda$0));
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Gave " + EconomyBridge.INSTANCE.formatBalance(amount) + " Pokedollars to " + player.method_5477().getString() + " for all badges bonus");
        }
        return amount;
    }

    public final int getLeagueEntryFee() {
        return this.getConfig().getLeagueRewards().getEntryFee();
    }

    public final boolean chargeLeagueEntryFee(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int fee = this.getConfig().getLeagueRewards().getEntryFee();
        if (fee <= 0) {
            return true;
        }
        if (EconomyBridge.INSTANCE.withdraw(player, fee)) {
            player.method_43496((class_2561)class_2561.method_43470((String)("-" + EconomyBridge.INSTANCE.formatBalance(fee) + " Pokedollars (Entree Ligue)")).method_27694(EconomyManager::chargeLeagueEntryFee$lambda$0));
            return true;
        }
        return false;
    }

    public final int giveLeagueStageReward(@NotNull class_3222 player, int stageNumber) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int index = stageNumber - 1;
        List<Integer> list = this.getConfig().getLeagueRewards().getStageVictoryRewards();
        boolean bl = 0 <= index ? index < list.size() : false;
        if (bl) {
            n = list.get(index);
        } else {
            int it = index;
            boolean bl2 = false;
            n = 1000;
        }
        int amount = ((Number)n).intValue();
        if (EconomyBridge.INSTANCE.deposit(player, amount)) {
            player.method_43496((class_2561)class_2561.method_43470((String)("+" + EconomyBridge.INSTANCE.formatBalance(amount) + " Pokedollars (Victoire Etape " + stageNumber + ")")).method_27694(EconomyManager::giveLeagueStageReward$lambda$1));
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Gave " + EconomyBridge.INSTANCE.formatBalance(amount) + " Pokedollars to " + player.method_5477().getString() + " for league stage " + stageNumber);
        }
        return amount;
    }

    public final int giveLeagueCompletionBonus(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int amount = this.getConfig().getLeagueRewards().getCompletionBonus();
        if (amount > 0 && EconomyBridge.INSTANCE.deposit(player, amount)) {
            player.method_43496((class_2561)class_2561.method_43470((String)("+" + EconomyBridge.INSTANCE.formatBalance(amount) + " Pokedollars (CHAMPION DE LA LIGUE!)")).method_27694(EconomyManager::giveLeagueCompletionBonus$lambda$0));
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Gave " + EconomyBridge.INSTANCE.formatBalance(amount) + " Pokedollars to " + player.method_5477().getString() + " for league completion");
        }
        return amount;
    }

    public final int getRankedEntryFee() {
        return this.getConfig().getRankedRewards().getEntryFee();
    }

    public final boolean chargeRankedEntryFee(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int fee = this.getConfig().getRankedRewards().getEntryFee();
        if (fee <= 0) {
            return true;
        }
        if (EconomyBridge.INSTANCE.withdraw(player, fee)) {
            player.method_43496((class_2561)class_2561.method_43470((String)("-" + EconomyBridge.INSTANCE.formatBalance(fee) + " Pokedollars (Entree Combat Ranked)")).method_27694(EconomyManager::chargeRankedEntryFee$lambda$0));
            return true;
        }
        return false;
    }

    public final int giveRankedVictoryReward(@NotNull class_3222 player, @NotNull String rankName, int winStreak) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)rankName, (String)"rankName");
        int baseReward = this.getConfig().getRankedRewards().getVictoryReward();
        Map<String, Double> map = this.getConfig().getRankedRewards().getRankMultipliers();
        String string = rankName.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        Double d = map.get(string);
        double multiplier = d != null ? d : 1.0;
        int streakBonus = RangesKt.coerceAtLeast((int)Math.min(this.getConfig().getRankedRewards().getStreakBonus() * (winStreak - 1), this.getConfig().getRankedRewards().getMaxStreakBonus()), (int)0);
        int baseWithMultiplier = (int)((double)baseReward * multiplier);
        int totalAmount = baseWithMultiplier + streakBonus;
        if (EconomyBridge.INSTANCE.deposit(player, totalAmount)) {
            StringBuilder message = new StringBuilder("+" + EconomyBridge.INSTANCE.formatBalance(baseWithMultiplier) + " Pokedollars (Victoire Ranked)");
            if (streakBonus > 0) {
                message.append(" +" + EconomyBridge.INSTANCE.formatBalance(streakBonus) + " (Serie x" + winStreak + ")");
            }
            player.method_43496((class_2561)class_2561.method_43470((String)message.toString()).method_27694(EconomyManager::giveRankedVictoryReward$lambda$0));
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Gave " + EconomyBridge.INSTANCE.formatBalance(totalAmount) + " Pokedollars to " + player.method_5477().getString() + " for ranked victory (rank=" + rankName + ", streak=" + winStreak + ")");
        }
        return totalAmount;
    }

    public final void refundRankedEntryFee(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int fee = this.getConfig().getRankedRewards().getEntryFee();
        if (fee <= 0) {
            return;
        }
        if (EconomyBridge.INSTANCE.deposit(player, fee)) {
            player.method_43496((class_2561)class_2561.method_43470((String)("+" + EconomyBridge.INSTANCE.formatBalance(fee) + " Pokedollars (Remboursement)")).method_27694(EconomyManager::refundRankedEntryFee$lambda$0));
        }
    }

    public final int getDuelMinBet() {
        return this.getConfig().getDuelRewards().getMinBet();
    }

    public final int getDuelMaxBet() {
        return this.getConfig().getDuelRewards().getMaxBet();
    }

    public final boolean chargeDuelBet(@NotNull class_3222 player1, @NotNull class_3222 player2, int betAmount) {
        Intrinsics.checkNotNullParameter((Object)player1, (String)"player1");
        Intrinsics.checkNotNullParameter((Object)player2, (String)"player2");
        if (betAmount <= 0) {
            return true;
        }
        long balance1 = EconomyBridge.INSTANCE.getBalance(player1);
        long balance2 = EconomyBridge.INSTANCE.getBalance(player2);
        if (balance1 < (long)betAmount || balance2 < (long)betAmount) {
            return false;
        }
        EconomyBridge.INSTANCE.withdraw(player1, betAmount);
        EconomyBridge.INSTANCE.withdraw(player2, betAmount);
        player1.method_43496((class_2561)class_2561.method_43470((String)("-" + EconomyBridge.INSTANCE.formatBalance(betAmount) + " Pokedollars (Mise Duel)")).method_27694(EconomyManager::chargeDuelBet$lambda$0));
        player2.method_43496((class_2561)class_2561.method_43470((String)("-" + EconomyBridge.INSTANCE.formatBalance(betAmount) + " Pokedollars (Mise Duel)")).method_27694(EconomyManager::chargeDuelBet$lambda$1));
        return true;
    }

    public final void giveDuelWinnings(@NotNull class_3222 winner, int totalPot) {
        Intrinsics.checkNotNullParameter((Object)winner, (String)"winner");
        if (totalPot <= 0) {
            return;
        }
        if (EconomyBridge.INSTANCE.deposit(winner, totalPot)) {
            winner.method_43496((class_2561)class_2561.method_43470((String)("+" + EconomyBridge.INSTANCE.formatBalance(totalPot) + " Pokedollars (Victoire Duel!)")).method_27694(EconomyManager::giveDuelWinnings$lambda$0));
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Gave " + EconomyBridge.INSTANCE.formatBalance(totalPot) + " Pokedollars to " + winner.method_5477().getString() + " for duel victory");
        }
    }

    public final int giveTournamentReward(@NotNull class_3222 player, int placement, int matchWins) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int placementReward = switch (placement) {
            case 1 -> this.getConfig().getTournamentRewards().getFirstPlaceReward();
            case 2 -> this.getConfig().getTournamentRewards().getSecondPlaceReward();
            case 3 -> this.getConfig().getTournamentRewards().getThirdPlaceReward();
            default -> 0;
        };
        int matchBonus = this.getConfig().getTournamentRewards().getMatchWinBonus() * matchWins;
        int totalAmount = placementReward + matchBonus;
        if (totalAmount > 0 && EconomyBridge.INSTANCE.deposit(player, totalAmount)) {
            String placementText = switch (placement) {
                case 1 -> "1er PLACE!";
                case 2 -> "2eme place";
                case 3 -> "3eme place";
                default -> "Participation";
            };
            player.method_43496((class_2561)class_2561.method_43470((String)("+" + EconomyBridge.INSTANCE.formatBalance(totalAmount) + " Pokedollars (" + placementText + " + " + matchWins + " victoires)")).method_27694(arg_0 -> EconomyManager.giveTournamentReward$lambda$0(placement, arg_0)));
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Gave " + EconomyBridge.INSTANCE.formatBalance(totalAmount) + " Pokedollars to " + player.method_5477().getString() + " for tournament (place=" + placement + ", wins=" + matchWins + ")");
        }
        return totalAmount;
    }

    public final int giveTournamentParticipationReward(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int amount = this.getConfig().getTournamentRewards().getParticipationReward();
        if (amount <= 0) {
            return 0;
        }
        if (EconomyBridge.INSTANCE.deposit(player, amount)) {
            player.method_43496((class_2561)class_2561.method_43470((String)("+" + EconomyBridge.INSTANCE.formatBalance(amount) + " Pokedollars (Participation Tournoi)")).method_27694(EconomyManager::giveTournamentParticipationReward$lambda$0));
        }
        return amount;
    }

    public final boolean hasEnough(@NotNull class_3222 player, int amount) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return EconomyBridge.INSTANCE.getBalance(player) >= (long)amount;
    }

    public final long getBalance(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return EconomyBridge.INSTANCE.getBalance(player);
    }

    private static final class_2583 giveGymVictoryReward$lambda$1(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final class_2583 giveAllBadgesBonus$lambda$0(class_2583 it) {
        return it.method_36139(16766720);
    }

    private static final class_2583 chargeLeagueEntryFee$lambda$0(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2583 giveLeagueStageReward$lambda$1(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final class_2583 giveLeagueCompletionBonus$lambda$0(class_2583 it) {
        return it.method_36139(16766720).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 chargeRankedEntryFee$lambda$0(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2583 giveRankedVictoryReward$lambda$0(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final class_2583 refundRankedEntryFee$lambda$0(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2583 chargeDuelBet$lambda$0(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2583 chargeDuelBet$lambda$1(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2583 giveDuelWinnings$lambda$0(class_2583 it) {
        return it.method_36139(0x55FF55).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 giveTournamentReward$lambda$0(int $placement, class_2583 it) {
        return $placement == 1 ? it.method_36139(16766720).method_10982(Boolean.valueOf(true)) : it.method_36139(0x55FF55);
    }

    private static final class_2583 giveTournamentParticipationReward$lambda$0(class_2583 it) {
        return it.method_36139(0xAAAAAA);
    }
}

