/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.economy;

import com.music176.pokemonleague.PokemonLeagueMod;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001<B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\bJ\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u001d\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001b\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0012J\u001f\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0019J\u001f\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0019J\u0019\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010!\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b!\u0010\u0012J\u001f\u0010#\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010%\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b%\u0010$J\u0019\u0010(\u001a\u0004\u0018\u00010\u00012\u0006\u0010'\u001a\u00020&H\u0002\u00a2\u0006\u0004\b(\u0010)J\u0019\u0010,\u001a\u0004\u0018\u00010+2\u0006\u0010*\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b,\u0010-J\u0019\u0010/\u001a\u00020\u00062\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0004\b/\u00100R\u0016\u00101\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0014\u00103\u001a\u00020\u00108\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b3\u00104R\u001c\u00106\u001a\b\u0012\u0002\b\u0003\u0018\u0001058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0018\u00108\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0018\u0010:\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u00109R\u0018\u0010;\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u00109\u00a8\u0006="}, d2={"Lcom/music176/pokemonleague/economy/EconomyBridge;", "", "<init>", "()V", "", "initialize", "", "tryInitCommonEconomy", "()Z", "tryInitImpactor", "isAvailable", "Lcom/music176/pokemonleague/economy/EconomyBridge$EconomyType;", "getEconomyType", "()Lcom/music176/pokemonleague/economy/EconomyBridge$EconomyType;", "Lnet/minecraft/class_3222;", "player", "", "getBalance", "(Lnet/minecraft/class_3222;)J", "rawBalance", "", "formatBalance", "(J)Ljava/lang/String;", "amount", "withdraw", "(Lnet/minecraft/class_3222;J)Z", "deposit", "hasEnough", "getCommonEconomyBalance", "commonEconomyWithdraw", "commonEconomyDeposit", "getCommonEconomyAccount", "(Lnet/minecraft/class_3222;)Ljava/lang/Object;", "getImpactorBalance", "", "impactorWithdraw", "(Lnet/minecraft/class_3222;I)Z", "impactorDeposit", "Ljava/util/UUID;", "uuid", "getImpactorAccount", "(Ljava/util/UUID;)Ljava/lang/Object;", "account", "Ljava/math/BigDecimal;", "getImpactorBalanceFromAccount", "(Ljava/lang/Object;)Ljava/math/BigDecimal;", "result", "isImpactorTransactionSuccessful", "(Ljava/lang/Object;)Z", "economyType", "Lcom/music176/pokemonleague/economy/EconomyBridge$EconomyType;", "COMMON_ECONOMY_MULTIPLIER", "J", "Ljava/lang/Class;", "commonEconomyClass", "Ljava/lang/Class;", "defaultCurrencyId", "Ljava/lang/Object;", "impactorService", "impactorCurrency", "EconomyType", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nEconomyBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EconomyBridge.kt\ncom/music176/pokemonleague/economy/EconomyBridge\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,428:1\n3919#2:429\n4434#2,2:430\n3919#2:432\n4434#2,2:433\n3919#2:435\n4434#2,2:436\n1#3:438\n*S KotlinDebug\n*F\n+ 1 EconomyBridge.kt\ncom/music176/pokemonleague/economy/EconomyBridge\n*L\n313#1:429\n313#1:430,2\n341#1:432\n341#1:433,2\n387#1:435\n387#1:436,2\n*E\n"})
public final class EconomyBridge {
    @NotNull
    public static final EconomyBridge INSTANCE = new EconomyBridge();
    @NotNull
    private static EconomyType economyType = EconomyType.NONE;
    private static final long COMMON_ECONOMY_MULTIPLIER = 100L;
    @Nullable
    private static Class<?> commonEconomyClass;
    @Nullable
    private static Object defaultCurrencyId;
    @Nullable
    private static Object impactorService;
    @Nullable
    private static Object impactorCurrency;

    private EconomyBridge() {
    }

    public final void initialize() {
        if (this.tryInitCommonEconomy()) {
            economyType = EconomyType.COMMON_ECONOMY;
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Economy integration enabled: Common Economy API (GUIShop)");
            return;
        }
        if (this.tryInitImpactor()) {
            economyType = EconomyType.IMPACTOR;
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Economy integration enabled: Impactor");
            return;
        }
        economyType = EconomyType.NONE;
        PokemonLeagueMod.INSTANCE.getLOGGER().info("No economy mod found - economy features disabled (free mode)");
    }

    private final boolean tryInitCommonEconomy() {
        boolean bl;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            commonEconomyClass = Class.forName("eu.pb4.common.economy.api.CommonEconomy", true, classLoader);
            defaultCurrencyId = class_2960.method_12829((String)"guishop:default");
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Common Economy API found");
            bl = true;
        }
        catch (ClassNotFoundException e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Common Economy API not found (ClassNotFoundException)");
            bl = false;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().warn("Failed to init Common Economy: " + e.getClass().getSimpleName() + ": " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    private final boolean tryInitImpactor() {
        boolean bl;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> impactorClass = Class.forName("net.impactdev.impactor.api.Impactor", true, classLoader);
            Object impactor = impactorClass.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
            Object services = impactorClass.getMethod("services", new Class[0]).invoke(impactor, new Object[0]);
            Class<?> economyServiceClass = Class.forName("net.impactdev.impactor.api.economy.EconomyService");
            Object[] objectArray = new Class[]{Class.class};
            Method method = services.getClass().getMethod("provide", (Class<?>[])objectArray);
            objectArray = new Object[]{economyServiceClass};
            Object object = impactorService = method.invoke(services, objectArray);
            Intrinsics.checkNotNull((Object)object);
            Object currencies = object.getClass().getMethod("currencies", new Class[0]).invoke(impactorService, new Object[0]);
            impactorCurrency = currencies.getClass().getMethod("primary", new Class[0]).invoke(currencies, new Object[0]);
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().warn("Failed to init Impactor: " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    public final boolean isAvailable() {
        return economyType != EconomyType.NONE;
    }

    @NotNull
    public final EconomyType getEconomyType() {
        return economyType;
    }

    public final long getBalance(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return switch (WhenMappings.$EnumSwitchMapping$0[economyType.ordinal()]) {
            case 1 -> this.getCommonEconomyBalance(player);
            case 2 -> this.getImpactorBalance(player);
            case 3 -> Long.MAX_VALUE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final String formatBalance(long rawBalance) {
        long whole = rawBalance / 100L;
        long decimals = rawBalance % 100L;
        NumberFormat formatter = NumberFormat.getIntegerInstance(Locale.FRANCE);
        String string = formatter.format(whole);
        String string2 = "%02d";
        Object[] objectArray = new Object[]{decimals};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string + "," + string3;
    }

    public final boolean withdraw(@NotNull class_3222 player, long amount) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (amount <= 0L) {
            return true;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[economyType.ordinal()]) {
            case 1 -> this.commonEconomyWithdraw(player, amount);
            case 2 -> this.impactorWithdraw(player, (int)amount);
            case 3 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final boolean deposit(@NotNull class_3222 player, long amount) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (amount <= 0L) {
            return true;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[economyType.ordinal()]) {
            case 1 -> this.commonEconomyDeposit(player, amount);
            case 2 -> this.impactorDeposit(player, (int)amount);
            case 3 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final boolean hasEnough(@NotNull class_3222 player, long amount) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.getBalance(player) >= amount;
    }

    private final long getCommonEconomyBalance(class_3222 player) {
        long l;
        try {
            Object object = this.getCommonEconomyAccount(player);
            if (object == null) {
                return Long.MAX_VALUE;
            }
            Object account = object;
            Method balanceMethod = account.getClass().getMethod("balance", new Class[0]);
            Object object2 = balanceMethod.invoke(account, new Object[0]);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Long");
            l = (Long)object2;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to get Common Economy balance: " + e.getMessage());
            l = Long.MAX_VALUE;
        }
        return l;
    }

    private final boolean commonEconomyWithdraw(class_3222 player, long amount) {
        boolean bl;
        try {
            Object object = this.getCommonEconomyAccount(player);
            if (object == null) {
                return true;
            }
            Object account = object;
            Class[] classArray = new Class[]{Long.TYPE};
            Method canDecreaseMethod = account.getClass().getMethod("canDecreaseBalance", classArray);
            Object[] objectArray = new Object[]{amount};
            Object canDecrease = canDecreaseMethod.invoke(account, objectArray);
            Method successMethod = canDecrease.getClass().getMethod("isSuccessful", new Class[0]);
            Object object2 = successMethod.invoke(canDecrease, new Object[0]);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            if (!((Boolean)object2).booleanValue()) {
                return false;
            }
            Class[] classArray2 = new Class[]{Long.TYPE};
            Method decreaseMethod = account.getClass().getMethod("decreaseBalance", classArray2);
            Object[] objectArray2 = new Object[]{amount};
            Object result = decreaseMethod.invoke(account, objectArray2);
            Method resultSuccessMethod = result.getClass().getMethod("isSuccessful", new Class[0]);
            Object object3 = resultSuccessMethod.invoke(result, new Object[0]);
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Boolean");
            bl = (Boolean)object3;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to withdraw via Common Economy: " + e.getMessage());
            bl = true;
        }
        return bl;
    }

    private final boolean commonEconomyDeposit(class_3222 player, long amount) {
        boolean bl;
        try {
            Object object = this.getCommonEconomyAccount(player);
            if (object == null) {
                return true;
            }
            Object account = object;
            Class[] classArray = new Class[]{Long.TYPE};
            Method increaseMethod = account.getClass().getMethod("increaseBalance", classArray);
            Object[] objectArray = new Object[]{amount};
            Object result = increaseMethod.invoke(account, objectArray);
            Method successMethod = result.getClass().getMethod("isSuccessful", new Class[0]);
            Object object2 = successMethod.invoke(result, new Object[0]);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            bl = (Boolean)object2;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to deposit via Common Economy: " + e.getMessage());
            bl = true;
        }
        return bl;
    }

    private final Object getCommonEconomyAccount(class_3222 player) {
        Object var2_2;
        try {
            Object object;
            block14: {
                Object object2;
                Class<?> commonEconomy;
                block13: {
                    Class<?> clazz = commonEconomyClass;
                    if (clazz == null) {
                        return null;
                    }
                    commonEconomy = clazz;
                    Method[] methodArray = commonEconomy.getMethods();
                    Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
                    for (Object object3 : (Object[])methodArray) {
                        Method it = (Method)object3;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"getAccounts") && it.getParameterCount() == 1)) continue;
                        object2 = object3;
                        break block13;
                    }
                    object2 = null;
                }
                Method getAccountsMethod = (Method)object2;
                if (getAccountsMethod != null) {
                    try {
                        Object[] objectArray = new Object[]{player};
                        Object object4 = getAccountsMethod.invoke(null, objectArray);
                        Collection accounts = object4 instanceof Collection ? (Collection)object4 : null;
                        object4 = accounts;
                        if (!(object4 == null || object4.isEmpty())) {
                            return CollectionsKt.first((Iterable)accounts);
                        }
                    }
                    catch (Exception e) {
                        PokemonLeagueMod.INSTANCE.getLOGGER().warn("getAccounts failed: " + e.getClass().getSimpleName() + ": " + e.getMessage());
                    }
                }
                Method[] methodArray = commonEconomy.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
                for (Object object5 : (Object[])methodArray) {
                    Method it = (Method)object5;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"getAccount") && it.getParameterCount() == 2)) continue;
                    object = object5;
                    break block14;
                }
                object = null;
            }
            Method method = (Method)object;
            if (method == null) {
                EconomyBridge $this$getCommonEconomyAccount_u24lambda_u242 = this;
                boolean bl = false;
                PokemonLeagueMod.INSTANCE.getLOGGER().warn("No getAccount(2) method found in CommonEconomy");
                return null;
            }
            Method getAccountMethod = method;
            class_2960[] class_2960Array = new class_2960[]{class_2960.method_12829((String)"guishop:default"), class_2960.method_12829((String)"guishop:money"), class_2960.method_12829((String)"minecraft:default")};
            List currencyIds = CollectionsKt.listOf((Object[])class_2960Array);
            for (class_2960 currencyId : currencyIds) {
                try {
                    Object[] objectArray = new Object[]{player, currencyId};
                    Object account = getAccountMethod.invoke(null, objectArray);
                    if (account == null) continue;
                    return account;
                }
                catch (Exception e) {
                }
            }
            PokemonLeagueMod.INSTANCE.getLOGGER().warn("No Common Economy account found for " + player.method_5477().getString());
            var2_2 = null;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to get Common Economy account: " + e.getClass().getSimpleName() + ": " + e.getMessage());
            var2_2 = null;
        }
        return var2_2;
    }

    private final long getImpactorBalance(class_3222 player) {
        long l;
        try {
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            Object object = this.getImpactorAccount(uUID);
            if (object == null) {
                return Long.MAX_VALUE;
            }
            Object account = object;
            BigDecimal bigDecimal = this.getImpactorBalanceFromAccount(account);
            if (bigDecimal == null) {
                return Long.MAX_VALUE;
            }
            BigDecimal balance = bigDecimal;
            l = balance.longValue();
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to get Impactor balance: " + e.getMessage());
            l = Long.MAX_VALUE;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean impactorWithdraw(class_3222 player, int amount) {
        boolean bl;
        try {
            void $this$filterTo$iv$iv;
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            Object object = this.getImpactorAccount(uUID);
            if (object == null) {
                return true;
            }
            Object account = object;
            BigDecimal bigDecimal = this.getImpactorBalanceFromAccount(account);
            if (bigDecimal == null) {
                return true;
            }
            BigDecimal balance = bigDecimal;
            if (balance.intValue() < amount) {
                return false;
            }
            BigDecimal withdrawAmount = new BigDecimal(amount);
            Method[] methodArray = account.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
            Object[] $this$filter$iv = methodArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Method it = (Method)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"withdraw")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List withdrawMethods = (List)destination$iv$iv;
            for (Method method : withdrawMethods) {
                try {
                    Object result;
                    Class<?>[] paramTypes = method.getParameterTypes();
                    if (paramTypes.length == 1 && Intrinsics.areEqual(paramTypes[0], BigDecimal.class)) {
                        Object[] objectArray2 = new Object[]{withdrawAmount};
                        result = method.invoke(account, objectArray2);
                        return this.isImpactorTransactionSuccessful(result);
                    }
                    if (paramTypes.length != 2) continue;
                    Object[] objectArray3 = new Object[]{impactorCurrency, withdrawAmount};
                    result = method.invoke(account, objectArray3);
                    return this.isImpactorTransactionSuccessful(result);
                }
                catch (Exception e) {
                }
            }
            bl = true;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to withdraw via Impactor: " + e.getMessage());
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean impactorDeposit(class_3222 player, int amount) {
        boolean bl;
        try {
            void $this$filterTo$iv$iv;
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            Object object = this.getImpactorAccount(uUID);
            if (object == null) {
                return true;
            }
            Object account = object;
            BigDecimal depositAmount = new BigDecimal(amount);
            Method[] methodArray = account.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
            Object[] $this$filter$iv = methodArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Method it = (Method)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"deposit")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List depositMethods = (List)destination$iv$iv;
            for (Method method : depositMethods) {
                try {
                    Object result;
                    Class<?>[] paramTypes = method.getParameterTypes();
                    if (paramTypes.length == 1 && Intrinsics.areEqual(paramTypes[0], BigDecimal.class)) {
                        Object[] objectArray2 = new Object[]{depositAmount};
                        result = method.invoke(account, objectArray2);
                        return this.isImpactorTransactionSuccessful(result);
                    }
                    if (paramTypes.length != 2) continue;
                    Object[] objectArray3 = new Object[]{impactorCurrency, depositAmount};
                    result = method.invoke(account, objectArray3);
                    return this.isImpactorTransactionSuccessful(result);
                }
                catch (Exception e) {
                }
            }
            bl = true;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to deposit via Impactor: " + e.getMessage());
            bl = true;
        }
        return bl;
    }

    private final Object getImpactorAccount(UUID uuid) {
        Object var2_9;
        try {
            Object object;
            Object[] objectArray;
            Method accountMethod;
            Object object2;
            Object object3;
            block8: {
                Object object4 = impactorService;
                Intrinsics.checkNotNull((Object)object4);
                Method[] methodArray = object4.getClass().getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
                for (Object object5 : (Object[])methodArray) {
                    Method it = (Method)object5;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"account") && it.getParameterTypes().length == 1)) continue;
                    object3 = object5;
                    break block8;
                }
                object3 = null;
            }
            if ((object2 = (accountMethod = (Method)object3)) == null || (object2 = ((Method)object2).invoke(impactorService, objectArray = new Object[]{uuid})) == null) {
                return null;
            }
            Object result = object2;
            if (result instanceof CompletableFuture) {
                object = ((CompletableFuture)result).join();
            } else {
                String string = result.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Optional", (boolean)false, (int)2, null)) {
                    objectArray = new Class[]{Object.class};
                    Method orElse = result.getClass().getMethod("orElse", (Class<?>[])objectArray);
                    objectArray = new Object[]{null};
                    object = orElse.invoke(result, objectArray);
                } else {
                    object = result;
                }
            }
            var2_9 = object;
        }
        catch (Exception e) {
            var2_9 = null;
        }
        return var2_9;
    }

    /*
     * WARNING - void declaration
     */
    private final BigDecimal getImpactorBalanceFromAccount(Object account) {
        Object var2_20;
        try {
            void $this$filterTo$iv$iv;
            Method[] methodArray = account.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
            Object[] $this$filter$iv = methodArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Method it = (Method)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"balance")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List balanceMethods = (List)destination$iv$iv;
            for (Method method : balanceMethods) {
                try {
                    BigDecimal bigDecimal;
                    Method[] result;
                    Method[] methodArray2;
                    Class<?>[] paramTypes = method.getParameterTypes();
                    Intrinsics.checkNotNull(paramTypes);
                    if (paramTypes.length == 0) {
                        methodArray2 = method.invoke(account, new Object[0]);
                    } else {
                        if (paramTypes.length != 1 || impactorCurrency == null) continue;
                        Object[] objectArray2 = new Object[]{impactorCurrency};
                        methodArray2 = method.invoke(account, objectArray2);
                    }
                    Method[] methodArray3 = result = methodArray2;
                    if (methodArray3 instanceof BigDecimal) {
                        bigDecimal = (BigDecimal)result;
                    } else if (methodArray3 instanceof Number) {
                        bigDecimal = new BigDecimal(((Number)result).doubleValue());
                    } else {
                        Method toBigDecimal;
                        Method method2;
                        block15: {
                            Method[] methodArray4 = result;
                            if (result != null && (methodArray4 = methodArray4.getClass()) != null && (methodArray4 = methodArray4.getMethods()) != null) {
                                Method[] methodArray5 = methodArray4;
                                int n = methodArray5.length;
                                for (int i = 0; i < n; ++i) {
                                    Method method3;
                                    Method it = method3 = methodArray5[i];
                                    boolean bl = false;
                                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"toBigDecimal")) continue;
                                    method2 = method3;
                                    break block15;
                                }
                                method2 = null;
                            } else {
                                method2 = null;
                            }
                        }
                        Method method4 = toBigDecimal = method2;
                        Object object = method4 != null ? method4.invoke((Object)result, new Object[0]) : null;
                        bigDecimal = object instanceof BigDecimal ? (BigDecimal)object : null;
                    }
                    return bigDecimal;
                }
                catch (Exception e) {
                }
            }
            var2_20 = null;
        }
        catch (Exception e) {
            var2_20 = null;
        }
        return var2_20;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isImpactorTransactionSuccessful(Object result) {
        if (result == null) {
            return false;
        }
        try {
            block6: {
                v0 = result.getClass().getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getMethods(...)");
                for (Object var7_5 : (Object[])v0) {
                    it = (Method)var7_5;
                    $i$a$-find-EconomyBridge$isImpactorTransactionSuccessful$successMethod$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"successful")) ** GOTO lbl-1000
                    v1 = it.getParameterTypes();
                    Intrinsics.checkNotNullExpressionValue(v1, (String)"getParameterTypes(...)");
                    if (((Object[])v1).length == 0) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    if (!v2) continue;
                    v3 = var7_5;
                    break block6;
                }
                v3 = null;
            }
            v4 = successMethod = (Method)v3;
            var4_2 = v4 != null ? v4.invoke(result, new Object[0]) : null;
            v5 = var4_2 instanceof Boolean != false ? (Boolean)var4_2 : null;
            var2_9 = v5 != null ? v5 : true;
        }
        catch (Exception e) {
            var2_9 = true;
        }
        return var2_9;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/music176/pokemonleague/economy/EconomyBridge$EconomyType;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "COMMON_ECONOMY", "IMPACTOR", "pokemon-league-mod"})
    public static final class EconomyType
    extends Enum<EconomyType> {
        public static final /* enum */ EconomyType NONE = new EconomyType();
        public static final /* enum */ EconomyType COMMON_ECONOMY = new EconomyType();
        public static final /* enum */ EconomyType IMPACTOR = new EconomyType();
        private static final /* synthetic */ EconomyType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static EconomyType[] values() {
            return (EconomyType[])$VALUES.clone();
        }

        public static EconomyType valueOf(String value) {
            return Enum.valueOf(EconomyType.class, value);
        }

        @NotNull
        public static EnumEntries<EconomyType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = economyTypeArray = new EconomyType[]{EconomyType.NONE, EconomyType.COMMON_ECONOMY, EconomyType.IMPACTOR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EconomyType.values().length];
            try {
                nArray[EconomyType.COMMON_ECONOMY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EconomyType.IMPACTOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EconomyType.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

