/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.duel;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.scheduling.SchedulingFunctionsKt;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.BattleStartResult;
import com.cobblemon.mod.common.battles.ErroredBattleStart;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.config.Position;
import com.music176.pokemonleague.duel.BestOf;
import com.music176.pokemonleague.duel.DuelConfig;
import com.music176.pokemonleague.duel.DuelInvitation;
import com.music176.pokemonleague.duel.DuelMode;
import com.music176.pokemonleague.duel.DuelPlayer;
import com.music176.pokemonleague.duel.DuelSession;
import com.music176.pokemonleague.duel.DuelSpectatorManager;
import com.music176.pokemonleague.duel.DuelState;
import com.music176.pokemonleague.gym.GymData;
import com.music176.pokemonleague.gym.GymManager;
import com.music176.pokemonleague.integration.FTBQuestsIntegration;
import com.music176.pokemonleague.inventory.InventoryManager;
import com.music176.pokemonleague.league.LeagueManager;
import com.music176.pokemonleague.profile.Badge;
import com.music176.pokemonleague.profile.BadgeCollection;
import com.music176.pokemonleague.profile.PlayerProfile;
import com.music176.pokemonleague.profile.PlayerProfileManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003J\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000f0\u00160\u0013\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u0015\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u0015\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\"\u0010#Jg\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020%2\u0006\u0010(\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0\u0013\u00a2\u0006\u0004\b.\u0010/J\u0017\u00101\u001a\u00020\u00062\u0006\u00100\u001a\u00020-H\u0002\u00a2\u0006\u0004\b1\u00102J\u001d\u00104\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u00103\u001a\u00020\u0018\u00a2\u0006\u0004\b4\u00105J\u001d\u00106\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u00103\u001a\u00020\u0018\u00a2\u0006\u0004\b6\u00105J\u001d\u00108\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u00182\u0006\u00107\u001a\u00020\r\u00a2\u0006\u0004\b8\u00109J\u001f\u0010<\u001a\u00020\u00062\u0006\u00100\u001a\u00020-2\u0006\u0010;\u001a\u00020:H\u0002\u00a2\u0006\u0004\b<\u0010=J\u0017\u0010>\u001a\u00020\u00062\u0006\u00100\u001a\u00020-H\u0002\u00a2\u0006\u0004\b>\u00102J\u0017\u0010@\u001a\u00020\u00062\u0006\u0010?\u001a\u00020!H\u0002\u00a2\u0006\u0004\b@\u0010AJ\u0017\u0010B\u001a\u00020\u00062\u0006\u0010?\u001a\u00020!H\u0002\u00a2\u0006\u0004\bB\u0010AJ\u0017\u0010C\u001a\u00020\u00062\u0006\u0010?\u001a\u00020!H\u0002\u00a2\u0006\u0004\bC\u0010AJ'\u0010F\u001a\u00020\u00062\u0006\u0010?\u001a\u00020!2\u0006\u0010D\u001a\u00020\u001d2\u0006\u0010E\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\bF\u0010GJ3\u0010J\u001a\u00020\u00062\u0006\u0010?\u001a\u00020!2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00132\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0013H\u0002\u00a2\u0006\u0004\bJ\u0010KJ)\u0010N\u001a\u00020\u00062\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013\u00a2\u0006\u0004\bN\u0010OJ\u0017\u0010P\u001a\u00020\u00062\u0006\u0010?\u001a\u00020!H\u0002\u00a2\u0006\u0004\bP\u0010AJ\u0017\u0010Q\u001a\u00020\u00062\u0006\u0010?\u001a\u00020!H\u0002\u00a2\u0006\u0004\bQ\u0010AJ\u001d\u0010T\u001a\u00020\u00062\u0006\u0010R\u001a\u00020\u00182\u0006\u0010S\u001a\u00020\u000f\u00a2\u0006\u0004\bT\u0010UJ\u0015\u0010V\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\bV\u0010WJ\u0015\u0010X\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\bX\u0010WJ\u001f\u0010[\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010Z\u001a\u00020YH\u0002\u00a2\u0006\u0004\b[\u0010\\J\u0017\u0010]\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b]\u0010WJ\u0017\u0010^\u001a\u0004\u0018\u00010-2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b^\u0010_J\u0013\u0010a\u001a\b\u0012\u0004\u0012\u00020!0`\u00a2\u0006\u0004\ba\u0010bR\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010cR$\u0010f\u001a\u00020d2\u0006\u0010e\u001a\u00020d8\u0006@BX\u0086.\u00a2\u0006\f\n\u0004\bf\u0010g\u001a\u0004\bh\u0010iR \u0010k\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020!0j8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bk\u0010lR \u0010m\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180j8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bm\u0010lR \u0010n\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020-0j8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bn\u0010lR \u0010o\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180j8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bo\u0010l\u00a8\u0006p"}, d2={"Lcom/music176/pokemonleague/duel/DuelManager;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "initialize", "(Lnet/minecraft/server/MinecraftServer;)V", "shutdown", "reloadConfig", "startExpirationChecker", "checkExpiredInvitations", "", "arenaId", "", "isArenaAvailable", "(Ljava/lang/String;)Z", "isArenaOccupiedByDuel", "", "getAvailableArenas", "()Ljava/util/List;", "Lkotlin/Pair;", "getAllArenasWithStatus", "Ljava/util/UUID;", "playerId", "isPlayerInDuel", "(Ljava/util/UUID;)Z", "hasPlayerPendingInvite", "Lnet/minecraft/class_3222;", "player", "canPlayerDuel", "(Lnet/minecraft/class_3222;)Z", "Lcom/music176/pokemonleague/duel/DuelSession;", "getPlayerSession", "(Ljava/util/UUID;)Lcom/music176/pokemonleague/duel/DuelSession;", "initiator", "Lcom/music176/pokemonleague/duel/DuelMode;", "mode", "Lcom/music176/pokemonleague/duel/BestOf;", "bestOf", "team1Ids", "team1Names", "team2Ids", "team2Names", "Lcom/music176/pokemonleague/duel/DuelInvitation;", "createInvitation", "(Lnet/minecraft/class_3222;Lcom/music176/pokemonleague/duel/DuelMode;Lcom/music176/pokemonleague/duel/BestOf;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)Lcom/music176/pokemonleague/duel/DuelInvitation;", "invitation", "sendInvitationMessages", "(Lcom/music176/pokemonleague/duel/DuelInvitation;)V", "invitationId", "acceptInvitation", "(Lnet/minecraft/class_3222;Ljava/util/UUID;)Z", "declineInvitation", "reason", "cancelInvitation", "(Ljava/util/UUID;Ljava/lang/String;)V", "Lnet/minecraft/class_2561;", "message", "notifyAllInvitationPlayers", "(Lcom/music176/pokemonleague/duel/DuelInvitation;Lnet/minecraft/class_2561;)V", "startDuelFromInvitation", "session", "teleportPlayersToArena", "(Lcom/music176/pokemonleague/duel/DuelSession;)V", "startCountdown", "startBattle", "player1", "player2", "start1v1Battle", "(Lcom/music176/pokemonleague/duel/DuelSession;Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;)V", "team1Players", "team2Players", "start2v2Battle", "(Lcom/music176/pokemonleague/duel/DuelSession;Ljava/util/List;Ljava/util/List;)V", "winnerIds", "loserIds", "handleBattleResult", "(Ljava/util/List;Ljava/util/List;)V", "handleSeriesEnd", "teleportPlayersBack", "sessionId", "cancelled", "endSession", "(Ljava/util/UUID;Z)V", "playerQuit", "(Lnet/minecraft/class_3222;)V", "handlePlayerDisconnect", "Lcom/music176/pokemonleague/config/Position;", "position", "teleportToPosition", "(Lnet/minecraft/class_3222;Lcom/music176/pokemonleague/config/Position;)V", "recallAllPokemon", "getPendingInvitation", "(Ljava/util/UUID;)Lcom/music176/pokemonleague/duel/DuelInvitation;", "", "getActiveSessions", "()Ljava/util/Collection;", "Lnet/minecraft/server/MinecraftServer;", "Lcom/music176/pokemonleague/duel/DuelConfig;", "value", "config", "Lcom/music176/pokemonleague/duel/DuelConfig;", "getConfig", "()Lcom/music176/pokemonleague/duel/DuelConfig;", "Ljava/util/concurrent/ConcurrentHashMap;", "activeSessions", "Ljava/util/concurrent/ConcurrentHashMap;", "playerToSession", "pendingInvitations", "playerPendingInvite", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nDuelManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuelManager.kt\ncom/music176/pokemonleague/duel/DuelManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1052:1\n1869#2,2:1053\n774#2:1055\n865#2,2:1056\n1869#2,2:1058\n1761#2,3:1060\n1563#2:1063\n1634#2,3:1064\n774#2:1067\n865#2,2:1068\n1563#2:1070\n1634#2,3:1071\n1869#2,2:1075\n1869#2,2:1077\n1869#2,2:1079\n1869#2,2:1081\n1869#2,2:1083\n1878#2,3:1085\n1878#2,3:1088\n1869#2,2:1091\n1869#2,2:1093\n1869#2,2:1095\n1869#2,2:1097\n1869#2,2:1099\n1617#2,9:1101\n1869#2:1110\n1870#2:1112\n1626#2:1113\n1617#2,9:1114\n1869#2:1123\n1870#2:1125\n1626#2:1126\n774#2:1127\n865#2,2:1128\n1563#2:1130\n1634#2,3:1131\n774#2:1134\n865#2,2:1135\n1563#2:1137\n1634#2,3:1138\n774#2:1141\n865#2,2:1142\n1563#2:1144\n1634#2,3:1145\n774#2:1148\n865#2,2:1149\n1563#2:1151\n1634#2,3:1152\n1761#2,3:1155\n1869#2,2:1158\n1869#2,2:1160\n1869#2,2:1162\n1869#2,2:1164\n1869#2,2:1166\n1869#2,2:1168\n1869#2,2:1170\n1869#2,2:1172\n1563#2:1174\n1634#2,3:1175\n1869#2,2:1178\n1869#2,2:1180\n1869#2,2:1182\n1869#2,2:1184\n1869#2,2:1186\n1869#2,2:1188\n1869#2,2:1190\n1869#2,2:1192\n1#3:1074\n1#3:1111\n1#3:1124\n*S KotlinDebug\n*F\n+ 1 DuelManager.kt\ncom/music176/pokemonleague/duel/DuelManager\n*L\n58#1:1053,2\n89#1:1055\n89#1:1056,2\n90#1:1058,2\n118#1:1060,3\n126#1:1063\n126#1:1064,3\n127#1:1067\n127#1:1068,2\n134#1:1070\n134#1:1071,3\n295#1:1075,2\n314#1:1077,2\n460#1:1079,2\n473#1:1081,2\n488#1:1083,2\n509#1:1085,3\n524#1:1088,3\n541#1:1091,2\n548#1:1093,2\n570#1:1095,2\n579#1:1097,2\n627#1:1099,2\n641#1:1101,9\n641#1:1110\n641#1:1112\n641#1:1113\n642#1:1114,9\n642#1:1123\n642#1:1125\n642#1:1126\n666#1:1127\n666#1:1128,2\n666#1:1130\n666#1:1131,3\n667#1:1134\n667#1:1135,2\n667#1:1137\n667#1:1138,3\n712#1:1141\n712#1:1142,2\n712#1:1144\n712#1:1145,3\n725#1:1148\n725#1:1149,2\n725#1:1151\n725#1:1152,3\n786#1:1155,3\n795#1:1158,2\n804#1:1160,2\n824#1:1162,2\n833#1:1164,2\n856#1:1166,2\n859#1:1168,2\n864#1:1170,2\n873#1:1172,2\n903#1:1174\n903#1:1175,3\n905#1:1178,2\n943#1:1180,2\n952#1:1182,2\n973#1:1184,2\n985#1:1186,2\n988#1:1188,2\n1031#1:1190,2\n598#1:1192,2\n641#1:1111\n642#1:1124\n*E\n"})
public final class DuelManager {
    @NotNull
    public static final DuelManager INSTANCE = new DuelManager();
    @Nullable
    private static MinecraftServer server;
    private static DuelConfig config;
    @NotNull
    private static final ConcurrentHashMap<UUID, DuelSession> activeSessions;
    @NotNull
    private static final ConcurrentHashMap<UUID, UUID> playerToSession;
    @NotNull
    private static final ConcurrentHashMap<UUID, DuelInvitation> pendingInvitations;
    @NotNull
    private static final ConcurrentHashMap<UUID, UUID> playerPendingInvite;

    private DuelManager() {
    }

    @NotNull
    public final DuelConfig getConfig() {
        DuelConfig duelConfig = config;
        if (duelConfig != null) {
            return duelConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    public final void initialize(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        DuelManager.server = server;
        config = DuelConfig.Companion.load();
        this.startExpirationChecker();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("DuelManager initialized");
    }

    public final void shutdown() {
        Collection<DuelSession> collection = activeSessions.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)collection);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DuelSession session = (DuelSession)element$iv;
            boolean bl = false;
            INSTANCE.endSession(session.getSessionId(), true);
        }
        pendingInvitations.clear();
        playerPendingInvite.clear();
        server = null;
        PokemonLeagueMod.INSTANCE.getLOGGER().info("DuelManager shutdown");
    }

    public final void reloadConfig() {
        config = DuelConfig.Companion.load();
    }

    private final void startExpirationChecker() {
        SchedulingFunctionsKt.afterOnServer((float)10.0f, DuelManager::startExpirationChecker$lambda$0);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExpiredInvitations() {
        void $this$filterTo$iv$iv;
        Collection<DuelInvitation> collection = pendingInvitations.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DuelInvitation it = (DuelInvitation)element$iv$iv;
            boolean bl = false;
            if (!it.isExpired()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List expired = (List)destination$iv$iv;
        Iterable $this$forEach$iv = expired;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DuelInvitation invitation = (DuelInvitation)element$iv;
            boolean bl = false;
            INSTANCE.cancelInvitation(invitation.getInvitationId(), "Invitation expiree");
        }
    }

    public final boolean isArenaAvailable(@NotNull String arenaId) {
        Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
        if (GymManager.INSTANCE.isGymOccupied(arenaId)) {
            return false;
        }
        return !this.isArenaOccupiedByDuel(arenaId);
    }

    public final boolean isArenaOccupiedByDuel(@NotNull String arenaId) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
            Collection<DuelSession> collection = activeSessions.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DuelSession it = (DuelSession)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getArenaId(), (Object)arenaId)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAvailableArenas() {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = GymManager.INSTANCE.getGymConfig().getGyms();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GymData gymData = (GymData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((GymData)((Object)it)).getGymId());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!INSTANCE.isArenaAvailable(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<String, Boolean>> getAllArenasWithStatus() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = GymManager.INSTANCE.getGymConfig().getGyms();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void gym;
            GymData gymData = (GymData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)gym.getGymId(), (Object)INSTANCE.isArenaAvailable(gym.getGymId())));
        }
        return (List)destination$iv$iv;
    }

    public final boolean isPlayerInDuel(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return playerToSession.containsKey(playerId);
    }

    public final boolean hasPlayerPendingInvite(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return playerPendingInvite.containsKey(playerId);
    }

    public final boolean canPlayerDuel(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        if (this.isPlayerInDuel(uUID)) {
            return false;
        }
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        if (GymManager.INSTANCE.isPlayerActive(uUID2)) {
            return false;
        }
        UUID uUID3 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
        if (LeagueManager.INSTANCE.isPlayerActive(uUID3)) {
            return false;
        }
        UUID uUID4 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID4, (String)"getUUID(...)");
        return !this.hasPlayerPendingInvite(uUID4);
    }

    @Nullable
    public final DuelSession getPlayerSession(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        UUID uUID = playerToSession.get(playerId);
        if (uUID == null) {
            return null;
        }
        UUID sessionId = uUID;
        return activeSessions.get(sessionId);
    }

    @Nullable
    public final DuelInvitation createInvitation(@NotNull class_3222 initiator, @NotNull DuelMode mode, @NotNull BestOf bestOf, @NotNull String arenaId, @NotNull List<UUID> team1Ids, @NotNull List<String> team1Names, @NotNull List<UUID> team2Ids, @NotNull List<String> team2Names) {
        List allPlayerIds;
        Intrinsics.checkNotNullParameter((Object)initiator, (String)"initiator");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)bestOf), (String)"bestOf");
        Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
        Intrinsics.checkNotNullParameter(team1Ids, (String)"team1Ids");
        Intrinsics.checkNotNullParameter(team1Names, (String)"team1Names");
        Intrinsics.checkNotNullParameter(team2Ids, (String)"team2Ids");
        Intrinsics.checkNotNullParameter(team2Names, (String)"team2Names");
        GymData gymData = GymManager.INSTANCE.getGymConfig().getGym(arenaId);
        if (gymData == null) {
            initiator.method_43496((class_2561)class_2561.method_43470((String)"Arene introuvable!").method_27694(DuelManager::createInvitation$lambda$0));
            return null;
        }
        if (gymData.getRequiredBadge() != null) {
            Object playerName;
            Object profile;
            allPlayerIds = CollectionsKt.plus((Collection)team1Ids, (Iterable)team2Ids);
            List playersWithoutBadge = new ArrayList();
            int n = ((Collection)allPlayerIds).size();
            for (int i = 0; i < n; ++i) {
                String string;
                boolean hasBadge;
                UUID playerId = (UUID)allPlayerIds.get(i);
                profile = PlayerProfileManager.INSTANCE.getProfile(playerId);
                Object object = profile;
                boolean bl = object != null && (object = ((PlayerProfile)object).getBadges()) != null && (object = ((BadgeCollection)object).getBadgeById(gymData.getRequiredBadge())) != null ? ((Badge)object).getObtained() : (hasBadge = false);
                if (hasBadge) continue;
                if (team1Ids.contains(playerId)) {
                    String string2;
                    idx = team1Ids.indexOf(playerId);
                    var19_29 = team1Names;
                    boolean bl2 = 0 <= idx ? idx < var19_29.size() : false;
                    if (bl2) {
                        string2 = var19_29.get(idx);
                    } else {
                        it = idx;
                        boolean bl3 = false;
                        string2 = "Joueur inconnu";
                    }
                    string = string2;
                } else {
                    String string3;
                    idx = team2Ids.indexOf(playerId);
                    var19_29 = team2Names;
                    boolean bl4 = 0 <= idx ? idx < var19_29.size() : false;
                    if (bl4) {
                        string3 = var19_29.get(idx);
                    } else {
                        it = idx;
                        boolean bl5 = false;
                        string3 = "Joueur inconnu";
                    }
                    string = string3;
                }
                playerName = string;
                playersWithoutBadge.add(playerName);
            }
            if (!((Collection)playersWithoutBadge).isEmpty()) {
                Object object;
                Object v7;
                block15: {
                    profile = GymManager.INSTANCE.getGymConfig().getGyms();
                    Iterator hasBadge = profile.iterator();
                    while (hasBadge.hasNext()) {
                        playerName = hasBadge.next();
                        GymData it = (GymData)playerName;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getBadgeId(), (Object)gymData.getRequiredBadge())) continue;
                        v7 = playerName;
                        break block15;
                    }
                    v7 = null;
                }
                GymData gymData2 = v7;
                String requiredBadgeName = gymData2 != null && (object = gymData2.getBadgeName()) != null ? object : gymData.getRequiredBadge();
                initiator.method_43496((class_2561)class_2561.method_43470((String)"Impossible de duel dans cette arene!").method_27694(DuelManager::createInvitation$lambda$4));
                initiator.method_43496((class_2561)class_2561.method_43470((String)("Badge manquant (" + requiredBadgeName + "): " + CollectionsKt.joinToString$default((Iterable)playersWithoutBadge, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null))).method_27694(DuelManager::createInvitation$lambda$5));
                return null;
            }
        }
        if (!this.isArenaAvailable(arenaId)) {
            initiator.method_43496((class_2561)class_2561.method_43470((String)"Cette arene n'est plus disponible!").method_27694(DuelManager::createInvitation$lambda$6));
            return null;
        }
        allPlayerIds = CollectionsKt.plus((Collection)team1Ids, (Iterable)team2Ids);
        for (UUID playerId : allPlayerIds) {
            class_3222 player;
            if (Intrinsics.areEqual((Object)playerId, (Object)initiator.method_5667())) continue;
            MinecraftServer minecraftServer = server;
            class_3222 class_32222 = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : (player = null);
            if (player == null) {
                initiator.method_43496((class_2561)class_2561.method_43470((String)"Un joueur n'est plus en ligne!").method_27694(DuelManager::createInvitation$lambda$7));
                return null;
            }
            if (this.canPlayerDuel(player)) continue;
            initiator.method_43496((class_2561)class_2561.method_43470((String)(player.method_5477().getString() + " n'est pas disponible pour un duel!")).method_27694(DuelManager::createInvitation$lambda$8));
            return null;
        }
        UUID uUID = initiator.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        String string = initiator.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        DuelInvitation invitation = new DuelInvitation(null, mode, bestOf, arenaId, uUID, string, team1Ids, team1Names, team2Ids, team2Names, null, 0L, this.getConfig().getInvitationTimeoutSeconds(), 3073, null);
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Creating invitation: id=" + invitation.getInvitationId() + ", timeout=" + this.getConfig().getInvitationTimeoutSeconds() + "s, invited=" + invitation.getAllInvitedPlayerIds());
        Map playerId = pendingInvitations;
        playerId.put(invitation.getInvitationId(), invitation);
        Iterable $this$forEach$iv = invitation.getAllInvitedPlayerIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID playerId2 = (UUID)element$iv;
            boolean bl = false;
            ((Map)playerPendingInvite).put(playerId2, invitation.getInvitationId());
        }
        this.sendInvitationMessages(invitation);
        Set<UUID> set = invitation.getAcceptedPlayers();
        UUID uUID2 = initiator.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        set.add(uUID2);
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Duel invitation created: " + invitation.getInvitationId());
        return invitation;
    }

    private final void sendInvitationMessages(DuelInvitation invitation) {
        String modeText = invitation.getMode() == DuelMode.DUEL_1V1 ? "1v1" : "2v2";
        Object object = GymManager.INSTANCE.getGymConfig().getGym(invitation.getArenaId());
        if (object == null || (object = ((GymData)object).getGymName()) == null) {
            object = invitation.getArenaId();
        }
        Object arenaName = object;
        Iterable $this$forEach$iv = invitation.getAllInvitedPlayerIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID playerId = (UUID)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(playerId)) == null) continue;
            MinecraftServer player = minecraftServer;
            player.method_43496((class_2561)class_2561.method_43473());
            player.method_43496((class_2561)class_2561.method_43470((String)"=== INVITATION DUEL ===").method_27694(DuelManager::sendInvitationMessages$lambda$0$0));
            player.method_43496((class_2561)class_2561.method_43470((String)(invitation.getInitiatorName() + " vous invite a un duel " + modeText + " " + invitation.getBestOf().getDisplayName() + "!")).method_27694(DuelManager::sendInvitationMessages$lambda$0$1));
            player.method_43496((class_2561)class_2561.method_43470((String)("Arene: " + (String)arenaName)).method_27694(DuelManager::sendInvitationMessages$lambda$0$2));
            if (invitation.getMode() == DuelMode.DUEL_2V2) {
                player.method_43496((class_2561)class_2561.method_43470((String)("Equipe 1: " + CollectionsKt.joinToString$default((Iterable)invitation.getTeam1PlayerNames(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null))).method_27694(DuelManager::sendInvitationMessages$lambda$0$3));
                player.method_43496((class_2561)class_2561.method_43470((String)("Equipe 2: " + CollectionsKt.joinToString$default((Iterable)invitation.getTeam2PlayerNames(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null))).method_27694(DuelManager::sendInvitationMessages$lambda$0$4));
            }
            class_5250 acceptButton = class_2561.method_43470((String)"[ACCEPTER]").method_27696(class_2583.field_24360.method_36139(0x55FF55).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/duel accept \"" + invitation.getInvitationId() + "\"")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Cliquez pour accepter"))));
            class_5250 declineButton = class_2561.method_43470((String)"[REFUSER]").method_27696(class_2583.field_24360.method_36139(0xFF5555).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/duel decline \"" + invitation.getInvitationId() + "\"")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Cliquez pour refuser"))));
            player.method_43496((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)acceptButton).method_10852((class_2561)class_2561.method_43470((String)"  ")).method_10852((class_2561)declineButton));
            player.method_43496((class_2561)class_2561.method_43473());
        }
    }

    public final boolean acceptInvitation(@NotNull class_3222 player, @NotNull UUID invitationId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)invitationId, (String)"invitationId");
        PokemonLeagueMod.INSTANCE.getLOGGER().info("acceptInvitation called: player=" + player.method_5477().getString() + ", invitationId=" + invitationId);
        DuelInvitation invitation = pendingInvitations.get(invitationId);
        if (invitation == null) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Invitation not found in pendingInvitations. Keys: " + pendingInvitations.keySet());
            player.method_43496((class_2561)class_2561.method_43470((String)"Cette invitation n'existe plus!").method_27694(DuelManager::acceptInvitation$lambda$0));
            return false;
        }
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Invitation found: createdAt=" + invitation.getCreatedAt() + ", timeout=" + invitation.getTimeoutSeconds() + "s, isExpired=" + invitation.isExpired());
        if (invitation.isExpired()) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Cette invitation a expire!").method_27694(DuelManager::acceptInvitation$lambda$1));
            this.cancelInvitation(invitationId, "Invitation expiree");
            return false;
        }
        List<UUID> invitedIds = invitation.getAllInvitedPlayerIds();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Invited players: " + invitedIds + ", checking if " + player.method_5667() + " is in list");
        if (!invitedIds.contains(player.method_5667())) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Vous n'etes pas invite a ce duel!").method_27694(DuelManager::acceptInvitation$lambda$2));
            return false;
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        invitation.accept(uUID);
        playerPendingInvite.remove(player.method_5667());
        player.method_43496((class_2561)class_2561.method_43470((String)"Vous avez accepte l'invitation!").method_27694(DuelManager::acceptInvitation$lambda$3));
        class_5250 class_52502 = class_2561.method_43470((String)(player.method_5477().getString() + " a accepte l'invitation!")).method_27694(DuelManager::acceptInvitation$lambda$4);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
        this.notifyAllInvitationPlayers(invitation, (class_2561)class_52502);
        if (invitation.allAccepted()) {
            this.startDuelFromInvitation(invitation);
        }
        return true;
    }

    public final boolean declineInvitation(@NotNull class_3222 player, @NotNull UUID invitationId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)invitationId, (String)"invitationId");
        DuelInvitation invitation = pendingInvitations.get(invitationId);
        if (invitation == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Cette invitation n'existe plus!").method_27694(DuelManager::declineInvitation$lambda$0));
            return false;
        }
        player.method_43496((class_2561)class_2561.method_43470((String)"Vous avez refuse l'invitation.").method_27694(DuelManager::declineInvitation$lambda$1));
        this.cancelInvitation(invitationId, player.method_5477().getString() + " a refuse l'invitation");
        return true;
    }

    public final void cancelInvitation(@NotNull UUID invitationId, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)invitationId, (String)"invitationId");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        DuelInvitation duelInvitation = pendingInvitations.remove(invitationId);
        if (duelInvitation == null) {
            return;
        }
        DuelInvitation invitation = duelInvitation;
        Iterable $this$forEach$iv = invitation.getAllInvitedPlayerIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID playerId = (UUID)element$iv;
            boolean bl = false;
            playerPendingInvite.remove(playerId);
        }
        class_5250 class_52502 = class_2561.method_43470((String)("Invitation annulee: " + reason)).method_27694(DuelManager::cancelInvitation$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
        this.notifyAllInvitationPlayers(invitation, (class_2561)class_52502);
    }

    private final void notifyAllInvitationPlayers(DuelInvitation invitation, class_2561 message) {
        List allIds = CollectionsKt.plus((Collection)invitation.getTeam1PlayerIds(), (Iterable)invitation.getTeam2PlayerIds());
        Iterable $this$forEach$iv = allIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID playerId = (UUID)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(playerId)) == null) continue;
            minecraftServer.method_43496(message);
        }
    }

    private final void startDuelFromInvitation(DuelInvitation invitation) {
        MinecraftServer player;
        UUID playerId;
        int index;
        int n;
        pendingInvitations.remove(invitation.getInvitationId());
        Iterable $this$forEach$iv = invitation.getAllInvitedPlayerIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Iterator playerId2 = (UUID)element$iv;
            boolean bl = false;
            playerPendingInvite.remove(playerId2);
        }
        if (!this.isArenaAvailable(invitation.getArenaId())) {
            class_5250 class_52502 = class_2561.method_43470((String)"L'arene n'est plus disponible!").method_27694(DuelManager::startDuelFromInvitation$lambda$1);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
            this.notifyAllInvitationPlayers(invitation, (class_2561)class_52502);
            return;
        }
        DuelSession session = new DuelSession(null, invitation.getMode(), invitation.getBestOf(), invitation.getArenaId(), null, null, 0L, 0, 0, 0, null, false, 4081, null);
        Iterable $this$forEachIndexed$iv = invitation.getTeam1PlayerIds();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            UUID uUID = (UUID)item$iv;
            index = n;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(playerId)) == null) continue;
            player = minecraftServer;
            List<DuelPlayer> list = session.getTeam1();
            String string = playerId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = player.method_37908().method_27983().method_29177().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            list.add(new DuelPlayer(string, invitation.getTeam1PlayerNames().get(index), string2, player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455(), true, 0, 512, null));
        }
        $this$forEachIndexed$iv = invitation.getTeam2PlayerIds();
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            playerId = (UUID)item$iv;
            index = n;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(playerId)) == null) continue;
            player = minecraftServer;
            List<DuelPlayer> list = session.getTeam2();
            String string = playerId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string3 = player.method_37908().method_27983().method_29177().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            list.add(new DuelPlayer(string, invitation.getTeam2PlayerNames().get(index), string3, player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455(), true, 0, 512, null));
        }
        ((Map)activeSessions).put(session.getSessionId(), session);
        Iterable $this$forEach$iv2 = session.getAllPlayerIds();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            UUID playerId3 = (UUID)element$iv;
            boolean bl = false;
            ((Map)playerToSession).put(playerId3, session.getSessionId());
        }
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Duel session started: " + session.getSessionId());
        $this$forEach$iv2 = session.getAllPlayerIds();
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            UUID playerId4 = (UUID)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            class_3222 player2 = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId4) : null;
            if (player2 == null) continue;
            String string = player2.method_5477().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            int totalDuels = PlayerProfileManager.INSTANCE.recordDuelStarted(playerId4, string);
            FTBQuestsIntegration.INSTANCE.checkAndCompleteDuelQuests(player2, totalDuels);
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Player " + player2.method_5477().getString() + " has started " + totalDuels + " duels total");
        }
        this.teleportPlayersToArena(session);
        this.startCountdown(session);
    }

    private final void teleportPlayersToArena(DuelSession session) {
        GymData gymData = GymManager.INSTANCE.getGymConfig().getGym(session.getArenaId());
        if (gymData == null) {
            return;
        }
        GymData gymData2 = gymData;
        Position team1Spawn = gymData2.getPlayerSpawnPosition();
        Iterable $this$forEach$iv = session.getTeam1();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DuelPlayer duelPlayer = (DuelPlayer)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(duelPlayer.getUUID())) == null) continue;
            MinecraftServer player = minecraftServer;
            InventoryManager.INSTANCE.saveAndClearInventory((class_3222)player);
            INSTANCE.teleportToPosition((class_3222)player, team1Spawn);
        }
        Position team2Spawn = gymData2.getNpcSpawnPosition();
        Iterable $this$forEach$iv2 = session.getTeam2();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            DuelPlayer duelPlayer = (DuelPlayer)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            if (minecraftServer == null || (minecraftServer = minecraftServer.method_3760()) == null || (minecraftServer = minecraftServer.method_14602(duelPlayer.getUUID())) == null) continue;
            MinecraftServer player = minecraftServer;
            InventoryManager.INSTANCE.saveAndClearInventory((class_3222)player);
            INSTANCE.teleportToPosition((class_3222)player, team2Spawn);
        }
    }

    private final void startCountdown(DuelSession session) {
        session.setState(DuelState.COUNTDOWN);
        int countdownSeconds = this.getConfig().getCountdownSeconds();
        DuelManager.startCountdown$countdown(session, countdownSeconds);
    }

    /*
     * WARNING - void declaration
     */
    private final void startBattle(DuelSession session) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        Object element$iv2;
        session.setState(DuelState.IN_BATTLE);
        session.setInBattle(true);
        String modeText = session.getMode() == DuelMode.DUEL_1V1 ? "1v1" : "2v2";
        Iterable $this$forEach$iv = session.getAllPlayerIds();
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            class_3222 player;
            UUID playerId = (UUID)element$iv2;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            class_3222 class_32222 = player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
            if (class_32222 != null) {
                class_32222.method_43496((class_2561)class_2561.method_43470((String)("=== COMBAT " + modeText + " - Match " + session.getCurrentMatch() + " ===")).method_27694(DuelManager::startBattle$lambda$0$0));
            }
            class_3222 class_32223 = player;
            if (class_32223 == null) continue;
            class_32223.method_43496((class_2561)class_2561.method_43470((String)"Les items sont desactives dans les duels!").method_27694(DuelManager::startBattle$lambda$0$1));
        }
        Iterable $this$mapNotNull$iv = session.getTeam1();
        boolean $i$f$mapNotNull = false;
        element$iv2 = $this$mapNotNull$iv;
        Iterable<class_3222> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            class_3222 it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DuelPlayer it = (DuelPlayer)element$iv$iv;
            boolean bl2 = false;
            MinecraftServer minecraftServer = server;
            if ((minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(it.getUUID()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List team1Players = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv2 = session.getTeam2();
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            class_3222 it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            DuelPlayer it = (DuelPlayer)element$iv$iv;
            boolean bl4 = false;
            MinecraftServer minecraftServer = server;
            if ((minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(it.getUUID()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List team2Players = (List)destination$iv$iv2;
        if (team1Players.isEmpty() || team2Players.isEmpty()) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Not enough players to start duel battle");
            this.endSession(session.getSessionId(), true);
            return;
        }
        try {
            if (session.getMode() == DuelMode.DUEL_1V1) {
                this.start1v1Battle(session, (class_3222)team1Players.get(0), (class_3222)team2Players.get(0));
            } else {
                this.start2v2Battle(session, team1Players, team2Players);
            }
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to start duel battle", (Throwable)e);
            this.endSession(session.getSessionId(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void start1v1Battle(DuelSession session, class_3222 player1, class_3222 player2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Pokemon it;
        void $this$filterTo$iv$iv2;
        PlayerPartyStore party1 = Cobblemon.INSTANCE.getStorage().getParty(player1);
        PlayerPartyStore party2 = Cobblemon.INSTANCE.getStorage().getParty(player2);
        Iterable $this$filter$iv = (Iterable)party1;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (Pokemon)element$iv$iv;
            boolean bl = false;
            if (!(!it.isFainted())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (Pokemon)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BattlePokemon.Companion.playerOwned(it));
        }
        List pokemon1 = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = (Iterable)party2;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        BattleActor[] destination$iv$iv2 = (BattleActor[])new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pokemon it2 = (Pokemon)element$iv$iv;
            boolean bl = false;
            if (!(!it2.isFainted())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pokemon it2 = (Pokemon)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(BattlePokemon.Companion.playerOwned(it2));
        }
        List pokemon2 = (List)destination$iv$iv2;
        if (pokemon1.isEmpty() || pokemon2.isEmpty()) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Players don't have valid Pokemon for duel");
            this.endSession(session.getSessionId(), true);
            return;
        }
        UUID uUID = player1.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PlayerBattleActor actor1 = new PlayerBattleActor(uUID, pokemon1);
        UUID uUID2 = player2.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        PlayerBattleActor actor2 = new PlayerBattleActor(uUID2, pokemon2);
        destination$iv$iv2 = new BattleActor[]{actor1};
        BattleSide side1 = new BattleSide(destination$iv$iv2);
        BattleActor[] $i$f$mapTo22 = new BattleActor[]{actor2};
        BattleSide side2 = new BattleSide($i$f$mapTo22);
        BattleFormat format = BattleFormat.Companion.getGEN_9_SINGLES();
        Set originalRuleSet = format.getRuleSet();
        format.setRuleSet(SetsKt.plus((Set)originalRuleSet, (Object)"Bag Clause"));
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Starting 1v1 duel with Bag Clause. RuleSet: " + format.getRuleSet());
        try {
            BattleStartResult result = BattleRegistry.startBattle((BattleFormat)format, (BattleSide)side1, (BattleSide)side2, (boolean)false);
            result.ifErrored(arg_0 -> DuelManager.start1v1Battle$lambda$4(session, arg_0));
            result.ifSuccessful(DuelManager::start1v1Battle$lambda$5);
        }
        finally {
            format.setRuleSet(originalRuleSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void start2v2Battle(DuelSession session, List<? extends class_3222> team1Players, List<? extends class_3222> team2Players) {
        BattleActor[] party;
        Collection collection;
        Iterable<BattlePokemon> destination$iv$iv;
        List team1Actors = new ArrayList();
        for (class_3222 class_32222 : team1Players) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl;
            Pokemon it;
            void $this$filterTo$iv$iv;
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(class_32222);
            Iterable $this$filter$iv = (Iterable)playerPartyStore;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Pokemon)element$iv$iv;
                bl = false;
                if (!(!it.isFainted())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Pokemon)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                collection.add((BattlePokemon)BattlePokemon.Companion.playerOwned(it));
            }
            List pokemon = (List)destination$iv$iv;
            if (pokemon.isEmpty()) {
                PokemonLeagueMod.INSTANCE.getLOGGER().error("Player " + class_32222.method_5477().getString() + " has no healthy Pokemon for 2v2 duel");
                this.endSession(session.getSessionId(), true);
                return;
            }
            UUID uUID = class_32222.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            team1Actors.add(new PlayerBattleActor(uUID, pokemon));
        }
        List team2Actors = new ArrayList();
        for (class_3222 class_32223 : team2Players) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl;
            Pokemon it;
            void $this$filterTo$iv$iv;
            party = Cobblemon.INSTANCE.getStorage().getParty(class_32223);
            Iterable $this$filter$iv = (Iterable)party;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Pokemon)element$iv$iv;
                bl = false;
                if (!(!it.isFainted())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Pokemon)item$iv$iv;
                collection = destination$iv$iv3;
                bl = false;
                collection.add(BattlePokemon.Companion.playerOwned(it));
            }
            List pokemon = (List)destination$iv$iv3;
            if (pokemon.isEmpty()) {
                PokemonLeagueMod.INSTANCE.getLOGGER().error("Player " + class_32223.method_5477().getString() + " has no healthy Pokemon for 2v2 duel");
                this.endSession(session.getSessionId(), true);
                return;
            }
            UUID uUID = class_32223.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            team2Actors.add(new PlayerBattleActor(uUID, pokemon));
        }
        if (team1Actors.size() != 2 || team2Actors.size() != 2) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Not enough players for 2v2 duel: team1=" + team1Actors.size() + ", team2=" + team2Actors.size());
            this.endSession(session.getSessionId(), true);
            return;
        }
        BattleActor[] battleActorArray = new BattleActor[]{team1Actors.get(0), team1Actors.get(1)};
        BattleSide battleSide = new BattleSide(battleActorArray);
        party = new BattleActor[]{team2Actors.get(0), team2Actors.get(1)};
        BattleSide battleSide2 = new BattleSide(party);
        BattleFormat format = BattleFormat.Companion.getGEN_9_MULTI();
        Set originalRuleSet = format.getRuleSet();
        format.setRuleSet(SetsKt.plus((Set)originalRuleSet, (Object)"Bag Clause"));
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Starting 2v2 duel with Bag Clause. RuleSet: " + format.getRuleSet());
        try {
            BattleStartResult result = BattleRegistry.startBattle((BattleFormat)format, (BattleSide)battleSide, (BattleSide)battleSide2, (boolean)false);
            result.ifErrored(arg_0 -> DuelManager.start2v2Battle$lambda$4(session, arg_0));
            result.ifSuccessful(DuelManager::start2v2Battle$lambda$5);
        }
        finally {
            format.setRuleSet(originalRuleSet);
        }
    }

    public final void handleBattleResult(@NotNull List<UUID> winnerIds, @NotNull List<UUID> loserIds) {
        class_3222 player;
        int winningTeam;
        boolean bl;
        DuelSession session;
        block20: {
            Object object;
            Object object2;
            block18: {
                Intrinsics.checkNotNullParameter(winnerIds, (String)"winnerIds");
                Intrinsics.checkNotNullParameter(loserIds, (String)"loserIds");
                for (Object it : (Iterable)winnerIds) {
                    boolean bl2 = false;
                    if ((it = playerToSession.get(it)) == null) continue;
                    object2 = it;
                    break block18;
                }
                object2 = object = null;
            }
            if (object2 == null) {
                Object object3;
                block19: {
                    for (UUID it : (Iterable)loserIds) {
                        boolean bl3 = false;
                        if ((it = playerToSession.get(it)) == null) continue;
                        object3 = it;
                        break block19;
                    }
                    object3 = object = null;
                }
                if (object3 == null) {
                    return;
                }
            }
            Object sessionId = object;
            DuelSession duelSession = activeSessions.get(sessionId);
            if (duelSession == null) {
                return;
            }
            session = duelSession;
            if (!session.getInBattle()) {
                return;
            }
            session.setInBattle(false);
            Iterable $this$any$iv = winnerIds;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UUID it = (UUID)element$iv;
                    boolean bl4 = false;
                    if (!session.isInTeam1(it)) continue;
                    bl = true;
                    break block20;
                }
                bl = false;
            }
        }
        int n = winningTeam = bl ? 1 : 2;
        if (winningTeam == 1) {
            $this$any$iv = session.getTeam1Wins();
            session.setTeam1Wins($this$any$iv + 1);
        } else {
            $this$any$iv = session.getTeam2Wins();
            session.setTeam2Wins($this$any$iv + 1);
        }
        Iterable $this$forEach$iv = session.getAllPlayerIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID playerId = (UUID)element$iv;
            boolean bl5 = false;
            MinecraftServer minecraftServer = server;
            class_3222 player2 = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
            if (player2 == null) continue;
            INSTANCE.recallAllPokemon(player2);
        }
        String winningTeamName = winningTeam == 1 ? "Equipe 1 (Bleu)" : "Equipe 2 (Rouge)";
        Iterable $this$forEach$iv22 = session.getAllPlayerIds();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv22) {
            UUID playerId = (UUID)element$iv;
            boolean bl6 = false;
            MinecraftServer minecraftServer = server;
            class_3222 class_32222 = player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
            if (class_32222 != null) {
                class_32222.method_43496((class_2561)class_2561.method_43470((String)(winningTeamName + " remporte le match " + session.getCurrentMatch() + "!")).method_27694(arg_0 -> DuelManager.handleBattleResult$lambda$4$0(winningTeam, arg_0)));
            }
            class_3222 class_32223 = player;
            if (class_32223 == null) continue;
            class_32223.method_43496((class_2561)class_2561.method_43470((String)("Score: " + session.getScoreString())).method_27694(DuelManager::handleBattleResult$lambda$4$1));
        }
        if (session.isSeriesOver()) {
            this.handleSeriesEnd(session);
        } else {
            int $this$forEach$iv22 = session.getCurrentMatch();
            session.setCurrentMatch($this$forEach$iv22 + 1);
            session.setState(DuelState.BETWEEN_MATCHES);
            Iterable $this$forEach$iv23 = session.getAllPlayerIds();
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv23) {
                UUID playerId = (UUID)element$iv;
                boolean bl7 = false;
                MinecraftServer minecraftServer = server;
                class_3222 class_32224 = player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
                if (class_32224 == null) continue;
                class_32224.method_43496((class_2561)class_2561.method_43470((String)"Prochain match dans 5 secondes...").method_27694(DuelManager::handleBattleResult$lambda$5$0));
            }
            $this$forEach$iv23 = session.getAllPlayerIds();
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv23) {
                UUID playerId = (UUID)element$iv;
                boolean bl8 = false;
                MinecraftServer minecraftServer = server;
                player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
                if (player == null) continue;
                Cobblemon.INSTANCE.getStorage().getParty(player).heal();
            }
            SchedulingFunctionsKt.afterOnServer((float)5.0f, () -> DuelManager.handleBattleResult$lambda$7(session));
        }
    }

    private final void handleSeriesEnd(DuelSession session) {
        DuelPlayer duelPlayer;
        session.setState(DuelState.FINISHED);
        Integer n = session.getWinningTeam();
        Intrinsics.checkNotNull((Object)n);
        int winningTeam = n;
        List<DuelPlayer> winningPlayers = winningTeam == 1 ? session.getTeam1() : session.getTeam2();
        List<DuelPlayer> losingPlayers = winningTeam == 1 ? session.getTeam2() : session.getTeam1();
        Iterable $this$forEach$iv = winningPlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            duelPlayer = (DuelPlayer)element$iv;
            boolean bl = false;
            PlayerProfileManager.INSTANCE.recordDuelWin(duelPlayer.getUUID(), duelPlayer.getPlayerName(), session.getMode());
        }
        $this$forEach$iv = losingPlayers;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            duelPlayer = (DuelPlayer)element$iv;
            boolean bl = false;
            PlayerProfileManager.INSTANCE.recordDuelLoss(duelPlayer.getUUID(), duelPlayer.getPlayerName(), session.getMode());
        }
        $this$forEach$iv = session.getAllPlayerIds();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID playerId = (UUID)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            class_3222 player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
            if (player == null) continue;
            Cobblemon.INSTANCE.getStorage().getParty(player).heal();
        }
        String winnerNames = CollectionsKt.joinToString$default((Iterable)winningPlayers, (CharSequence)", ", null, null, (int)0, null, DuelManager::handleSeriesEnd$lambda$3, (int)30, null);
        Iterable $this$forEach$iv2 = session.getAllPlayerIds();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            class_3222 player;
            UUID playerId = (UUID)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            class_3222 class_32222 = player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
            if (class_32222 != null) {
                class_32222.method_43496((class_2561)class_2561.method_43473());
            }
            class_3222 class_32223 = player;
            if (class_32223 != null) {
                class_32223.method_43496((class_2561)class_2561.method_43470((String)"=== FIN DU DUEL ===").method_27694(DuelManager::handleSeriesEnd$lambda$4$0));
            }
            class_3222 class_32224 = player;
            if (class_32224 != null) {
                class_32224.method_43496((class_2561)class_2561.method_43470((String)("Vainqueur(s): " + winnerNames)).method_27694(DuelManager::handleSeriesEnd$lambda$4$1));
            }
            class_3222 class_32225 = player;
            if (class_32225 != null) {
                class_32225.method_43496((class_2561)class_2561.method_43470((String)("Score final: " + session.getScoreString())).method_27694(DuelManager::handleSeriesEnd$lambda$4$2));
            }
            class_3222 class_32226 = player;
            if (class_32226 == null) continue;
            class_32226.method_43496((class_2561)class_2561.method_43473());
        }
        SchedulingFunctionsKt.afterOnServer((float)5.0f, () -> DuelManager.handleSeriesEnd$lambda$5(session));
    }

    /*
     * WARNING - void declaration
     */
    private final void teleportPlayersBack(DuelSession session) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        PokemonLeagueMod.INSTANCE.getLOGGER().info("teleportPlayersBack called for session " + session.getSessionId());
        Iterable iterable = session.getAllPlayers();
        Logger logger = PokemonLeagueMod.INSTANCE.getLOGGER();
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DuelPlayer duelPlayer = (DuelPlayer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPlayerName());
        }
        logger.info("Players to teleport: " + (List)destination$iv$iv);
        Iterable $this$forEach$iv = session.getAllPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            class_3222 player;
            DuelPlayer duelPlayer;
            block9: {
                block8: {
                    Object v3;
                    block7: {
                        duelPlayer = (DuelPlayer)element$iv;
                        boolean bl = false;
                        PokemonLeagueMod.INSTANCE.getLOGGER().info("Attempting to teleport " + duelPlayer.getPlayerName() + " to world=" + duelPlayer.getOriginalWorld() + ", x=" + duelPlayer.getOriginalX() + ", y=" + duelPlayer.getOriginalY() + ", z=" + duelPlayer.getOriginalZ());
                        MinecraftServer minecraftServer = server;
                        class_3222 class_32222 = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(duelPlayer.getUUID()) : (player = null);
                        if (player == null) {
                            PokemonLeagueMod.INSTANCE.getLOGGER().warn("Player " + duelPlayer.getPlayerName() + " (" + duelPlayer.getPlayerId() + ") not found on server!");
                            continue;
                        }
                        class_2960 worldKey = class_2960.method_12829((String)duelPlayer.getOriginalWorld());
                        object = server;
                        if (object == null || (object = object.method_29435()) == null) break block8;
                        Iterable iterable2 = (Iterable)object;
                        for (Object t : iterable2) {
                            class_5321 it = (class_5321)t;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.method_29177(), (Object)worldKey)) continue;
                            v3 = t;
                            break block7;
                        }
                        v3 = null;
                    }
                    if ((object = (class_5321)v3) == null) break block8;
                    Object it = object;
                    boolean bl = false;
                    MinecraftServer minecraftServer = server;
                    Object object2 = minecraftServer != null ? minecraftServer.method_3847((class_5321)it) : null;
                    object = object2;
                    if (object2 != null) break block9;
                }
                object = player.method_51469();
            }
            Object level = object;
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Teleporting " + duelPlayer.getPlayerName() + " to level=" + level.method_27983().method_29177());
            player.method_14251((class_3218)level, duelPlayer.getOriginalX(), duelPlayer.getOriginalY(), duelPlayer.getOriginalZ(), duelPlayer.getOriginalYaw(), duelPlayer.getOriginalPitch());
            InventoryManager.INSTANCE.restoreInventory(player);
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Teleport complete for " + duelPlayer.getPlayerName());
        }
    }

    public final void endSession(@NotNull UUID sessionId, boolean cancelled) {
        UUID playerId;
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        DuelSession duelSession = activeSessions.remove(sessionId);
        if (duelSession == null) {
            return;
        }
        DuelSession session = duelSession;
        Iterable $this$forEach$iv = session.getAllPlayerIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            playerId = (UUID)element$iv;
            boolean bl = false;
            playerToSession.remove(playerId);
        }
        DuelSpectatorManager.INSTANCE.endAllSpectators(sessionId);
        if (cancelled) {
            this.teleportPlayersBack(session);
            $this$forEach$iv = session.getAllPlayerIds();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3222 player;
                playerId = (UUID)element$iv;
                boolean bl = false;
                MinecraftServer minecraftServer = server;
                class_3222 class_32222 = player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
                if (class_32222 != null) {
                    class_32222.method_43496((class_2561)class_2561.method_43470((String)"Le duel a ete annule.").method_27694(DuelManager::endSession$lambda$1$0));
                }
            }
        }
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Duel session ended: " + sessionId + " (cancelled: " + cancelled + ")");
    }

    public final void playerQuit(@NotNull class_3222 player) {
        DuelPlayer duelPlayer;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        DuelSession duelSession = this.getPlayerSession(uUID);
        if (duelSession == null) {
            return;
        }
        DuelSession session = duelSession;
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        Integer n = session.getPlayerTeam(uUID2);
        if (n == null) {
            return;
        }
        int quittingTeam = n;
        Iterable $this$forEach$iv = session.getAllPlayerIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 p;
            UUID playerId = (UUID)element$iv;
            boolean bl = false;
            MinecraftServer minecraftServer = server;
            class_3222 class_32222 = p = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
            if (class_32222 == null) continue;
            class_32222.method_43496((class_2561)class_2561.method_43470((String)(player.method_5477().getString() + " a abandonne le duel!")).method_27694(DuelManager::playerQuit$lambda$0$0));
        }
        List<DuelPlayer> winningPlayers = quittingTeam == 1 ? session.getTeam2() : session.getTeam1();
        List<DuelPlayer> losingPlayers = quittingTeam == 1 ? session.getTeam1() : session.getTeam2();
        Iterable $this$forEach$iv2 = winningPlayers;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            duelPlayer = (DuelPlayer)element$iv;
            boolean bl = false;
            PlayerProfileManager.INSTANCE.recordDuelWin(duelPlayer.getUUID(), duelPlayer.getPlayerName(), session.getMode());
        }
        $this$forEach$iv2 = losingPlayers;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            duelPlayer = (DuelPlayer)element$iv;
            boolean bl = false;
            PlayerProfileManager.INSTANCE.recordDuelLoss(duelPlayer.getUUID(), duelPlayer.getPlayerName(), session.getMode());
        }
        this.teleportPlayersBack(session);
        this.endSession(session.getSessionId(), false);
    }

    public final void handlePlayerDisconnect(@NotNull class_3222 player) {
        UUID inviteId;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        if (InventoryManager.INSTANCE.hasSavedInventory(uUID)) {
            InventoryManager.INSTANCE.restoreInventory(player);
        }
        if ((inviteId = playerPendingInvite.remove(player.method_5667())) != null) {
            this.cancelInvitation(inviteId, player.method_5477().getString() + " s'est deconnecte");
        }
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        DuelSession session = this.getPlayerSession(uUID2);
        if (session != null) {
            this.playerQuit(player);
        }
    }

    private final void teleportToPosition(class_3222 player, Position position) {
        Object object;
        block6: {
            block5: {
                Object v1;
                block4: {
                    class_2960 worldKey = class_2960.method_12829((String)position.getWorld());
                    object = server;
                    if (object == null || (object = object.method_29435()) == null) break block5;
                    Iterable iterable = (Iterable)object;
                    for (Object t : iterable) {
                        class_5321 it = (class_5321)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.method_29177(), (Object)worldKey)) continue;
                        v1 = t;
                        break block4;
                    }
                    v1 = null;
                }
                if ((object = (class_5321)v1) == null) break block5;
                Object it = object;
                boolean bl = false;
                MinecraftServer minecraftServer = server;
                Object object2 = minecraftServer != null ? minecraftServer.method_3847((class_5321)it) : null;
                object = object2;
                if (object2 != null) break block6;
            }
            object = player.method_51469();
        }
        Object level = object;
        player.method_14251((class_3218)level, position.getX(), position.getY(), position.getZ(), position.getYaw(), position.getPitch());
    }

    private final void recallAllPokemon(class_3222 player) {
        try {
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            Iterable $this$forEach$iv = (Iterable)party;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pokemon pokemon = (Pokemon)element$iv;
                boolean bl = false;
                Object object = pokemon.getEntity();
                if (object != null && (object = object.recallWithAnimation()) != null) continue;
                pokemon.recall();
                object = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to recall Pokemon", (Throwable)e);
        }
    }

    @Nullable
    public final DuelInvitation getPendingInvitation(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        UUID uUID = playerPendingInvite.get(playerId);
        if (uUID == null) {
            return null;
        }
        UUID inviteId = uUID;
        return pendingInvitations.get(inviteId);
    }

    @NotNull
    public final Collection<DuelSession> getActiveSessions() {
        Collection<DuelSession> collection = activeSessions.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    private static final Unit startExpirationChecker$lambda$0() {
        INSTANCE.checkExpiredInvitations();
        if (server != null) {
            INSTANCE.startExpirationChecker();
        }
        return Unit.INSTANCE;
    }

    private static final class_2583 createInvitation$lambda$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 createInvitation$lambda$4(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 createInvitation$lambda$5(class_2583 it) {
        return it.method_36139(0xFFAA00);
    }

    private static final class_2583 createInvitation$lambda$6(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 createInvitation$lambda$7(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 createInvitation$lambda$8(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 sendInvitationMessages$lambda$0$0(class_2583 it) {
        return it.method_36139(0xFFAA00).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 sendInvitationMessages$lambda$0$1(class_2583 it) {
        return it.method_36139(0xFFFFFF);
    }

    private static final class_2583 sendInvitationMessages$lambda$0$2(class_2583 it) {
        return it.method_36139(0xAAAAAA);
    }

    private static final class_2583 sendInvitationMessages$lambda$0$3(class_2583 it) {
        return it.method_36139(0x5555FF);
    }

    private static final class_2583 sendInvitationMessages$lambda$0$4(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 acceptInvitation$lambda$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 acceptInvitation$lambda$1(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 acceptInvitation$lambda$2(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 acceptInvitation$lambda$3(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final class_2583 acceptInvitation$lambda$4(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final class_2583 declineInvitation$lambda$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 declineInvitation$lambda$1(class_2583 it) {
        return it.method_36139(0xFFAA00);
    }

    private static final class_2583 cancelInvitation$lambda$1(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 startDuelFromInvitation$lambda$1(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final void startCountdown$countdown(DuelSession $session, int seconds) {
        if (seconds > 0) {
            Iterable $this$forEach$iv = $session.getAllPlayerIds();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3222 player;
                UUID playerId = (UUID)element$iv;
                boolean bl = false;
                MinecraftServer minecraftServer = server;
                class_3222 class_32222 = player = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(playerId) : null;
                if (class_32222 == null) continue;
                class_32222.method_43496((class_2561)class_2561.method_43470((String)("Combat dans " + seconds + "...")).method_27694(DuelManager::startCountdown$countdown$lambda$0$0));
            }
            SchedulingFunctionsKt.afterOnServer((float)1.0f, () -> DuelManager.startCountdown$countdown$lambda$1(seconds, $session));
        } else {
            INSTANCE.startBattle($session);
        }
    }

    private static final class_2583 startCountdown$countdown$lambda$0$0(class_2583 it) {
        return it.method_36139(0xFFFF55).method_10982(Boolean.valueOf(true));
    }

    private static final Unit startCountdown$countdown$lambda$1(int $seconds, DuelSession $session) {
        DuelManager.startCountdown$countdown($session, $seconds - 1);
        return Unit.INSTANCE;
    }

    private static final class_2583 startBattle$lambda$0$0(class_2583 it) {
        return it.method_36139(0x55FF55).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 startBattle$lambda$0$1(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final Unit start1v1Battle$lambda$4(DuelSession $session, ErroredBattleStart error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to start 1v1 duel: " + CollectionsKt.joinToString$default((Iterable)error.getErrors(), null, null, null, (int)0, null, null, (int)63, null));
        INSTANCE.endSession($session.getSessionId(), true);
        return Unit.INSTANCE;
    }

    private static final Unit start1v1Battle$lambda$5(PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        PokemonLeagueMod.INSTANCE.getLOGGER().info("1v1 duel battle started: " + battle.getBattleId());
        return Unit.INSTANCE;
    }

    private static final Unit start2v2Battle$lambda$4(DuelSession $session, ErroredBattleStart error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to start 2v2 duel: " + CollectionsKt.joinToString$default((Iterable)error.getErrors(), null, null, null, (int)0, null, null, (int)63, null));
        INSTANCE.endSession($session.getSessionId(), true);
        return Unit.INSTANCE;
    }

    private static final Unit start2v2Battle$lambda$5(PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        PokemonLeagueMod.INSTANCE.getLOGGER().info("2v2 duel battle started: " + battle.getBattleId());
        return Unit.INSTANCE;
    }

    private static final class_2583 handleBattleResult$lambda$4$0(int $winningTeam, class_2583 it) {
        return it.method_36139($winningTeam == 1 ? 0x5555FF : 0xFF5555).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 handleBattleResult$lambda$4$1(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final class_2583 handleBattleResult$lambda$5$0(class_2583 it) {
        return it.method_36139(0xAAAAAA);
    }

    private static final Unit handleBattleResult$lambda$7(DuelSession $session) {
        if (activeSessions.containsKey($session.getSessionId())) {
            INSTANCE.startCountdown($session);
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence handleSeriesEnd$lambda$3(DuelPlayer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPlayerName();
    }

    private static final class_2583 handleSeriesEnd$lambda$4$0(class_2583 it) {
        return it.method_36139(16766720).method_10982(Boolean.valueOf(true));
    }

    private static final class_2583 handleSeriesEnd$lambda$4$1(class_2583 it) {
        return it.method_36139(0x55FF55);
    }

    private static final class_2583 handleSeriesEnd$lambda$4$2(class_2583 it) {
        return it.method_36139(0xFFFF55);
    }

    private static final Unit handleSeriesEnd$lambda$5(DuelSession $session) {
        INSTANCE.teleportPlayersBack($session);
        INSTANCE.endSession($session.getSessionId(), false);
        return Unit.INSTANCE;
    }

    private static final class_2583 endSession$lambda$1$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    private static final class_2583 playerQuit$lambda$0$0(class_2583 it) {
        return it.method_36139(0xFF5555);
    }

    static {
        activeSessions = new ConcurrentHashMap();
        playerToSession = new ConcurrentHashMap();
        pendingInvitations = new ConcurrentHashMap();
        playerPendingInvite = new ConcurrentHashMap();
    }
}

