/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.config;

import com.music176.pokemonleague.PokemonLeagueMod;
import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0003J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eR\u001b\u0010\u0012\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/music176/pokemonleague/config/ConfigManager;", "", "<init>", "()V", "", "initialize", "createReadmeFile", "reloadAll", "Ljava/io/File;", "getConfigDirectory", "()Ljava/io/File;", "", "", "listConfigFiles", "()Ljava/util/List;", "configDir$delegate", "Lkotlin/Lazy;", "getConfigDir", "configDir", "pokemon-league-mod"})
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE = new ConfigManager();
    @NotNull
    private static final Lazy configDir$delegate = LazyKt.lazy(ConfigManager::configDir_delegate$lambda$0);

    private ConfigManager() {
    }

    private final File getConfigDir() {
        Lazy lazy = configDir$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (File)object;
    }

    public final void initialize() {
        if (!this.getConfigDir().exists()) {
            this.getConfigDir().mkdirs();
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Created config directory: " + this.getConfigDir().getAbsolutePath());
        }
        this.createReadmeFile();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Configuration manager initialized");
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Config directory: " + this.getConfigDir().getAbsolutePath());
    }

    private final void createReadmeFile() {
        File readmeFile = new File(this.getConfigDir(), "README.txt");
        if (!readmeFile.exists()) {
            FilesKt.writeText$default((File)readmeFile, (String)"Pokemon League Mod - Configuration Files\n========================================\n\nThis directory contains all configuration files for the Pokemon League mod.\n\nFILES:\n------\n\n1. config.json\n   - Main league configuration\n   - Entry fee for the league\n   - Spawn/lobby position\n   - HUD position for league display\n   - 7 stages with champions, pokemon teams, rewards\n\n2. gym_config.json\n   - Configuration for the 5 Pokemon Gyms (Arenas)\n   - Each gym has: ID, name, type, champion, badge\n   - 3 trainers + 1 champion per gym (Gauntlet system)\n   - Entry fees and rewards per gym\n   - Spawn positions for player and NPCs\n   - HUD positions per gym\n\n3. player_stats.json\n   - Legacy statistics for the Pokemon League\n   - Tracks: attempts, failures, successes per player\n   - Used for league leaderboards\n\n4. player_profiles.json\n   - Complete player profiles\n   - Badge collection (5 gym badges)\n   - Statistics per gym\n   - Total credits earned/spent\n   - Battle win/loss counts\n\nCOMMANDS:\n---------\n\nLeague Commands:\n  /league - Open league menu\n  /league start - Enter the league\n  /league quit - Leave the league\n  /league status - Check league status\n  /league spectate - Spectate current player\n  /league admin reload - Reload configuration\n  /league admin setspawn player|npc <stage> - Set spawn positions\n  /league admin sethud - Set HUD position\n  /league admin forceend - Force end current session\n\nGym Commands:\n  /gym <gymId> - Open gym menu (rock, water, electric, grass, psychic)\n  /gym quit - Quit current gym challenge\n  /gym status - Check gym status\n  /gym admin reload - Reload gym configuration\n  /gym admin setspawn <gymId> player|npc - Set spawn positions\n  /gym admin sethud <gymId> - Set gym HUD position\n  /gym admin removehud <gymId> - Remove gym HUD\n  /gym admin givebadge <player> <badgeId> - Give a badge to a player\n  /gym admin resetbadges <player> - Reset all badges for a player\n\nMenu Commands:\n  /menu - Open global player menu\n  /menu badges - Open badges submenu\n  /badges - Alias for /menu badges\n\nFrench Aliases:\n  /ligue - Alias for /league\n  /arene - Alias for /gym\n\nBADGE IDs:\n----------\n  rock_badge - Badge Roche (Gym 1)\n  cascade_badge - Badge Cascade (Gym 2)\n  thunder_badge - Badge Foudre (Gym 3)\n  rainbow_badge - Badge Prisme (Gym 4)\n  marsh_badge - Badge Marais (Gym 5)\n\nGYM IDs:\n--------\n  rock - Arene Roche (Gym 1)\n  water - Arene Eau (Gym 2)\n  electric - Arene Electrik (Gym 3)\n  grass - Arene Plante (Gym 4)\n  psychic - Arene Psy (Gym 5)\n\nPROGRESSION:\n------------\n  1. Complete Gym 1 (Rock) -> Earn Rock Badge\n  2. Complete Gym 2 (Water) -> Earn Cascade Badge (requires Rock Badge)\n  3. Complete Gym 3 (Electric) -> Earn Thunder Badge (requires Cascade Badge)\n  4. Complete Gym 4 (Grass) -> Earn Rainbow Badge (requires Thunder Badge)\n  5. Complete Gym 5 (Psychic) -> Earn Marsh Badge (requires Rainbow Badge)\n  6. Access Pokemon League (requires all 5 badges)\n\nGAUNTLET SYSTEM:\n----------------\n  Each gym challenge consists of:\n  - Phase 1-3: Fight 3 trainers WITHOUT healing between fights\n  - Phase 4: Fight the Champion (full heal before this phase)\n\n  If you lose at any phase, you are ejected and lose your entry fee.\n", null, (int)2, null);
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Created README.txt in config directory");
        }
    }

    public final void reloadAll() {
        PokemonLeagueMod.INSTANCE.reloadConfig();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("All configurations reloaded");
    }

    @NotNull
    public final File getConfigDirectory() {
        return this.getConfigDir();
    }

    @NotNull
    public final List<String> listConfigFiles() {
        Object[] objectArray = new String[]{"config.json - League configuration", "gym_config.json - Gym/Arena configuration", "player_stats.json - Legacy player statistics", "player_profiles.json - Player profiles and badges"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final File configDir_delegate$lambda$0() {
        return FabricLoader.getInstance().getConfigDir().resolve("pokemonleague").toFile();
    }
}

