/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.music176.pokemonleague.economy.EconomyBridge;
import com.music176.pokemonleague.profile.PlayerProfileManager;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u001d\u0010\u0010\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/music176/pokemonleague/commands/UtilityCommands;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "", "pay", "(Lcom/mojang/brigadier/context/CommandContext;)I", "balance", "played", "Lnet/minecraft/class_2561;", "PREFIX", "Lnet/minecraft/class_2561;", "pokemon-league-mod"})
public final class UtilityCommands {
    @NotNull
    public static final UtilityCommands INSTANCE = new UtilityCommands();
    @NotNull
    private static final class_2561 PREFIX;

    private UtilityCommands() {
    }

    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pay").requires(UtilityCommands::register$lambda$0)).then(class_2170.method_9244((String)"player", (ArgumentType)((ArgumentType)class_2186.method_9305())).then(class_2170.method_9244((String)"amount", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(UtilityCommands::register$lambda$1))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"balance").requires(UtilityCommands::register$lambda$2)).executes(UtilityCommands::register$lambda$3));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bal").requires(UtilityCommands::register$lambda$4)).executes(UtilityCommands::register$lambda$5));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"played").requires(UtilityCommands::register$lambda$6)).executes(UtilityCommands::register$lambda$7));
    }

    private final int pay(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 sender = source.method_9207();
        class_3222 target = class_2186.method_9315(context, (String)"player");
        long humanAmount = IntegerArgumentType.getInteger(context, (String)"amount");
        long rawAmount = humanAmount * 100L;
        if (Intrinsics.areEqual((Object)sender.method_5667(), (Object)target.method_5667())) {
            sender.method_43496((class_2561)PREFIX.method_27661().method_10852((class_2561)class_2561.method_43470((String)"Vous ne pouvez pas vous payer vous-meme !").method_27692(class_124.field_1061)));
            return 0;
        }
        if (!EconomyBridge.INSTANCE.isAvailable()) {
            sender.method_43496((class_2561)PREFIX.method_27661().method_10852((class_2561)class_2561.method_43470((String)"Le systeme d'economie n'est pas disponible.").method_27692(class_124.field_1061)));
            return 0;
        }
        Intrinsics.checkNotNull((Object)sender);
        if (!EconomyBridge.INSTANCE.hasEnough(sender, rawAmount)) {
            long currentBalance = EconomyBridge.INSTANCE.getBalance(sender);
            sender.method_43496((class_2561)PREFIX.method_27661().method_10852((class_2561)class_2561.method_43470((String)"Solde insuffisant ! Vous avez ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)EconomyBridge.INSTANCE.formatBalance(currentBalance)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" Pokedollars.").method_27692(class_124.field_1061)));
            return 0;
        }
        boolean withdrawSuccess = EconomyBridge.INSTANCE.withdraw(sender, rawAmount);
        if (!withdrawSuccess) {
            sender.method_43496((class_2561)PREFIX.method_27661().method_10852((class_2561)class_2561.method_43470((String)"Erreur lors du retrait. Reessayez plus tard.").method_27692(class_124.field_1061)));
            return 0;
        }
        Intrinsics.checkNotNull((Object)target);
        boolean depositSuccess = EconomyBridge.INSTANCE.deposit(target, rawAmount);
        if (!depositSuccess) {
            EconomyBridge.INSTANCE.deposit(sender, rawAmount);
            sender.method_43496((class_2561)PREFIX.method_27661().method_10852((class_2561)class_2561.method_43470((String)"Erreur lors du transfert. La transaction a ete annulee.").method_27692(class_124.field_1061)));
            return 0;
        }
        String formattedAmount = EconomyBridge.INSTANCE.formatBalance(rawAmount);
        class_124[] class_124Array = new class_124[]{class_124.field_1065, class_124.field_1067};
        sender.method_43496((class_2561)PREFIX.method_27661().method_10852((class_2561)class_2561.method_43470((String)"Vous avez envoye ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)formattedAmount).method_27695(class_124Array)).method_10852((class_2561)class_2561.method_43470((String)" Pokedollars a ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)target.method_5477().getString()).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" !").method_27692(class_124.field_1060)));
        class_124Array = new class_124[]{class_124.field_1065, class_124.field_1067};
        target.method_43496((class_2561)PREFIX.method_27661().method_10852((class_2561)class_2561.method_43470((String)"Vous avez recu ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)formattedAmount).method_27695(class_124Array)).method_10852((class_2561)class_2561.method_43470((String)" Pokedollars de ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)sender.method_5477().getString()).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" !").method_27692(class_124.field_1060)));
        return 1;
    }

    private final int balance(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        if (!EconomyBridge.INSTANCE.isAvailable()) {
            player.method_43496((class_2561)PREFIX.method_27661().method_10852((class_2561)class_2561.method_43470((String)"Le systeme d'economie n'est pas disponible.").method_27692(class_124.field_1061)));
            return 0;
        }
        Intrinsics.checkNotNull((Object)player);
        long balance = EconomyBridge.INSTANCE.getBalance(player);
        class_124[] class_124Array = new class_124[]{class_124.field_1065, class_124.field_1067};
        player.method_43496((class_2561)PREFIX.method_27661().method_10852((class_2561)class_2561.method_43470((String)"Solde : ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)EconomyBridge.INSTANCE.formatBalance(balance)).method_27695(class_124Array)).method_10852((class_2561)class_2561.method_43470((String)" Pokedollars").method_27692(class_124.field_1054)));
        return 1;
    }

    private final int played(CommandContext<class_2168> context) {
        class_124[] class_124Array;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        long totalMinutes = PlayerProfileManager.INSTANCE.getCurrentPlaytimeMinutes(uUID);
        long days = totalMinutes / (long)1440;
        long hours = totalMinutes % (long)1440 / (long)60;
        long minutes = totalMinutes % (long)60;
        class_124[] $this$played_u24lambda_u240 = class_124Array = new StringBuilder();
        boolean bl = false;
        if (days > 0L) {
            $this$played_u24lambda_u240.append(days + "j ");
        }
        if (hours > 0L || days > 0L) {
            $this$played_u24lambda_u240.append(hours + "h ");
        }
        $this$played_u24lambda_u240.append(minutes + "min");
        String timeString = class_124Array.toString();
        class_124Array = new class_124[]{class_124.field_1075, class_124.field_1067};
        player.method_43496((class_2561)PREFIX.method_27661().method_10852((class_2561)class_2561.method_43470((String)"Temps de jeu : ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)timeString).method_27695(class_124Array)));
        return 1;
    }

    private static final boolean register$lambda$0(class_2168 it) {
        return it.method_9259(0);
    }

    private static final int register$lambda$1(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.pay((CommandContext<class_2168>)context);
    }

    private static final boolean register$lambda$2(class_2168 it) {
        return it.method_9259(0);
    }

    private static final int register$lambda$3(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.balance((CommandContext<class_2168>)context);
    }

    private static final boolean register$lambda$4(class_2168 it) {
        return it.method_9259(0);
    }

    private static final int register$lambda$5(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.balance((CommandContext<class_2168>)context);
    }

    private static final boolean register$lambda$6(class_2168 it) {
        return it.method_9259(0);
    }

    private static final int register$lambda$7(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.played((CommandContext<class_2168>)context);
    }

    static {
        class_124[] class_124Array = new class_124[]{class_124.field_1065, class_124.field_1067};
        class_5250 class_52502 = class_2561.method_43470((String)"[Zoo Academy] ").method_27695(class_124Array);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"withStyle(...)");
        PREFIX = (class_2561)class_52502;
    }
}

