/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague.battle;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleFledEvent;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.music176.pokemonleague.PokemonLeagueMod;
import com.music176.pokemonleague.duel.DuelManager;
import com.music176.pokemonleague.duel.DuelPlayer;
import com.music176.pokemonleague.duel.DuelSession;
import com.music176.pokemonleague.gym.GymManager;
import com.music176.pokemonleague.gym.GymSession;
import com.music176.pokemonleague.league.LeagueManager;
import com.music176.pokemonleague.league.LeagueSession;
import com.music176.pokemonleague.ranked.RankedItemBlocker;
import com.music176.pokemonleague.ranked.RankedManager;
import com.music176.pokemonleague.ranked.RankedPlayer;
import com.music176.pokemonleague.ranked.RankedSession;
import com.music176.pokemonleague.tournament.TournamentManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b \u0010\u001fJ\u0017\u0010!\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b!\u0010\u0011J\u0019\u0010#\u001a\u0004\u0018\u00010\u00192\u0006\u0010\"\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lcom/music176/pokemonleague/battle/BattleResultHandler;", "", "<init>", "()V", "", "register", "Lcom/cobblemon/mod/common/api/events/battles/BattleFledEvent;", "event", "handleBattleFled", "(Lcom/cobblemon/mod/common/api/events/battles/BattleFledEvent;)V", "Ljava/util/UUID;", "playerId", "handleRankedForfeit", "(Ljava/util/UUID;)V", "handleDuelForfeit", "Lcom/cobblemon/mod/common/api/events/battles/BattleVictoryEvent;", "handleBattleVictory", "(Lcom/cobblemon/mod/common/api/events/battles/BattleVictoryEvent;)V", "Lcom/music176/pokemonleague/league/LeagueSession;", "session", "handleLeagueBattle", "(Lcom/cobblemon/mod/common/api/events/battles/BattleVictoryEvent;Lcom/music176/pokemonleague/league/LeagueSession;)V", "Lcom/music176/pokemonleague/gym/GymSession;", "handleGymBattle", "(Lcom/cobblemon/mod/common/api/events/battles/BattleVictoryEvent;Lcom/music176/pokemonleague/gym/GymSession;)V", "Lnet/minecraft/class_3222;", "player", "recallAllPokemon", "(Lnet/minecraft/class_3222;)V", "", "handleTournamentBattle", "(Lcom/cobblemon/mod/common/api/events/battles/BattleVictoryEvent;)Z", "handleRankedBattle", "handleDuelBattle", "uuid", "findServerPlayer", "(Ljava/util/UUID;)Lnet/minecraft/class_3222;", "pokemon-league-mod"})
@SourceDebugExtension(value={"SMAP\nBattleResultHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BattleResultHandler.kt\ncom/music176/pokemonleague/battle/BattleResultHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,401:1\n1563#2:402\n1634#2,3:403\n1563#2:406\n1634#2,3:407\n1563#2:410\n1634#2,3:411\n1563#2:414\n1634#2,3:415\n1563#2:418\n1634#2,3:419\n1563#2:422\n1634#2,3:423\n1563#2:426\n1634#2,3:427\n1563#2:430\n1634#2,3:431\n1374#2:434\n1460#2,5:435\n1374#2:440\n1460#2,5:441\n1761#2,3:447\n1761#2,3:450\n1761#2,3:453\n1761#2,3:456\n1869#2,2:459\n774#2:461\n865#2,2:462\n1617#2,9:464\n1869#2:473\n1870#2:475\n1626#2:476\n774#2:477\n865#2,2:478\n1563#2:480\n1634#2,3:481\n774#2:484\n865#2,2:485\n1563#2:487\n1634#2,3:488\n774#2:491\n865#2,2:492\n1617#2,9:494\n1869#2:503\n1870#2:505\n1626#2:506\n774#2:507\n865#2,2:508\n1563#2:510\n1634#2,3:511\n774#2:514\n865#2,2:515\n1563#2:517\n1634#2,3:518\n774#2:521\n865#2,2:522\n1617#2,9:524\n1869#2:533\n1870#2:535\n1626#2:536\n774#2:537\n865#2,2:538\n1563#2:540\n1634#2,3:541\n774#2:544\n865#2,2:545\n1563#2:547\n1634#2,3:548\n1#3:446\n1#3:474\n1#3:504\n1#3:534\n*S KotlinDebug\n*F\n+ 1 BattleResultHandler.kt\ncom/music176/pokemonleague/battle/BattleResultHandler\n*L\n104#1:402\n104#1:403,3\n106#1:406\n106#1:407,3\n110#1:410\n110#1:411,3\n112#1:414\n112#1:415,3\n132#1:418\n132#1:419,3\n134#1:422\n134#1:423,3\n138#1:426\n138#1:427,3\n140#1:430\n140#1:431,3\n156#1:434\n156#1:435,5\n157#1:440\n157#1:441,5\n194#1:447,3\n198#1:450,3\n238#1:453,3\n242#1:456,3\n272#1:459,2\n292#1:461\n292#1:462,2\n298#1:464,9\n298#1:473\n298#1:475\n298#1:476\n307#1:477\n307#1:478,2\n308#1:480\n308#1:481,3\n311#1:484\n311#1:485,2\n312#1:487\n312#1:488,3\n326#1:491\n326#1:492,2\n332#1:494,9\n332#1:503\n332#1:505\n332#1:506\n341#1:507\n341#1:508,2\n342#1:510\n342#1:511,3\n345#1:514\n345#1:515,2\n346#1:517\n346#1:518,3\n360#1:521\n360#1:522,2\n366#1:524,9\n366#1:533\n366#1:535\n366#1:536\n375#1:537\n375#1:538,2\n376#1:540\n376#1:541,3\n379#1:544\n379#1:545,2\n380#1:547\n380#1:548,3\n298#1:474\n332#1:504\n366#1:534\n*E\n"})
public final class BattleResultHandler {
    @NotNull
    public static final BattleResultHandler INSTANCE = new BattleResultHandler();

    private BattleResultHandler() {
    }

    public final void register() {
        Observable.subscribe$default((Observable)((Observable)CobblemonEvents.BATTLE_VICTORY), null, BattleResultHandler::register$lambda$0, (int)1, null);
        Observable.subscribe$default((Observable)((Observable)CobblemonEvents.BATTLE_FLED), null, BattleResultHandler::register$lambda$1, (int)1, null);
        RankedItemBlocker.INSTANCE.initialize();
        PokemonLeagueMod.INSTANCE.getLOGGER().info("BattleResultHandler registered");
    }

    private final void handleBattleFled(BattleFledEvent event) {
        UUID fleeingPlayerId = event.getPlayer().getUuid();
        class_3222 serverPlayer = this.findServerPlayer(fleeingPlayerId);
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Player with UUID " + fleeingPlayerId + " fled from battle");
        if (TournamentManager.INSTANCE.isPlayerInMatch(fleeingPlayerId)) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Fleeing player is in a tournament match, handling as forfeit");
            TournamentManager.INSTANCE.handlePlayerForfeit(fleeingPlayerId);
            return;
        }
        if (RankedManager.INSTANCE.isPlayerInSession(fleeingPlayerId)) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Fleeing player is in a ranked match, handling as forfeit");
            this.handleRankedForfeit(fleeingPlayerId);
            return;
        }
        if (DuelManager.INSTANCE.isPlayerInDuel(fleeingPlayerId)) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Fleeing player is in a duel, handling as forfeit");
            this.handleDuelForfeit(fleeingPlayerId);
            return;
        }
        GymSession gymSession = GymManager.INSTANCE.getPlayerSession(fleeingPlayerId);
        if (gymSession != null && serverPlayer != null) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Fleeing player is in a gym challenge, handling as defeat");
            this.recallAllPokemon(serverPlayer);
            GymManager.INSTANCE.handleDefeat(serverPlayer);
            return;
        }
        LeagueSession leagueSession = LeagueManager.INSTANCE.getActiveSession();
        if (leagueSession != null && Intrinsics.areEqual((Object)leagueSession.getPlayerId(), (Object)fleeingPlayerId) && serverPlayer != null) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Fleeing player is in the league, handling as defeat");
            this.recallAllPokemon(serverPlayer);
            LeagueManager.INSTANCE.handleDefeat(serverPlayer);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleRankedForfeit(UUID playerId) {
        List list;
        List list2;
        Collection collection;
        Iterable destination$iv$iv;
        RankedSession rankedSession = RankedManager.INSTANCE.getPlayerSession(playerId);
        if (rankedSession == null) {
            return;
        }
        RankedSession session = rankedSession;
        Integer n = session.getPlayerTeam(playerId);
        if (n == null) {
            return;
        }
        int fleeingTeam = n;
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Player " + playerId + " forfeited ranked match (team " + fleeingTeam + ")");
        if (fleeingTeam == 1) {
            $this$map$iv = session.getTeam2();
            $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                RankedPlayer rankedPlayer = (RankedPlayer)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPlayerId());
            }
            list2 = (List)destination$iv$iv;
        } else {
            $this$map$iv = session.getTeam1();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (RankedPlayer)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPlayerId());
            }
            list2 = (List)destination$iv$iv;
        }
        List winnerIds = list2;
        if (fleeingTeam == 1) {
            $this$map$iv = session.getTeam1();
            $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RankedPlayer bl = (RankedPlayer)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getPlayerId());
            }
            list = (List)destination$iv$iv;
        } else {
            $this$map$iv = session.getTeam2();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                RankedPlayer it = (RankedPlayer)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPlayerId());
            }
            list = (List)destination$iv$iv;
        }
        List loserIds = list;
        RankedManager.INSTANCE.handleBattleResult(winnerIds, loserIds);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleDuelForfeit(UUID playerId) {
        List list;
        List list2;
        Collection collection;
        Iterable destination$iv$iv;
        DuelSession duelSession = DuelManager.INSTANCE.getPlayerSession(playerId);
        if (duelSession == null) {
            return;
        }
        DuelSession session = duelSession;
        Integer n = session.getPlayerTeam(playerId);
        if (n == null) {
            return;
        }
        int fleeingTeam = n;
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Player " + playerId + " forfeited duel (team " + fleeingTeam + ")");
        if (fleeingTeam == 1) {
            $this$map$iv = session.getTeam2();
            $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DuelPlayer duelPlayer = (DuelPlayer)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getUUID());
            }
            list2 = (List)destination$iv$iv;
        } else {
            $this$map$iv = session.getTeam1();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (DuelPlayer)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getUUID());
            }
            list2 = (List)destination$iv$iv;
        }
        List winnerIds = list2;
        if (fleeingTeam == 1) {
            $this$map$iv = session.getTeam1();
            $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DuelPlayer bl = (DuelPlayer)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getUUID());
            }
            list = (List)destination$iv$iv;
        } else {
            $this$map$iv = session.getTeam2();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DuelPlayer it = (DuelPlayer)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getUUID());
            }
            list = (List)destination$iv$iv;
        }
        List loserIds = list;
        DuelManager.INSTANCE.handleBattleResult(winnerIds, loserIds);
    }

    private final void handleBattleVictory(BattleVictoryEvent event) {
        Object gymSession;
        block7: {
            Object object;
            Iterable list$iv$iv;
            BattleActor it;
            Iterable $this$flatMapTo$iv$iv;
            LeagueSession leagueSession = LeagueManager.INSTANCE.getActiveSession();
            if (leagueSession != null) {
                this.handleLeagueBattle(event, leagueSession);
                return;
            }
            Iterable $this$flatMap$iv = event.getWinners();
            boolean $i$f$flatMap = false;
            Object object2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (BattleActor)element$iv$iv;
                boolean bl = false;
                list$iv$iv = it.getPlayerUUIDs();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = event.getLosers();
            Collection collection = (List)destination$iv$iv;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (BattleActor)element$iv$iv;
                boolean bl = false;
                list$iv$iv = it.getPlayerUUIDs();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            for (UUID it2 : (Iterable)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv))) {
                boolean bl = false;
                object2 = GymManager.INSTANCE.getPlayerSession(it2);
                if (object2 == null) continue;
                object = object2;
                break block7;
            }
            object = gymSession = null;
        }
        if (gymSession != null) {
            this.handleGymBattle(event, (GymSession)gymSession);
            return;
        }
        if (this.handleTournamentBattle(event)) {
            return;
        }
        if (this.handleRankedBattle(event)) {
            return;
        }
        this.handleDuelBattle(event);
    }

    private final void handleLeagueBattle(BattleVictoryEvent event, LeagueSession session) {
        boolean bl;
        boolean playerWon;
        block17: {
            boolean bl2;
            block16: {
                Object object;
                block15: {
                    Object object2;
                    Object it;
                    Object object32;
                    block14: {
                        Iterable iterable = event.getBattle().getActors();
                        for (Object object32 : iterable) {
                            it = (BattleActor)object32;
                            boolean bl3 = false;
                            if (!(it.getType() == ActorType.PLAYER && Intrinsics.areEqual((Object)it.getUuid(), (Object)session.getPlayerId()))) continue;
                            object2 = object32;
                            break block14;
                        }
                        object2 = null;
                    }
                    BattleActor battleActor = (BattleActor)object2;
                    if (battleActor == null) {
                        return;
                    }
                    BattleActor playerActor = battleActor;
                    Iterable iterable = event.getBattle().getActors();
                    object32 = iterable.iterator();
                    while (object32.hasNext()) {
                        Object it2 = it = object32.next();
                        boolean bl4 = false;
                        if (!(it2.getType() == ActorType.NPC)) continue;
                        object = it;
                        break block15;
                    }
                    object = null;
                }
                BattleActor battleActor = object;
                if (battleActor == null) {
                    return;
                }
                BattleActor npcActor = battleActor;
                Iterable $this$any$iv = event.getWinners();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BattleActor winner = (BattleActor)element$iv;
                        boolean bl5 = false;
                        if (!(winner.getType() == ActorType.PLAYER && Intrinsics.areEqual((Object)winner.getUuid(), (Object)session.getPlayerId()))) continue;
                        bl2 = true;
                        break block16;
                    }
                    bl2 = false;
                }
            }
            playerWon = bl2;
            Iterable $this$any$iv = event.getLosers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BattleActor loser = (BattleActor)element$iv;
                    boolean bl6 = false;
                    if (!(loser.getType() == ActorType.PLAYER && Intrinsics.areEqual((Object)loser.getUuid(), (Object)session.getPlayerId()))) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        boolean playerLost = bl;
        class_3222 serverPlayer = this.findServerPlayer(session.getPlayerId());
        if (serverPlayer == null) {
            PokemonLeagueMod.INSTANCE.getLOGGER().warn("Could not find server player for league battle result");
            return;
        }
        this.recallAllPokemon(serverPlayer);
        if (playerWon) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Player " + session.getPlayerName() + " won stage " + session.getCurrentStage());
            LeagueManager.INSTANCE.handleVictory(serverPlayer);
        } else if (playerLost) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Player " + session.getPlayerName() + " lost at stage " + session.getCurrentStage());
            LeagueManager.INSTANCE.handleDefeat(serverPlayer);
        }
    }

    private final void handleGymBattle(BattleVictoryEvent event, GymSession session) {
        boolean bl;
        boolean playerWon;
        block17: {
            boolean bl2;
            block16: {
                Object object;
                block15: {
                    Object object2;
                    Object it;
                    Object object32;
                    block14: {
                        Iterable iterable = event.getBattle().getActors();
                        for (Object object32 : iterable) {
                            it = (BattleActor)object32;
                            boolean bl3 = false;
                            if (!(it.getType() == ActorType.PLAYER && Intrinsics.areEqual((Object)it.getUuid(), (Object)session.getPlayerId()))) continue;
                            object2 = object32;
                            break block14;
                        }
                        object2 = null;
                    }
                    BattleActor battleActor = (BattleActor)object2;
                    if (battleActor == null) {
                        return;
                    }
                    BattleActor playerActor = battleActor;
                    Iterable iterable = event.getBattle().getActors();
                    object32 = iterable.iterator();
                    while (object32.hasNext()) {
                        Object it2 = it = object32.next();
                        boolean bl4 = false;
                        if (!(it2.getType() == ActorType.NPC)) continue;
                        object = it;
                        break block15;
                    }
                    object = null;
                }
                BattleActor battleActor = object;
                if (battleActor == null) {
                    return;
                }
                BattleActor npcActor = battleActor;
                Iterable $this$any$iv = event.getWinners();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BattleActor winner = (BattleActor)element$iv;
                        boolean bl5 = false;
                        if (!(winner.getType() == ActorType.PLAYER && Intrinsics.areEqual((Object)winner.getUuid(), (Object)session.getPlayerId()))) continue;
                        bl2 = true;
                        break block16;
                    }
                    bl2 = false;
                }
            }
            playerWon = bl2;
            Iterable $this$any$iv = event.getLosers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BattleActor loser = (BattleActor)element$iv;
                    boolean bl6 = false;
                    if (!(loser.getType() == ActorType.PLAYER && Intrinsics.areEqual((Object)loser.getUuid(), (Object)session.getPlayerId()))) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        boolean playerLost = bl;
        class_3222 serverPlayer = this.findServerPlayer(session.getPlayerId());
        if (serverPlayer == null) {
            PokemonLeagueMod.INSTANCE.getLOGGER().warn("Could not find server player for gym battle result");
            return;
        }
        this.recallAllPokemon(serverPlayer);
        if (playerWon) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Player " + session.getPlayerName() + " won gym " + session.getGymId() + " phase " + session.getCurrentPhase());
            GymManager.INSTANCE.handleVictory(serverPlayer);
        } else if (playerLost) {
            PokemonLeagueMod.INSTANCE.getLOGGER().info("Player " + session.getPlayerName() + " lost at gym " + session.getGymId() + " phase " + session.getCurrentPhase());
            GymManager.INSTANCE.handleDefeat(serverPlayer);
        }
    }

    private final void recallAllPokemon(class_3222 player) {
        try {
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            Iterable $this$forEach$iv = (Iterable)party;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pokemon pokemon = (Pokemon)element$iv;
                boolean bl = false;
                Object object = pokemon.getEntity();
                if (object != null) {
                    PokemonEntity entity = object;
                    boolean bl2 = false;
                    PokemonLeagueMod.INSTANCE.getLOGGER().info("Recalling Pokemon: " + pokemon.getSpecies().getName());
                    CompletableFuture completableFuture = entity.recallWithAnimation();
                    object = completableFuture;
                    if (completableFuture != null) continue;
                }
                BattleResultHandler $this$recallAllPokemon_u24lambda_u240_u241 = INSTANCE;
                boolean bl3 = false;
                pokemon.recall();
                object = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to recall Pokemon for player " + player.method_5477().getString(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean handleTournamentBattle(BattleVictoryEvent event) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        BattleActor it;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        void $this$mapNotNullTo$iv$iv;
        void $this$filterTo$iv$iv3;
        Iterable $this$filter$iv3 = event.getBattle().getActors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv3;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            BattleActor it2 = (BattleActor)element$iv$iv;
            boolean bl = false;
            if (!(it2.getType() == ActorType.PLAYER)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List playerActors = (List)destination$iv$iv;
        if (playerActors.size() < 2) {
            return false;
        }
        Iterable $this$mapNotNull$iv = playerActors;
        boolean $i$f$mapNotNull22 = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            UUID it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl2 = false;
            BattleActor actor = (BattleActor)element$iv$iv;
            boolean bl3 = false;
            if ((TournamentManager.INSTANCE.isPlayerInMatch(actor.getUuid()) ? actor.getUuid() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List tournamentPlayerIds = (List)destination$iv$iv2;
        if (tournamentPlayerIds.isEmpty()) {
            return false;
        }
        Iterable $i$f$mapNotNull22 = event.getWinners();
        boolean $i$f$filter2 = false;
        destination$iv$iv2 = $this$filter$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (BattleActor)element$iv$iv;
            boolean bl5 = false;
            if (!(it.getType() == ActorType.PLAYER)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv3;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (BattleActor)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl6 = false;
            collection.add(it.getUuid());
        }
        List winnerIds = (List)destination$iv$iv3;
        Iterable $i$f$map22 = event.getLosers();
        boolean $i$f$filter3 = false;
        destination$iv$iv3 = $this$filter$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BattleActor it3 = (BattleActor)element$iv$iv;
            boolean bl7 = false;
            if (!(it3.getType() == ActorType.PLAYER)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv4;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BattleActor it3 = (BattleActor)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl8 = false;
            collection.add(it3.getUuid());
        }
        List loserIds = (List)destination$iv$iv4;
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Tournament battle result - Winners: " + winnerIds + ", Losers: " + loserIds);
        TournamentManager.INSTANCE.handleBattleResult(winnerIds, loserIds);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean handleRankedBattle(BattleVictoryEvent event) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        BattleActor it;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        void $this$mapNotNullTo$iv$iv;
        void $this$filterTo$iv$iv3;
        Iterable $this$filter$iv3 = event.getBattle().getActors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv3;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            BattleActor it2 = (BattleActor)element$iv$iv;
            boolean bl = false;
            if (!(it2.getType() == ActorType.PLAYER)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List playerActors = (List)destination$iv$iv;
        if (playerActors.size() < 2) {
            return false;
        }
        Iterable $this$mapNotNull$iv = playerActors;
        boolean $i$f$mapNotNull22 = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            UUID it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl2 = false;
            BattleActor actor = (BattleActor)element$iv$iv;
            boolean bl3 = false;
            if ((RankedManager.INSTANCE.isPlayerInSession(actor.getUuid()) ? actor.getUuid() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List rankedPlayerIds = (List)destination$iv$iv2;
        if (rankedPlayerIds.isEmpty()) {
            return false;
        }
        Iterable $i$f$mapNotNull22 = event.getWinners();
        boolean $i$f$filter2 = false;
        destination$iv$iv2 = $this$filter$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (BattleActor)element$iv$iv;
            boolean bl5 = false;
            if (!(it.getType() == ActorType.PLAYER)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv3;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (BattleActor)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl6 = false;
            collection.add(it.getUuid());
        }
        List winnerIds = (List)destination$iv$iv3;
        Iterable $i$f$map22 = event.getLosers();
        boolean $i$f$filter3 = false;
        destination$iv$iv3 = $this$filter$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BattleActor it3 = (BattleActor)element$iv$iv;
            boolean bl7 = false;
            if (!(it3.getType() == ActorType.PLAYER)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv4;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BattleActor it3 = (BattleActor)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl8 = false;
            collection.add(it3.getUuid());
        }
        List loserIds = (List)destination$iv$iv4;
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Ranked battle result - Winners: " + winnerIds + ", Losers: " + loserIds);
        RankedManager.INSTANCE.handleBattleResult(winnerIds, loserIds);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void handleDuelBattle(BattleVictoryEvent event) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        BattleActor it;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        void $this$mapNotNullTo$iv$iv;
        void $this$filterTo$iv$iv3;
        Iterable $this$filter$iv3 = event.getBattle().getActors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv3;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            BattleActor it2 = (BattleActor)element$iv$iv;
            boolean bl = false;
            if (!(it2.getType() == ActorType.PLAYER)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List playerActors = (List)destination$iv$iv;
        if (playerActors.size() < 2) {
            return;
        }
        Iterable $this$mapNotNull$iv = playerActors;
        boolean $i$f$mapNotNull22 = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            UUID it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl2 = false;
            BattleActor actor = (BattleActor)element$iv$iv;
            boolean bl3 = false;
            if ((DuelManager.INSTANCE.isPlayerInDuel(actor.getUuid()) ? actor.getUuid() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List duelPlayerIds = (List)destination$iv$iv2;
        if (duelPlayerIds.isEmpty()) {
            return;
        }
        Iterable $i$f$mapNotNull22 = event.getWinners();
        boolean $i$f$filter2 = false;
        destination$iv$iv2 = $this$filter$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (BattleActor)element$iv$iv;
            boolean bl5 = false;
            if (!(it.getType() == ActorType.PLAYER)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv3;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (BattleActor)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl6 = false;
            collection.add(it.getUuid());
        }
        List winnerIds = (List)destination$iv$iv3;
        Iterable $i$f$map22 = event.getLosers();
        boolean $i$f$filter3 = false;
        destination$iv$iv3 = $this$filter$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BattleActor it3 = (BattleActor)element$iv$iv;
            boolean bl7 = false;
            if (!(it3.getType() == ActorType.PLAYER)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv4;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BattleActor it3 = (BattleActor)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl8 = false;
            collection.add(it3.getUuid());
        }
        List loserIds = (List)destination$iv$iv4;
        PokemonLeagueMod.INSTANCE.getLOGGER().info("Duel battle result - Winners: " + winnerIds + ", Losers: " + loserIds);
        DuelManager.INSTANCE.handleBattleResult(winnerIds, loserIds);
    }

    private final class_3222 findServerPlayer(UUID uuid) {
        class_3222 class_32222;
        try {
            MinecraftServer minecraftServer = DistributionUtilsKt.server();
            class_32222 = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(uuid) : null;
        }
        catch (Exception e) {
            PokemonLeagueMod.INSTANCE.getLOGGER().error("Failed to find server player", (Throwable)e);
            class_32222 = null;
        }
        return class_32222;
    }

    private static final Unit register$lambda$0(BattleVictoryEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        INSTANCE.handleBattleVictory(event);
        return Unit.INSTANCE;
    }

    private static final Unit register$lambda$1(BattleFledEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        INSTANCE.handleBattleFled(event);
        return Unit.INSTANCE;
    }
}

