/*
 * Decompiled with CFR 0.152.
 */
package com.music176.pokemonleague;

import com.mojang.brigadier.CommandDispatcher;
import com.music176.pokemonleague.battle.BattleResultHandler;
import com.music176.pokemonleague.commands.LeagueCommands;
import com.music176.pokemonleague.commands.UtilityCommands;
import com.music176.pokemonleague.config.ConfigManager;
import com.music176.pokemonleague.config.LeagueConfig;
import com.music176.pokemonleague.duel.DuelManager;
import com.music176.pokemonleague.economy.EconomyManager;
import com.music176.pokemonleague.gym.GymHUD;
import com.music176.pokemonleague.gym.GymManager;
import com.music176.pokemonleague.hud.LeagueHUD;
import com.music176.pokemonleague.integration.FTBQuestsIntegration;
import com.music176.pokemonleague.inventory.InventoryLockHandler;
import com.music176.pokemonleague.inventory.InventoryManager;
import com.music176.pokemonleague.league.LeagueManager;
import com.music176.pokemonleague.profile.PlayerProfileManager;
import com.music176.pokemonleague.ranked.RankedCommands;
import com.music176.pokemonleague.ranked.RankedInvitationManager;
import com.music176.pokemonleague.ranked.RankedManager;
import com.music176.pokemonleague.ranked.RankedQueue;
import com.music176.pokemonleague.ranked.RankedRewards;
import com.music176.pokemonleague.spectator.LeagueSpectatorManager;
import com.music176.pokemonleague.stats.PlayerStatsManager;
import com.music176.pokemonleague.tournament.TournamentCommands;
import com.music176.pokemonleague.tournament.TournamentManager;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003R\u0014\u0010\b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\"\u0010\u0010\u001a\u00020\u000f8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/music176/pokemonleague/PokemonLeagueMod;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "reloadConfig", "", "MOD_ID", "Ljava/lang/String;", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "Lcom/music176/pokemonleague/config/LeagueConfig;", "config", "Lcom/music176/pokemonleague/config/LeagueConfig;", "getConfig", "()Lcom/music176/pokemonleague/config/LeagueConfig;", "setConfig", "(Lcom/music176/pokemonleague/config/LeagueConfig;)V", "pokemon-league-mod"})
public final class PokemonLeagueMod
implements ModInitializer {
    @NotNull
    public static final PokemonLeagueMod INSTANCE = new PokemonLeagueMod();
    @NotNull
    public static final String MOD_ID = "pokemonleague";
    @NotNull
    private static final Logger LOGGER;
    public static LeagueConfig config;

    private PokemonLeagueMod() {
    }

    @NotNull
    public final Logger getLOGGER() {
        return LOGGER;
    }

    @NotNull
    public final LeagueConfig getConfig() {
        LeagueConfig leagueConfig = config;
        if (leagueConfig != null) {
            return leagueConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    public final void setConfig(@NotNull LeagueConfig leagueConfig) {
        Intrinsics.checkNotNullParameter((Object)leagueConfig, (String)"<set-?>");
        config = leagueConfig;
    }

    public void onInitialize() {
        LOGGER.info("Initializing Pokemon League Mod...");
        ConfigManager.INSTANCE.initialize();
        this.setConfig(LeagueConfig.Companion.load());
        LOGGER.info("Configuration loaded: " + this.getConfig().getStages().size() + " stages configured");
        CommandRegistrationCallback.EVENT.register(PokemonLeagueMod::onInitialize$lambda$0);
        ServerLifecycleEvents.SERVER_STARTED.register(PokemonLeagueMod::onInitialize$lambda$1);
        ServerLifecycleEvents.SERVER_STOPPING.register(PokemonLeagueMod::onInitialize$lambda$2);
        ServerPlayConnectionEvents.JOIN.register(PokemonLeagueMod::onInitialize$lambda$3);
        ServerPlayConnectionEvents.DISCONNECT.register(PokemonLeagueMod::onInitialize$lambda$4);
        LOGGER.info("Pokemon League Mod initialized successfully!");
    }

    public final void reloadConfig() {
        this.setConfig(LeagueConfig.Companion.load());
        GymManager.INSTANCE.reloadConfig();
        DuelManager.INSTANCE.reloadConfig();
        RankedManager.INSTANCE.reloadConfig();
        TournamentManager.INSTANCE.reloadConfig();
        EconomyManager.INSTANCE.reloadConfig();
        LOGGER.info("Configuration reloaded");
    }

    private static final void onInitialize$lambda$0(CommandDispatcher dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        Intrinsics.checkNotNull((Object)dispatcher);
        LeagueCommands.INSTANCE.register((CommandDispatcher<class_2168>)dispatcher);
        RankedCommands.INSTANCE.register((CommandDispatcher<class_2168>)dispatcher);
        TournamentCommands.INSTANCE.register((CommandDispatcher<class_2168>)dispatcher);
        UtilityCommands.INSTANCE.register((CommandDispatcher<class_2168>)dispatcher);
        LOGGER.info("Commands registered");
    }

    private static final void onInitialize$lambda$1(MinecraftServer server) {
        BattleResultHandler.INSTANCE.register();
        LOGGER.info("Battle event listeners registered");
        Intrinsics.checkNotNull((Object)server);
        LeagueManager.INSTANCE.initialize(server);
        EconomyManager.INSTANCE.initialize();
        PlayerStatsManager.INSTANCE.load();
        LOGGER.info("Player stats loaded");
        PlayerProfileManager.INSTANCE.load();
        LOGGER.info("Player profiles loaded");
        GymManager.INSTANCE.initialize(server);
        LOGGER.info("Gym Manager initialized");
        LeagueHUD.INSTANCE.initialize(server);
        LOGGER.info("League HUD initialized");
        GymHUD.INSTANCE.initialize(server);
        LOGGER.info("Gym HUDs initialized");
        DuelManager.INSTANCE.initialize(server);
        LOGGER.info("Duel Manager initialized");
        RankedManager.INSTANCE.initialize(server);
        LOGGER.info("Ranked Manager initialized");
        RankedInvitationManager.INSTANCE.startExpirationChecker();
        LOGGER.info("Ranked Invitation Manager initialized");
        InventoryLockHandler.INSTANCE.initialize();
        LOGGER.info("Inventory Lock Handler initialized");
        TournamentManager.INSTANCE.initialize(server);
        LOGGER.info("Tournament Manager initialized");
        FTBQuestsIntegration.INSTANCE.initialize(server);
        LOGGER.info("FTB Quests Integration initialized");
        LOGGER.info("League Manager initialized");
    }

    private static final void onInitialize$lambda$2(MinecraftServer server) {
        LeagueHUD.INSTANCE.shutdown();
        GymHUD.INSTANCE.shutdown();
        FTBQuestsIntegration.INSTANCE.shutdown();
        TournamentManager.INSTANCE.shutdown();
        RankedInvitationManager.INSTANCE.clearAll();
        RankedManager.INSTANCE.shutdown();
        DuelManager.INSTANCE.shutdown();
        GymManager.INSTANCE.shutdown();
        LeagueManager.INSTANCE.shutdown();
        InventoryManager.INSTANCE.clearAll();
        InventoryLockHandler.INSTANCE.shutdown();
        PlayerProfileManager.INSTANCE.flushAllPlaytimes();
        PlayerProfileManager.INSTANCE.save();
        LOGGER.info("League Manager shutdown");
    }

    private static final void onInitialize$lambda$3(class_3244 handler, PacketSender sender, MinecraftServer server) {
        class_3222 player = handler.field_14140;
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        String string = player.method_5477().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        PlayerProfileManager.INSTANCE.onPlayerJoin(uUID, string);
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        if (TournamentManager.INSTANCE.isPlayerInTournament(uUID2)) {
            Intrinsics.checkNotNull((Object)player);
            TournamentManager.INSTANCE.handlePlayerReconnect(player);
            LOGGER.info("Tournament player reconnected: " + player.method_5477().getString());
            return;
        }
        UUID uUID3 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
        if (LeagueManager.INSTANCE.needsTeleportOnReconnect(uUID3)) {
            Intrinsics.checkNotNull((Object)player);
            LeagueManager.INSTANCE.handlePlayerReconnect(player);
        }
        UUID uUID4 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID4, (String)"getUUID(...)");
        if (InventoryManager.INSTANCE.hasSavedInventory(uUID4)) {
            Intrinsics.checkNotNull((Object)player);
            InventoryManager.INSTANCE.restoreInventory(player);
            LOGGER.info("Restored saved inventory for reconnecting player " + player.method_5477().getString());
        }
        Intrinsics.checkNotNull((Object)player);
        RankedRewards.INSTANCE.givePendingRewards(player);
    }

    private static final void onInitialize$lambda$4(class_3244 handler, MinecraftServer server) {
        class_3222 player;
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                player = handler.field_14140;
                                UUID uUID = player.method_5667();
                                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                                PlayerProfileManager.INSTANCE.onPlayerDisconnect(uUID);
                                UUID uUID2 = player.method_5667();
                                Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
                                if (LeagueManager.INSTANCE.isPlayerActive(uUID2)) {
                                    Intrinsics.checkNotNull((Object)player);
                                    LeagueManager.INSTANCE.handlePlayerDisconnect(player);
                                }
                                UUID uUID3 = player.method_5667();
                                Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
                                if (GymManager.INSTANCE.isPlayerActive(uUID3)) {
                                    Intrinsics.checkNotNull((Object)player);
                                    GymManager.INSTANCE.handlePlayerDisconnect(player);
                                }
                                UUID uUID4 = player.method_5667();
                                Intrinsics.checkNotNullExpressionValue((Object)uUID4, (String)"getUUID(...)");
                                if (DuelManager.INSTANCE.isPlayerInDuel(uUID4)) break block12;
                                UUID uUID5 = player.method_5667();
                                Intrinsics.checkNotNullExpressionValue((Object)uUID5, (String)"getUUID(...)");
                                if (!DuelManager.INSTANCE.hasPlayerPendingInvite(uUID5)) break block13;
                            }
                            Intrinsics.checkNotNull((Object)player);
                            DuelManager.INSTANCE.handlePlayerDisconnect(player);
                        }
                        UUID uUID = player.method_5667();
                        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                        if (RankedQueue.INSTANCE.isInQueue(uUID)) break block14;
                        UUID uUID6 = player.method_5667();
                        Intrinsics.checkNotNullExpressionValue((Object)uUID6, (String)"getUUID(...)");
                        if (!RankedManager.INSTANCE.isPlayerInSession(uUID6)) break block15;
                    }
                    Intrinsics.checkNotNull((Object)player);
                    RankedManager.INSTANCE.handlePlayerDisconnect(player);
                }
                UUID uUID = player.method_5667();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                if (RankedInvitationManager.INSTANCE.hasPendingInvite(uUID)) break block16;
                UUID uUID7 = player.method_5667();
                Intrinsics.checkNotNullExpressionValue((Object)uUID7, (String)"getUUID(...)");
                if (!RankedInvitationManager.INSTANCE.hasSentInvite(uUID7)) break block17;
            }
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            RankedInvitationManager.INSTANCE.handlePlayerDisconnect(uUID);
        }
        Intrinsics.checkNotNull((Object)player);
        LeagueSpectatorManager.INSTANCE.removeSpectator(player);
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        if (TournamentManager.INSTANCE.isPlayerInTournament(uUID)) {
            TournamentManager.INSTANCE.handlePlayerDisconnect(player);
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)MOD_ID);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }
}

