/*
 * Decompiled with CFR 0.152.
 */
package lol.gito.radgyms.common.gym;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerNPC;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerRegistry;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import lol.gito.radgyms.common.RadGyms;
import lol.gito.radgyms.common.api.dto.Gym;
import lol.gito.radgyms.common.api.dto.TrainerModel;
import lol.gito.radgyms.common.entity.Trainer;
import lol.gito.radgyms.common.gym.GymTemplate;
import lol.gito.radgyms.common.gym.TeamGenerator;
import lol.gito.radgyms.common.gym.TrainerFactory;
import lol.gito.radgyms.common.gym.TrainerSpawner;
import lol.gito.radgyms.common.registry.RadGymsDimensions;
import lol.gito.radgyms.common.registry.RadGymsTemplates;
import lol.gito.radgyms.common.state.PlayerData;
import lol.gito.radgyms.common.state.RadGymsState;
import lol.gito.radgyms.common.world.PlayerSpawnHelper;
import lol.gito.radgyms.common.world.StructurePlacer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_5281;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=50, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ/\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001aR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001bR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001cR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001d\u00a8\u0006\u001e"}, d2={"Llol/gito/radgyms/common/gym/GymInitializer;", "", "Llol/gito/radgyms/common/registry/RadGymsTemplates;", "templateRegistry", "Llol/gito/radgyms/common/gym/TrainerSpawner;", "trainerSpawner", "Llol/gito/radgyms/common/world/StructurePlacer;", "structureManager", "Llol/gito/radgyms/common/gym/TrainerFactory;", "trainerFactory", "Llol/gito/radgyms/common/gym/TeamGenerator;", "teamGenerator", "<init>", "(Llol/gito/radgyms/common/registry/RadGymsTemplates;Llol/gito/radgyms/common/gym/TrainerSpawner;Llol/gito/radgyms/common/world/StructurePlacer;Llol/gito/radgyms/common/gym/TrainerFactory;Llol/gito/radgyms/common/gym/TeamGenerator;)V", "Lnet/minecraft/class_3222;", "serverPlayer", "Lnet/minecraft/class_3218;", "serverWorld", "", "level", "", "type", "", "initInstance", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3218;ILjava/lang/String;)Z", "Llol/gito/radgyms/common/registry/RadGymsTemplates;", "Llol/gito/radgyms/common/gym/TrainerSpawner;", "Llol/gito/radgyms/common/world/StructurePlacer;", "Llol/gito/radgyms/common/gym/TrainerFactory;", "Llol/gito/radgyms/common/gym/TeamGenerator;", "Rad Gyms [Cobblemon]"})
@SourceDebugExtension(value={"SMAP\nGymInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GymInitializer.kt\nlol/gito/radgyms/common/gym/GymInitializer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,90:1\n216#2,2:91\n*S KotlinDebug\n*F\n+ 1 GymInitializer.kt\nlol/gito/radgyms/common/gym/GymInitializer\n*L\n83#1:91,2\n*E\n"})
public final class GymInitializer {
    @NotNull
    private final RadGymsTemplates templateRegistry;
    @NotNull
    private final TrainerSpawner trainerSpawner;
    @NotNull
    private final StructurePlacer structureManager;
    @NotNull
    private final TrainerFactory trainerFactory;
    @NotNull
    private final TeamGenerator teamGenerator;

    public GymInitializer(@NotNull RadGymsTemplates templateRegistry, @NotNull TrainerSpawner trainerSpawner, @NotNull StructurePlacer structureManager, @NotNull TrainerFactory trainerFactory, @NotNull TeamGenerator teamGenerator) {
        Intrinsics.checkNotNullParameter((Object)templateRegistry, (String)"templateRegistry");
        Intrinsics.checkNotNullParameter((Object)trainerSpawner, (String)"trainerSpawner");
        Intrinsics.checkNotNullParameter((Object)structureManager, (String)"structureManager");
        Intrinsics.checkNotNullParameter((Object)trainerFactory, (String)"trainerFactory");
        Intrinsics.checkNotNullParameter((Object)teamGenerator, (String)"teamGenerator");
        this.templateRegistry = templateRegistry;
        this.trainerSpawner = trainerSpawner;
        this.structureManager = structureManager;
        this.trainerFactory = trainerFactory;
        this.teamGenerator = teamGenerator;
    }

    public final boolean initInstance(@NotNull class_3222 serverPlayer, @NotNull class_3218 serverWorld, int level, @Nullable String type) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        Intrinsics.checkNotNullParameter((Object)serverWorld, (String)"serverWorld");
        Gym.Json json = this.templateRegistry.getTemplateOrDefault(type);
        if (json == null) {
            return false;
        }
        Gym.Json dto = json;
        class_2960 class_29602 = serverWorld.method_27983().method_29177();
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"location(...)");
        class_243 class_2432 = serverPlayer.method_19538();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"position(...)");
        RadGymsState.Companion.setReturnCoordsForPlayer(serverPlayer, new PlayerData.ReturnCoords(class_29602, Vec3ExtensionsKt.toBlockPos((class_243)class_2432)));
        int gymLevel = RangesKt.coerceIn((int)level, (ClosedRange)((ClosedRange)new IntRange(5, Cobblemon.INSTANCE.getConfig().getMaxPokemonLevel())));
        String gymType = CollectionsKt.contains((Iterable)this.templateRegistry.getTemplateIdentifiers(), (Object)type) ? type : "default";
        GymTemplate gymTemplate = GymTemplate.Companion.fromDto(serverPlayer, dto, gymLevel, gymType, this.trainerFactory, this.teamGenerator);
        MinecraftServer minecraftServer = serverPlayer.field_13995;
        Intrinsics.checkNotNull((Object)minecraftServer);
        class_3218 class_32182 = minecraftServer.method_3847(RadGymsDimensions.RADGYMS_LEVEL_KEY);
        if (class_32182 == null) {
            return false;
        }
        class_3218 gymDimension = class_32182;
        class_2338 playerGymCoords = PlayerSpawnHelper.INSTANCE.getUniquePlayerCoords(serverPlayer, gymDimension);
        class_2338 dest = class_2338.method_49637((double)((double)playerGymCoords.method_10263() + gymTemplate.getRelativePlayerSpawn().field_1352), (double)((double)playerGymCoords.method_10264() + gymTemplate.getRelativePlayerSpawn().field_1351), (double)((double)playerGymCoords.method_10260() + gymTemplate.getRelativePlayerSpawn().field_1350));
        this.structureManager.placeStructure((class_5281)gymDimension, playerGymCoords, gymTemplate.getStructure());
        gymDimension.method_14178().method_17297(class_3230.field_19280, gymDimension.method_22350(dest).method_12004(), 4, (Object)dest);
        Intrinsics.checkNotNull((Object)dest);
        PlayerSpawnHelper.INSTANCE.teleportPlayer(serverPlayer, gymDimension, dest, gymTemplate.getPlayerYaw(), 0.0f);
        Map<UUID, TrainerModel> trainerUUIDs = this.trainerSpawner.spawnAll(gymTemplate, gymDimension, playerGymCoords);
        String label = "";
        String string = type;
        if (string == null) {
            string = "default";
        }
        Gym gymInstance = new Gym(gymTemplate, trainerUUIDs, playerGymCoords, gymLevel, string, label);
        RadGymsState.Companion.addGymForPlayer(serverPlayer, gymInstance);
        TrainerRegistry trainerRegistry = RadGyms.RCT.getTrainerRegistry();
        Map<UUID, TrainerModel> $this$forEach$iv = gymInstance.getNpcList();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, TrainerModel>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            TrainerNPC trainer;
            Map.Entry<UUID, TrainerModel> element$iv;
            Map.Entry<UUID, TrainerModel> entry = element$iv = iterator.next();
            boolean bl = false;
            UUID uuid = entry.getKey();
            TrainerModel npc = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)trainerRegistry.registerNPC(uuid.toString(), npc.getTrainer()), (String)"registerNPC(...)");
            class_1297 class_12972 = gymDimension.method_14190(uuid);
            Intrinsics.checkNotNull((Object)class_12972, (String)"null cannot be cast to non-null type lol.gito.radgyms.common.entity.Trainer");
            trainer.setEntity((class_1309)((Trainer)class_12972));
        }
        return true;
    }
}

